/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dependencyAnalysis.core.export;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.dependencyAnalysis.core.export.ExportLicenseRule;
import com.intellij.dependencyAnalysis.core.export.LicenseDictTypeAdapter;
import com.intellij.dependencyAnalysis.core.export.LicenseExportTypeAdapter;
import com.intellij.dependencyAnalysis.core.export.ModuleDataExport;
import com.intellij.dependencyAnalysis.core.export.ProjectMetadataExport;
import com.intellij.dependencyAnalysis.core.model.Dependency;
import com.intellij.dependencyAnalysis.core.model.ModuleMetadata;
import com.intellij.dependencyAnalysis.core.model.ProjectMetadata;
import com.intellij.dependencyAnalysis.core.utils.CommonUtilsKt;
import com.intellij.dependencyAnalysis.core.utils.TreeUtilsKt;
import com.jetbrains.themis.License;
import com.jetbrains.themis.LicenseRule;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\fH\u0007\u001a\u0016\u0010\r\u001a\u00020\u0001*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"SBOM_CSV", "", "SBOM_HTML", "SBOM_JSON", "SBOM_LEGACY_JSON", "SBOM_MARKDOWN", "SBOM_SPDX", "STARDUST", "getModulesFromProjectMetadata", "", "Lcom/intellij/dependencyAnalysis/core/export/ModuleDataExport;", "metadata", "Lcom/intellij/dependencyAnalysis/core/model/ProjectMetadata;", "export", "", "Lcom/jetbrains/themis/LicenseRule;", "exportLicenseDict", "exportNew", "intellij.dependencyAnalysis.core"})
@SourceDebugExtension(value={"SMAP\nExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Export.kt\ncom/intellij/dependencyAnalysis/core/export/ExportKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,170:1\n1549#2:171\n1620#2,3:172\n1045#2:175\n1655#2,8:176\n1360#2:184\n1446#2,5:185\n1655#2,8:190\n1655#2,8:198\n1045#2:206\n1194#2,2:207\n1222#2,4:209\n125#3:213\n152#3,3:214\n*S KotlinDebug\n*F\n+ 1 Export.kt\ncom/intellij/dependencyAnalysis/core/export/ExportKt\n*L\n126#1:171\n126#1:172,3\n128#1:175\n128#1:176,8\n158#1:184\n158#1:185,5\n158#1:190,8\n159#1:198,8\n159#1:206\n159#1:207,2\n159#1:209,4\n166#1:213\n166#1:214,3\n*E\n"})
public final class ExportKt {
    @NotNull
    public static final String SBOM_JSON = "json";
    @NotNull
    public static final String STARDUST = "xml";
    @NotNull
    public static final String SBOM_CSV = "csv";
    @NotNull
    public static final String SBOM_HTML = "html";
    @NotNull
    public static final String SBOM_MARKDOWN = "md";
    @NotNull
    public static final String SBOM_LEGACY_JSON = "json";
    @NotNull
    public static final String SBOM_SPDX = "qodana.spdx";

    /*
     * WARNING - void declaration
     */
    private static final List<ModuleDataExport> getModulesFromProjectMetadata(ProjectMetadata metadata) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = metadata.getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleMetadata moduleMetadata = (ModuleMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ModuleDataExport(it.getName(), CommonUtilsKt.relative(metadata.getPath(), it.getPath())));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$distinctBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ModuleDataExport it = (ModuleDataExport)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (ModuleDataExport)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ModuleDataExport it = (ModuleDataExport)e$iv;
            boolean bl = false;
            String key$iv = it.getName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @Deprecated(message="Use current ProjectMetadata export format")
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final String export(@NotNull ProjectMetadata $this$export) {
        Intrinsics.checkNotNullParameter((Object)$this$export, (String)"<this>");
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        String string = gson.toJson((Object)new ProjectMetadataExport(null, ExportKt.getModulesFromProjectMetadata($this$export), $this$export.getUniqueModulesLicense(), $this$export.getDependencies(false), 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @NotNull
    public static final String exportNew(@NotNull ProjectMetadata $this$exportNew) {
        Intrinsics.checkNotNullParameter((Object)$this$exportNew, (String)"<this>");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)License.class), (Object)new LicenseExportTypeAdapter()).disableHtmlEscaping().setPrettyPrinting().create();
        String string = gson.toJson((Object)$this$exportNew);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String exportLicenseDict(@NotNull ProjectMetadata $this$exportLicenseDict) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable $this$sortedBy$iv;
        void $this$distinctBy$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$exportLicenseDict, (String)"<this>");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)License.class), (Object)new LicenseDictTypeAdapter()).disableHtmlEscaping().setPrettyPrinting().create();
        List<License> moduleLicenses = $this$exportLicenseDict.getUniqueModulesLicense();
        Iterable $this$flatMap$iv = $this$exportLicenseDict.getModules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ModuleMetadata)element$iv$iv;
            boolean bl = false;
            list$iv$iv = TreeUtilsKt.getFlatUniqueDependencies(((ModuleMetadata)it).getDependencies());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Dependency)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Dependency)it).getLicenses();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            License it2 = (License)e$iv;
            boolean bl = false;
            String key$iv = it2.getKey();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List dependencyLicenses2 = list$iv;
        Iterable $this$distinctBy$iv2 = CollectionsKt.plus((Collection)moduleLicenses, (Iterable)dependencyLicenses2);
        boolean $i$f$distinctBy2 = false;
        HashSet<String> set$iv2 = new HashSet<String>();
        ArrayList list$iv2 = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv2) {
            License it3 = (License)e$iv;
            boolean bl = false;
            String key$iv = it3.getKey();
            if (!set$iv2.add(key$iv)) continue;
            list$iv2.add(e$iv);
        }
        $this$distinctBy$iv2 = list$iv2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                License it = (License)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getKey());
                it = (License)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getKey())));
            }
        });
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        list$iv2 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it4;
            License license = (License)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(it4.getKey(), element$iv$iv);
        }
        Map allLicenses2 = destination$iv$iv2;
        String string = gson.toJson((Object)allLicenses2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String export(@NotNull Map<String, LicenseRule> $this$export) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$export, (String)"<this>");
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        Map<String, LicenseRule> map = $this$export;
        Gson gson2 = gson;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ExportLicenseRule((String)it.getKey(), CollectionsKt.toList((Iterable)((LicenseRule)it.getValue()).getAllowed()), CollectionsKt.toList((Iterable)((LicenseRule)it.getValue()).getProhibited())));
        }
        String string = gson2.toJson((Object)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }
}

