/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.dotnetwatch.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.debugger.RiderDebuggerElevationUtilKt;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.plugins.dotnetwatch.run.DotNetWatchRunConfigurationEditor;
import com.jetbrains.rider.plugins.dotnetwatch.run.DotNetWatchRunConfigurationOptions;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import com.jetbrains.rider.run.ExternalConsoleMediator;
import com.jetbrains.rider.run.TerminalProcessHandler;
import com.jetbrains.rider.run.configurations.BuildAwareRunConfiguration;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.project.DotNetProjectConfigurationType;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0002H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/dotnetwatch/run/DotNetWatchRunConfiguration;", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "Lcom/jetbrains/rider/plugins/dotnetwatch/run/DotNetWatchRunConfigurationOptions;", "Lcom/jetbrains/rider/run/configurations/BuildAwareRunConfiguration;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "riderDotNetActiveRuntimeHost", "Lcom/jetbrains/rider/runtime/RiderDotNetActiveRuntimeHost;", "type", "Lcom/jetbrains/rider/run/configurations/project/DotNetProjectConfigurationType;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getOptions", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "mustBeStoppedToRunBuild", "", "watchOptions", "intellij.rider.plugins.dotnetwatch"})
@SourceDebugExtension(value={"SMAP\nDotNetWatchRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetWatchRunConfiguration.kt\ncom/jetbrains/rider/plugins/dotnetwatch/run/DotNetWatchRunConfiguration\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,139:1\n17#2,2:140\n*S KotlinDebug\n*F\n+ 1 DotNetWatchRunConfiguration.kt\ncom/jetbrains/rider/plugins/dotnetwatch/run/DotNetWatchRunConfiguration\n*L\n30#1:140,2\n*E\n"})
public final class DotNetWatchRunConfiguration
extends RunConfigurationBase<DotNetWatchRunConfigurationOptions>
implements BuildAwareRunConfiguration,
DumbAware {
    @NotNull
    private final RiderDotNetActiveRuntimeHost riderDotNetActiveRuntimeHost;
    @NotNull
    private final DotNetProjectConfigurationType type;

    public DotNetWatchRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        ComponentManager $this$getService$iv = (ComponentManager)project;
        boolean $i$f$getService = false;
        Object object = $this$getService$iv.getService(RiderDotNetActiveRuntimeHost.class);
        if (object == null) {
            throw new IllegalStateException("Service " + RiderDotNetActiveRuntimeHost.class + " not found in container " + $this$getService$iv);
        }
        this.riderDotNetActiveRuntimeHost = (RiderDotNetActiveRuntimeHost)object;
        this.type = new DotNetProjectConfigurationType();
    }

    @NotNull
    public final DotNetWatchRunConfigurationOptions watchOptions() {
        return this.getOptions();
    }

    @NotNull
    protected DotNetWatchRunConfigurationOptions getOptions() {
        RunConfigurationOptions runConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)runConfigurationOptions, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.dotnetwatch.run.DotNetWatchRunConfigurationOptions");
        return (DotNetWatchRunConfigurationOptions)runConfigurationOptions;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return (SettingsEditor)new DotNetWatchRunConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        return (RunProfileState)new CommandLineState(executionEnvironment, this){
            final /* synthetic */ DotNetWatchRunConfiguration this$0;
            {
                this.this$0 = $receiver;
                super($executionEnvironment);
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) {
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                Intrinsics.checkNotNullParameter(runner, (String)"runner");
                try {
                    ProcessHandler processHandler;
                    File file;
                    File workingDirectory;
                    DotNetCoreRuntime dotNetCoreRuntime = (DotNetCoreRuntime)DotNetWatchRunConfiguration.access$getRiderDotNetActiveRuntimeHost$p(this.this$0).getDotNetCoreRuntime().getValue();
                    if (dotNetCoreRuntime == null) {
                        throw new ExecutionException("Could not determine active .NET runtime.");
                    }
                    DotNetCoreRuntime dotNetExePath = dotNetCoreRuntime;
                    GeneralCommandLine commandLine = DotNetProcessRunProfileStateKt.createEmptyConsoleCommandLine$default((boolean)this.this$0.getOptions().getUseExternalConsole(), null, (boolean)false, (int)6, null);
                    commandLine.setExePath(dotNetExePath.getCliExePath());
                    Object[] objectArray = new String[]{"watch", "run", "--project", this.this$0.getOptions().getProjectFilePath()};
                    commandLine.addParameters(CollectionsKt.listOf((Object[])objectArray));
                    Project project = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    Object object = ProjectExKt.getRunnableProjectsModelIfAvailable((Project)project);
                    if (object != null && (object = object.getProjects()) != null && (object = (List)object.getValueOrNull()) != null) {
                        RunnableProject runnableProject;
                        Object v3;
                        DotNetWatchRunConfiguration dotNetWatchRunConfiguration;
                        block23: {
                            Object object2 = object;
                            dotNetWatchRunConfiguration = this.this$0;
                            Object runnableProjects = object2;
                            boolean bl = false;
                            Iterable $this$singleOrNull$iv = (Iterable)runnableProjects;
                            boolean $i$f$singleOrNull = false;
                            Object single$iv = null;
                            boolean found$iv = false;
                            for (T element$iv : $this$singleOrNull$iv) {
                                RunnableProject it = (RunnableProject)element$iv;
                                boolean bl2 = false;
                                if (!(Intrinsics.areEqual((Object)it.getProjectFilePath(), (Object)dotNetWatchRunConfiguration.getOptions().getProjectFilePath()) && DotNetWatchRunConfiguration.access$getType$p(dotNetWatchRunConfiguration).isApplicable(it.getKind()))) continue;
                                if (found$iv) {
                                    v3 = null;
                                    break block23;
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            v3 = !found$iv ? null : single$iv;
                        }
                        RunnableProject runnableProject2 = v3;
                        if (runnableProject2 != null && (runnableProject = runnableProject2).getProjectOutputs().size() > 1) {
                            boolean bl;
                            block24: {
                                Iterable $this$any$iv = runnableProject.getProjectOutputs();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        ProjectOutput it = (ProjectOutput)element$iv;
                                        boolean bl3 = false;
                                        RdTargetFrameworkId rdTargetFrameworkId = it.getTfm();
                                        if (!Intrinsics.areEqual((Object)(rdTargetFrameworkId != null ? rdTargetFrameworkId.getPresentableName() : null), (Object)dotNetWatchRunConfiguration.getOptions().getProjectTfm())) continue;
                                        bl = true;
                                        break block24;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                String[] stringArray = new String[]{"--framework", dotNetWatchRunConfiguration.getOptions().getProjectTfm()};
                                commandLine.addParameters(stringArray);
                            }
                        }
                    }
                    String string = this.this$0.getOptions().getVerbosity().getArgumentValue();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        commandLine.addParameter(it);
                    }
                    if (this.this$0.getOptions().isSuppressHotReload()) {
                        commandLine.addParameter("--no-hot-reload");
                    }
                    if (((CharSequence)this.this$0.getOptions().getWatchParameters()).length() > 0) {
                        commandLine.getParametersList().addAll(ParametersListUtil.parse((String)this.this$0.getOptions().getWatchParameters()));
                    }
                    if (((CharSequence)this.this$0.getOptions().getProgramParameters()).length() > 0) {
                        commandLine.addParameter("--");
                        commandLine.getParametersList().addAll(ParametersListUtil.parse((String)this.this$0.getOptions().getProgramParameters()));
                    }
                    if ((workingDirectory = new File(this.this$0.getOptions().getWorkingDirectory())).exists()) {
                        file = workingDirectory;
                    } else {
                        Project project2 = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        file = SolutionHostExtensionsKt.getSolutionDirectory((Project)project2);
                    }
                    commandLine.setWorkDirectory(file);
                    commandLine.withParentEnvironmentType(this.this$0.getOptions().isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
                    commandLine.withEnvironment(this.this$0.getOptions().getEnvs());
                    if (this.this$0.getOptions().isRestartOnRudeEditEditor()) {
                        commandLine.withEnvironment("DOTNET_WATCH_RESTART_ON_RUDE_EDIT", "true");
                    }
                    if (this.this$0.getOptions().isUsePollingFileWatcher()) {
                        commandLine.withEnvironment("DOTNET_USE_POLLING_FILE_WATCHER", "true");
                    }
                    if (this.this$0.getOptions().isSuppressBrowserLaunch()) {
                        commandLine.withEnvironment("DOTNET_WATCH_SUPPRESS_LAUNCH_BROWSER", "true");
                    }
                    if (this.this$0.getOptions().isSuppressBrowserRefresh()) {
                        commandLine.withEnvironment("DOTNET_WATCH_SUPPRESS_BROWSER_REFRESH", "true");
                    }
                    if (this.this$0.getOptions().getUseExternalConsole()) {
                        processHandler = ExternalConsoleMediator.INSTANCE.createProcessHandler(commandLine);
                    } else {
                        Project project3 = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                        processHandler = (ProcessHandler)new TerminalProcessHandler(project3, commandLine, false, 4, null);
                    }
                    ProcessHandler processHandler2 = processHandler;
                    ProcessTerminatedListener.attach((ProcessHandler)processHandler2);
                    ConsoleKind consoleKind = this.this$0.getOptions().getUseExternalConsole() ? ConsoleKind.ExternalConsole : ConsoleKind.Normal;
                    Project project4 = this.this$0.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                    ConsoleView console = DotNetProcessRunProfileStateKt.createConsole$default((ConsoleKind)consoleKind, (ProcessHandler)processHandler2, (Project)project4, null, (int)8, null);
                    AnAction[] anActionArray = AnAction.EMPTY_ARRAY;
                    return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, processHandler2, Arrays.copyOf(anActionArray, anActionArray.length));
                }
                catch (Throwable t) {
                    Project project = this.getEnvironment().getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    RiderDebuggerElevationUtilKt.showElevationDialogIfNeeded((Throwable)t, (Project)project);
                    throw new ExecutionException(t);
                }
            }

            @NotNull
            protected ProcessHandler startProcess() {
                throw new ExecutionException("startProcess() should not be called.");
            }
        };
    }

    public boolean mustBeStoppedToRunBuild() {
        return false;
    }

    public static final /* synthetic */ RiderDotNetActiveRuntimeHost access$getRiderDotNetActiveRuntimeHost$p(DotNetWatchRunConfiguration $this) {
        return $this.riderDotNetActiveRuntimeHost;
    }

    public static final /* synthetic */ DotNetProjectConfigurationType access$getType$p(DotNetWatchRunConfiguration $this) {
        return $this.type;
    }
}

