/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtilRt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class AddNamespaceDialog
extends DialogWrapper {
    private JPanel myRoot;
    private JLabel myIcon;
    private ComboBox<String> myPrefix;
    private ComboBox<String> myURI;

    public AddNamespaceDialog(Project project, Set<String> unresolvedPrefixes, Collection<String> uriList, Mode mode) {
        super(project, false);
        this.$$$setupUI$$$();
        this.myIcon.setText(null);
        this.myIcon.setIcon(Messages.getQuestionIcon());
        this.myURI.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(uriList)));
        this.myURI.setSelectedItem((Object)"");
        this.myURI.setEditable(mode == Mode.EDITABLE || mode == Mode.URI_EDITABLE);
        this.addUpdateListener(this.myURI);
        this.myPrefix.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(unresolvedPrefixes)));
        this.myPrefix.setEditable(mode == Mode.EDITABLE || mode == Mode.PREFIX_EDITABLE);
        if (unresolvedPrefixes.size() == 1) {
            String next = unresolvedPrefixes.iterator().next();
            this.myPrefix.setSelectedItem((Object)next);
        }
        this.addUpdateListener(this.myPrefix);
        this.updateOkAction();
        this.init();
    }

    private void addUpdateListener(ComboBox<String> comboBox) {
        Component component;
        ComboBoxEditor boxEditor = comboBox.getEditor();
        if (boxEditor != null && (component = boxEditor.getEditorComponent()) instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AddNamespaceDialog.this.updateOkAction();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/xpathView/ui/AddNamespaceDialog$1", "textChanged"));
                }
            });
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AddNamespaceDialog.this.updateOkAction();
            }
        });
    }

    private void updateOkAction() {
        this.getOKAction().setEnabled(this.getURI().length() > 0 && this.getPrefix().length() > 0);
    }

    protected JComponent createCenterPanel() {
        return this.myRoot;
    }

    public String getPrefix() {
        Object item = this.myPrefix.isEditable() ? this.myPrefix.getEditor().getItem() : this.myPrefix.getSelectedItem();
        return ((String)item).trim();
    }

    public String getURI() {
        Object item = this.myURI.isEditable() ? this.myURI.getEditor().getItem() : this.myURI.getSelectedItem();
        return ((String)item).trim();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JLabel jLabel;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 10, 10), -1, -1, false, false));
        this.myIcon = jLabel = new JLabel();
        jLabel.setText("Icon");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 2, 1, 9, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/XPathBundle", AddNamespaceDialog.class).getString("label.enter.the.prefix.and.uri.of.the.namespace.to.add"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(5, 0, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/XPathBundle", AddNamespaceDialog.class).getString("label.prefix1"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/XPathBundle", AddNamespaceDialog.class).getString("label.uri"));
        jPanel2.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrefix = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel2.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(75, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myURI = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 0, null, null, null));
        jLabel3.setLabelFor((Component)comboBox2);
        jLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static enum Mode {
        EDITABLE,
        PREFIX_EDITABLE,
        URI_EDITABLE,
        FIXED;

    }
}

