/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.AbstractFix;
import org.intellij.lang.xpath.xslt.util.XsltCodeInsightUtil;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateVariableFix
extends AbstractFix {
    private final XPathVariableReference myReference;

    public CreateVariableFix(XPathVariableReference reference) {
        this.myReference = reference;
    }

    @NotNull
    public String getText() {
        String string = XPathBundle.message("intention.name.create.variable", this.myReference.getReferencedName());
        if (string == null) {
            CreateVariableFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.create.variable", new Object[0]);
        if (string == null) {
            CreateVariableFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateVariableFix.$$$reportNull$$$0(2);
        }
        editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)this.myReference, XmlTag.class, (boolean)true);
        if (tag == null) {
            return;
        }
        XmlTag xmlTag = tag.createChildTag("variable", "http://www.w3.org/1999/XSL/Transform", null, false);
        xmlTag.setAttribute("name", this.myReference.getReferencedName());
        xmlTag.setAttribute("select", "dummy");
        XmlAttribute select = xmlTag.getAttribute("select", null);
        assert (select != null);
        PsiElement dummy = XsltSupport.getAttValueToken(select);
        assert (dummy != null);
        TemplateBuilderImpl builder = CreateVariableFix.createTemplateBuilder(xmlTag);
        builder.replaceElement(dummy, (Expression)new MacroCallNode((Macro)new CompleteMacro()));
        builder.setEndVariableAfter((PsiElement)select);
        Template template = builder.buildTemplate();
        template.addTextSegment("\n");
        template.setToIndent(true);
        XmlTag insertionPoint = this.findVariableInsertionPoint(tag);
        CreateVariableFix.moveTo(editor, insertionPoint);
        TemplateManager.getInstance((Project)project).startTemplate(editor, template);
    }

    private XmlTag findVariableInsertionPoint(XmlTag currentUsageTag) {
        return XsltCodeInsightUtil.findVariableInsertionPoint(currentUsageTag, this.getUsageBlock(), this.myReference.getReferencedName(), new XmlTag[0]);
    }

    @Nullable
    public PsiElement getUsageBlock() {
        return XsltCodeInsightUtil.getUsageBlock(this.myReference);
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateVariableFix.$$$reportNull$$$0(3);
        }
        if (!this.myReference.isValid()) {
            return false;
        }
        PsiFile psiFile = this.myReference.getContainingFile();
        assert (psiFile != null);
        return this.myReference.isValid() && psiFile.isValid();
    }

    @Override
    protected boolean requiresEditor() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            CreateVariableFix.$$$reportNull$$$0(4);
        }
        return new CreateVariableFix((XPathVariableReference)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myReference, (PsiFile)target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/CreateVariableFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/CreateVariableFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

