/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.HashSet;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltCallTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltParameter;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.psi.XsltWithParam;
import org.intellij.lang.xpath.xslt.quickfix.AddWithParamFix;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class AddOptionalArgumentsIntention
extends AddWithParamFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.add.optional.argument", new Object[0]);
        if (string == null) {
            AddOptionalArgumentsIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            AddOptionalArgumentsIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean isAvailableImpl(@NotNull Project project, Editor editor, PsiFile file) {
        XsltWithParam[] arguments;
        XsltParameter[] parameters;
        if (project == null) {
            AddOptionalArgumentsIntention.$$$reportNull$$$0(2);
        }
        if (!XsltSupport.isXsltFile(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return false;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (tag == null) {
            return false;
        }
        if (!XsltSupport.isTemplateCall(tag)) {
            return false;
        }
        XsltCallTemplate call = XsltElementFactory.getInstance().wrapElement(tag, XsltCallTemplate.class);
        if (call == null) {
            return false;
        }
        XsltTemplate template = call.getTemplate();
        if (template == null) {
            return false;
        }
        HashSet<String> params = new HashSet<String>();
        for (XsltParameter parameter : parameters = template.getParameters()) {
            if (!parameter.hasDefault()) continue;
            params.add(parameter.getName());
        }
        for (XsltWithParam argument : arguments = call.getArguments()) {
            params.remove(argument.getParamName());
        }
        this.myTag = tag;
        return params.size() > 0 && AddOptionalArgumentsIntention.isAvailableAt(element, tag, offset);
    }

    protected static boolean isAvailableAt(PsiElement element, XmlTag tag, int offset) {
        ASTNode child;
        ASTNode node = tag.getNode();
        return node != null && (child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node)) != null && child.getTextRange().contains(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/intentions/AddOptionalArgumentsIntention";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/intentions/AddOptionalArgumentsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

