/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import org.intellij.lang.xpath.xslt.context.XsltNamespaceContext;
import org.intellij.lang.xpath.xslt.impl.references.SimpleAttributeReference;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReference
extends SimpleAttributeReference
implements EmptyResolveMessageProvider {
    private final TextRange myRange;

    public PrefixReference(XmlAttribute attribute) {
        super(attribute);
        this.myRange = PrefixReference.getPrefixRange(this.myAttribute);
    }

    public PrefixReference(XmlAttribute attribute, TextRange range) {
        super(attribute);
        this.myRange = range;
    }

    public static TextRange getPrefixRange(XmlAttribute attribute) {
        String value = attribute.getValue();
        int p = value.indexOf(58);
        if (p == -1) {
            return TextRange.from((int)0, (int)0);
        }
        for (int i = p - 1; i >= 0; --i) {
            if (Character.isJavaIdentifierPart(value.charAt(i))) continue;
            return TextRange.create((int)(i + 1), (int)p);
        }
        return TextRange.from((int)0, (int)p);
    }

    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    protected TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            PrefixReference.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @Override
    @Nullable
    public PsiElement resolveImpl() {
        return XsltNamespaceContext.resolvePrefix(this.getCanonicalText(), (XmlElement)this.myAttribute);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = XPathBundle.partialMessage("inspection.message.undeclared.namespace.prefix", 1, new Object[0]);
        if (string == null) {
            PrefixReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/xpath/xslt/impl/references/PrefixReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

