/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.changeReminder.predict;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.changeReminder.UtilKt;
import com.jetbrains.changeReminder.plugin.UserSettings;
import com.jetbrains.changeReminder.predict.PredictionController;
import com.jetbrains.changeReminder.predict.PredictionData;
import com.jetbrains.changeReminder.predict.PredictionRequest;
import com.jetbrains.changeReminder.predict.PredictionService;
import com.jetbrains.changeReminder.repository.FilesHistoryProvider;
import git4idea.history.GitHistoryTraverser;
import git4idea.history.GitHistoryTraverserListener;
import git4idea.history.GitHistoryTraverserProviderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0004\b\u000b %\b\u0001\u0018\u00002\u00020\u0001:\u00017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0014H\u0002J\b\u00101\u001a\u00020(H\u0002J\u000f\u00102\u001a\u0004\u0018\u00010(H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010&\u00a8\u00068"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOCK", "Ljava/lang/Object;", "changeListsListener", "com/jetbrains/changeReminder/predict/PredictionService$changeListsListener$1", "Lcom/jetbrains/changeReminder/predict/PredictionService$changeListsListener$1;", "gitHistoryTraverserListener", "com/jetbrains/changeReminder/predict/PredictionService$gitHistoryTraverserListener$1", "Lcom/jetbrains/changeReminder/predict/PredictionService$gitHistoryTraverserListener$1;", "inProgress", "", "getInProgress", "()Z", "isDisposed", "isReadyToDisplay", "predictionData", "Lcom/jetbrains/changeReminder/predict/PredictionData;", "predictionDataToDisplay", "getPredictionDataToDisplay", "()Lcom/jetbrains/changeReminder/predict/PredictionData;", "predictionRequestDisposable", "Lorg/jetbrains/annotations/NotNull;", "predictionRequirements", "Lcom/jetbrains/changeReminder/predict/PredictionService$PredictionRequirements;", "getProject", "()Lcom/intellij/openapi/project/Project;", "serviceDisposable", "taskController", "com/jetbrains/changeReminder/predict/PredictionService$taskController$1", "Lcom/jetbrains/changeReminder/predict/PredictionService$taskController$1;", "userSettings", "Lcom/jetbrains/changeReminder/plugin/UserSettings;", "userSettingsListener", "com/jetbrains/changeReminder/predict/PredictionService$userSettingsListener$1", "Lcom/jetbrains/changeReminder/predict/PredictionService$userSettingsListener$1;", "calculatePrediction", "", "dispose", "onTraverserDisposed", "refreshChangesBrowser", "setEmptyPrediction", "reason", "Lcom/jetbrains/changeReminder/predict/PredictionData$EmptyPredictionReason;", "setPrediction", "newPrediction", "shutdownService", "startService", "()Lkotlin/Unit;", "updateTraverser", "traverser", "Lgit4idea/history/GitHistoryTraverser;", "PredictionRequirements", "intellij.vcs.changeReminder"})
@SourceDebugExtension(value={"SMAP\nPredictionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PredictionService.kt\ncom/jetbrains/changeReminder/predict/PredictionService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n40#2,3:184\n1549#3:187\n1620#3,3:188\n1549#3:191\n1620#3,3:192\n*S KotlinDebug\n*F\n+ 1 PredictionService.kt\ncom/jetbrains/changeReminder/predict/PredictionService\n*L\n28#1:184,3\n127#1:187\n127#1:188,3\n138#1:191\n138#1:192,3\n*E\n"})
public final class PredictionService
implements Disposable {
    @NotNull
    private final Project project;
    private boolean isDisposed;
    @Nullable
    private PredictionRequirements predictionRequirements;
    private Disposable serviceDisposable;
    @NotNull
    private final UserSettings userSettings;
    @NotNull
    private final Object LOCK;
    @NotNull
    private Disposable predictionRequestDisposable;
    @NotNull
    private PredictionData predictionData;
    @NotNull
    private final taskController.1 taskController;
    @NotNull
    private final gitHistoryTraverserListener.1 gitHistoryTraverserListener;
    @NotNull
    private final changeListsListener.1 changeListsListener;
    @NotNull
    private final userSettingsListener.1 userSettingsListener;

    public PredictionService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$service = false;
        Class<UserSettings> serviceClass$iv = UserSettings.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.userSettings = (UserSettings)((Object)object);
        this.LOCK = new Object();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.predictionRequestDisposable = disposable;
        this.predictionData = new PredictionData.EmptyPrediction(PredictionData.EmptyPredictionReason.SERVICE_INIT);
        Project project2 = this.project;
        Function1<PredictionData, Unit> function1 = new Function1<PredictionData, Unit>(this){
            final /* synthetic */ PredictionService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull PredictionData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Object object = PredictionService.access$getLOCK$p(this.this$0);
                PredictionService predictionService = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    PredictionService.access$setPrediction(predictionService, it);
                    Unit unit = Unit.INSTANCE;
                }
            }
        };
        this.taskController = new PredictionController(this, project2, function1){
            final /* synthetic */ PredictionService this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, "ChangeReminder Calculation", $receiver, (Function1<? super PredictionData, Unit>)((Function1)$super_call_param$2));
            }

            public void inProgressChanged(boolean value) {
                PredictionService.access$refreshChangesBrowser(this.this$0);
            }
        };
        this.gitHistoryTraverserListener = new GitHistoryTraverserListener(this){
            final /* synthetic */ PredictionService this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void traverserCreated(@NotNull GitHistoryTraverser newTraverser) {
                Intrinsics.checkNotNullParameter((Object)newTraverser, (String)"newTraverser");
                Object object = PredictionService.access$getLOCK$p(this.this$0);
                PredictionService predictionService = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    PredictionService.access$updateTraverser(predictionService, newTraverser);
                    Disposer.register((Disposable)((Disposable)newTraverser), () -> gitHistoryTraverserListener.1.traverserCreated$lambda$1$lambda$0(predictionService));
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void graphUpdated() {
                Object object = PredictionService.access$getLOCK$p(this.this$0);
                PredictionService predictionService = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    Object object3 = PredictionService.access$getPredictionRequirements$p(predictionService);
                    if (object3 != null && (object3 = ((PredictionRequirements)object3).getFilesHistoryProvider()) != null) {
                        ((FilesHistoryProvider)object3).clear();
                    }
                    PredictionService.access$setEmptyPrediction(predictionService, PredictionData.EmptyPredictionReason.GRAPH_CHANGED);
                    PredictionService.access$calculatePrediction(predictionService);
                    Unit unit = Unit.INSTANCE;
                }
            }

            private static final void traverserCreated$lambda$1$lambda$0(PredictionService this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                PredictionService.access$onTraverserDisposed(this$0);
            }
        };
        this.changeListsListener = new ChangeListAdapter(this){
            @NotNull
            private Collection<? extends Change> lastChanges;
            final /* synthetic */ PredictionService this$0;
            {
                this.this$0 = $receiver;
                this.lastChanges = CollectionsKt.emptyList();
            }

            public void changeListsChanged() {
                Collection changes = ChangeListManager.getInstance((Project)this.this$0.getProject()).getDefaultChangeList().getChanges();
                if (!Comparing.haveEqualElements((Collection)changes, this.lastChanges)) {
                    PredictionService.access$calculatePrediction(this.this$0);
                    Intrinsics.checkNotNull((Object)changes);
                    this.lastChanges = changes;
                }
            }
        };
        this.userSettingsListener = new UserSettings.PluginStatusListener(this){
            final /* synthetic */ PredictionService this$0;
            {
                this.this$0 = $receiver;
            }

            public void statusChanged(boolean isEnabled) {
                if (isEnabled) {
                    PredictionService.access$startService(this.this$0);
                } else {
                    PredictionService.access$shutdownService(this.this$0);
                }
            }
        };
        if (this.userSettings.isPluginEnabled()) {
            this.startService();
        }
        this.userSettings.addPluginStatusListener(this.userSettingsListener, this);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final PredictionData getPredictionDataToDisplay() {
        return this.predictionData;
    }

    public final boolean isReadyToDisplay() {
        return this.predictionData instanceof PredictionData.Prediction;
    }

    public final boolean getInProgress() {
        return this.taskController.getInProgress();
    }

    private final void updateTraverser(GitHistoryTraverser traverser) {
        Object object = this.predictionRequirements;
        if (Intrinsics.areEqual((Object)(object != null && (object = ((PredictionRequirements)object).getFilesHistoryProvider()) != null ? ((FilesHistoryProvider)object).getTraverser() : null), (Object)traverser)) {
            return;
        }
        this.predictionRequirements = new PredictionRequirements(new FilesHistoryProvider(traverser));
        this.calculatePrediction();
    }

    private final void onTraverserDisposed() {
        this.setEmptyPrediction(PredictionData.EmptyPredictionReason.TRAVERSER_INVALID);
        PredictionRequirements predictionRequirements = this.predictionRequirements;
        if (predictionRequirements == null) {
            return;
        }
        FilesHistoryProvider filesHistoryProvider = predictionRequirements.component1();
        this.predictionRequirements = null;
        filesHistoryProvider.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void calculatePrediction() {
        Object object = this.LOCK;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            if (!Disposer.isDisposed((Disposable)this.predictionRequestDisposable)) {
                Disposer.dispose((Disposable)this.predictionRequestDisposable);
            }
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.predictionRequestDisposable = disposable;
            Collection changes = ChangeListManager.getInstance((Project)this.project).getDefaultChangeList().getChanges();
            if (changes.size() > Registry.intValue((String)"vcs.changeReminder.changes.limit")) {
                this.setEmptyPrediction(PredictionData.EmptyPredictionReason.TOO_MANY_FILES);
                return;
            }
            PredictionRequirements predictionRequirements = this.predictionRequirements;
            if (predictionRequirements == null) {
                PredictionService it = this;
                boolean bl2 = false;
                this.setEmptyPrediction(PredictionData.EmptyPredictionReason.REQUIREMENTS_NOT_MET);
                return;
            }
            FilesHistoryProvider filesHistoryProvider = predictionRequirements.component1();
            Intrinsics.checkNotNull((Object)changes);
            Iterable $this$map$iv = changes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Change change = (Change)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(ChangesUtil.getFilePath((Change)it));
            }
            List changeListFiles = (List)destination$iv$iv;
            PredictionData currentPredictionData = this.predictionData;
            if (currentPredictionData instanceof PredictionData.Prediction && Comparing.haveEqualElements(((PredictionData.Prediction)currentPredictionData).getRequestedFiles(), (Collection)changeListFiles)) {
                this.setPrediction(currentPredictionData);
                return;
            }
            Map<VirtualFile, Collection<FilePath>> rootFiles = UtilKt.getGitRootFiles(this.project, changeListFiles);
            Set<VirtualFile> roots = rootFiles.keySet();
            filesHistoryProvider.getTraverser().addIndexingListener((Collection)roots, this.predictionRequestDisposable, arg_0 -> PredictionService.calculatePrediction$lambda$4$lambda$3(this, filesHistoryProvider, rootFiles, arg_0));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Unit startService() {
        Unit unit;
        Object object = this.LOCK;
        synchronized (object) {
            Unit unit2;
            boolean bl = false;
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.serviceDisposable = disposable;
            MessageBus messageBus = this.project.getMessageBus();
            Disposable disposable2 = this.serviceDisposable;
            if (disposable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceDisposable");
                disposable2 = null;
            }
            MessageBusConnection connection = messageBus.connect(disposable2);
            Topic topic = ChangeListListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)this.changeListsListener);
            GitHistoryTraverserListener gitHistoryTraverserListener2 = this.gitHistoryTraverserListener;
            Disposable disposable3 = this.serviceDisposable;
            if (disposable3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceDisposable");
                disposable3 = null;
            }
            GitHistoryTraverserProviderKt.subscribeForGitHistoryTraverserCreation((Project)this.project, (GitHistoryTraverserListener)gitHistoryTraverserListener2, (Disposable)disposable3);
            GitHistoryTraverser gitHistoryTraverser = GitHistoryTraverserProviderKt.getTraverser((Project)this.project);
            if (gitHistoryTraverser != null) {
                GitHistoryTraverser it = gitHistoryTraverser;
                boolean bl2 = false;
                this.updateTraverser(it);
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void shutdownService() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Disposer.dispose((Disposable)this.predictionRequestDisposable);
            this.onTraverserDisposed();
            Disposable disposable = this.serviceDisposable;
            if (disposable == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serviceDisposable");
                disposable = null;
            }
            Disposer.dispose((Disposable)disposable);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void setEmptyPrediction(PredictionData.EmptyPredictionReason reason) {
        this.setPrediction(new PredictionData.EmptyPrediction(reason));
    }

    private final void setPrediction(PredictionData newPrediction) {
        this.predictionData = newPrediction;
        this.refreshChangesBrowser();
    }

    public void dispose() {
        this.isDisposed = true;
        if (this.userSettings.isPluginEnabled()) {
            this.shutdownService();
        }
    }

    private final void refreshChangesBrowser() {
        if (!this.isDisposed) {
            MessageBus messageBus = this.project.getMessageBus();
            Topic topic = ChangesViewModifier.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            ((ChangesViewModifier.ChangesViewModifierListener)messageBus.syncPublisher(topic)).updated();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void calculatePrediction$lambda$4$lambda$3(PredictionService this$0, FilesHistoryProvider $filesHistoryProvider, Map $rootFiles, Collection indexedRoots) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filesHistoryProvider, (String)"$filesHistoryProvider");
        Intrinsics.checkNotNullParameter((Object)$rootFiles, (String)"$rootFiles");
        Intrinsics.checkNotNullParameter((Object)indexedRoots, (String)"indexedRoots");
        Object[] objectArray = new PredictionRequest[1];
        Iterable iterable = indexedRoots;
        FilesHistoryProvider filesHistoryProvider = $filesHistoryProvider;
        int n = 0;
        Object[] objectArray2 = objectArray;
        taskController.1 var14_9 = this$0.taskController;
        boolean $i$f$map = false;
        void var7_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitHistoryTraverser.IndexedRoot indexedRoot = (GitHistoryTraverser.IndexedRoot)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)MapsKt.getValue((Map)$rootFiles, (Object)it.getRoot())));
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.toMap((Iterable)collection);
        FilesHistoryProvider filesHistoryProvider2 = filesHistoryProvider;
        objectArray2[n] = new PredictionRequest(filesHistoryProvider2, map);
        var14_9.request(objectArray);
    }

    public static final /* synthetic */ void access$refreshChangesBrowser(PredictionService $this) {
        $this.refreshChangesBrowser();
    }

    public static final /* synthetic */ Object access$getLOCK$p(PredictionService $this) {
        return $this.LOCK;
    }

    public static final /* synthetic */ void access$setPrediction(PredictionService $this, PredictionData newPrediction) {
        $this.setPrediction(newPrediction);
    }

    public static final /* synthetic */ void access$onTraverserDisposed(PredictionService $this) {
        $this.onTraverserDisposed();
    }

    public static final /* synthetic */ void access$updateTraverser(PredictionService $this, GitHistoryTraverser traverser) {
        $this.updateTraverser(traverser);
    }

    public static final /* synthetic */ PredictionRequirements access$getPredictionRequirements$p(PredictionService $this) {
        return $this.predictionRequirements;
    }

    public static final /* synthetic */ void access$setEmptyPrediction(PredictionService $this, PredictionData.EmptyPredictionReason reason) {
        $this.setEmptyPrediction(reason);
    }

    public static final /* synthetic */ void access$calculatePrediction(PredictionService $this) {
        $this.calculatePrediction();
    }

    public static final /* synthetic */ Unit access$startService(PredictionService $this) {
        return $this.startService();
    }

    public static final /* synthetic */ void access$shutdownService(PredictionService $this) {
        $this.shutdownService();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/changeReminder/predict/PredictionService$PredictionRequirements;", "", "filesHistoryProvider", "Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "(Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;)V", "getFilesHistoryProvider", "()Lcom/jetbrains/changeReminder/repository/FilesHistoryProvider;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.changeReminder"})
    private static final class PredictionRequirements {
        @NotNull
        private final FilesHistoryProvider filesHistoryProvider;

        public PredictionRequirements(@NotNull FilesHistoryProvider filesHistoryProvider) {
            Intrinsics.checkNotNullParameter((Object)filesHistoryProvider, (String)"filesHistoryProvider");
            this.filesHistoryProvider = filesHistoryProvider;
        }

        @NotNull
        public final FilesHistoryProvider getFilesHistoryProvider() {
            return this.filesHistoryProvider;
        }

        @NotNull
        public final FilesHistoryProvider component1() {
            return this.filesHistoryProvider;
        }

        @NotNull
        public final PredictionRequirements copy(@NotNull FilesHistoryProvider filesHistoryProvider) {
            Intrinsics.checkNotNullParameter((Object)filesHistoryProvider, (String)"filesHistoryProvider");
            return new PredictionRequirements(filesHistoryProvider);
        }

        public static /* synthetic */ PredictionRequirements copy$default(PredictionRequirements predictionRequirements, FilesHistoryProvider filesHistoryProvider, int n, Object object) {
            if ((n & 1) != 0) {
                filesHistoryProvider = predictionRequirements.filesHistoryProvider;
            }
            return predictionRequirements.copy(filesHistoryProvider);
        }

        @NotNull
        public String toString() {
            return "PredictionRequirements(filesHistoryProvider=" + this.filesHistoryProvider + ")";
        }

        public int hashCode() {
            return this.filesHistoryProvider.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PredictionRequirements)) {
                return false;
            }
            PredictionRequirements predictionRequirements = (PredictionRequirements)other;
            return Intrinsics.areEqual((Object)this.filesHistoryProvider, (Object)predictionRequirements.filesHistoryProvider);
        }
    }
}

