/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.GeneratorFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandSentListener;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 92\u00020\u0001:\u00049:;<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\bH\u0002J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0014H\u0002J\u000e\u0010-\u001a\b\u0018\u00010\u0011R\u00020\u0000H\u0002J\b\u0010.\u001a\u00020\u0019H\u0002J\u0014\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010'\u001a\u00020\u0014J\u000e\u00102\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0014J\u0015\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b5J\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002H807\"\u0004\b\u0000\u00108*\b\u0012\u0004\u0012\u0002H80\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\b\u0012\u00060\u0011R\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager;", "", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "commandManager", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;)V", "isCommandRunning", "", "isCommandSent", "isInitialized", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandSentListener;", "lock", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock;", "runningGenerator", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Generator;", "scheduledCommands", "Ljava/util/Queue;", "", "scheduledGenerators", "scheduledKeyBindings", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$KeyBinding;", "addListener", "", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "cancelGenerators", "registrar", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock$AfterLockActionRegistrar;", "incompatibleCondition", "createClearPromptShortcut", "terminal", "Lcom/jediterm/terminal/Terminal;", "doSendCommandToExecute", "starter", "Lcom/jediterm/terminal/TerminalStarter;", "shellCommand", "isGenerator", "fireGeneratorCommandSent", "generatorCommand", "fireUserCommandSent", "userCommand", "pollNextGeneratorToRun", "processQueueIfReady", "runGeneratorAsync", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "sendCommandToExecute", "sendKeyBinding", "keyBinding", "sendKeyBinding$intellij_terminal", "drainToList", "", "T", "Companion", "Generator", "KeyBinding", "Lock", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager\n+ 2 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,427:1\n217#2,2:428\n219#2:434\n217#2,2:435\n219#2:441\n59#3,4:430\n59#3,4:437\n13#3:442\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager\n*L\n293#1:428,2\n293#1:434\n300#1:435,2\n300#1:441\n293#1:430,4\n300#1:437,4\n376#1:442\n*E\n"})
public final class ShellCommandExecutionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final CopyOnWriteArrayList<ShellCommandSentListener> listeners;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Queue<Generator> scheduledGenerators;
    @NotNull
    private final Queue<KeyBinding> scheduledKeyBindings;
    @Nullable
    private Generator runningGenerator;
    @NotNull
    private final Queue<String> scheduledCommands;
    private boolean isInitialized;
    private boolean isCommandRunning;
    private boolean isCommandSent;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicInteger NEXT_REQUEST_ID;
    @NotNull
    private static final String GENERATOR_COMMAND = "__jetbrains_intellij_run_generator";
    @NotNull
    private static final String SHORTCUT_CTRL_U = "\u0015";
    @NotNull
    private static final Map<Character, String> pwshCharsToEscape;

    public ShellCommandExecutionManager(@NotNull BlockTerminalSession session2, @NotNull ShellCommandManager commandManager) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        this.session = session2;
        this.listeners = new CopyOnWriteArrayList();
        this.lock = new Lock();
        this.scheduledGenerators = new LinkedList();
        this.scheduledKeyBindings = new LinkedList();
        this.scheduledCommands = new LinkedList();
        commandManager.addListener(new ShellCommandListener(){

            @Override
            public void initialized() {
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ShellCommandExecutionManager.access$setInitialized$p(this.this$0, true);
                    }
                }));
                this.processQueueIfReady();
            }

            @Override
            public void commandStarted(@NotNull String command2) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                            ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().warn("Received command_started event, but previous command wasn't finished");
                        }
                        ShellCommandExecutionManager.access$setCommandRunning$p(this.this$0, true);
                    }
                }));
                this.processQueueIfReady();
            }

            @Override
            public void commandFinished(@NotNull CommandFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (!ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                            ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().warn("Received command_finished event, but command wasn't started");
                        }
                        ShellCommandExecutionManager.access$setCommandSent$p(this.this$0, false);
                        ShellCommandExecutionManager.access$setCommandRunning$p(this.this$0, false);
                    }
                }));
                this.processQueueIfReady();
            }

            @Override
            public void generatorFinished(@NotNull GeneratorFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this, event){
                    final /* synthetic */ ShellCommandExecutionManager this$0;
                    final /* synthetic */ GeneratorFinishedEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(1);
                    }

                    public final void invoke(@NotNull Lock.AfterLockActionRegistrar registrar) {
                        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                        if (ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0) == null) {
                            ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().warn("Received generator_finished event (request_id=" + this.$event.getRequestId() + "), but no running generator");
                        } else {
                            Generator generator2 = ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0);
                            Intrinsics.checkNotNull((Object)generator2);
                            Generator runningGeneratorLocal = generator2;
                            ShellCommandExecutionManager.access$setRunningGenerator$p(this.this$0, null);
                            registrar.afterLock((Function0<Unit>)((Function0)new Function0<Unit>(this.$event, runningGeneratorLocal){
                                final /* synthetic */ GeneratorFinishedEvent $event;
                                final /* synthetic */ Generator $runningGeneratorLocal;
                                {
                                    this.$event = $event;
                                    this.$runningGeneratorLocal = $runningGeneratorLocal;
                                    super(0);
                                }

                                public final void invoke() {
                                    if (this.$event.getRequestId() == this.$runningGeneratorLocal.getRequestId()) {
                                        ShellCommandResult result2 = ShellCommandResult.Companion.create(this.$event.getOutput(), this.$event.getExitCode());
                                        this.$runningGeneratorLocal.getDeferred().complete((Object)result2);
                                    } else {
                                        String msg = "Received generator_finished event (request_id=" + this.$event.getRequestId() + "), but " + this.$runningGeneratorLocal + " was expected";
                                        ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().warn(msg);
                                        this.$runningGeneratorLocal.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
                                    }
                                }
                            }));
                        }
                    }
                }));
                this.processQueueIfReady();
            }
        }, this.session);
    }

    private final void cancelGenerators(Lock.AfterLockActionRegistrar registrar, String incompatibleCondition) {
        block1: {
            Generator generator2 = this.runningGenerator;
            if (generator2 != null) {
                Generator runningGenerator = generator2;
                boolean bl = false;
                registrar.afterLock((Function0<Unit>)((Function0)new Function0<Unit>(runningGenerator, incompatibleCondition){
                    final /* synthetic */ Generator $runningGenerator;
                    final /* synthetic */ String $incompatibleCondition;
                    {
                        this.$runningGenerator = $runningGenerator;
                        this.$incompatibleCondition = $incompatibleCondition;
                        super(0);
                    }

                    public final void invoke() {
                        String msg = "Unexpectedly running " + this.$runningGenerator + ", but " + this.$incompatibleCondition;
                        ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().warn(msg);
                        this.$runningGenerator.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
                    }
                }));
            }
            this.runningGenerator = null;
            List list = UtilKt.nullize(this.drainToList(this.scheduledGenerators));
            if (list == null) break block1;
            List cancelledGenerators = list;
            boolean bl = false;
            LOG.warn("Unexpected scheduled generators " + cancelledGenerators + ", but " + incompatibleCondition);
            registrar.afterLock((Function0<Unit>)((Function0)new Function0<Unit>((List<Generator>)cancelledGenerators, incompatibleCondition){
                final /* synthetic */ List<Generator> $cancelledGenerators;
                final /* synthetic */ String $incompatibleCondition;
                {
                    this.$cancelledGenerators = $cancelledGenerators;
                    this.$incompatibleCondition = $incompatibleCondition;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.$cancelledGenerators;
                    String string = this.$incompatibleCondition;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Generator it = (Generator)element$iv;
                        boolean bl = false;
                        it.getDeferred().cancel(new CancellationException("Unexpectedly scheduled generator, but " + string));
                    }
                }
            }));
        }
    }

    public final void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this, shellCommand){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ String $shellCommand;
            {
                this.this$0 = $receiver;
                this.$shellCommand = $shellCommand;
                super(1);
            }

            public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (ShellCommandExecutionManager.access$isCommandSent$p(this.this$0) || ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                    ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().info("Command '" + this.$shellCommand + "' is postponed until currently running command is finished");
                }
                if (!ShellCommandExecutionManager.access$isInitialized$p(this.this$0)) {
                    ShellCommandExecutionManager.Companion.getLOG$intellij_terminal().info("Command '" + this.$shellCommand + "' is postponed until `initialized` event is received");
                }
                ShellCommandExecutionManager.access$getScheduledCommands$p(this.this$0).offer(this.$shellCommand);
            }
        }));
        this.processQueueIfReady();
    }

    public final void sendKeyBinding$intellij_terminal(@NotNull KeyBinding keyBinding) {
        Intrinsics.checkNotNullParameter((Object)keyBinding, (String)"keyBinding");
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this, keyBinding){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ KeyBinding $keyBinding;
            {
                this.this$0 = $receiver;
                this.$keyBinding = $keyBinding;
                super(1);
            }

            public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ShellCommandExecutionManager.access$getScheduledKeyBindings$p(this.this$0).offer(this.$keyBinding);
            }
        }));
        this.processQueueIfReady();
    }

    @NotNull
    public final Deferred<ShellCommandResult> runGeneratorAsync(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        Generator generator2 = new Generator(shellCommand);
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this, generator2){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ Generator $generator;
            {
                this.this$0 = $receiver;
                this.$generator = $generator;
                super(1);
            }

            public final void invoke(@NotNull Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ShellCommandExecutionManager.access$getScheduledGenerators$p(this.this$0).offer(this.$generator);
            }
        }));
        this.processQueueIfReady();
        return (Deferred)generator2.getDeferred();
    }

    private final void processQueueIfReady() {
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)new Function1<Lock.AfterLockActionRegistrar, Unit>(this){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Lock.AfterLockActionRegistrar registrar) {
                block5: {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                    if (!ShellCommandExecutionManager.access$isInitialized$p(this.this$0)) {
                        ShellCommandExecutionManager.access$cancelGenerators(this.this$0, registrar, "not initialized yet");
                        return;
                    }
                    if (ShellCommandExecutionManager.access$isCommandSent$p(this.this$0) || ShellCommandExecutionManager.access$isCommandRunning$p(this.this$0)) {
                        ShellCommandExecutionManager.access$cancelGenerators(this.this$0, registrar, "command is running");
                        return;
                    }
                    if (ShellCommandExecutionManager.access$getRunningGenerator$p(this.this$0) != null) {
                        return;
                    }
                    List keyBindings = ShellCommandExecutionManager.access$drainToList(this.this$0, ShellCommandExecutionManager.access$getScheduledKeyBindings$p(this.this$0));
                    if (!((Collection)keyBindings).isEmpty()) {
                        ShellCommandExecutionManager.access$getSession$p(this.this$0).getTerminalStarterFuture$intellij_terminal().thenAccept(arg_0 -> processQueueIfReady.1.invoke$lambda$0((Function1)new Function1<TerminalStarter, Unit>((List<KeyBinding>)keyBindings, this.this$0){
                            final /* synthetic */ List<KeyBinding> $keyBindings;
                            final /* synthetic */ ShellCommandExecutionManager this$0;
                            {
                                this.$keyBindings = $keyBindings;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@Nullable TerminalStarter terminalStarter) {
                                if (terminalStarter == null) {
                                    return;
                                }
                                Iterable $this$forEach$iv = this.$keyBindings;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    KeyBinding keyBinding = (KeyBinding)element$iv;
                                    boolean bl = false;
                                    terminalStarter.sendBytes(keyBinding.getBytes(), false);
                                }
                                if (ShellCommandExecutionManager.access$getSession$p(this.this$0).getShellIntegration().getShellType() == ShellType.BASH) {
                                    Terminal terminal = terminalStarter.getTerminal();
                                    Intrinsics.checkNotNullExpressionValue((Object)terminal, (String)"getTerminal(...)");
                                    String clearPrompt = ShellCommandExecutionManager.access$createClearPromptShortcut(this.this$0, terminal);
                                    byte[] byArray = terminalStarter.getTerminal().getCodeForKey(10, 0);
                                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getCodeForKey(...)");
                                    Object object = byArray;
                                    Charset charset = StandardCharsets.UTF_8;
                                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                                    Charset charset2 = charset;
                                    String enterCode = new String((byte[])object, charset2);
                                    terminalStarter.sendString(clearPrompt + enterCode, false);
                                }
                            }
                        }, arg_0));
                    }
                    if ((string = (String)ShellCommandExecutionManager.access$getScheduledCommands$p(this.this$0).poll()) != null) {
                        String string2 = string;
                        ShellCommandExecutionManager shellCommandExecutionManager = this.this$0;
                        String command2 = string2;
                        boolean bl = false;
                        ShellCommandExecutionManager.access$cancelGenerators(shellCommandExecutionManager, registrar, "user command is ready to execute");
                        ShellCommandExecutionManager.access$setCommandSent$p(shellCommandExecutionManager, true);
                        ShellCommandExecutionManager.access$doSendCommandToExecute(shellCommandExecutionManager, command2, false);
                        return;
                    }
                    Generator generator2 = ShellCommandExecutionManager.access$pollNextGeneratorToRun(this.this$0);
                    if (generator2 == null) break block5;
                    Generator generator3 = generator2;
                    ShellCommandExecutionManager shellCommandExecutionManager = this.this$0;
                    Generator it = generator3;
                    boolean bl = false;
                    ShellCommandExecutionManager.access$setRunningGenerator$p(shellCommandExecutionManager, it);
                    ShellCommandExecutionManager.access$doSendCommandToExecute(shellCommandExecutionManager, it.shellCommand(), true);
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }));
    }

    private final Generator pollNextGeneratorToRun() {
        Generator generator2 = null;
        while ((generator2 = this.scheduledGenerators.poll()) != null && !generator2.getDeferred().isActive()) {
        }
        return generator2;
    }

    private final <T> List<T> drainToList(Queue<T> $this$drainToList) {
        ArrayList<T> arrayList;
        ArrayList<T> it = arrayList = new ArrayList<T>($this$drainToList.size());
        boolean bl = false;
        while (!((Collection)$this$drainToList).isEmpty()) {
            T t = $this$drainToList.poll();
            Intrinsics.checkNotNull(t);
            it.add(t);
        }
        return arrayList;
    }

    private final void doSendCommandToExecute(String shellCommand, boolean isGenerator) {
        this.session.getTerminalStarterFuture$intellij_terminal().thenAccept(arg_0 -> ShellCommandExecutionManager.doSendCommandToExecute$lambda$3((Function1)new Function1<TerminalStarter, Unit>(this, shellCommand, isGenerator){
            final /* synthetic */ ShellCommandExecutionManager this$0;
            final /* synthetic */ String $shellCommand;
            final /* synthetic */ boolean $isGenerator;
            {
                this.this$0 = $receiver;
                this.$shellCommand = $shellCommand;
                this.$isGenerator = $isGenerator;
                super(1);
            }

            public final void invoke(@Nullable TerminalStarter starter) {
                if (starter == null) {
                    return;
                }
                ShellCommandExecutionManager.access$doSendCommandToExecute(this.this$0, starter, this.$shellCommand, this.$isGenerator);
            }
        }, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final void doSendCommandToExecute(TerminalStarter starter, String shellCommand, boolean isGenerator) {
        adjustedCommand = shellCommand;
        v0 = starter.getTerminal().getCodeForKey(10, 0);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCodeForKey(...)");
        var6_5 = v0;
        v1 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"UTF_8");
        var7_6 = v1;
        enterCode = new String(var6_5, var7_6);
        if (!this.session.getModel().isBracketedPasteMode()) ** GOTO lbl-1000
        if (StringsKt.contains$default((CharSequence)adjustedCommand, (CharSequence)"\n", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v2 = adjustedCommand;
        v3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"lineSeparator(...)");
        if (StringsKt.contains$default((CharSequence)v2, (CharSequence)v3, (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            adjustedCommand = org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManager$Companion.access$bracketed(ShellCommandExecutionManager.Companion, adjustedCommand);
        } else lbl-1000:
        // 2 sources

        {
            adjustedCommand = StringsKt.replace$default((String)adjustedCommand, (String)"\n", (String)enterCode, (boolean)false, (int)4, null);
        }
        v4 = starter.getTerminal();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getTerminal(...)");
        clearPrompt = this.createClearPromptShortcut(v4);
        TerminalUtil.sendCommandToExecute(clearPrompt + adjustedCommand, starter);
        if (isGenerator) {
            this.fireGeneratorCommandSent(shellCommand);
        } else {
            this.fireUserCommandSent(shellCommand);
        }
    }

    public final void addListener(@NotNull ShellCommandSentListener listener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem((List)this.listeners, listener, parentDisposable);
    }

    public static /* synthetic */ void addListener$default(ShellCommandExecutionManager shellCommandExecutionManager, ShellCommandSentListener shellCommandSentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = shellCommandExecutionManager.session;
        }
        shellCommandExecutionManager.addListener(shellCommandSentListener, disposable);
    }

    private final void fireUserCommandSent(String userCommand) {
        for (ShellCommandSentListener listener : this.listeners) {
            listener.userCommandSent(userCommand);
        }
        ShellCommandManager.Companion $this$iv = ShellCommandManager.Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("User command sent: " + userCommand, e$iv);
        }
    }

    private final void fireGeneratorCommandSent(String generatorCommand) {
        for (ShellCommandSentListener listener : this.listeners) {
            listener.generatorCommandSent(generatorCommand);
        }
        ShellCommandManager.Companion $this$iv = ShellCommandManager.Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Generator command sent: " + generatorCommand, e$iv);
        }
    }

    private final String createClearPromptShortcut(Terminal terminal) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[this.session.getShellIntegration().getShellType().ordinal()] == 1) {
            if (SystemInfo.isUnix) {
                string = SHORTCUT_CTRL_U;
            } else {
                byte[] byArray = terminal.getCodeForKey(36, 2);
                Intrinsics.checkNotNull((Object)byArray);
                string = new String(byArray, Charsets.UTF_8);
            }
        } else {
            string = SHORTCUT_CTRL_U;
        }
        return string;
    }

    private static final void doSendCommandToExecute$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isCommandSent$p(ShellCommandExecutionManager $this) {
        return $this.isCommandSent;
    }

    public static final /* synthetic */ boolean access$isCommandRunning$p(ShellCommandExecutionManager $this) {
        return $this.isCommandRunning;
    }

    public static final /* synthetic */ boolean access$isInitialized$p(ShellCommandExecutionManager $this) {
        return $this.isInitialized;
    }

    public static final /* synthetic */ Queue access$getScheduledCommands$p(ShellCommandExecutionManager $this) {
        return $this.scheduledCommands;
    }

    public static final /* synthetic */ Queue access$getScheduledKeyBindings$p(ShellCommandExecutionManager $this) {
        return $this.scheduledKeyBindings;
    }

    public static final /* synthetic */ Queue access$getScheduledGenerators$p(ShellCommandExecutionManager $this) {
        return $this.scheduledGenerators;
    }

    public static final /* synthetic */ void access$cancelGenerators(ShellCommandExecutionManager $this, Lock.AfterLockActionRegistrar registrar, String incompatibleCondition) {
        $this.cancelGenerators(registrar, incompatibleCondition);
    }

    public static final /* synthetic */ Generator access$getRunningGenerator$p(ShellCommandExecutionManager $this) {
        return $this.runningGenerator;
    }

    public static final /* synthetic */ List access$drainToList(ShellCommandExecutionManager $this, Queue $receiver) {
        return $this.drainToList($receiver);
    }

    public static final /* synthetic */ String access$createClearPromptShortcut(ShellCommandExecutionManager $this, Terminal terminal) {
        return $this.createClearPromptShortcut(terminal);
    }

    public static final /* synthetic */ Generator access$pollNextGeneratorToRun(ShellCommandExecutionManager $this) {
        return $this.pollNextGeneratorToRun();
    }

    public static final /* synthetic */ void access$setCommandSent$p(ShellCommandExecutionManager $this, boolean bl) {
        $this.isCommandSent = bl;
    }

    public static final /* synthetic */ void access$doSendCommandToExecute(ShellCommandExecutionManager $this, String shellCommand, boolean isGenerator) {
        $this.doSendCommandToExecute(shellCommand, isGenerator);
    }

    public static final /* synthetic */ void access$setRunningGenerator$p(ShellCommandExecutionManager $this, Generator generator2) {
        $this.runningGenerator = generator2;
    }

    public static final /* synthetic */ void access$doSendCommandToExecute(ShellCommandExecutionManager $this, TerminalStarter starter, String shellCommand, boolean isGenerator) {
        $this.doSendCommandToExecute(starter, shellCommand, isGenerator);
    }

    public static final /* synthetic */ void access$setInitialized$p(ShellCommandExecutionManager $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ void access$setCommandRunning$p(ShellCommandExecutionManager $this, boolean bl) {
        $this.isCommandRunning = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandExecutionManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        NEXT_REQUEST_ID = new AtomicInteger(0);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('`'), (Object)"``"), TuplesKt.to((Object)Character.valueOf('\"'), (Object)"`\""), TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"`0"), TuplesKt.to((Object)Character.valueOf('\u0007'), (Object)"`a"), TuplesKt.to((Object)Character.valueOf('\b'), (Object)"`b"), TuplesKt.to((Object)Character.valueOf('\f'), (Object)"`f"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"`n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"`r"), TuplesKt.to((Object)Character.valueOf('\t'), (Object)"`t"), TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"'v"), TuplesKt.to((Object)Character.valueOf('$'), (Object)"`$")};
        pwshCharsToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Companion;", "", "()V", "GENERATOR_COMMAND", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_terminal", "()Lcom/intellij/openapi/diagnostic/Logger;", "NEXT_REQUEST_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "SHORTCUT_CTRL_U", "pwshCharsToEscape", "", "", "getPwshCharsToEscape$annotations", "bracketed", "command", "escapePowerShellParameter", "parameter", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG$intellij_terminal() {
            return LOG;
        }

        private static /* synthetic */ void getPwshCharsToEscape$annotations() {
        }

        @NotNull
        public final String escapePowerShellParameter(@NotNull String parameter) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            int n = parameter.length();
            StringBuilder $this$escapePowerShellParameter_u24lambda_u240 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            int n2 = parameter.length();
            for (int i = 0; i < n2; ++i) {
                char ch = parameter.charAt(i);
                Object object = (String)pwshCharsToEscape.get(Character.valueOf(ch));
                if (object == null) {
                    object = Character.valueOf(ch);
                }
                $this$escapePowerShellParameter_u24lambda_u240.append(object);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String bracketed(String command2) {
            return "\u001b[200~" + command2 + "\u001b[201~";
        }

        public static final /* synthetic */ String access$bracketed(Companion $this, String command2) {
            return $this.bracketed(command2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Generator;", "", "shellCommand", "", "(Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager;Ljava/lang/String;)V", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "getDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "requestId", "", "getRequestId", "()I", "toString", "intellij.terminal"})
    private final class Generator {
        @NotNull
        private final String shellCommand;
        private final int requestId;
        @NotNull
        private final CompletableDeferred<ShellCommandResult> deferred;

        public Generator(String shellCommand) {
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            this.shellCommand = shellCommand;
            this.requestId = NEXT_REQUEST_ID.incrementAndGet();
            this.deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        }

        public final int getRequestId() {
            return this.requestId;
        }

        @NotNull
        public final CompletableDeferred<ShellCommandResult> getDeferred() {
            return this.deferred;
        }

        @NotNull
        public final String shellCommand() {
            String string = WhenMappings.$EnumSwitchMapping$0[ShellCommandExecutionManager.this.session.getShellIntegration().getShellType().ordinal()] == 1 ? StringUtil.wrapWithDoubleQuote((String)Companion.escapePowerShellParameter(this.shellCommand)) : ParametersListUtil.escape((CharSequence)this.shellCommand);
            Intrinsics.checkNotNull((Object)string);
            String escapedCommand = string;
            return "__jetbrains_intellij_run_generator " + this.requestId + " " + escapedCommand;
        }

        @NotNull
        public String toString() {
            return "Generator(command=" + this.shellCommand + ", requestId=" + this.requestId + ")";
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ShellType.values().length];
                try {
                    nArray[ShellType.POWERSHELL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$KeyBinding;", "", "bytes", "", "([B)V", "getBytes", "()[B", "intellij.terminal"})
    public static final class KeyBinding {
        @NotNull
        private final byte[] bytes;

        public KeyBinding(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.bytes = bytes;
        }

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock;", "", "()V", "lock", "withLock", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock$AfterLockActionRegistrar;", "AfterLockActionRegistrar", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandExecutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n1855#2,2:428\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock\n*L\n366#1:428,2\n*E\n"})
    private static final class Lock {
        @NotNull
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void withLock(@NotNull Function1<? super AfterLockActionRegistrar, Unit> block2) {
            Intrinsics.checkNotNullParameter(block2, (String)"block");
            List afterLockBlocks = new ArrayList();
            try {
                Object object = this.lock;
                synchronized (object) {
                    boolean $i$a$-synchronized-ShellCommandExecutionManager$Lock$withLock$22 = false;
                    block2.invoke((Object)new AfterLockActionRegistrar(afterLockBlocks){
                        final /* synthetic */ List<Function0<Unit>> $afterLockBlocks;
                        {
                            this.$afterLockBlocks = $afterLockBlocks;
                        }

                        public void afterLock(@NotNull Function0<Unit> block2) {
                            Intrinsics.checkNotNullParameter(block2, (String)"block");
                            this.$afterLockBlocks.add(block2);
                        }
                    });
                    Unit $i$a$-synchronized-ShellCommandExecutionManager$Lock$withLock$22 = Unit.INSTANCE;
                }
            }
            finally {
                Iterable $this$forEach$iv = afterLockBlocks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager$Lock$AfterLockActionRegistrar;", "", "afterLock", "", "block", "Lkotlin/Function0;", "intellij.terminal"})
        public static interface AfterLockActionRegistrar {
            public void afterLock(@NotNull Function0<Unit> var1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShellType.values().length];
            try {
                nArray[ShellType.POWERSHELL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

