/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.prompt.lang.TerminalPromptLanguage;
import org.jetbrains.plugins.terminal.block.prompt.lang.TerminalPromptPsiFile;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/lang/TerminalPromptFileViewProvider;", "Lcom/intellij/psi/SingleRootFileViewProvider;", "psiManager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "eventSystemEnabled", "", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "getPromptModel", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "getShellType", "()Lorg/jetbrains/plugins/terminal/util/ShellType;", "createCopy", "copy", "createFile", "Lcom/intellij/psi/PsiFile;", "lang", "Lcom/intellij/lang/Language;", "Companion", "TerminalPromptContentElement", "TerminalPromptFileElementType", "intellij.terminal"})
public final class TerminalPromptFileViewProvider
extends SingleRootFileViewProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IElementType CONTENT_ELEMENT_TYPE = new IElementType("TERMINAL_PROMPT_CONTENT", (Language)TerminalPromptLanguage.INSTANCE);

    public TerminalPromptFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(psiManager, virtualFile, eventSystemEnabled, (Language)TerminalPromptLanguage.INSTANCE);
    }

    private final ShellType getShellType() {
        Object object = this.getVirtualFile().getUserData(ShellType.Companion.getKEY());
        Intrinsics.checkNotNull((Object)object);
        return (ShellType)((Object)object);
    }

    private final TerminalPromptModel getPromptModel() {
        Object object = this.getVirtualFile().getUserData(TerminalPromptModel.Companion.getKEY());
        Intrinsics.checkNotNull((Object)object);
        return (TerminalPromptModel)object;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Language lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return (PsiFile)new TerminalPromptPsiFile((IElementType)new TerminalPromptFileElementType(), (FileViewProvider)this);
    }

    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        Intrinsics.checkNotNullParameter((Object)copy, (String)"copy");
        copy.putUserData(ShellType.Companion.getKEY(), (Object)this.getShellType());
        copy.putUserData(TerminalPromptModel.Companion.getKEY(), (Object)this.getPromptModel());
        PsiManagerEx psiManagerEx = this.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManagerEx, (String)"getManager(...)");
        return new TerminalPromptFileViewProvider((PsiManager)psiManagerEx, copy, false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/lang/TerminalPromptFileViewProvider$Companion;", "", "()V", "CONTENT_ELEMENT_TYPE", "Lcom/intellij/psi/tree/IElementType;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/lang/TerminalPromptFileViewProvider$TerminalPromptContentElement;", "Lcom/intellij/extapi/psi/ASTWrapperPsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "toString", "", "intellij.terminal"})
    private static final class TerminalPromptContentElement
    extends ASTWrapperPsiElement {
        public TerminalPromptContentElement(@NotNull ASTNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super(node);
        }

        @NotNull
        public String toString() {
            String string = ((Object)((Object)this)).getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/lang/TerminalPromptFileViewProvider$TerminalPromptFileElementType;", "Lcom/intellij/psi/tree/IFileElementType;", "(Lorg/jetbrains/plugins/terminal/block/prompt/lang/TerminalPromptFileViewProvider;)V", "doParseContents", "Lcom/intellij/lang/ASTNode;", "chameleon", "psi", "Lcom/intellij/psi/PsiElement;", "intellij.terminal"})
    private final class TerminalPromptFileElementType
    extends IFileElementType {
        public TerminalPromptFileElementType() {
            super("TERMINAL_PROMPT_FILE", (Language)TerminalPromptLanguage.INSTANCE, false);
        }

        @NotNull
        protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
            Intrinsics.checkNotNullParameter((Object)chameleon, (String)"chameleon");
            Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
            int inputOffset = Math.min(TerminalPromptFileViewProvider.this.getPromptModel().getCommandStartOffset(), chameleon.getChars().length());
            TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(TerminalPromptFileViewProvider.this.getShellType());
            if (terminalShellSupport == null || (terminalShellSupport = terminalShellSupport.getPromptContentElementType()) == null) {
                terminalShellSupport = PlainTextTokenTypes.PLAIN_TEXT_FILE;
            }
            TerminalShellSupport inputElementType = terminalShellSupport;
            LazyParseablePsiElement promptNode = new LazyParseablePsiElement(PlainTextTokenTypes.PLAIN_TEXT_FILE, chameleon.getChars().subSequence(0, inputOffset));
            LazyParseablePsiElement inputNode = new LazyParseablePsiElement((IElementType)inputElementType, chameleon.getChars().subSequence(inputOffset, chameleon.getChars().length()));
            CompositeElement root = new CompositeElement(CONTENT_ELEMENT_TYPE);
            root.setPsi((PsiElement)new TerminalPromptContentElement((ASTNode)root));
            root.rawAddChildrenWithoutNotifications((TreeElement)promptNode);
            root.rawAddChildrenWithoutNotifications((TreeElement)inputNode);
            return (ASTNode)root;
        }
    }
}

