/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u0011\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\nH\u0086\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot;", "", "document", "Lcom/intellij/openapi/editor/Document;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "(Lcom/intellij/openapi/editor/Document;Ljava/util/List;)V", "allSortedHighlightings", "size", "", "getSize", "()I", "buildAndSortHighlightings", "findHighlightingIndex", "documentOffset", "get", "index", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalOutputHighlightingsSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputHighlightingsSnapshot.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n1045#2:65\n13#3:66\n13#3:67\n*S KotlinDebug\n*F\n+ 1 TerminalOutputHighlightingsSnapshot.kt\norg/jetbrains/plugins/terminal/block/output/TerminalOutputHighlightingsSnapshot\n*L\n41#1:65\n47#1:66\n50#1:67\n*E\n"})
public final class TerminalOutputHighlightingsSnapshot {
    @NotNull
    private final Document document;
    @NotNull
    private final List<HighlightingInfo> allSortedHighlightings;

    public TerminalOutputHighlightingsSnapshot(@NotNull Document document, @NotNull List<HighlightingInfo> highlightings2) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(highlightings2, (String)"highlightings");
        this.document = document;
        this.allSortedHighlightings = this.buildAndSortHighlightings(this.document, highlightings2);
    }

    public final int getSize() {
        return this.allSortedHighlightings.size();
    }

    @NotNull
    public final HighlightingInfo get(int index) {
        return this.allSortedHighlightings.get(index);
    }

    public final int findHighlightingIndex(int documentOffset) {
        int insertionIndex;
        if (documentOffset <= 0) {
            return 0;
        }
        int binarySearchInd2 = CollectionsKt.binarySearch(this.allSortedHighlightings, (int)0, (int)this.allSortedHighlightings.size(), (Function1)((Function1)new Function1<HighlightingInfo, Integer>(documentOffset){
            final /* synthetic */ int $documentOffset;
            {
                this.$documentOffset = $documentOffset;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull HighlightingInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.compare((int)it.getStartOffset(), (int)this.$documentOffset);
            }
        }));
        return binarySearchInd2 >= 0 ? binarySearchInd2 : ((insertionIndex = -binarySearchInd2 - 1) == 0 || insertionIndex == this.allSortedHighlightings.size() && documentOffset >= this.document.getTextLength() ? insertionIndex : insertionIndex - 1);
    }

    private final List<HighlightingInfo> buildAndSortHighlightings(Document document, List<HighlightingInfo> highlightings2) {
        Iterable $this$sortedBy$iv = highlightings2;
        boolean $i$f$sortedBy = false;
        List sortedHighlightings = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HighlightingInfo it = (HighlightingInfo)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (HighlightingInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
        int documentLength = document.getTextLength();
        List result2 = new ArrayList(sortedHighlightings.size() * 2 + 1);
        int startOffset = 0;
        for (HighlightingInfo highlighting : sortedHighlightings) {
            boolean $i$f$logger;
            if (highlighting.getStartOffset() < 0 || highlighting.getEndOffset() > documentLength) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings range should be within document");
            }
            if (startOffset > highlighting.getStartOffset()) {
                $i$f$logger = false;
                Logger logger = Logger.getInstance(TerminalOutputModel.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Terminal highlightings should not overlap");
            }
            if (startOffset < highlighting.getStartOffset()) {
                result2.add(new HighlightingInfo(startOffset, highlighting.getStartOffset(), EmptyTextAttributesProvider.INSTANCE));
            }
            result2.add(highlighting);
            startOffset = highlighting.getEndOffset();
        }
        if (startOffset < documentLength) {
            result2.add(new HighlightingInfo(startOffset, documentLength, EmptyTextAttributesProvider.INSTANCE));
        }
        return result2;
    }
}

