/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0014H$J\u0014\u0010\u0016\u001a\u00020\u00132\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher;", "Lcom/intellij/ide/IdeEventQueue$EventDispatcher;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/Disposable;)V", "actionsToSkip", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "ignoreNextKeyTypedEvent", "", "keyListener", "Ljava/awt/event/KeyListener;", "myRegistered", "dispatch", "e", "Ljava/awt/AWTEvent;", "dispatchKeyEvent", "", "Ljava/awt/event/KeyEvent;", "handleKeyEvent", "register", "skipAction", "unregister", "Companion", "MyKeyEventsListener", "intellij.terminal"})
public abstract class TerminalEventDispatcher
implements IdeEventQueue.EventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final KeyListener keyListener;
    private boolean myRegistered;
    @NotNull
    private List<? extends AnAction> actionsToSkip;
    private boolean ignoreNextKeyTypedEvent;
    @NonNls
    @NotNull
    private static final List<String> ACTIONS_TO_SKIP;

    public TerminalEventDispatcher(@NotNull EditorEx editor, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.editor = editor;
        this.parentDisposable = parentDisposable;
        this.keyListener = new MyKeyEventsListener();
        this.actionsToSkip = CollectionsKt.emptyList();
    }

    public boolean dispatch(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof KeyEvent) {
            this.dispatchKeyEvent((KeyEvent)e);
        }
        return false;
    }

    private final void dispatchKeyEvent(KeyEvent e) {
        if (!this.skipAction(e)) {
            if (e.getID() != 400 || !this.ignoreNextKeyTypedEvent) {
                this.ignoreNextKeyTypedEvent = false;
                this.handleKeyEvent(e);
            }
        } else {
            this.ignoreNextKeyTypedEvent = true;
        }
    }

    protected abstract void handleKeyEvent(@NotNull KeyEvent var1);

    public final void register(@NotNull List<? extends AnAction> actionsToSkip) {
        Intrinsics.checkNotNullParameter(actionsToSkip, (String)"actionsToSkip");
        ThreadingAssertions.assertEventDispatchThread();
        this.actionsToSkip = actionsToSkip;
        if (!this.myRegistered) {
            IdeEventQueue.Companion.getInstance().addDispatcher((IdeEventQueue.EventDispatcher)this, this.parentDisposable);
            JComponent jComponent = this.editor.getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
            RevertOnDisposeUtilKt.addKeyListener((Component)jComponent, (Disposable)this.parentDisposable, (KeyListener)this.keyListener);
            this.myRegistered = true;
        }
    }

    public final void unregister() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myRegistered) {
            IdeEventQueue.Companion.getInstance().removeDispatcher((IdeEventQueue.EventDispatcher)this);
            this.editor.getContentComponent().removeKeyListener(this.keyListener);
            this.actionsToSkip = CollectionsKt.emptyList();
            this.myRegistered = false;
        }
    }

    private final boolean skipAction(KeyEvent e) {
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        for (AnAction anAction : this.actionsToSkip) {
            Shortcut[] shortcutArray;
            Intrinsics.checkNotNullExpressionValue((Object)anAction.getShortcutSet().getShortcuts(), (String)"getShortcuts(...)");
            for (Shortcut sc : shortcutArray) {
                if (!sc.isKeyboard() || !sc.startsWith((Shortcut)eventShortcut)) continue;
                if (!Registry.is((String)"terminal.Ctrl-E.opens.RecentFiles.popup", (boolean)false) && Intrinsics.areEqual((Object)"RecentFiles", (Object)ActionManager.getInstance().getId(anAction))) {
                    return e.getModifiersEx() == 128 && e.getKeyCode() == 69;
                }
                return true;
            }
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"ActivateTerminalToolWindow", "ActivateProjectToolWindow", "ActivateFavoritesToolWindow", "ActivateBookmarksToolWindow", "ActivateFindToolWindow", "ActivateRunToolWindow", "ActivateDebugToolWindow", "ActivateProblemsViewToolWindow", "ActivateTODOToolWindow", "ActivateStructureToolWindow", "ActivateHierarchyToolWindow", "ActivateServicesToolWindow", "ActivateCommitToolWindow", "ActivateVersionControlToolWindow", "EditorEscape", "HideActiveWindow", "HideAllWindows", "NextWindow", "PreviousWindow", "NextProjectWindow", "PreviousProjectWindow", "ShowBookmarks", "ShowTypeBookmarks", "FindInPath", "GotoBookmark0", "GotoBookmark1", "GotoBookmark2", "GotoBookmark3", "GotoBookmark4", "GotoBookmark5", "GotoBookmark6", "GotoBookmark7", "GotoBookmark8", "GotoBookmark9", "GotoAction", "GotoFile", "GotoClass", "GotoSymbol", "Vcs.Push", "ShowSettings", "RecentFiles", "Switcher", "ResizeToolWindowLeft", "ResizeToolWindowRight", "ResizeToolWindowUp", "ResizeToolWindowDown", "MaximizeToolWindow", "MaintenanceAction", "TerminalIncreaseFontSize", "TerminalDecreaseFontSize", "TerminalResetFontSize", "Terminal.Paste", "Terminal.CopySelectedText", "Terminal.CopyBlock"};
        ACTIONS_TO_SKIP = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher$Companion;", "", "()V", "ACTIONS_TO_SKIP", "", "", "getActionsToSkip", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalEventDispatcher.kt\norg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1603#2,9:266\n1855#2:275\n1856#2:277\n1612#2:278\n1#3:276\n*S KotlinDebug\n*F\n+ 1 TerminalEventDispatcher.kt\norg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher$Companion\n*L\n181#1:266,9\n181#1:275\n181#1:277\n181#1:278\n181#1:276\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<AnAction> getActionsToSkip() {
            void $this$mapNotNullTo$iv$iv;
            ActionManager actionManager = ActionManager.getInstance();
            Iterable $this$mapNotNull$iv = ACTIONS_TO_SKIP;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                AnAction it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String actionId = (String)element$iv$iv;
                boolean bl2 = false;
                if (actionManager.getAction(actionId) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher$MyKeyEventsListener;", "Ljava/awt/event/KeyAdapter;", "(Lorg/jetbrains/plugins/terminal/block/output/TerminalEventDispatcher;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "keyTyped", "intellij.terminal"})
    private final class MyKeyEventsListener
    extends KeyAdapter {
        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TerminalEventDispatcher.this.handleKeyEvent(e);
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TerminalEventDispatcher.this.ignoreNextKeyTypedEvent = false;
            TerminalEventDispatcher.this.handleKeyEvent(e);
        }
    }
}

