/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.timing;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.WaitTimedOutError;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Timeout;

public final class Pause {
    private static final Timeout DEFAULT_TIMEOUT = Timeout.timeout();
    private static final int SLEEP_INTERVAL = 10;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public static void pause(@Nonnull Condition condition) {
        Pause.pause(condition, DEFAULT_TIMEOUT);
    }

    public static void pause(@Nonnull Condition condition, @Nonnull Timeout timeout) {
        Preconditions.checkNotNull(timeout);
        Pause.pause(condition, timeout.duration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(final @Nonnull Condition condition, long timeout) {
        Preconditions.checkNotNull(condition);
        try {
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() {
                    while (!Thread.currentThread().isInterrupted() && !condition.test()) {
                        Pause.pause();
                    }
                    return condition;
                }
            };
            Pause.performPause(task, timeout, condition);
        }
        finally {
            condition.done();
        }
    }

    private static void performPause(Callable<Object> task, long timeout, Object value) {
        Future<Object> futureResult = EXECUTOR_SERVICE.submit(task);
        try {
            futureResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            futureResult.cancel(true);
            throw new WaitTimedOutError(String.format("Timed out waiting for %s", new StandardRepresentation().toStringOf(value)));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            e.printStackTrace();
        }
    }

    public static void pause(@Nonnull Condition[] conditions) {
        Pause.pause(conditions, DEFAULT_TIMEOUT);
    }

    public static void pause(@Nonnull Condition[] conditions, @Nonnull Timeout timeout) {
        Pause.pause(conditions, timeout.duration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pause(final @Nonnull Condition[] conditions, long timeout) {
        Preconditions.checkNotNullOrEmpty(conditions);
        for (Condition condition : conditions) {
            Preconditions.checkNotNull(condition);
        }
        try {
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() {
                    while (!Thread.currentThread().isInterrupted() && !Pause.areSatisfied(conditions)) {
                        Pause.pause();
                    }
                    return conditions;
                }
            };
            Pause.performPause(task, timeout, conditions);
        }
        finally {
            for (Condition condition : conditions) {
                condition.done();
            }
        }
    }

    private static boolean areSatisfied(@Nonnull Condition[] conditions) {
        for (Condition condition : conditions) {
            if (condition.test()) continue;
            return false;
        }
        return true;
    }

    public static void pause(long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit);
        Pause.pause(unit.toMillis(timeout));
    }

    public static void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void pause() {
        Pause.pause(10L);
    }

    private Pause() {
    }
}

