/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.assertj.core.util.Lists;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.AbstractJTableCellWriter;
import org.assertj.swing.driver.JComboBoxDriver;
import org.assertj.swing.driver.JComboBoxEditableQuery;
import org.assertj.swing.driver.JTableStopCellEditingTask;

public class JTableComboBoxEditorCellWriter
extends AbstractJTableCellWriter {
    private final JComboBoxDriver driver;

    public JTableComboBoxEditorCellWriter(@Nonnull Robot robot) {
        super(robot);
        this.driver = new JComboBoxDriver(robot);
    }

    @Override
    @RunsInEDT
    public void enterValue(@Nonnull JTable table, int row, int column, @Nonnull String value) {
        JComboBox<?> editor2 = this.doStartCellEditing(table, row, column);
        this.selectOrType(editor2, value);
        JTableStopCellEditingTask.stopEditing(table, row, column);
    }

    private void selectOrType(@Nonnull JComboBox<?> editor2, @Nonnull String value) {
        boolean selectValue;
        boolean bl = selectValue = !JComboBoxEditableQuery.isEditable(editor2);
        if (!selectValue) {
            selectValue = Lists.newArrayList(this.driver.contentsOf(editor2)).contains(value);
        }
        if (selectValue) {
            this.driver.selectItem(editor2, value);
            return;
        }
        this.driver.replaceText(editor2, value);
    }

    @Override
    @RunsInEDT
    public void startCellEditing(@Nonnull JTable table, int row, int column) {
        this.doStartCellEditing(table, row, column);
    }

    @RunsInEDT
    private JComboBox<?> doStartCellEditing(@Nonnull JTable table, int row, int column) {
        Point cellLocation = JTableComboBoxEditorCellWriter.cellLocation(table, row, column, this.location());
        this.robot.click((Component)table, cellLocation);
        JComboBox<?> comboBox = this.waitForEditorActivation(table, row, column);
        this.cellEditor(JTableComboBoxEditorCellWriter.cellEditor(table, row, column));
        return comboBox;
    }

    @RunsInEDT
    private JComboBox<?> waitForEditorActivation(@Nonnull JTable table, int row, int column) {
        return this.waitForEditorActivation(table, row, column, JComboBox.class);
    }
}

