/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiDirectory;
import com.intellij.rider.navbar.EntityNavBarItem;
import com.jetbrains.rdclient.fileStructure.ProtocolFileStructureFakePsiElement;
import com.jetbrains.rider.nuget.helpers.RiderNuGetPackageFolders;
import com.jetbrains.rider.projectView.ExternalSourceService;
import com.jetbrains.rider.projectView.ProjectModelDataKeys;
import com.jetbrains.rider.projectView.moveProviders.RiderCopyProvider;
import com.jetbrains.rider.projectView.moveProviders.RiderCutProvider;
import com.jetbrains.rider.projectView.moveProviders.RiderDeleteProvider;
import com.jetbrains.rider.projectView.moveProviders.RiderPasteProvider;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import icons.ReSharperIcons;
import icons.RiderIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/rider/navbar/RiderNavBarModelExtension;", "Lcom/intellij/ide/navigationToolbar/AbstractNavBarModelExtension;", "()V", "additionalRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getData", "", "dataId", "", "provider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getIcon", "Ljavax/swing/Icon;", "object", "getPresentableText", "intellij.rider.navbar.backend"})
@SourceDebugExtension(value={"SMAP\nRiderNavBarModelExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNavBarModelExtension.kt\ncom/intellij/rider/navbar/RiderNavBarModelExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class RiderNavBarModelExtension
extends AbstractNavBarModelExtension {
    @Nullable
    public String getPresentableText(@Nullable Object object) {
        if (!(object instanceof ProtocolFileStructureFakePsiElement)) {
            return null;
        }
        String shortName = ((ProtocolFileStructureFakePsiElement)object).getNode().getShortName();
        return shortName;
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull DataProvider provider) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        ProjectModelEntity[] projectModelEntityArray = PlatformDataKeys.SELECTED_ITEM.getData(provider);
        EntityNavBarItem entityNavBarItem = projectModelEntityArray instanceof EntityNavBarItem ? (EntityNavBarItem)projectModelEntityArray : null;
        if (entityNavBarItem == null) {
            return null;
        }
        EntityNavBarItem item = entityNavBarItem;
        ProjectModelEntity projectModelEntity = item.getEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity entity = projectModelEntity;
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            object = RiderDeleteProvider.INSTANCE;
        } else if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            object = RiderCopyProvider.INSTANCE;
        } else if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            object = RiderCutProvider.INSTANCE;
        } else if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            object = RiderPasteProvider.INSTANCE;
        } else if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFileUrl virtualFileUrl = entity.getUrl();
            object = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
        } else if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            VirtualFileUrl virtualFileUrl = entity.getUrl();
            if (virtualFileUrl != null && (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) != null) {
                VirtualFileUrl it = virtualFileUrl;
                boolean bl = false;
                VirtualFile[] virtualFileArray = new VirtualFile[]{it};
                object = virtualFileArray;
            } else {
                object = new VirtualFile[]{};
            }
        } else if (ProjectModelDataKeys.INSTANCE.getPROJECT_MODEL_ENTITY_ARRAY().is(dataId)) {
            projectModelEntityArray = new ProjectModelEntity[]{entity};
            object = projectModelEntityArray;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public Icon getIcon(@Nullable Object object) {
        Object object2 = object;
        if (object2 == null) {
            return null;
        }
        Object value = object2;
        if (value instanceof Project || value instanceof Module) {
            return RiderIcons.FileTypes.Solution;
        }
        if (value instanceof PsiDirectory) {
            return ReSharperIcons.ProjectModel.Folder;
        }
        return null;
    }

    @NotNull
    public Collection<VirtualFile> additionalRoots(@Nullable Project project) {
        if (project == null) {
            return new ArrayList();
        }
        List result = new ArrayList();
        result.addAll(ExternalSourceService.Companion.getInstance(project).getExternalSourceDirectories());
        result.addAll(RiderNuGetPackageFolders.Companion.getInstance(project).getPackageFolders());
        return result;
    }
}

