/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.psi.PsiFile;
import com.intellij.rider.features.navbar.backend.MemberNavBarItem;
import com.intellij.rider.navbar.RiderNavbarMembersSupport;
import com.jetbrains.rdclient.fileStructure.FrontendFileStructureHost;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rider/navbar/RiderNavBarMemberItemDataRule;", "Lcom/intellij/ide/impl/dataRules/GetDataRule;", "()V", "lastStructureRoot", "Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getData", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getSymbolFromEditor", "Lcom/intellij/rider/features/navbar/backend/MemberNavBarItem;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.navbar.backend"})
public final class RiderNavBarMemberItemDataRule
implements GetDataRule {
    @Nullable
    private ProtocolStructureViewTreeElement lastStructureRoot;

    @Nullable
    public Pointer<? extends NavBarItem> getData(@NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        if (!UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataProvider);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        MemberNavBarItem memberNavBarItem = this.getSymbolFromEditor(project2, dataProvider);
        return memberNavBarItem != null ? memberNavBarItem.createPointer() : null;
    }

    private final MemberNavBarItem getSymbolFromEditor(Project project, DataProvider dataProvider) {
        ProtocolStructureViewTreeElement nextChild;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataProvider);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)editor2);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            return null;
        }
        PsiFile language = psiFile;
        if (RiderNavbarMembersSupport.INSTANCE.forLanguage((Language)language) == null) {
            return null;
        }
        Pair pair = (Pair)FrontendFileStructureHost.Companion.getInstance(project).getStructureTree().getValueOrNull();
        if (pair == null || (pair = (ProtocolStructureViewTreeElement)pair.getSecond()) == null) {
            return null;
        }
        Pair structure = pair;
        if (!(structure.getChildren().length == 0)) {
            this.lastStructureRoot = structure;
        }
        if (this.lastStructureRoot == null) {
            return null;
        }
        int currentOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        ProtocolStructureViewTreeElement protocolStructureViewTreeElement = this.lastStructureRoot;
        Intrinsics.checkNotNull((Object)protocolStructureViewTreeElement);
        ProtocolStructureViewTreeElement current = protocolStructureViewTreeElement;
        block0: do {
            nextChild = null;
            for (ProtocolStructureViewTreeElement child : current.getChildren()) {
                boolean isNodeWithEmptyRange;
                TextRange range = child.getMyFakePsiNode().getRange();
                boolean bl = isNodeWithEmptyRange = range != null && range.contains(currentOffset);
                if (!isNodeWithEmptyRange && (range != null || !(!(child.getChildren().length == 0)))) continue;
                nextChild = child;
                continue block0;
            }
        } while (nextChild != null);
        if (current.getProtocolTreeNode().getId() == 0) {
            return null;
        }
        PsiFile psiFile2 = PlatformTextControlUtilsKt.getPsiFile((Editor)editor2);
        if (psiFile2 == null) {
            return null;
        }
        return new MemberNavBarItem(project, current, psiFile2);
    }
}

