/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationRequests;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptorKt;
import com.jetbrains.rider.projectView.utils.NavigationUtilKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceEntityErrorsSupport;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/rider/navbar/EntityNavBarItem;", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "project", "Lcom/intellij/openapi/project/Project;", "originalEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;)V", "entity", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "originalName", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getIcon", "Ljavax/swing/Icon;", "getText", "forPopup", "", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "navigateOnClick", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "weight", "", "intellij.rider.navbar.backend"})
public final class EntityNavBarItem
extends DefaultNavBarItem<ProjectModelEntityReference> {
    @NotNull
    private final Project project;
    @NotNull
    private final String originalName;

    public EntityNavBarItem(@NotNull Project project, @NotNull ProjectModelEntity originalEntity) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalEntity, (String)"originalEntity");
        super((Object)ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)originalEntity));
        this.project = project;
        this.originalName = originalEntity.getName();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final ProjectModelEntity getEntity() {
        return ((ProjectModelEntityReference)this.getData()).getEntity(this.project);
    }

    @Nullable
    public Icon getIcon() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        if (projectModelEntity == null) {
            return AllIcons.Actions.Refresh;
        }
        ProjectModelEntity entity = projectModelEntity;
        return ProjectModelIconsKt.calculateIcon((ProjectModelEntity)entity, (Project)this.project);
    }

    @NotNull
    public String getText(boolean forPopup) {
        ProjectModelEntity projectModelEntity = this.getEntity();
        if (projectModelEntity == null) {
            return this.originalName;
        }
        ProjectModelEntity entity = projectModelEntity;
        return entity.getName();
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes errorAttributes;
        Color color;
        ProjectModelEntity projectModelEntity = this.getEntity();
        if (projectModelEntity == null) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            return simpleTextAttributes;
        }
        ProjectModelEntity entity = projectModelEntity;
        VirtualFileUrl virtualFileUrl = entity.getUrl();
        VirtualFile virtualFile = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
        Color color2 = color = virtualFile != null ? FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile).getColor() : null;
        SimpleTextAttributes simpleTextAttributes = errorAttributes = WorkspaceEntityErrorsSupport.Companion.getInstance(this.project).hasErrors(entity) ? DefaultNavBarItemKt.getNavBarErrorAttributes() : (virtualFile != null && WolfTheProblemSolver.getInstance((Project)this.project).isProblemFile(virtualFile) ? DefaultNavBarItemKt.getNavBarErrorAttributes() : null);
        SimpleTextAttributes simpleTextAttributes2 = errorAttributes;
        return new SimpleTextAttributes(null, color, simpleTextAttributes != null ? simpleTextAttributes.getWaveColor() : null, simpleTextAttributes2 != null ? simpleTextAttributes2.getStyle() : 0);
    }

    public boolean navigateOnClick() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)projectModelEntity) : false;
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity entity = projectModelEntity;
        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)this.project);
        if (n == null) {
            return null;
        }
        int entityId = n;
        VirtualFile virtualFile = NavigationUtilKt.getVirtualFileForNavigateToSource((ProjectModelEntity)entity);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        return NavigationRequests.Companion.getInstance().rawNavigationRequest(new Navigatable(entityId, virtualFile2, this){
            final /* synthetic */ int $entityId;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ EntityNavBarItem this$0;
            {
                this.$entityId = $entityId;
                this.$virtualFile = $virtualFile;
                this.this$0 = $receiver;
            }

            public void navigate(boolean requestFocus) {
                RiderOpenFileDescriptorKt.withProjectModelId((int)this.$entityId, (Function0)((Function0)new Function0<Unit>(this.$virtualFile, this.this$0, requestFocus){
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ EntityNavBarItem this$0;
                    final /* synthetic */ boolean $requestFocus;
                    {
                        this.$virtualFile = $virtualFile;
                        this.this$0 = $receiver;
                        this.$requestFocus = $requestFocus;
                        super(0);
                    }

                    public final void invoke() {
                        NavigationUtilKt.navigate((VirtualFile)this.$virtualFile, (Project)this.this$0.getProject(), (boolean)this.$requestFocus);
                    }
                }));
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
    }

    public int weight() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        if (projectModelEntity == null) {
            return super.weight();
        }
        ProjectModelEntity entity = projectModelEntity;
        return ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)entity) ? 2 : (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity) || ProjectModelEntityExtensionsKt.isUnloadedProject((ProjectModelEntity)entity) ? 3 : 4);
    }
}

