/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.model.TaskOptions;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001:\u0001&B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000e\u0010\u001e\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J8\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\r\b\u0002\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\u00032\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0007H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/plugins/watcher/config/ui/WatcherInfo;", "", "enabled", "", "watcher", "Lcom/intellij/plugins/watcher/model/TaskOptions;", "watcherName", "", "Lcom/intellij/openapi/util/NlsSafe;", "level", "Lcom/intellij/plugins/watcher/config/ui/WatcherInfo$WatcherLevel;", "(ZLcom/intellij/plugins/watcher/model/TaskOptions;Ljava/lang/String;Lcom/intellij/plugins/watcher/config/ui/WatcherInfo$WatcherLevel;)V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getLevel", "()Lcom/intellij/plugins/watcher/config/ui/WatcherInfo$WatcherLevel;", "setLevel", "(Lcom/intellij/plugins/watcher/config/ui/WatcherInfo$WatcherLevel;)V", "getWatcher", "()Lcom/intellij/plugins/watcher/model/TaskOptions;", "setWatcher", "(Lcom/intellij/plugins/watcher/model/TaskOptions;)V", "getWatcherName", "()Ljava/lang/String;", "setWatcherName", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "WatcherLevel", "intellij.fileWatcher"})
public final class WatcherInfo {
    private boolean enabled;
    @Nullable
    private TaskOptions watcher;
    @NotNull
    private String watcherName;
    @NotNull
    private WatcherLevel level;

    public WatcherInfo(boolean enabled, @Nullable TaskOptions watcher, @NotNull String watcherName, @NotNull WatcherLevel level) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)watcherName, (String)"watcherName");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.enabled = enabled;
        this.watcher = watcher;
        this.watcherName = watcherName;
        this.level = level;
        if (this.watcher == null) {
            v0 = this.level == WatcherLevel.Global;
        } else {
            TaskOptions taskOptions = this.watcher;
            v0 = bl = Intrinsics.areEqual((Object)this.watcherName, (Object)(taskOptions != null ? taskOptions.getName() : null));
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Nullable
    public final TaskOptions getWatcher() {
        return this.watcher;
    }

    public final void setWatcher(@Nullable TaskOptions taskOptions) {
        this.watcher = taskOptions;
    }

    @NotNull
    public final String getWatcherName() {
        return this.watcherName;
    }

    public final void setWatcherName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.watcherName = string;
    }

    @NotNull
    public final WatcherLevel getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull WatcherLevel watcherLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)watcherLevel), (String)"<set-?>");
        this.level = watcherLevel;
    }

    public final boolean component1() {
        return this.enabled;
    }

    @Nullable
    public final TaskOptions component2() {
        return this.watcher;
    }

    @NotNull
    public final String component3() {
        return this.watcherName;
    }

    @NotNull
    public final WatcherLevel component4() {
        return this.level;
    }

    @NotNull
    public final WatcherInfo copy(boolean enabled, @Nullable TaskOptions watcher, @NotNull String watcherName, @NotNull WatcherLevel level) {
        Intrinsics.checkNotNullParameter((Object)watcherName, (String)"watcherName");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return new WatcherInfo(enabled, watcher, watcherName, level);
    }

    public static /* synthetic */ WatcherInfo copy$default(WatcherInfo watcherInfo, boolean bl, TaskOptions taskOptions, String string, WatcherLevel watcherLevel, int n, Object object) {
        if ((n & 1) != 0) {
            bl = watcherInfo.enabled;
        }
        if ((n & 2) != 0) {
            taskOptions = watcherInfo.watcher;
        }
        if ((n & 4) != 0) {
            string = watcherInfo.watcherName;
        }
        if ((n & 8) != 0) {
            watcherLevel = watcherInfo.level;
        }
        return watcherInfo.copy(bl, taskOptions, string, watcherLevel);
    }

    @NotNull
    public String toString() {
        return "WatcherInfo(enabled=" + this.enabled + ", watcher=" + this.watcher + ", watcherName=" + this.watcherName + ", level=" + this.level + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.enabled);
        result = result * 31 + (this.watcher == null ? 0 : this.watcher.hashCode());
        result = result * 31 + this.watcherName.hashCode();
        result = result * 31 + this.level.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WatcherInfo)) {
            return false;
        }
        WatcherInfo watcherInfo = (WatcherInfo)other;
        if (this.enabled != watcherInfo.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.watcher, (Object)watcherInfo.watcher)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.watcherName, (Object)watcherInfo.watcherName)) {
            return false;
        }
        return this.level == watcherInfo.level;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001a\b\u0002\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/plugins/watcher/config/ui/WatcherInfo$WatcherLevel;", "", "myDisplayNameSupplier", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "(Ljava/lang/String;ILjava/util/function/Supplier;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "Project", "Global", "intellij.fileWatcher"})
    public static final class WatcherLevel
    extends Enum<WatcherLevel> {
        @NotNull
        private final Supplier<String> myDisplayNameSupplier;
        public static final /* enum */ WatcherLevel Project;
        public static final /* enum */ WatcherLevel Global;
        private static final /* synthetic */ WatcherLevel[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private WatcherLevel(Supplier<String> myDisplayNameSupplier) {
            this.myDisplayNameSupplier = myDisplayNameSupplier;
        }

        @NotNull
        public final String getDisplayName() {
            String string = this.myDisplayNameSupplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        public static WatcherLevel[] values() {
            return (WatcherLevel[])$VALUES.clone();
        }

        public static WatcherLevel valueOf(String value) {
            return Enum.valueOf(WatcherLevel.class, value);
        }

        @NotNull
        public static EnumEntries<WatcherLevel> getEntries() {
            return $ENTRIES;
        }

        static {
            Supplier<String> supplier = BackgroundTaskBundle.messagePointer("file.watcher.level.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Project = new WatcherLevel(supplier);
            Supplier<String> supplier2 = BackgroundTaskBundle.messagePointer("file.watcher.level.global", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier2, (String)"messagePointer(...)");
            Global = new WatcherLevel(supplier2);
            $VALUES = watcherLevelArray = new WatcherLevel[]{WatcherLevel.Project, WatcherLevel.Global};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

