/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialogPanel;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.tools.FilterInfo;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewWatcherDialog
extends DialogWrapper {
    private static final String[] WINDOWS_EXTENSIONS = new String[]{".com", ".exe", ".bat", ".cmd"};
    private final Project myProject;
    private final boolean myDefaultProject;
    private final DataContext myDataContext;
    private final NewWatcherDialogPanel content;

    public NewWatcherDialog(@NotNull Project project, @NotNull TaskOptions options, @NlsContexts.DialogTitle String title) {
        if (project == null) {
            NewWatcherDialog.$$$reportNull$$$0(0);
        }
        if (options == null) {
            NewWatcherDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myDefaultProject = this.myProject.isDefault();
        this.content = new NewWatcherDialogPanel(this.myProject);
        this.myDataContext = TaskUtils.getContext(this.myProject, null);
        this.setTitle(title);
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.programField.getTextField()));
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.argumentsField.getTextField()));
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.workingDirField.getTextField()));
        MacrosDialog.addTextFieldExtension((ExtendableTextField)((ExtendableTextField)this.content.outputField.getTextField()));
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return super.isFileSelectable(file) || file != null && SystemInfo.isMac && file.isDirectory() && "app".equals(file.getExtension());
            }
        };
        this.content.programField.addBrowseFolderListener(new TextBrowseFolderListener(fileChooserDescriptor, project){
            private boolean myPathStartsWithProjectFileDirMacro;
            {
                this.myPathStartsWithProjectFileDirMacro = false;
            }

            @Nullable
            protected VirtualFile getInitialFile() {
                this.myPathStartsWithProjectFileDirMacro = NewWatcherDialog.this.content.programField.getText().trim().startsWith("$ProjectFileDir$");
                return super.getInitialFile();
            }

            @NotNull
            protected String expandPath(@NotNull String path) {
                File ioFile;
                if (path == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = (ioFile = NewWatcherDialog.findProgramFile(NewWatcherDialog.this.content.programField.getText().trim(), NewWatcherDialog.this.myDataContext, NewWatcherDialog.this.content.envComponent.getEnvData())) != null ? FileUtil.toSystemIndependentName((String)ioFile.getAbsolutePath()) : path;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                String macroExpanded;
                if (chosenFile == null) {
                    2.$$$reportNull$$$0(2);
                }
                Object path = FileUtil.toSystemDependentName((String)chosenFile.getPath());
                if (SystemInfo.isWindows) {
                    String lowerCase = StringUtil.toLowerCase((String)path);
                    for (String extension : WINDOWS_EXTENSIONS) {
                        if (!lowerCase.endsWith(extension)) continue;
                        path = ((String)path).substring(0, ((String)path).length() - extension.length());
                        break;
                    }
                }
                if (this.myPathStartsWithProjectFileDirMacro && (macroExpanded = new ProjectFileDirMacro().expand(NewWatcherDialog.this.myDataContext)) != null && ((String)path).startsWith(macroExpanded)) {
                    path = "$ProjectFileDir$" + ((String)path).substring(macroExpanded.length());
                }
                String string = path;
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        });
        JTextField programTextField = this.content.programField.getTextField();
        if (programTextField instanceof JBTextField) {
            ((JBTextField)programTextField).getEmptyText().setText(BackgroundTaskBundle.message("file.watcher.dialog.status.text.program.path.not.set", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        this.content.workingDirField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        for (TaskOptions.ExitCodeBehavior behavior : TaskOptions.ExitCodeBehavior.values()) {
            ((DefaultComboBoxModel)this.content.behaviourComboBox.getModel()).addElement(behavior);
        }
        this.content.behaviourComboBox.setRenderer((ListCellRenderer<TaskOptions.ExitCodeBehavior>)SimpleListCellRenderer.create((String)"", TaskOptions.ExitCodeBehavior::getDisplayName));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.content.scopeCombo);
        if (!this.myDefaultProject) {
            this.content.scopeCombo.setShowEmptyScopes(true);
            this.content.scopeCombo.setCurrentSelection(false);
            ((JComboBox)this.content.scopeCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewWatcherDialog.this.updateMatchedFilesInfo();
                }
            });
        }
        this.content.fileTypesCombo.setPrototypeDisplayValue(TaskUtils.FAKE_ANY_FILE_TYPE);
        this.content.fileTypesCombo.setRenderer((ListCellRenderer<FileType>)new FileTypeRenderer());
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, Comparator.comparing(FileType::getName));
        ((DefaultComboBoxModel)this.content.fileTypesCombo.getModel()).addElement(TaskUtils.FAKE_ANY_FILE_TYPE);
        for (FileType type : fileTypes) {
            if (type instanceof InternalFileType || type instanceof FakeFileType) continue;
            ((DefaultComboBoxModel)this.content.fileTypesCombo.getModel()).addElement(type);
        }
        ComboboxSpeedSearch search = new ComboboxSpeedSearch(this.content.fileTypesCombo, null){

            protected String getElementText(Object element) {
                return ((FileType)element).getName();
            }
        };
        search.setupListeners();
        this.content.fileTypesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileType fileType = (FileType)NewWatcherDialog.this.content.fileTypesCombo.getSelectedItem();
                boolean enabled = fileType != null && TaskUtils.findDependencyFinderForExtension(fileType.getDefaultExtension()) != null;
                NewWatcherDialog.this.content.trackOnlyRootFilesCheckBox.setEnabled(enabled);
            }
        });
        this.content.fileTypesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewWatcherDialog.this.updateMatchedFilesInfo();
            }
        });
        this.content.programField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                NewWatcherDialog.this.updateProgramNotFoundErrorLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/watcher/config/ui/NewWatcherDialog$7", "textChanged"));
            }
        });
        this.content.noSuchFilesInScopeErrorLabel.setIcon(AllIcons.General.BalloonWarning);
        this.content.envComponent.addChangeListener(e -> this.updateProgramNotFoundErrorLabel());
        this.setTaskOptions(options);
        this.updateMatchedFilesInfo();
        this.updateProgramNotFoundErrorLabel();
        this.init();
    }

    private void updateMatchedFilesInfo() {
        FileType fileType = (FileType)this.content.fileTypesCombo.getSelectedItem();
        if (fileType == UnknownFileType.INSTANCE) {
            this.content.noSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("file.watcher.dialog.error.label.unknown.file.type", new Object[0]));
            this.content.noSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        if (this.myDefaultProject) {
            this.content.noSuchFilesInScopeErrorLabel.setVisible(false);
            return;
        }
        SearchScope selectedScope = this.content.scopeCombo.getSelectedScope();
        if (selectedScope == null) {
            this.content.noSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("file.watcher.dialog.error.label.unknown.scope", new Object[0]));
            this.content.noSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        if (fileType != null && fileType != TaskUtils.FAKE_ANY_FILE_TYPE && selectedScope instanceof GlobalSearchScope && !(selectedScope instanceof ScratchesSearchScope) && !FileTypeIndex.containsFileOfType((FileType)fileType, (GlobalSearchScope)((GlobalSearchScope)selectedScope))) {
            this.content.noSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("file.watcher.dialog.warning.label.no.such.files.in.scope", new Object[0]));
            this.content.noSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        this.content.noSuchFilesInScopeErrorLabel.setVisible(false);
    }

    private void updateProgramNotFoundErrorLabel() {
        String program = this.content.programField.getText().trim();
        if (!(program.isEmpty() || this.myDefaultProject && MacroManager.containsMacros((String)program) || NewWatcherDialog.findProgramFile(program, this.myDataContext, this.content.envComponent.getEnvData()) != null)) {
            this.content.programField.getTextField().setForeground((Color)JBColor.RED);
        } else {
            this.content.programField.getTextField().setForeground(UIUtil.getLabelForeground());
        }
    }

    @Nullable
    public static File findProgramFile(@NotNull String program, @Nullable DataContext dataContext, @NotNull EnvironmentVariablesData envData) {
        String path;
        if (program == null) {
            NewWatcherDialog.$$$reportNull$$$0(2);
        }
        if (envData == null) {
            NewWatcherDialog.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)program)) {
            return null;
        }
        if ((program = NewWatcherDialog.expandMacrosIfNeeded(program, dataContext)) == null) {
            return null;
        }
        if (OSAgnosticPathUtil.isAbsolute((String)program)) {
            File file = new File(program);
            boolean exists = file.exists();
            if (exists && file.isDirectory() && SystemInfo.isMac && program.endsWith(".app")) {
                return file;
            }
            if (!(!SystemInfo.isWindows || exists && NewWatcherDialog.hasWindowsExecutableExtension(file.getName()))) {
                for (String ext : WINDOWS_EXTENSIONS) {
                    File file1 = new File(program + ext);
                    if (!file1.exists() || file1.isDirectory()) continue;
                    return file1;
                }
            }
            return exists ? file : null;
        }
        String customPath = (String)envData.getEnvs().get("PATH");
        String string = path = StringUtil.isEmpty((String)customPath) ? EnvironmentUtil.getValue((String)"PATH") : NewWatcherDialog.expandMacrosIfNeeded(customPath, dataContext);
        if (path == null) {
            return null;
        }
        File file = PathEnvironmentVariableUtil.findInPath((String)program, (String)path, null);
        if (SystemInfo.isWindows && (file == null || !NewWatcherDialog.hasWindowsExecutableExtension(file.getName()))) {
            for (String ext : WINDOWS_EXTENSIONS) {
                File file1 = PathEnvironmentVariableUtil.findInPath((String)(program + ext), (String)path, null);
                if (file1 == null || file1.isDirectory()) continue;
                return file1;
            }
        }
        return file;
    }

    private static boolean hasWindowsExecutableExtension(@NotNull String _fileName) {
        if (_fileName == null) {
            NewWatcherDialog.$$$reportNull$$$0(4);
        }
        String fileName = StringUtil.toLowerCase((String)_fileName);
        for (String ext : WINDOWS_EXTENSIONS) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String expandMacrosIfNeeded(@NotNull String str, @Nullable DataContext dataContext) {
        if (str == null) {
            NewWatcherDialog.$$$reportNull$$$0(5);
        }
        if (!MacroManager.containsMacros((String)str)) {
            return str;
        }
        MacroManager macroManager = MacroManager.getInstance();
        try {
            return macroManager.expandSilentMacros(str, true, dataContext);
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.content.panel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "EditFileWatcherDialog";
    }

    public TaskOptions getTaskOptions() {
        TaskOptions options = new TaskOptions();
        options.setName(this.content.nameField.getText().trim());
        FileType fileType = (FileType)ObjectUtils.notNull((Object)((FileType)this.content.fileTypesCombo.getSelectedItem()), (Object)FileTypes.UNKNOWN);
        String defaultExtension = fileType.getDefaultExtension();
        options.setFileExtension(StringUtil.isEmpty((String)defaultExtension) ? fileType.getName() : defaultExtension);
        if (this.myDefaultProject) {
            options.setScopeName((String)this.content.scopeForDefaultProjectCombo.getItem());
        } else {
            options.setScopeName(this.content.scopeCombo.getSelectedScopeName());
        }
        options.setProgram(this.content.programField.getText().trim());
        options.setArguments(this.content.argumentsField.getText().trim());
        options.setWorkingDir(this.content.workingDirField.getText().trim());
        options.setOutput(this.content.outputField.getText().trim());
        options.setTrackOnlyRoot(this.content.trackOnlyRootFilesCheckBox.isSelected());
        options.setImmediateSync(this.content.immediateFileSynchronizationCheckBox.isSelected());
        options.setRunOnExternalChanges(this.content.runOnExternalChangesCheckBox.isSelected());
        options.setCheckSyntaxErrors(!this.content.triggerWatcherRegardlessSyntaxErrorsCheckBox.isSelected());
        options.setOutputFromStdout(this.content.outputFromStdout.isSelected());
        options.setEnvData(this.content.envComponent.getEnvData());
        String filtersText = this.content.outputFilterField.getText().trim();
        FilterInfo[] filters = filtersText.isEmpty() ? new FilterInfo[]{} : (FilterInfo[])Arrays.stream(StringUtil.splitByLines((String)filtersText)).map(s -> new FilterInfo(s, "", "")).toArray(FilterInfo[]::new);
        options.setOutputFilters(filters);
        options.setExitCodeBehavior((TaskOptions.ExitCodeBehavior)((Object)ObjectUtils.notNull((Object)((Object)((TaskOptions.ExitCodeBehavior)((Object)this.content.behaviourComboBox.getSelectedItem()))), (Object)((Object)TaskOptions.ExitCodeBehavior.ERROR))));
        return options;
    }

    private void setTaskOptions(@NotNull TaskOptions options) {
        if (options == null) {
            NewWatcherDialog.$$$reportNull$$$0(6);
        }
        this.content.nameField.setText(StringUtil.notNullize((String)options.getName()));
        this.content.fileTypesCombo.setSelectedItem(options.getFileType());
        final String scopeName = options.getScopeName();
        if (this.myDefaultProject) {
            String[] items = new String[]{ProjectScope.getProjectFilesScopeName(), GlobalSearchScopesCore.getProjectProductionFilesScopeName(), GlobalSearchScopesCore.getProjectTestFilesScopeName()};
            this.content.scopeForDefaultProjectCombo.setModel(new DefaultComboBoxModel<String>(items));
            if (StringUtil.isEmpty((String)scopeName)) {
                this.content.scopeForDefaultProjectCombo.setSelectedIndex(0);
            } else {
                if (!ArrayUtil.contains((String)scopeName, (String[])items)) {
                    this.content.scopeForDefaultProjectCombo.insertItemAt((Object)scopeName, 0);
                }
                this.content.scopeForDefaultProjectCombo.setSelectedItem((Object)scopeName);
            }
        } else {
            this.content.scopeCombo.init(this.myProject, scopeName);
            if (!StringUtil.isEmpty((String)scopeName) && !scopeName.equals(this.content.scopeCombo.getSelectedScopeName())) {
                this.content.scopeCombo.getComboBox().insertItemAt((Object)new ScopeDescriptor(null){

                    public String getDisplayName() {
                        return scopeName;
                    }

                    public Icon getIcon() {
                        return AllIcons.General.BalloonWarning;
                    }
                }, 0);
                this.content.scopeCombo.getComboBox().setSelectedIndex(0);
            }
        }
        this.content.programField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getProgram())));
        this.content.argumentsField.setText(options.getArguments());
        this.content.workingDirField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getWorkingDir())));
        this.content.outputField.setText(options.getOutput());
        this.content.trackOnlyRootFilesCheckBox.setSelected(options.isTrackOnlyRoot());
        this.content.triggerWatcherRegardlessSyntaxErrorsCheckBox.setSelected(!options.isCheckSyntaxErrors());
        this.content.immediateFileSynchronizationCheckBox.setSelected(options.isImmediateSync());
        this.content.runOnExternalChangesCheckBox.setSelected(options.isRunOnExternalChanges());
        this.content.outputFromStdout.setSelected(options.isOutputFromStdout());
        this.content.envComponent.setEnvData(options.getEnvData());
        this.content.outputFilterField.setText(Arrays.stream(options.getOutputFilters()).map(f -> f.getRegExp()).collect(Collectors.joining("\n")));
        this.content.behaviourComboBox.setSelectedItem((Object)options.getExitCodeBehavior());
    }

    @Nullable
    protected String getHelpId() {
        return "settings.project.settings.file.watchers.new.watcher";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "program";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findProgramFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWindowsExecutableExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "expandMacrosIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTaskOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

