/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.fsharp.services.fsi.runScript;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.debugger.IRiderDebuggable;
import com.jetbrains.rider.ideaInterop.fileTypes.fsharp.FSharpScriptFileType;
import com.jetbrains.rider.plugins.fsharp.FSharpBundle;
import com.jetbrains.rider.plugins.fsharp.services.fsi.runScript.FSharpScriptConfigurationEditor;
import com.jetbrains.rider.plugins.fsharp.services.fsi.runScript.FSharpScriptExecutorFactory;
import com.jetbrains.rider.run.configurations.AsyncExecutorFactory;
import com.jetbrains.rider.run.configurations.DotProfilingAwareRunConfiguration;
import com.jetbrains.rider.run.configurations.RiderAsyncRunConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 '2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001'B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\b\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/runScript/FSharpScriptConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderAsyncRunConfiguration;", "Lcom/jetbrains/rider/debugger/IRiderDebuggable;", "Lcom/jetbrains/rider/run/configurations/DotProfilingAwareRunConfiguration;", "name", "", "scriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "envs", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/Map;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "getEnvs", "()Ljava/util/Map;", "setEnvs", "(Ljava/util/Map;)V", "getScriptFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setScriptFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "checkConfiguration", "", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfigurationEditor", "Lcom/jetbrains/rider/plugins/fsharp/services/fsi/runScript/FSharpScriptConfigurationEditor;", "readExternal", "element", "Lorg/jdom/Element;", "suggestedName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "supportsProfiling", "", "executorId", "writeExternal", "Companion", "intellij.rider.plugins.fsharp"})
public final class FSharpScriptConfiguration
extends RiderAsyncRunConfiguration
implements IRiderDebuggable,
DotProfilingAwareRunConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private VirtualFile scriptFile;
    @NotNull
    private Map<String, String> envs;
    @NotNull
    private static final String SCRIPT_PATH = "SCRIPT_PATH";

    public FSharpScriptConfiguration(@NotNull String name, @Nullable VirtualFile scriptFile, @NotNull Map<String, String> envs, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(name, project, factory, (Function1)1.INSTANCE, (AsyncExecutorFactory)new FSharpScriptExecutorFactory());
        this.scriptFile = scriptFile;
        this.envs = envs;
    }

    @Nullable
    public final VirtualFile getScriptFile() {
        return this.scriptFile;
    }

    public final void setScriptFile(@Nullable VirtualFile virtualFile) {
        this.scriptFile = virtualFile;
    }

    @NotNull
    public final Map<String, String> getEnvs() {
        return this.envs;
    }

    public final void setEnvs(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.envs = map;
    }

    public void checkConfiguration() {
        block3: {
            block2: {
                super.checkConfiguration();
                if (this.scriptFile == null) break block2;
                VirtualFile virtualFile = this.scriptFile;
                Intrinsics.checkNotNull((Object)virtualFile);
                if (!virtualFile.exists()) break block2;
                VirtualFile virtualFile2 = this.scriptFile;
                Intrinsics.checkNotNull((Object)virtualFile2);
                if (Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)FSharpScriptFileType.INSTANCE.getDefaultExtension())) break block3;
            }
            throw new RuntimeConfigurationError(FSharpBundle.message("Fsi.runConfiguration.has.invalid.script.file.path", new Object[0]));
        }
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        String string = JDOMExternalizerUtil.readField((Element)element, (String)SCRIPT_PATH);
        this.scriptFile = string != null ? DocumentUtilKt.toVirtualFile((String)string, (boolean)true) : null;
        Map savedEnvs = new LinkedHashMap();
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)savedEnvs);
        this.envs = savedEnvs;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        VirtualFile virtualFile = this.scriptFile;
        JDOMExternalizerUtil.writeField((Element)element, (String)SCRIPT_PATH, (String)(virtualFile != null ? virtualFile.getPath() : null));
        EnvironmentVariablesComponent.writeExternal((Element)element, this.envs);
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        FSharpScriptConfiguration newConfiguration = new FSharpScriptConfiguration(string, this.scriptFile, this.envs, project, configurationFactory);
        newConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)newConfiguration);
        return (RunConfiguration)newConfiguration;
    }

    @NotNull
    public FSharpScriptConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new FSharpScriptConfigurationEditor(project);
    }

    public boolean supportsProfiling(@NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        return false;
    }

    @Nullable
    public String suggestedName() {
        VirtualFile virtualFile = this.scriptFile;
        return virtualFile != null ? virtualFile.getName() : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/fsharp/services/fsi/runScript/FSharpScriptConfiguration$Companion;", "", "()V", "SCRIPT_PATH", "", "intellij.rider.plugins.fsharp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

