/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.VcsFeatureProviderKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/VcsFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "intellij.completionMlRanking"})
final class VcsFeatureProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "vcs";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map features2;
        block5: {
            PsiElement psi;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
            Integer changesCount = (Integer)contextFeatures.getUserData(VcsFeatureProviderKt.getChangesCountKey());
            if (changesCount == null || changesCount > 1000) {
                return MapsKt.emptyMap();
            }
            features2 = new LinkedHashMap();
            Project project = location.getProject();
            PsiElement psiElement = psi = element.getPsiElement();
            Object psiFile = psiElement != null ? psiElement.getContainingFile() : null;
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null || (psiFile2 = psiFile2.getViewProvider()) == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block5;
            PsiFile file = psiFile2;
            boolean bl = false;
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
            ChangeListManager changeListManager2 = changeListManager;
            Change change = changeListManager2.getChange((VirtualFile)file);
            if (change != null) {
                Change change2 = change;
                boolean bl2 = false;
                features2.put("file_state", MLFeatureValue.Companion.categorical((Enum)change2.getType()));
                if (change2.getType() == Change.Type.MODIFICATION && psi instanceof PsiNameIdentifierOwner) {
                    Document document = PsiDocumentManager.getInstance((Project)project).getCachedDocument(psiFile);
                    TextRange range = ((PsiNameIdentifierOwner)psi).getTextRange();
                    if (document != null && range != null && range.getEndOffset() <= document.getTextLength()) {
                        Intrinsics.checkNotNull((Object)project);
                        LineStatusTracker lineStatusTracker = LineStatusTrackerManager.Companion.getInstance(project).getLineStatusTracker(document);
                        if (lineStatusTracker != null && lineStatusTracker.isValid() && lineStatusTracker.isRangeModified(document.getLineNumber(range.getStartOffset()), document.getLineNumber(range.getEndOffset()))) {
                            features2.put("declaration_is_changed", MLFeatureValue.Companion.binary(true));
                        }
                    }
                }
            }
        }
        return features2;
    }
}

