/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.SingleFileDiffPreviewProcessor;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryDiffProcessor;", "Lcom/intellij/openapi/vcs/changes/SingleFileDiffPreviewProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "changeGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/vcs/changes/Change;", "isInEditor", "", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;ZLcom/intellij/openapi/Disposable;)V", "getCurrentRequestProvider", "Lcom/intellij/diff/chains/DiffRequestProducer;", "getFastLoadingTimeMillis", "", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "intellij.platform.vcs.log.impl"})
public final class FileHistoryDiffProcessor
extends SingleFileDiffPreviewProcessor {
    @NotNull
    private final Function0<Change> changeGetter;
    private final boolean isInEditor;

    public FileHistoryDiffProcessor(@NotNull Project project, @NotNull Function0<? extends Change> changeGetter, boolean isInEditor, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(changeGetter, (String)"changeGetter");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project, isInEditor ? "Default" : "VcsFileHistoryView");
        this.changeGetter = changeGetter;
        this.isInEditor = isInEditor;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
    }

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return !this.isInEditor || super.shouldAddToolbarBottomBorder(toolbarComponents);
    }

    protected int getFastLoadingTimeMillis() {
        return 10;
    }

    @Nullable
    protected DiffRequestProducer getCurrentRequestProvider() {
        Change change = (Change)this.changeGetter.invoke();
        if (change == null) {
            return null;
        }
        Change change2 = change;
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project);
        return (DiffRequestProducer)VcsLogChangesBrowser.Companion.createDiffRequestProducer(project, change2, new HashMap(), true);
    }
}

