/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.GraphPrintElement;
import com.intellij.vcs.log.graph.impl.facade.CascadeController;
import com.intellij.vcs.log.graph.impl.facade.GraphChangesUtil;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.sort.SortIndexMap;
import com.intellij.vcs.log.graph.impl.facade.sort.SortedBaseController;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraphBuilder;
import com.intellij.vcs.log.graph.utils.BfsSearch;
import com.intellij.vcs.log.graph.utils.IntHashSetFlags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u000256B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0016H\u0014J\b\u0010!\u001a\u00020\u0016H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&2\u0006\u0010'\u001a\u00020\u0019H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00162\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J3\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-2\u0006\u0010.\u001a\u00020\u001e2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u0001H-00H\u0002\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u0004\u0018\u00010\u00162\u0006\u00103\u001a\u000204H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController;", "Lcom/intellij/vcs/log/graph/impl/facade/CascadeController;", "controller", "Lcom/intellij/vcs/log/graph/impl/facade/sort/SortedBaseController;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "(Lcom/intellij/vcs/log/graph/impl/facade/sort/SortedBaseController;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)V", "bekGraphLayout", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout;", "compiledGraph", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraph;", "getCompiledGraph", "()Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraph;", "delegateGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "getDelegateGraph", "()Lcom/intellij/vcs/log/graph/api/LinearGraph;", "linearBekGraphBuilder", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder;", "mergeCommits", "Lit/unimi/dsi/fastutil/ints/IntSet;", "collapseAll", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAnswer;", "collapseNode", "node", "Lcom/intellij/vcs/log/graph/api/elements/GraphNode;", "collectChildFragments", "", "Lcom/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$MergeFragment;", "merge", "", "delegateGraphChanged", "delegateAnswer", "expandAll", "expandEdge", "edge", "Lcom/intellij/vcs/log/graph/api/elements/GraphEdge;", "getAllAdjacentDottedEdges", "", "graphElement", "highlightEdge", "highlightNode", "isCollapsed", "", "iterateMerges", "T", "start", "function", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "performAction", "action", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController$LinearGraphAction;", "BekGraphLayout", "Companion", "intellij.platform.vcs.log.graph.impl"})
@SourceDebugExtension(value={"SMAP\nLinearBekController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearBekController.kt\ncom/intellij/vcs/log/graph/linearBek/LinearBekController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n766#2:195\n857#2,2:196\n1#3:198\n*S KotlinDebug\n*F\n+ 1 LinearBekController.kt\ncom/intellij/vcs/log/graph/linearBek/LinearBekController\n*L\n89#1:195\n89#1:196,2\n*E\n"})
public final class LinearBekController
extends CascadeController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinearBekGraph compiledGraph;
    @NotNull
    private final BekGraphLayout bekGraphLayout;
    @NotNull
    private final LinearBekGraphBuilder linearBekGraphBuilder;
    @NotNull
    private final IntSet mergeCommits;
    @NotNull
    private static final Logger LOG;
    private static final int MAX_COLLAPSED_MERGES = 10;

    public LinearBekController(@NotNull SortedBaseController controller, @NotNull PermanentGraphInfo<?> permanentGraphInfo) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        super(controller, permanentGraphInfo);
        this.compiledGraph = new LinearBekGraph(this.getDelegateGraph());
        GraphLayout graphLayout = permanentGraphInfo.getPermanentGraphLayout();
        Intrinsics.checkNotNullExpressionValue((Object)graphLayout, (String)"getPermanentGraphLayout(...)");
        SortIndexMap sortIndexMap = controller.getBekIntMap();
        Intrinsics.checkNotNullExpressionValue((Object)sortIndexMap, (String)"getBekIntMap(...)");
        this.bekGraphLayout = new BekGraphLayout(graphLayout, sortIndexMap);
        this.linearBekGraphBuilder = new LinearBekGraphBuilder(this.getCompiledGraph(), this.bekGraphLayout);
        long start2 = System.currentTimeMillis();
        IntSet intSet = this.linearBekGraphBuilder.collapseAll();
        Intrinsics.checkNotNullExpressionValue((Object)intSet, (String)"collapseAll(...)");
        this.mergeCommits = intSet;
        LOG.debug("Linear bek took " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
    }

    private final LinearGraph getDelegateGraph() {
        return this.getDelegateController().getCompiledGraph();
    }

    @Override
    @NotNull
    public LinearBekGraph getCompiledGraph() {
        return this.compiledGraph;
    }

    @Override
    @NotNull
    protected LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer delegateAnswer) {
        Intrinsics.checkNotNullParameter((Object)delegateAnswer, (String)"delegateAnswer");
        return delegateAnswer;
    }

    @Override
    @Nullable
    protected LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (action.getType() == GraphAction.Type.BUTTON_COLLAPSE) {
            return this.collapseAll();
        }
        if (action.getType() == GraphAction.Type.BUTTON_EXPAND) {
            return this.expandAll();
        }
        GraphPrintElement graphPrintElement = action.getAffectedElement();
        if (graphPrintElement == null) {
            return null;
        }
        GraphPrintElement affectedElement = graphPrintElement;
        if (action.getType() == GraphAction.Type.MOUSE_CLICK) {
            GraphElement graphElement = affectedElement.getGraphElement();
            if (graphElement instanceof GraphNode) {
                LinearGraphController.LinearGraphAnswer answer = this.collapseNode((GraphNode)graphElement);
                if (answer != null) {
                    return answer;
                }
                for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                    LinearGraphController.LinearGraphAnswer expandedAnswer = this.expandEdge(dottedEdge);
                    if (expandedAnswer == null) continue;
                    return expandedAnswer;
                }
            } else if (graphElement instanceof GraphEdge) {
                return this.expandEdge((GraphEdge)graphElement);
            }
        } else if (action.getType() == GraphAction.Type.MOUSE_OVER) {
            GraphElement graphElement = affectedElement.getGraphElement();
            if (graphElement instanceof GraphNode) {
                LinearGraphController.LinearGraphAnswer answer = this.highlightNode((GraphNode)graphElement);
                if (answer != null) {
                    return answer;
                }
                for (GraphEdge dottedEdge : this.getAllAdjacentDottedEdges((GraphNode)graphElement)) {
                    LinearGraphController.LinearGraphAnswer highlightAnswer = this.highlightEdge(dottedEdge);
                    if (highlightAnswer == null) continue;
                    return highlightAnswer;
                }
            } else if (graphElement instanceof GraphEdge) {
                return this.highlightEdge((GraphEdge)graphElement);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GraphEdge> getAllAdjacentDottedEdges(GraphNode graphElement) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getCompiledGraph().getAdjacentEdges(graphElement.getNodeIndex(), EdgeFilter.ALL);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GraphEdge graphEdge = (GraphEdge)element$iv$iv;
            boolean bl = false;
            if (!(graphEdge.getType() == GraphEdgeType.DOTTED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final LinearGraphController.LinearGraphAnswer expandAll() {
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES, () -> LinearBekController.expandAll$lambda$1(this));
    }

    private final LinearGraphController.LinearGraphAnswer collapseAll() {
        LinearBekGraph.WorkingLinearBekGraph workingGraph = new LinearBekGraph.WorkingLinearBekGraph(this.getCompiledGraph());
        new LinearBekGraphBuilder(workingGraph, this.bekGraphLayout).collapseAll();
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(workingGraph.getRemovedEdges(), workingGraph.getAddedEdges(), this.getDelegateGraph()), () -> LinearBekController.collapseAll$lambda$2(workingGraph));
    }

    private final <T> T iterateMerges(int start2, Function1<? super Integer, ? extends T> function) {
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(this.getDelegateGraph());
        IntHashSetFlags intHashSetFlags = new IntHashSetFlags(this.getDelegateGraph().nodesCount());
        BfsSearch search2 = new BfsSearch<T>(start2, liteLinearGraph, intHashSetFlags){
            @NotNull
            private final Queue<Integer> queue;
            {
                void it;
                PriorityQueue<T> priorityQueue;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($start, $super_call_param$1, $super_call_param$2, false, 200);
                PriorityQueue<T> priorityQueue2 = priorityQueue = new PriorityQueue<T>(1, Collections.reverseOrder());
                iterateMerges.search.1 var7_6 = this;
                boolean bl = false;
                it.add($start);
                var7_6.queue = priorityQueue;
            }

            @NotNull
            protected Queue<Integer> getQueue() {
                return this.queue;
            }
        };
        return search2.find((Function1)new Function1<Integer, T>(this, function){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ Function1<Integer, T> $function;
            {
                this.this$0 = $receiver;
                this.$function = $function;
                super(1);
            }

            @Nullable
            public final T invoke(int it) {
                return (T)(LinearBekController.access$getMergeCommits$p(this.this$0).contains(it) ? this.$function.invoke((Object)it) : null);
            }
        });
    }

    private final boolean isCollapsed(int merge) {
        return LinearGraphUtils.getDownNodes(this.getCompiledGraph(), merge).size() == 1;
    }

    private final LinearGraphController.LinearGraphAnswer highlightNode(GraphNode node) {
        return (LinearGraphController.LinearGraphAnswer)this.iterateMerges(node.getNodeIndex(), (Function1)new Function1<Integer, LinearGraphController.LinearGraphAnswer>(this, node){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ GraphNode $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LinearGraphController.LinearGraphAnswer invoke(int merge) {
                if (!LinearBekController.access$isCollapsed(this.this$0, merge)) {
                    void destination$iv;
                    void $this$flatMapTo$iv;
                    Set fragments = LinearBekController.access$collectChildFragments(this.this$0, merge);
                    if (fragments.isEmpty()) {
                        return null;
                    }
                    Iterable iterable = fragments;
                    Collection collection = new LinkedHashSet<E>();
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        LinearBekGraphBuilder.MergeFragment it = (LinearBekGraphBuilder.MergeFragment)element$iv;
                        boolean bl = false;
                        Set<Integer> set = it.getAllNodes();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllNodes(...)");
                        Iterable list$iv = set;
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    Set nodesToHighlight = (Set)destination$iv;
                    if (nodesToHighlight.contains(this.$node.getNodeIndex())) {
                        return LinearGraphUtils.createSelectedAnswer(this.this$0.getCompiledGraph(), nodesToHighlight);
                    }
                }
                return null;
            }
        });
    }

    private final LinearGraphController.LinearGraphAnswer collapseNode(GraphNode node) {
        return (LinearGraphController.LinearGraphAnswer)this.iterateMerges(node.getNodeIndex(), (Function1)new Function1<Integer, LinearGraphController.LinearGraphAnswer>(this, node){
            final /* synthetic */ LinearBekController this$0;
            final /* synthetic */ GraphNode $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final LinearGraphController.LinearGraphAnswer invoke(int merge) {
                if (!LinearBekController.access$isCollapsed(this.this$0, merge)) {
                    Iterable $this$flatMapTo$iv;
                    Set fragments = LinearBekController.access$collectChildFragments(this.this$0, merge);
                    if (fragments.isEmpty()) {
                        return null;
                    }
                    Iterable iterable = fragments;
                    Object destination$iv = new TreeSet<T>(Comparator.reverseOrder());
                    boolean $i$f$flatMapTo = false;
                    for (T element$iv : $this$flatMapTo$iv) {
                        LinearBekGraphBuilder.MergeFragment f = (LinearBekGraphBuilder.MergeFragment)element$iv;
                        boolean bl = false;
                        Set<Integer> set = f.getTailsAndBody();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"getTailsAndBody(...)");
                        Iterable list$iv = SetsKt.plus(set, (Object)f.getParent());
                        CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                    }
                    TreeSet nodesToCollapse = (TreeSet)destination$iv;
                    if (!nodesToCollapse.contains(this.$node.getNodeIndex())) {
                        boolean bl;
                        block9: {
                            void $this$any$iv;
                            $this$flatMapTo$iv = fragments;
                            destination$iv = this.$node;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    LinearBekGraphBuilder.MergeFragment it = (LinearBekGraphBuilder.MergeFragment)element$iv;
                                    boolean bl2 = false;
                                    if (!(it.getLeftChild() == ((GraphNode)destination$iv).getNodeIndex())) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) {
                            return null;
                        }
                    }
                    for (Integer i : nodesToCollapse) {
                        LinearBekGraphBuilder linearBekGraphBuilder = LinearBekController.access$getLinearBekGraphBuilder$p(this.this$0);
                        Intrinsics.checkNotNull((Object)i);
                        linearBekGraphBuilder.collapseFragment(i);
                    }
                    return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.SOME_CHANGES, null, 2, null);
                }
                return null;
            }
        });
    }

    private final Set<LinearBekGraphBuilder.MergeFragment> collectChildFragments(int merge) {
        Set result2 = new LinkedHashSet();
        Object[] objectArray = new Integer[]{merge};
        LinkedHashSet toProcess = SetsKt.linkedSetOf((Object[])objectArray);
        while (!((Collection)toProcess).isEmpty()) {
            LinearBekGraphBuilder.MergeFragment mergeFragment;
            Object object = CollectionsKt.first((Iterable)toProcess);
            int it = ((Number)object).intValue();
            boolean bl = false;
            toProcess.remove(it);
            int nextNode = ((Number)object).intValue();
            if (this.linearBekGraphBuilder.getFragment(nextNode) == null) continue;
            LinearBekGraphBuilder.MergeFragment fragment = mergeFragment;
            boolean bl2 = false;
            result2.add(fragment);
            toProcess.addAll((Collection)fragment.getTailsAndBody());
            if (result2.size() <= 10) continue;
            break;
        }
        return result2;
    }

    private final LinearGraphController.LinearGraphAnswer highlightEdge(GraphEdge edge) {
        if (edge.getType() != GraphEdgeType.DOTTED) {
            return null;
        }
        Object[] objectArray = new Integer[]{edge.getUpNodeIndex(), edge.getDownNodeIndex()};
        return LinearGraphUtils.createSelectedAnswer(this.getCompiledGraph(), SetsKt.setOf((Object[])objectArray));
    }

    private final LinearGraphController.LinearGraphAnswer expandEdge(GraphEdge edge) {
        if (edge.getType() != GraphEdgeType.DOTTED) {
            return null;
        }
        return new LinearGraphController.LinearGraphAnswer(GraphChangesUtil.edgesReplaced(SetsKt.setOf((Object)edge), this.getCompiledGraph().expandEdge(edge), this.getDelegateGraph()), null, 2, null);
    }

    private static final void expandAll$lambda$1(LinearBekController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCompiledGraph().getDottedEdges().removeAll();
        this$0.getCompiledGraph().getHiddenEdges().removeAll();
    }

    private static final void collapseAll$lambda$2(LinearBekGraph.WorkingLinearBekGraph $workingGraph) {
        Intrinsics.checkNotNullParameter((Object)$workingGraph, (String)"$workingGraph");
        $workingGraph.applyChanges();
    }

    public static final /* synthetic */ IntSet access$getMergeCommits$p(LinearBekController $this) {
        return $this.mergeCommits;
    }

    public static final /* synthetic */ boolean access$isCollapsed(LinearBekController $this, int merge) {
        return $this.isCollapsed(merge);
    }

    public static final /* synthetic */ Set access$collectChildFragments(LinearBekController $this, int merge) {
        return $this.collectChildFragments(merge);
    }

    public static final /* synthetic */ LinearBekGraphBuilder access$getLinearBekGraphBuilder$p(LinearBekController $this) {
        return $this.linearBekGraphBuilder;
    }

    static {
        Logger logger = Logger.getInstance(LinearBekController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout;", "Lcom/intellij/vcs/log/graph/api/GraphLayout;", "graphLayout", "sortIndexMap", "Lcom/intellij/vcs/log/graph/impl/facade/sort/SortIndexMap;", "(Lcom/intellij/vcs/log/graph/api/GraphLayout;Lcom/intellij/vcs/log/graph/impl/facade/sort/SortIndexMap;)V", "getHeadNodeIndex", "", "", "getLayoutIndex", "nodeIndex", "getOneOfHeadNodeIndex", "intellij.platform.vcs.log.graph.impl"})
    @SourceDebugExtension(value={"SMAP\nLinearBekController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearBekController.kt\ncom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1549#2:195\n1620#2,3:196\n*S KotlinDebug\n*F\n+ 1 LinearBekController.kt\ncom/intellij/vcs/log/graph/linearBek/LinearBekController$BekGraphLayout\n*L\n187#1:195\n187#1:196,3\n*E\n"})
    private static final class BekGraphLayout
    implements GraphLayout {
        @NotNull
        private final GraphLayout graphLayout;
        @NotNull
        private final SortIndexMap sortIndexMap;

        public BekGraphLayout(@NotNull GraphLayout graphLayout, @NotNull SortIndexMap sortIndexMap) {
            Intrinsics.checkNotNullParameter((Object)graphLayout, (String)"graphLayout");
            Intrinsics.checkNotNullParameter((Object)sortIndexMap, (String)"sortIndexMap");
            this.graphLayout = graphLayout;
            this.sortIndexMap = sortIndexMap;
        }

        @Override
        public int getLayoutIndex(int nodeIndex) {
            return this.graphLayout.getLayoutIndex(this.sortIndexMap.getUsualIndex(nodeIndex));
        }

        @Override
        public int getOneOfHeadNodeIndex(int nodeIndex) {
            int usualIndex = this.graphLayout.getOneOfHeadNodeIndex(this.sortIndexMap.getUsualIndex(nodeIndex));
            return this.sortIndexMap.getSortedIndex(usualIndex);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Integer> getHeadNodeIndex() {
            void $this$mapTo$iv$iv;
            List<Integer> list = this.graphLayout.getHeadNodeIndex();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHeadNodeIndex(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Integer n = (Integer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(this.sortIndexMap.getSortedIndex(it.intValue()));
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/graph/linearBek/LinearBekController$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAX_COLLAPSED_MERGES", "", "intellij.platform.vcs.log.graph.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

