/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.DataPackKt;
import com.intellij.vcs.log.data.EmptyLogStorage;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/data/DataPack;", "Lcom/intellij/vcs/log/data/DataPackBase;", "refsModel", "Lcom/intellij/vcs/log/data/RefsModel;", "permanentGraph", "Lcom/intellij/vcs/log/graph/PermanentGraph;", "", "providers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "full", "", "(Lcom/intellij/vcs/log/data/RefsModel;Lcom/intellij/vcs/log/graph/PermanentGraph;Ljava/util/Map;Z)V", "getPermanentGraph", "()Lcom/intellij/vcs/log/graph/PermanentGraph;", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "Companion", "ErrorDataPack", "intellij.platform.vcs.log.impl"})
public class DataPack
extends DataPackBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermanentGraph<Integer> permanentGraph;
    @JvmField
    @NotNull
    public static final DataPack EMPTY;

    public DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, boolean full) {
        Intrinsics.checkNotNullParameter((Object)refsModel, (String)"refsModel");
        Intrinsics.checkNotNullParameter(permanentGraph, (String)"permanentGraph");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        super(providers, refsModel, full);
        this.permanentGraph = permanentGraph;
    }

    @NotNull
    public final PermanentGraph<Integer> getPermanentGraph() {
        return this.permanentGraph;
    }

    @NotNull
    public String toString() {
        return "{DataPack. " + this.permanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }

    @JvmStatic
    @NotNull
    public static final DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits2, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
        return Companion.build(commits2, refs, providers, storage, full);
    }

    static {
        VcsLogStorage vcsLogStorage = EmptyLogStorage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"INSTANCE");
        RefsModel refsModel = RefsModel.Companion.createEmptyInstance(vcsLogStorage);
        PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
        Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
        EMPTY = new DataPack(refsModel, permanentGraph, MapsKt.emptyMap(), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00072\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/vcs/log/data/DataPack$Companion;", "", "()V", "EMPTY", "Lcom/intellij/vcs/log/data/DataPack;", "build", "commits", "", "Lcom/intellij/vcs/log/graph/GraphCommit;", "", "refs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/data/CompressedRefs;", "providers", "Lcom/intellij/vcs/log/VcsLogProvider;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "full", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits2, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, ? extends VcsLogProvider> providers, @NotNull VcsLogStorage storage, boolean full) {
            Intrinsics.checkNotNullParameter(commits2, (String)"commits");
            Intrinsics.checkNotNullParameter(refs, (String)"refs");
            Intrinsics.checkNotNullParameter(providers, (String)"providers");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            RefsModel refsModel = RefsModel.Companion.create(refs, DataPackKt.access$getHeads(commits2), storage, providers);
            PermanentGraph permanentGraph = DataPackKt.access$buildPermanentGraph(commits2, refsModel, providers, storage);
            return new DataPack(refsModel, (PermanentGraph<Integer>)permanentGraph, providers, full);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/vcs/log/data/DataPack$ErrorDataPack;", "Lcom/intellij/vcs/log/data/DataPack;", "error", "", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "intellij.platform.vcs.log.impl"})
    public static final class ErrorDataPack
    extends DataPack {
        @NotNull
        private final Throwable error;

        public ErrorDataPack(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            VcsLogStorage vcsLogStorage = EmptyLogStorage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"INSTANCE");
            RefsModel refsModel = RefsModel.Companion.createEmptyInstance(vcsLogStorage);
            PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
            Intrinsics.checkNotNullExpressionValue(permanentGraph, (String)"getInstance(...)");
            super(refsModel, permanentGraph, MapsKt.emptyMap(), false);
            this.error = error;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }
    }
}

