/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.views;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.TokenType;
import com.jetbrains.dpa.views.CustomEditorHighlighter;
import com.jetbrains.dpa.views.DetailsViewControlKt;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpTextAttributeKeys;
import com.jetbrains.rider.model.BeIssueDetails;
import com.jetbrains.rider.model.IssueDetailsData;
import com.jetbrains.rider.model.IssueDetailsScrollTo;
import com.jetbrains.rider.model.IssueInfoHighlightingId;
import com.jetbrains.rider.model.IssueInfoHiglighting;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u00042\b\u0012\u0004\u0012\u00020\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u001fJ(\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020#2\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0002\u00a8\u0006&"}, d2={"Lcom/jetbrains/dpa/views/IssueDetailsViewControl;", "TViewModel", "Lcom/jetbrains/rider/model/BeIssueDetails;", "TIssueDetailsData", "Lcom/jetbrains/rider/model/IssueDetailsData;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "()V", "addCustomIssueHighlightings", "", "data", "highlighter", "Lcom/jetbrains/dpa/views/CustomEditorHighlighter;", "offset", "", "(Lcom/jetbrains/rider/model/IssueDetailsData;Lcom/jetbrains/dpa/views/CustomEditorHighlighter;I)V", "addIssueInfoHighlightings", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "icon", "Ljavax/swing/Icon;", "getCustomIssueParagraph", "", "(Lcom/jetbrains/rider/model/IssueDetailsData;)Ljava/lang/String;", "scrollView", "scrollTo", "Lcom/jetbrains/rider/model/IssueDetailsScrollTo;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "customInfoLine", "stacktraceLine", "intellij.rider.plugins.dpa"})
public abstract class IssueDetailsViewControl<TViewModel extends BeIssueDetails, TIssueDetailsData extends IssueDetailsData>
implements ViewBinder<BeIssueDetails> {
    @NotNull
    public abstract String getCustomIssueParagraph(@NotNull TIssueDetailsData var1);

    public abstract void addCustomIssueHighlightings(@NotNull TIssueDetailsData var1, @NotNull CustomEditorHighlighter var2, int var3);

    private final EditorCustomElementRenderer createRenderer(Editor editor, Icon icon, BeIssueDetails viewModel) {
        PresentationFactory factory = new PresentationFactory(editor);
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{factory.icon(icon), PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)factory.smallText("Explain with AI"), (int)0, (int)0, (int)2, (int)0, (int)22, null)};
        InlayPresentation basePresentation = factory.referenceOnHover(factory.roundWithBackgroundAndSmallInset(factory.seq(inlayPresentationArray)), (arg_0, arg_1) -> IssueDetailsViewControl.createRenderer$lambda$0(viewModel, arg_0, arg_1));
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        InlayPresentation presentation = factory.withCursorOnHover(basePresentation, cursor);
        return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
    }

    @NotNull
    public JComponent bind(@NotNull BeIssueDetails viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ConsoleViewImpl console2 = DetailsViewControlKt.createDetailsConsoleView(lifetime, ProjectUtilKt.toProject((RdProjectId)viewModel.getProjectId()), (Function0<Unit>)((Function0)new Function0<Unit>(viewModel){
            final /* synthetic */ BeIssueDetails $viewModel;
            {
                this.$viewModel = $viewModel;
                super(0);
            }

            public final void invoke() {
                this.$viewModel.getStacktraceLinkNavigated().fire((Object)Unit.INSTANCE);
            }
        }));
        Editor editor = console2.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)((Editor)editor2));
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        EditorHyperlinkSupport editorHyperlinkSupport2 = editorHyperlinkSupport;
        Ref.IntRef customInfoLine = new Ref.IntRef();
        Ref.IntRef stacktraceLine = new Ref.IntRef();
        Ref.ObjectRef explainWithAiInlay = new Ref.ObjectRef();
        viewModel.getData().view(lifetime, (Function2)new Function2<Lifetime, IssueDetailsData, Unit>((Ref.ObjectRef<Disposable>)explainWithAiInlay, editor2, this, customInfoLine, stacktraceLine, editorHyperlinkSupport2, console2, viewModel){
            final /* synthetic */ Ref.ObjectRef<Disposable> $explainWithAiInlay;
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ IssueDetailsViewControl<TViewModel, TIssueDetailsData> this$0;
            final /* synthetic */ Ref.IntRef $customInfoLine;
            final /* synthetic */ Ref.IntRef $stacktraceLine;
            final /* synthetic */ EditorHyperlinkSupport $editorHyperlinkSupport;
            final /* synthetic */ ConsoleViewImpl $console;
            final /* synthetic */ BeIssueDetails $viewModel;
            {
                this.$explainWithAiInlay = $explainWithAiInlay;
                this.$editor = $editor;
                this.this$0 = $receiver;
                this.$customInfoLine = $customInfoLine;
                this.$stacktraceLine = $stacktraceLine;
                this.$editorHyperlinkSupport = $editorHyperlinkSupport;
                this.$console = $console;
                this.$viewModel = $viewModel;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lifetime, @Nullable IssueDetailsData data) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                if (this.$explainWithAiInlay.element != null) {
                    Object object = this.$explainWithAiInlay.element;
                    Intrinsics.checkNotNull((Object)object);
                    Disposer.dispose((Disposable)((Disposable)object));
                }
                MarkupModelEx markupModelEx = this.$editor.getMarkupModel();
                Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
                MarkupModelEx markupModel = markupModelEx;
                markupModel.removeAllHighlighters();
                if (data == null) {
                    this.$editor.getDocument().setText((CharSequence)"");
                    return;
                }
                CustomEditorHighlighter highlighter = new CustomEditorHighlighter((Document)this.$editor.getDocument());
                this.$editor.setHighlighter((EditorHighlighter)highlighter);
                String customIssueText = this.this$0.getCustomIssueParagraph(data);
                this.$editor.getDocument().setText((CharSequence)(data.getIssueType() + ": " + data.getIssueTypeDescription() + "\n" + data.getInfo() + "\n" + customIssueText));
                int issueTypeLineLength = data.getIssueType().length() + 2 + data.getIssueTypeDescription().length() + 1;
                int issueInfoLength = data.getInfo().length() + 1;
                int customInfoOffset = issueTypeLineLength + issueInfoLength;
                CharSequence $this$count$iv = data.getInfo();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                int infoLinesCount = count$iv;
                this.$customInfoLine.element = 2 + (infoLinesCount + 1) - 1;
                this.$stacktraceLine.element = this.$editor.getDocument().getLineCount() - 1;
                this.$editorHyperlinkSupport.createHyperlink(0, data.getIssueType().length(), null, new HyperlinkInfo(this.$viewModel){
                    final /* synthetic */ BeIssueDetails $viewModel;
                    {
                        this.$viewModel = $viewModel;
                    }

                    public void navigate(@NotNull Project project) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        this.$viewModel.getIssueHelpLinkNavigate().fire((Object)Unit.INSTANCE);
                    }

                    public boolean includeInOccurenceNavigation() {
                        return false;
                    }
                });
                IssueDetailsViewControl.access$addIssueInfoHighlightings(this.this$0, data, markupModel, issueTypeLineLength);
                highlighter.append(0, customInfoOffset, TokenType.DUMMY_HOLDER, new TextAttributes());
                this.this$0.addCustomIssueHighlightings(data, highlighter, customInfoOffset);
                this.$console.print(data.getStacktrace(), ConsoleViewContentType.NORMAL_OUTPUT);
                this.$console.flushDeferredText();
                IssueDetailsViewControl.access$scrollView(this.this$0, (IssueDetailsScrollTo)InterfacesKt.valueOrDefault((IOptProperty)this.$viewModel.getScrollTo(), (Object)IssueDetailsScrollTo.customInfo), this.$editor, this.$customInfoLine.element, this.$stacktraceLine.element);
            }
        });
        viewModel.getScrollTo().view(lifetime, (Function2)new Function2<Lifetime, IssueDetailsScrollTo, Unit>(this, editor2, customInfoLine, stacktraceLine){
            final /* synthetic */ IssueDetailsViewControl<TViewModel, TIssueDetailsData> this$0;
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ Ref.IntRef $customInfoLine;
            final /* synthetic */ Ref.IntRef $stacktraceLine;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$customInfoLine = $customInfoLine;
                this.$stacktraceLine = $stacktraceLine;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lifetime, @NotNull IssueDetailsScrollTo scrollTo) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)scrollTo, (String)"scrollTo");
                IssueDetailsViewControl.access$scrollView(this.this$0, scrollTo, this.$editor, this.$customInfoLine.element, this.$stacktraceLine.element);
            }
        });
        viewModel.getWordWrap().view(lifetime, (Function2)new Function2<Lifetime, Boolean, Unit>(editor2){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lifetime, boolean wrap) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<anonymous parameter 0>");
                this.$editor.getSettings().setUseSoftWraps(wrap);
            }
        });
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)console2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)console2);
        viewModel.getStacktracePrevious().advise(lifetime, (Function1)new Function1<Unit, Unit>(prevAction, dataContext2){
            final /* synthetic */ AnAction $prevAction;
            final /* synthetic */ DataContext $dataContext;
            {
                this.$prevAction = $prevAction;
                this.$dataContext = $dataContext;
                super(1);
            }

            public final void invoke(@NotNull Unit unit) {
                Intrinsics.checkNotNullParameter((Object)unit, (String)"<anonymous parameter 0>");
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)this.$prevAction, null, (String)"unknown", (DataContext)this.$dataContext);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                AnActionEvent actionEvent = anActionEvent;
                this.$prevAction.actionPerformed(actionEvent);
            }
        });
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)console2);
        viewModel.getStacktraceNext().advise(lifetime, (Function1)new Function1<Unit, Unit>(nextAction, dataContext2){
            final /* synthetic */ AnAction $nextAction;
            final /* synthetic */ DataContext $dataContext;
            {
                this.$nextAction = $nextAction;
                this.$dataContext = $dataContext;
                super(1);
            }

            public final void invoke(@NotNull Unit unit) {
                Intrinsics.checkNotNullParameter((Object)unit, (String)"<anonymous parameter 0>");
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)this.$nextAction, null, (String)"unknown", (DataContext)this.$dataContext);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                AnActionEvent actionEvent = anActionEvent;
                this.$nextAction.actionPerformed(actionEvent);
            }
        });
        JComponent jComponent = console2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final void addIssueInfoHighlightings(IssueDetailsData data, MarkupModelEx markupModel, int offset) {
        TextAttributes boldTextAttributes = new TextAttributes();
        boldTextAttributes.setFontType(1);
        TextAttributes italicTextAttributes = new TextAttributes();
        italicTextAttributes.setFontType(2);
        for (IssueInfoHiglighting highlighting : data.getInfoHighlightings()) {
            switch (WhenMappings.$EnumSwitchMapping$0[highlighting.getIssueInfoHiglightingId().ordinal()]) {
                case 1: {
                    markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getCLASS(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    break;
                }
                case 2: {
                    markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, italicTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                    break;
                }
                case 3: {
                    markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getNUMBER(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    break;
                }
                case 4: {
                    markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, boldTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
            }
        }
    }

    private final void scrollView(IssueDetailsScrollTo scrollTo, EditorEx editor, int customInfoLine, int stacktraceLine) {
        int vOffset = switch (WhenMappings.$EnumSwitchMapping$1[scrollTo.ordinal()]) {
            case 1 -> 0;
            case 2 -> customInfoLine * editor.getLineHeight();
            case 3 -> stacktraceLine * editor.getLineHeight();
            case 4 -> editor.getDocument().getLineCount() * editor.getLineHeight();
            default -> throw new NoWhenBranchMatchedException();
        };
        editor.getScrollingModel().scroll(0, vOffset);
    }

    private static final void createRenderer$lambda$0(BeIssueDetails $viewModel, MouseEvent mouseEvent, Point point) {
        Intrinsics.checkNotNullParameter((Object)$viewModel, (String)"$viewModel");
        $viewModel.getExplainWithAi().fire((Object)Unit.INSTANCE);
    }

    public static final /* synthetic */ void access$addIssueInfoHighlightings(IssueDetailsViewControl $this, IssueDetailsData data, MarkupModelEx markupModel, int offset) {
        $this.addIssueInfoHighlightings(data, markupModel, offset);
    }

    public static final /* synthetic */ void access$scrollView(IssueDetailsViewControl $this, IssueDetailsScrollTo scrollTo, EditorEx editor, int customInfoLine, int stacktraceLine) {
        $this.scrollView(scrollTo, editor, customInfoLine, stacktraceLine);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IssueInfoHighlightingId.values().length];
            try {
                nArray[IssueInfoHighlightingId.TypeName.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.MetricContext.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Metric.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Caption.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Text.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IssueDetailsScrollTo.values().length];
            try {
                nArray[IssueDetailsScrollTo.info.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.customInfo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.stacktrace.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.end.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

