/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.MinMax;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Point;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b\u001a)\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\u0002\u0010\u0014\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"labelColor", "Ljava/awt/Color;", "getLabelColor", "()Ljava/awt/Color;", "labelFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "createTimeLabel", "", "time", "", "createValueLabel", "value", "", "label", "getXByLocation", "location", "Ljava/awt/Point;", "chart", "Lcom/intellij/ui/charts/GridChartWrapper;", "(Ljava/awt/Point;Lcom/intellij/ui/charts/GridChartWrapper;)Ljava/lang/Long;", "intellij.rider.plugins.dpa"})
public final class HelpersKt {
    private static final DateTimeFormatter labelFormatter = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());

    @NotNull
    public static final Color getLabelColor() {
        Color color = UIUtil.getLabelForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelForeground(...)");
        return color;
    }

    @NotNull
    public static final String createValueLabel(double value, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        String string = "%.2f";
        Object[] objectArray = new Object[]{value};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2 + " " + label;
    }

    @NotNull
    public static final String createTimeLabel(long time) {
        String string = labelFormatter.format(Instant.ofEpochSecond(time));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @Nullable
    public static final Long getXByLocation(@NotNull Point location, @NotNull GridChartWrapper<Long, Double> chart) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        MinMax minMax = chart.findMinMax();
        if (!minMax.isInitialized()) {
            return null;
        }
        if (location.x < chart.getMargins().left) {
            return null;
        }
        if (location.x > chart.getWidth() - chart.getMargins().right) {
            return null;
        }
        int chartX = location.x - chart.getMargins().left;
        int chartWidth = chart.getWidth() - (chart.getMargins().left + chart.getMargins().right);
        long xWidth = minMax.getXMax().longValue() - minMax.getXMin().longValue();
        if ((long)chartWidth + minMax.getXMin().longValue() <= 0L) {
            return null;
        }
        return (long)chartX * xWidth / (long)chartWidth + minMax.getXMin().longValue();
    }
}

