/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.jetbrains.dpa.monitoring.sessions.BaseChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.rider.model.GcEvent;
import com.jetbrains.rider.model.GcEventType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00020\u0001:\u0001\rB\u0015\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/GcOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "(Lkotlin/jvm/functions/Function0;)V", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "Companion", "intellij.rider.plugins.dpa"})
public final class GcOverlay
extends Overlay<LineChart<Long, Double, ?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<ChartSession> sessionGetter;

    public GcOverlay(@NotNull Function0<ChartSession> sessionGetter) {
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        this.sessionGetter = sessionGetter;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ChartSession chartSession = (ChartSession)this.sessionGetter.invoke();
        if (chartSession == null) {
            return;
        }
        ChartSession session = chartSession;
        if (session.getCachedData().isEmpty()) {
            return;
        }
        if (session.getGcData().isEmpty()) {
            return;
        }
        long qpcDuration = ULong.constructor-impl((long)(((BaseChartData)CollectionsKt.last(session.getCachedData())).getQpcTimeStamp-s-VKNKU() - ((BaseChartData)CollectionsKt.first(session.getCachedData())).getQpcTimeStamp-s-VKNKU()));
        if (qpcDuration == 0L) {
            return;
        }
        long startQpcTimestamp = ((BaseChartData)CollectionsKt.first(session.getCachedData())).getQpcTimeStamp-s-VKNKU();
        MinMax minMax = ((LineChart)this.getChart()).findMinMax();
        if (!minMax.isInitialized()) {
            return;
        }
        int offsetX = (int)((LineChart)this.getChart()).findLocation((MinMax)minMax, (Coordinates)new Coordinates((Number)((Number)Long.valueOf((long)((BaseChartData)CollectionsKt.first(session.getCachedData())).getTimeStamp())), (Number)((Number)Double.valueOf((double)0.0)))).x;
        int width = ((LineChart)this.getChart()).getWidth() - offsetX - ((LineChart)this.getChart()).getMargins().right;
        double multiplier = (double)width / UnsignedKt.ulongToDouble((long)qpcDuration);
        g.setPaint(Companion.getGcColor());
        Iterator iterator = session.getGcData().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator gcIterator = iterator;
        Object e = gcIterator.next();
        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
        GcEvent current = (GcEvent)e;
        long qpcFillingTimeInGc = 0L;
        int fillingX = GcOverlay.paintComponent$qpcTimestampToX(startQpcTimestamp, multiplier, current.getQpcTimeStamp-s-VKNKU());
        ULong startGcQpcTimestamp = null;
        if (current.getType() == GcEventType.GcStop) {
            qpcFillingTimeInGc = ULong.constructor-impl((long)(current.getQpcTimeStamp-s-VKNKU() - GcOverlay.paintComponent$xToQpcTimestamp(multiplier, startQpcTimestamp, fillingX)));
        } else {
            startGcQpcTimestamp = ULong.box-impl((long)current.getQpcTimeStamp-s-VKNKU());
            qpcFillingTimeInGc = 0L;
        }
        while (gcIterator.hasNext()) {
            Object e2 = gcIterator.next();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
            GcEvent current2 = (GcEvent)e2;
            int currentX = GcOverlay.paintComponent$qpcTimestampToX(startQpcTimestamp, multiplier, current2.getQpcTimeStamp-s-VKNKU());
            if (current2.getType() == GcEventType.GcStop) {
                if (startGcQpcTimestamp == null) continue;
                if (currentX == fillingX) {
                    var22_17 = startGcQpcTimestamp.unbox-impl();
                    var20_16 = ULong.constructor-impl((long)(current2.getQpcTimeStamp-s-VKNKU() - var22_17));
                    qpcFillingTimeInGc = ULong.constructor-impl((long)(qpcFillingTimeInGc + var20_16));
                } else {
                    var22_17 = startGcQpcTimestamp.unbox-impl();
                    var20_16 = ULong.constructor-impl((long)(GcOverlay.paintComponent$xToQpcTimestamp(multiplier, startQpcTimestamp, fillingX + 1) - var22_17));
                    qpcFillingTimeInGc = ULong.constructor-impl((long)(qpcFillingTimeInGc + var20_16));
                    GcOverlay.paintComponent$drawLine(g, offsetX, this, multiplier, fillingX, qpcFillingTimeInGc);
                    if (currentX > ++fillingX) {
                        GcOverlay.paintComponent$drawBar(g, offsetX, this, fillingX, currentX);
                    }
                    fillingX = currentX;
                    qpcFillingTimeInGc = ULong.constructor-impl((long)(current2.getQpcTimeStamp-s-VKNKU() - GcOverlay.paintComponent$xToQpcTimestamp(multiplier, startQpcTimestamp, fillingX)));
                }
                startGcQpcTimestamp = null;
                continue;
            }
            if (current2.getType() != GcEventType.GcStart) continue;
            startGcQpcTimestamp = ULong.box-impl((long)current2.getQpcTimeStamp-s-VKNKU());
            if (currentX <= fillingX) continue;
            GcOverlay.paintComponent$drawLine(g, offsetX, this, multiplier, fillingX, qpcFillingTimeInGc);
            fillingX = currentX;
            qpcFillingTimeInGc = 0L;
        }
        if (startGcQpcTimestamp == null && Long.compareUnsigned(qpcFillingTimeInGc, 0L) > 0) {
            GcOverlay.paintComponent$drawLine(g, offsetX, this, multiplier, fillingX, qpcFillingTimeInGc);
        } else if (Long.compareUnsigned(qpcFillingTimeInGc, 0L) > 0) {
            GcOverlay.paintComponent$drawLine(g, offsetX, this, multiplier, fillingX, qpcFillingTimeInGc);
        }
    }

    private static final int paintComponent$qpcTimestampToX(long startQpcTimestamp, double multiplier, long qpcTimestamp) {
        return (int)(UnsignedKt.ulongToDouble((long)ULong.constructor-impl((long)(qpcTimestamp - startQpcTimestamp))) * multiplier);
    }

    private static final long paintComponent$xToQpcTimestamp(double multiplier, long startQpcTimestamp, int x) {
        return ULong.constructor-impl((long)(UnsignedKt.doubleToULong((double)((double)x / multiplier)) + startQpcTimestamp));
    }

    private static final void paintComponent$drawBar(Graphics2D $g, int offsetX, GcOverlay this$0, int x1, int x2) {
        $g.fillRect(offsetX + x1, 1 + ((LineChart)this$0.getChart()).getHeight() - ((LineChart)this$0.getChart()).getMargins().bottom, x2 - x1, 15);
    }

    private static final void paintComponent$drawLine(Graphics2D $g, int offsetX, GcOverlay this$0, double multiplier, int x, long qpcTimeInGc) {
        $g.drawLine(offsetX + x, 1 + ((LineChart)this$0.getChart()).getHeight() - ((LineChart)this$0.getChart()).getMargins().bottom + 15 - (int)(UnsignedKt.ulongToDouble((long)qpcTimeInGc) * multiplier * (double)15), offsetX + x, 1 + ((LineChart)this$0.getChart()).getHeight() - ((LineChart)this$0.getChart()).getMargins().bottom + 15);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/GcOverlay$Companion;", "", "()V", "gcColor", "Ljava/awt/Color;", "getGcColor", "()Ljava/awt/Color;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getGcColor() {
            JBColor jBColor = JBColor.namedColor((String)"Monitoring.Chart.Gc", (Color)((Color)new JBColor(13214540, 13214540)));
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
            return (Color)jBColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

