/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.actions.DataKeysKt;
import com.jetbrains.dpa.monitoring.actions.StartModeActionKt;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "content", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "actionToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "session", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "getSession", "()Lcom/jetbrains/dpa/monitoring/sessions/Session;", "setSession", "(Lcom/jetbrains/dpa/monitoring/sessions/Session;)V", "bind", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nSessionToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionToolWindowPanel.kt\ncom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n13#2:71\n13#3:72\n*S KotlinDebug\n*F\n+ 1 SessionToolWindowPanel.kt\ncom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel\n*L\n15#1:71\n15#1:72\n*E\n"})
public final class SessionToolWindowPanel
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Session session;
    @NotNull
    private final ActionToolbar actionToolbar;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public SessionToolWindowPanel(@NotNull JComponent content2) {
        void $this$_init__u24lambda_u240;
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        super(true);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("MonitoringTool.ToolWindow.Actions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionToolbar actionToolbar2 = actionManager.createActionToolbar("ToolwindowContent", (ActionGroup)anAction, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar3 = actionToolbar = actionToolbar2;
        SessionToolWindowPanel sessionToolWindowPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.getComponent().setOpaque(false);
        $this$_init__u24lambda_u240.setTargetComponent((JComponent)((Object)this));
        $this$_init__u24lambda_u240.setReservePlaceAutoPopupIcon(false);
        sessionToolWindowPanel.actionToolbar = actionToolbar;
        ActionToolbar actionToolbar4 = new ActionToolbar[]{StartModeActionKt.getStartModeActionGroup()};
        ActionToolbar $this$_init__u24lambda_u241 = actionToolbar4 = actionManager.createActionToolbar("ToolwindowContent", (ActionGroup)new DefaultActionGroup((AnAction[])actionToolbar4), true);
        boolean bl2 = false;
        $this$_init__u24lambda_u241.getComponent().setOpaque(false);
        $this$_init__u24lambda_u241.setTargetComponent((JComponent)((Object)this));
        $this$_init__u24lambda_u241.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar5 = actionToolbar4;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar5, (String)"apply(...)");
        ActionToolbar startModeToolbar = actionToolbar5;
        BorderLayoutPanel panel = new BorderLayoutPanel();
        panel.addToLeft((Component)this.actionToolbar.getComponent());
        panel.addToRight((Component)startModeToolbar.getComponent());
        this.setToolbar((JComponent)panel);
        this.setContent(content2);
    }

    @Nullable
    public final Session getSession() {
        return this.session;
    }

    public final void setSession(@Nullable Session session) {
        this.session = session;
    }

    public final void bind(@NotNull Session session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        logger.trace("bind pid:" + session.getPid());
        this.session = session;
        session.getPerformanceProfilingSession().getOnStateChanged().advise(lifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ SessionToolWindowPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SessionToolWindowPanel.access$getActionToolbar$p(this.this$0).updateActionsAsync();
            }
        });
        lifetime.onTermination((Function0)new Function0<Unit>(session, this){
            final /* synthetic */ Session $session;
            final /* synthetic */ SessionToolWindowPanel this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SessionToolWindowPanel.access$getLogger$cp().trace("unbind pid:" + this.$session.getPid());
                this.this$0.setSession(null);
            }
        });
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        IProperty<ProcessInfo> iProperty;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        Session session = this.session;
        sink.set(DataKeysKt.getSESSION_PROCESS_ID(), (Object)(session != null ? Integer.valueOf(session.getPid()) : null));
        sink.set(DataKeysKt.getSESSION_PROCESS_INFO(), (iProperty = this.session) != null && (iProperty = iProperty.getProcessInfoProperty()) != null ? (ProcessInfo)iProperty.getValue() : null);
        Session session2 = this.session;
        sink.set(DataKeysKt.getSESSION_PERFORMANCE_PROFILING(), (Object)(session2 != null ? session2.getPerformanceProfilingSession() : null));
        Session session3 = this.session;
        sink.set(DataKeysKt.getSESSION_MEMORY_PROFILING(), (Object)(session3 != null ? session3.getMemoryProfilingSession() : null));
        Session session4 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_STACK_TRACE_COLLECTING_AVAILABLE(), (Object)(session4 != null ? Boolean.valueOf(session4.isStackTraceCollectingAvailable()) : null));
        Session session5 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_MEMORY_PROFILING_AVAILABLE(), (Object)(session5 != null ? Boolean.valueOf(session5.isMemoryProfilingAvailable()) : null));
        Session session6 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_SAMPLING_PROFILING_AVAILABLE(), (Object)(session6 != null ? Boolean.valueOf(session6.isSamplingProfilingAvailable()) : null));
        Session session7 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_TIMELINE_PROFILING_AVAILABLE(), (Object)(session7 != null ? Boolean.valueOf(session7.isTimelineProfilingAvailable()) : null));
    }

    public static final /* synthetic */ ActionToolbar access$getActionToolbar$p(SessionToolWindowPanel $this) {
        return $this.actionToolbar;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SessionToolWindowPanel.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

