/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "dataPanel", "Ljavax/swing/JComponent;", "emptyPanel", "Ljavax/swing/JPanel;", "bind", "", "session", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "setProcessInfo", "processInfo", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nProcessDashboardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDashboardPanel.kt\ncom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,130:1\n1#2:131\n13#3:132\n13#4:133\n*S KotlinDebug\n*F\n+ 1 ProcessDashboardPanel.kt\ncom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel\n*L\n35#1:132\n35#1:133\n*E\n"})
public final class ProcessDashboardPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JPanel emptyPanel;
    @Nullable
    private JComponent dataPanel;
    @NotNull
    private static final Logger logger;

    public ProcessDashboardPanel() {
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText("No running process");
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        this.emptyPanel = (JPanel)jBPanelWithEmptyText;
    }

    /*
     * WARNING - void declaration
     */
    private final void setProcessInfo(ProcessInfo processInfo) {
        Object[] $this$setProcessInfo_u24lambda_u2422_u24lambda_u2421;
        Object architecture;
        Object[] $this$setProcessInfo_u24lambda_u2418_u24lambda_u2417;
        Object[] $this$setProcessInfo_u24lambda_u2418_u24lambda_u2415;
        JPanel $this$setProcessInfo_u24lambda_u2418;
        Container $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413;
        Object[] $this$setProcessInfo_u24lambda_u2414_u24lambda_u2411;
        JPanel $this$setProcessInfo_u24lambda_u2414;
        String string;
        JBLabel $this$setProcessInfo_u24lambda_u2410_u24lambda_u245;
        JPanel $this$setProcessInfo_u24lambda_u2410;
        JBLabel $this$setProcessInfo_u24lambda_u244_u24lambda_u243;
        JBLabel $this$setProcessInfo_u24lambda_u244_u24lambda_u241;
        JPanel $this$setProcessInfo_u24lambda_u244;
        JPanel jPanel;
        JPanel $this$setProcessInfo_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean bl = false;
        $this$setProcessInfo_u24lambda_u240.setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel jPanel2 = jPanel;
        $this$setProcessInfo_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        Container container = jPanel2;
        boolean bl2 = false;
        String processId = String.valueOf(processInfo.getProcessId());
        Object[] objectArray = new Object[]{processId};
        JBLabel jBLabel = objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.process.id", objectArray));
        Container container2 = $this$setProcessInfo_u24lambda_u244;
        boolean bl3 = false;
        $this$setProcessInfo_u24lambda_u244_u24lambda_u241.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)processId).length() > 0) {
            Container container3 = $this$setProcessInfo_u24lambda_u244;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u244_u24lambda_u241 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            container2 = container3;
            boolean bl4 = false;
            $this$setProcessInfo_u24lambda_u244_u24lambda_u243.setFocusable(false);
            $this$setProcessInfo_u24lambda_u244_u24lambda_u243.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$4$lambda$3$lambda$2(processId, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)jPanel, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u244 = jPanel = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = jPanel2;
        boolean bl5 = false;
        String filename = processInfo.getFileName();
        objectArray = new Object[]{filename};
        $this$setProcessInfo_u24lambda_u244_u24lambda_u243 = objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.filename", objectArray));
        container2 = $this$setProcessInfo_u24lambda_u2410;
        boolean bl6 = false;
        $this$setProcessInfo_u24lambda_u2410_u24lambda_u245.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)filename).length() > 0) {
            void $this$setProcessInfo_u24lambda_u2410_u24lambda_u249;
            Object $this$setProcessInfo_u24lambda_u2410_u24lambda_u247;
            Container container4 = $this$setProcessInfo_u24lambda_u2410;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u245 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            container2 = container4;
            boolean bl7 = false;
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u247.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u247.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$10$lambda$7$lambda$6(filename, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
            Container container5 = $this$setProcessInfo_u24lambda_u2410;
            Icon icon2 = AllIcons.General.OpenDisk;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"OpenDisk");
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u247 = objectArray = new InlineIconButton(icon2, AllIcons.General.OpenDiskHover, null, null, null, 28, null);
            container2 = container5;
            boolean bl8 = false;
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u249.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2410_u24lambda_u249.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$10$lambda$9$lambda$8(filename, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)jPanel, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2410 = jPanel = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = jPanel2;
        boolean bl9 = false;
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        Object object = objectArray = processInfo.getStartTime().format(formatter);
        if (object == null) {
            string = "";
        } else {
            Intrinsics.checkNotNull((Object)object);
            string = objectArray;
        }
        String startTime = string;
        objectArray = new Object[]{startTime};
        objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.start.time", objectArray));
        container2 = objectArray;
        Container bl8 = $this$setProcessInfo_u24lambda_u2414;
        boolean bl10 = false;
        $this$setProcessInfo_u24lambda_u2414_u24lambda_u2411.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)bl8, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)startTime).length() > 0) {
            Container container6 = $this$setProcessInfo_u24lambda_u2414;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2411 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            bl8 = container6;
            boolean bl11 = false;
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$14$lambda$13$lambda$12(startTime, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)bl8, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)jPanel, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2414 = jPanel = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = jPanel2;
        boolean bl12 = false;
        String commandLine = processInfo.getCommandLine();
        objectArray = new Object[]{commandLine};
        objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.command.line", objectArray));
        startTime = objectArray;
        $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413 = $this$setProcessInfo_u24lambda_u2418;
        boolean bl13 = false;
        $this$setProcessInfo_u24lambda_u2418_u24lambda_u2415.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2414_u24lambda_u2413, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)commandLine).length() > 0) {
            Container container7 = $this$setProcessInfo_u24lambda_u2418;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2418_u24lambda_u2415 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413 = container7;
            boolean bl14 = false;
            $this$setProcessInfo_u24lambda_u2418_u24lambda_u2417.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2418_u24lambda_u2417.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$18$lambda$17$lambda$16(commandLine, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2414_u24lambda_u2413, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)jPanel, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2418 = jPanel = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = jPanel2;
        boolean bl152 = false;
        Object object2 = processInfo.getProcessArchitecture();
        if (object2 == null || (object2 = object2.name()) == null) {
            object2 = "";
        }
        if (((CharSequence)(architecture = object2)).length() > 0) {
            Object[] $this$setProcessInfo_u24lambda_u2422_u24lambda_u2419;
            void $this$setProcessInfo_u24lambda_u2422;
            objectArray = new Object[]{architecture};
            $this$setProcessInfo_u24lambda_u2418_u24lambda_u2417 = objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.process.architecture", objectArray));
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413 = (Container)$this$setProcessInfo_u24lambda_u2422;
            boolean bl16 = false;
            $this$setProcessInfo_u24lambda_u2422_u24lambda_u2419.setCopyable(true);
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2414_u24lambda_u2413, (Component)((Component)objectArray), null, (int)2, null);
            Container container8 = (Container)$this$setProcessInfo_u24lambda_u2422;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2422_u24lambda_u2419 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            $this$setProcessInfo_u24lambda_u2414_u24lambda_u2413 = container8;
            boolean bl17 = false;
            $this$setProcessInfo_u24lambda_u2422_u24lambda_u2421.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2422_u24lambda_u2421.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$22$lambda$21$lambda$20((String)architecture, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2414_u24lambda_u2413, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)jPanel, null, (int)2, null);
        String[] environmentVariables = processInfo.getEnvironmentVariables();
        if (!(environmentVariables.length == 0)) {
            void $this$setProcessInfo_u24lambda_u2423;
            TitledSeparator titledSeparator;
            TitledSeparator bl152 = titledSeparator = new TitledSeparator(MonitoringToolBundle.Companion.message("dashboard.row.environment.variables", new Object[0]));
            container = jPanel2;
            boolean bl18 = false;
            $this$setProcessInfo_u24lambda_u2423.setTitleFont($this$setProcessInfo_u24lambda_u2423.getTitleFont().deriveFont(1));
            RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)titledSeparator), null, (int)2, null);
            for (String envVar : environmentVariables) {
                void $this$setProcessInfo_u24lambda_u2424;
                $this$setProcessInfo_u24lambda_u2422_u24lambda_u2421 = objectArray = new JBLabel(envVar);
                container = jPanel2;
                boolean bl19 = false;
                $this$setProcessInfo_u24lambda_u2424.setCopyable(true);
                RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)objectArray), null, (int)2, null);
            }
        }
        this.dataPanel = ScrollPaneFactory.createScrollPane((Component)jPanel2, (boolean)true);
        this.remove(this.emptyPanel);
        this.add(this.dataPanel);
    }

    public final void bind(@NotNull Session session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        int pid = ((ProcessInfo)session.getProcessInfoProperty().getValue()).getProcessId();
        logger.trace("bind pid:" + pid);
        JComponent jComponent = this.dataPanel;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            this.remove(it);
        }
        this.add(this.emptyPanel);
        session.getProcessInfoProperty().advise(lifetime, (Function1)new Function1<ProcessInfo, Unit>((Object)this){

            public final void invoke(@NotNull ProcessInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ProcessDashboardPanel.access$setProcessInfo((ProcessDashboardPanel)((Object)this.receiver), p0);
            }
        });
        lifetime.onTermination((Function0)new Function0<Unit>(pid, this){
            final /* synthetic */ int $pid;
            final /* synthetic */ ProcessDashboardPanel this$0;
            {
                this.$pid = $pid;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ProcessDashboardPanel.access$getLogger$cp().trace("unbind pid:" + this.$pid);
                this.this$0.remove(ProcessDashboardPanel.access$getDataPanel$p(this.this$0));
                this.this$0.add(ProcessDashboardPanel.access$getEmptyPanel$p(this.this$0));
            }
        });
    }

    private static final void setProcessInfo$lambda$4$lambda$3$lambda$2(String $processId, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$processId, (String)"$processId");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($processId));
    }

    private static final void setProcessInfo$lambda$10$lambda$7$lambda$6(String $filename, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$filename, (String)"$filename");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($filename));
    }

    private static final void setProcessInfo$lambda$10$lambda$9$lambda$8(String $filename, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$filename, (String)"$filename");
        Path path = Paths.get($filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        RevealFileAction.openFile((Path)path);
    }

    private static final void setProcessInfo$lambda$14$lambda$13$lambda$12(String $startTime, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$startTime, (String)"$startTime");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($startTime));
    }

    private static final void setProcessInfo$lambda$18$lambda$17$lambda$16(String $commandLine, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$commandLine, (String)"$commandLine");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($commandLine));
    }

    private static final void setProcessInfo$lambda$22$lambda$21$lambda$20(String $architecture, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$architecture, (String)"$architecture");
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($architecture));
    }

    public static final /* synthetic */ void access$setProcessInfo(ProcessDashboardPanel $this, ProcessInfo processInfo) {
        $this.setProcessInfo(processInfo);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ JComponent access$getDataPanel$p(ProcessDashboardPanel $this) {
        return $this.dataPanel;
    }

    public static final /* synthetic */ JPanel access$getEmptyPanel$p(ProcessDashboardPanel $this) {
        return $this.emptyPanel;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessDashboardPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessDashboardPanel.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

