/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.ui.charts.ChartUtils;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.XYChartComponent;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.view.MemoryChartKt;
import com.jetbrains.dpa.monitoring.view.MonitoringChart;
import java.awt.Graphics2D;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/dpa/monitoring/view/MemoryXYLineChart;", "Lcom/jetbrains/dpa/monitoring/view/MonitoringChart;", "()V", "findGridLabelOffset", "Lcom/intellij/ui/charts/Coordinates;", "", "line", "Lcom/intellij/ui/charts/GridLine;", "g", "Ljava/awt/Graphics2D;", "reset", "", "update", "aggregatedChartValue", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "isUpdate", "", "intellij.rider.plugins.dpa"})
public final class MemoryXYLineChart
extends MonitoringChart {
    public MemoryXYLineChart() {
        ChartUtils.ranges((XYChartComponent)((XYChartComponent)this), (Function1)1.INSTANCE);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)this), (Function1)2.INSTANCE);
        this.setBorderPainted(true);
        JBInsets jBInsets = JBUI.insets((int)28, (int)15, (int)40, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        this.setMargins((Insets)jBInsets);
    }

    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates base = super.findGridLabelOffset(line, g);
        return new Coordinates(base.getX(), (Number)(base.getY().doubleValue() + (double)15));
    }

    @Override
    public void update(@NotNull ChartData aggregatedChartValue, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)aggregatedChartValue, (String)"aggregatedChartValue");
        long timestamp = aggregatedChartValue.getTimeStamp();
        if (!isUpdate) {
            this.getRanges().setXMin((Number)(timestamp - (long)60));
            this.getRanges().setXMax((Number)timestamp);
        }
        this.getRanges().setYMax((Number)Math.max(this.getRanges().getYMax().doubleValue(), MemoryChartKt.access$toMb(aggregatedChartValue.getTotalMemory())));
        this.applyEventHandlers(timestamp, aggregatedChartValue, isUpdate);
    }

    @Override
    public void reset() {
        super.reset();
        this.getRanges().setYMax((Number)100.0);
    }
}

