/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.ChartComponent;
import com.intellij.ui.charts.Overlay;
import com.intellij.ui.charts.XYLineDataset;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.MemoryChartKt;
import com.jetbrains.dpa.monitoring.view.MemoryXYLineChart;
import com.jetbrains.dpa.monitoring.view.MonitoringChartDatasetParams;
import com.jetbrains.dpa.monitoring.view.overlays.GcOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.MemoryPanelOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.PanelValueData;
import com.jetbrains.dpa.monitoring.view.overlays.TitleOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.ValueOverlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u001a\u001a\u0010\u0014\u001a\u00020\u0010*\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u001a\f\u0010\u0015\u001a\u00020\f*\u00020\fH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0003\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"gcColor", "Ljava/awt/Color;", "getGcColor", "()Ljava/awt/Color;", "gen0Color", "gen1Color", "gen2Color", "lohColor", "totalMemoryColor", "getTotalMemoryColor", "unmanagedMemoryColor", "unmanaged", "", "value", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "applyDotNetDatasetsAndOverlays", "Lcom/jetbrains/dpa/monitoring/view/MemoryXYLineChart;", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "applyNativeDatasetsAndOverlays", "toMb", "intellij.rider.plugins.dpa"})
public final class MemoryChartKt {
    @NotNull
    private static final Color unmanagedMemoryColor;
    @NotNull
    private static final Color gen0Color;
    @NotNull
    private static final Color gen1Color;
    @NotNull
    private static final Color gen2Color;
    @NotNull
    private static final Color lohColor;

    private static final double toMb(double $this$toMb) {
        return $this$toMb / (double)0x100000;
    }

    private static final double unmanaged(ChartData value) {
        return value.getTotalMemory() - value.getGen0() - value.getGen1() - value.getGen2() - value.getLoh();
    }

    private static final Color getTotalMemoryColor() {
        JBColor jBColor = JBColor.namedColor((String)"Monitoring.Chart.TotalMemory", (Color)((Color)new JBColor(6184029, 10463152)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return (Color)jBColor;
    }

    private static final Color getGcColor() {
        return GcOverlay.Companion.getGcColor();
    }

    @NotNull
    public static final MemoryXYLineChart applyDotNetDatasetsAndOverlays(@NotNull MemoryXYLineChart $this$applyDotNetDatasetsAndOverlays, @NotNull Function0<ChartSession> sessionGetter) {
        MemoryXYLineChart memoryXYLineChart;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyDotNetDatasetsAndOverlays), (String)"<this>");
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        MemoryXYLineChart $this$applyDotNetDatasetsAndOverlays_u24lambda_u240 = memoryXYLineChart = $this$applyDotNetDatasetsAndOverlays;
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Total", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyDotNetDatasetsAndOverlays.1.1.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)new Function1<XYLineDataset<Long, Double>, List<? extends ChartComponent>>(sessionGetter){
            final /* synthetic */ Function0<ChartSession> $sessionGetter;
            {
                this.$sessionGetter = $sessionGetter;
                super(1);
            }

            @NotNull
            public final List<ChartComponent> invoke(@NotNull XYLineDataset<Long, Double> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object[] objectArray = new Overlay[]{new TitleOverlay(MonitoringToolBundle.Companion.message("chart.memory.title.overlay", new Object[0]), "MB", it), new ValueOverlay(it), new GcOverlay(this.$sessionGetter), new MemoryPanelOverlay(this.$sessionGetter, (Function2<? super Graphics2D, ? super ChartData, PanelValueData[]>)((Function2)applyDotNetDatasetsAndOverlays.1.1.INSTANCE))};
                return CollectionsKt.listOf((Object[])objectArray);
            }
        }), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.3.INSTANCE))), TuplesKt.to((Object)"Gen 0", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyDotNetDatasetsAndOverlays.1.4.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)applyDotNetDatasetsAndOverlays.1.5.INSTANCE), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.6.INSTANCE))), TuplesKt.to((Object)"Gen 1", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyDotNetDatasetsAndOverlays.1.7.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)applyDotNetDatasetsAndOverlays.1.8.INSTANCE), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.9.INSTANCE))), TuplesKt.to((Object)"Gen 2", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyDotNetDatasetsAndOverlays.1.10.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)applyDotNetDatasetsAndOverlays.1.11.INSTANCE), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.12.INSTANCE))), TuplesKt.to((Object)"Loh", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyDotNetDatasetsAndOverlays.1.13.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)applyDotNetDatasetsAndOverlays.1.14.INSTANCE), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.15.INSTANCE)))};
        $this$applyDotNetDatasetsAndOverlays_u24lambda_u240.applyDatasetGenerator(MapsKt.mapOf((Pair[])pairArray));
        return memoryXYLineChart;
    }

    @NotNull
    public static final MemoryXYLineChart applyNativeDatasetsAndOverlays(@NotNull MemoryXYLineChart $this$applyNativeDatasetsAndOverlays, @NotNull Function0<ChartSession> sessionGetter) {
        MemoryXYLineChart memoryXYLineChart;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyNativeDatasetsAndOverlays), (String)"<this>");
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        MemoryXYLineChart $this$applyNativeDatasetsAndOverlays_u24lambda_u241 = memoryXYLineChart = $this$applyNativeDatasetsAndOverlays;
        boolean bl = false;
        $this$applyNativeDatasetsAndOverlays_u24lambda_u241.applyDatasetGenerator(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Total", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)applyNativeDatasetsAndOverlays.1.1.INSTANCE), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)new Function1<XYLineDataset<Long, Double>, List<? extends ChartComponent>>(sessionGetter){
            final /* synthetic */ Function0<ChartSession> $sessionGetter;
            {
                this.$sessionGetter = $sessionGetter;
                super(1);
            }

            @NotNull
            public final List<ChartComponent> invoke(@NotNull XYLineDataset<Long, Double> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object[] objectArray = new Overlay[]{new TitleOverlay(MonitoringToolBundle.Companion.message("chart.memory.title.overlay", new Object[0]), "MB", it), new ValueOverlay(it), new MemoryPanelOverlay(this.$sessionGetter, (Function2<? super Graphics2D, ? super ChartData, PanelValueData[]>)((Function2)applyNativeDatasetsAndOverlays.1.1.INSTANCE))};
                return CollectionsKt.listOf((Object[])objectArray);
            }
        }), (Function1<? super ChartData, Double>)((Function1)applyNativeDatasetsAndOverlays.1.3.INSTANCE)))));
        return memoryXYLineChart;
    }

    public static final /* synthetic */ double access$toMb(double $receiver) {
        return MemoryChartKt.toMb($receiver);
    }

    public static final /* synthetic */ Color access$getTotalMemoryColor() {
        return MemoryChartKt.getTotalMemoryColor();
    }

    public static final /* synthetic */ Color access$getUnmanagedMemoryColor$p() {
        return unmanagedMemoryColor;
    }

    public static final /* synthetic */ double access$unmanaged(ChartData value) {
        return MemoryChartKt.unmanaged(value);
    }

    public static final /* synthetic */ Color access$getGen0Color$p() {
        return gen0Color;
    }

    public static final /* synthetic */ Color access$getGen1Color$p() {
        return gen1Color;
    }

    public static final /* synthetic */ Color access$getGen2Color$p() {
        return gen2Color;
    }

    public static final /* synthetic */ Color access$getLohColor$p() {
        return lohColor;
    }

    public static final /* synthetic */ Color access$getGcColor() {
        return MemoryChartKt.getGcColor();
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Monitoring.Chart.Unmanged", (Color)((Color)new JBColor(14935528, 6316652)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        unmanagedMemoryColor = (Color)jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"Monitoring.Chart.Gen0", (Color)((Color)new JBColor(7976414, 7976414)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        gen0Color = (Color)jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"Monitoring.Chart.Gen1", (Color)((Color)new JBColor(14519966, 14519966)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        gen1Color = (Color)jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"Monitoring.Chart.Gen2", (Color)((Color)new JBColor(11391879, 11391879)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
        gen2Color = (Color)jBColor4;
        JBColor jBColor5 = JBColor.namedColor((String)"Monitoring.Chart.Loh", (Color)((Color)new JBColor(11705845, 11705845)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor5, (String)"namedColor(...)");
        lohColor = (Color)jBColor5;
    }
}

