/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.charts.XYLineChart;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.ChartPanel;
import com.jetbrains.dpa.monitoring.view.CpuChartKt;
import com.jetbrains.dpa.monitoring.view.CpuXYLineChart;
import com.jetbrains.dpa.monitoring.view.MemoryChartKt;
import com.jetbrains.dpa.monitoring.view.MemoryXYLineChart;
import com.jetbrains.dpa.monitoring.view.MonitoringChart;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002JD\u0010\u0010\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00112\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u00110\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u001c\u0010\u001e\u001a\u00020\u000f*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "()V", "areDotNetDatasetsAndOverlaysApplied", "", "charts", "", "Lcom/jetbrains/dpa/monitoring/view/MonitoringChart;", "session", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "getSession", "()Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "setSession", "(Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;)V", "addChartRepaint", "", "applyDotNetDatasetsAndOverlays", "T", "preAction", "Lkotlin/Function1;", "postAction", "Lkotlin/Function2;", "applyNativeDatasetsAndOverlays", "bind", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "update", "aggregatedChartValue", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "isUpdate", "addChartListeners", "Lcom/intellij/ui/charts/XYLineChart;", "adapter", "Lcom/jetbrains/dpa/monitoring/view/ChartPanel$ChartMouseAdapter;", "ChartMouseAdapter", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nChartPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPanel.kt\ncom/jetbrains/dpa/monitoring/view/ChartPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,143:1\n1#2:144\n1855#3,2:145\n1855#3,2:147\n1855#3,2:149\n1855#3,2:151\n13#4:153\n13#5:154\n*S KotlinDebug\n*F\n+ 1 ChartPanel.kt\ncom/jetbrains/dpa/monitoring/view/ChartPanel\n*L\n64#1:145,2\n73#1:147,2\n88#1:149,2\n136#1:151,2\n27#1:153\n27#1:154\n*E\n"})
public final class ChartPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MonitoringChart> charts;
    @Nullable
    private ChartSession session;
    private boolean areDotNetDatasetsAndOverlaysApplied;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public ChartPanel() {
        void $this$_init__u24lambda_u242;
        BorderLayoutPanel $this$_init__u24lambda_u241;
        JPanel jPanel;
        MonitoringChart[] monitoringChartArray = new MonitoringChart[]{CpuChartKt.applyNativeDatasetsAndOverlays(new CpuXYLineChart(), (Function0<ChartSession>)((Function0)new Function0<ChartSession>(this){
            final /* synthetic */ ChartPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ChartSession invoke() {
                return this.this$0.getSession();
            }
        })), MemoryChartKt.applyNativeDatasetsAndOverlays(new MemoryXYLineChart(), (Function0<ChartSession>)((Function0)new Function0<ChartSession>(this){
            final /* synthetic */ ChartPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ChartSession invoke() {
                return this.this$0.getSession();
            }
        }))};
        this.charts = CollectionsKt.listOf((Object[])monitoringChartArray);
        JPanel $this$_init__u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean $i$a$-apply-ChartPanel$panel$22 = false;
        $this$_init__u24lambda_u240.setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel panel = jPanel;
        JBPanel jBPanel = new BorderLayoutPanel().withPreferredHeight(100);
        BorderLayoutPanel $i$a$-apply-ChartPanel$panel$22 = (BorderLayoutPanel)jBPanel;
        Container container = panel;
        boolean bl = false;
        $this$_init__u24lambda_u241.addToCenter((Component)this.charts.get(0).getComponent());
        JBPanel jBPanel2 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel2, (String)"apply(...)");
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)jBPanel2), null, (int)2, null);
        jBPanel = new BorderLayoutPanel().withPreferredHeight(200);
        $this$_init__u24lambda_u241 = (BorderLayoutPanel)jBPanel;
        container = panel;
        boolean bl2 = false;
        $this$_init__u24lambda_u242.addToCenter((Component)this.charts.get(1).getComponent());
        JBPanel jBPanel3 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel3, (String)"apply(...)");
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)jBPanel3), null, (int)2, null);
        this.addToCenter(ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true));
        this.addChartRepaint();
    }

    private final void addChartRepaint() {
        for (MonitoringChart chart : this.charts) {
            ChartMouseAdapter adapter = new ChartMouseAdapter((XYLineChart<Long, Double>)((XYLineChart)chart));
            for (MonitoringChart chartToListen : this.charts) {
                if (Intrinsics.areEqual((Object)((Object)chartToListen), (Object)((Object)chart))) continue;
                this.addChartListeners(chartToListen, adapter);
            }
        }
    }

    private final void addChartListeners(XYLineChart<?, ?> $this$addChartListeners, ChartMouseAdapter adapter) {
        $this$addChartListeners.getComponent().addMouseListener(adapter);
        $this$addChartListeners.getComponent().addMouseMotionListener(adapter);
    }

    @Nullable
    public final ChartSession getSession() {
        return this.session;
    }

    public final void setSession(@Nullable ChartSession chartSession) {
        this.session = chartSession;
    }

    private final void applyNativeDatasetsAndOverlays(ChartSession session) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart chart = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            MonitoringChart monitoringChart = chart;
            if (monitoringChart instanceof CpuXYLineChart) {
                CpuChartKt.applyNativeDatasetsAndOverlays((CpuXYLineChart)chart, (Function0<ChartSession>)((Function0)new Function0<ChartSession>(session){
                    final /* synthetic */ ChartSession $session;
                    {
                        this.$session = $session;
                        super(0);
                    }

                    @Nullable
                    public final ChartSession invoke() {
                        return this.$session;
                    }
                }));
                continue;
            }
            if (!(monitoringChart instanceof MemoryXYLineChart)) continue;
            MemoryChartKt.applyNativeDatasetsAndOverlays((MemoryXYLineChart)chart, (Function0<ChartSession>)((Function0)new Function0<ChartSession>(session){
                final /* synthetic */ ChartSession $session;
                {
                    this.$session = $session;
                    super(0);
                }

                @Nullable
                public final ChartSession invoke() {
                    return this.$session;
                }
            }));
        }
    }

    private final <T> void applyDotNetDatasetsAndOverlays(ChartSession session, Function1<? super MonitoringChart, ? extends T> preAction, Function2<? super MonitoringChart, ? super T, Unit> postAction) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart chart = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            Object data = preAction.invoke((Object)chart);
            MonitoringChart monitoringChart = chart;
            if (monitoringChart instanceof CpuXYLineChart) {
                CpuChartKt.applyDotNetDatasetsAndOverlays((CpuXYLineChart)chart, (Function0<ChartSession>)((Function0)new Function0<ChartSession>(session){
                    final /* synthetic */ ChartSession $session;
                    {
                        this.$session = $session;
                        super(0);
                    }

                    @Nullable
                    public final ChartSession invoke() {
                        return this.$session;
                    }
                }));
            } else if (monitoringChart instanceof MemoryXYLineChart) {
                MemoryChartKt.applyDotNetDatasetsAndOverlays((MemoryXYLineChart)chart, (Function0<ChartSession>)((Function0)new Function0<ChartSession>(session){
                    final /* synthetic */ ChartSession $session;
                    {
                        this.$session = $session;
                        super(0);
                    }

                    @Nullable
                    public final ChartSession invoke() {
                        return this.$session;
                    }
                }));
            }
            postAction.invoke((Object)chart, data);
        }
        this.areDotNetDatasetsAndOverlaysApplied = true;
    }

    public final void bind(@NotNull ChartSession session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        logger.trace("bind pid:" + session.getPid());
        this.session = session;
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart p0 = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            p0.reset();
        }
        this.applyNativeDatasetsAndOverlays(session);
        this.areDotNetDatasetsAndOverlaysApplied = false;
        if (((Boolean)session.isDotNetSession().getValue()).booleanValue()) {
            this.applyDotNetDatasetsAndOverlays(session, bind.2.INSTANCE, bind.3.INSTANCE);
        }
        int n = session.getCachedData().size();
        for (int i = 0; i < n; ++i) {
            this.update(session.getChartData(i), false);
        }
        this.repaint();
        if (!this.areDotNetDatasetsAndOverlaysApplied) {
            SourceExKt.adviseUntil((ISource)((ISource)session.isDotNetSession()), (Lifetime)lifetime, (Function1)((Function1)new Function1<Boolean, Boolean>(this, session){
                final /* synthetic */ ChartPanel this$0;
                final /* synthetic */ ChartSession $session;
                {
                    this.this$0 = $receiver;
                    this.$session = $session;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(boolean isDpaEvent) {
                    if (isDpaEvent) {
                        ChartPanel.access$applyDotNetDatasetsAndOverlays(this.this$0, this.$session, bind.1.INSTANCE, bind.2.INSTANCE);
                    }
                    return isDpaEvent;
                }
            }));
        }
        session.getOnChartEvent().advise(lifetime, (Function1)new Function1<Pair<? extends ChartData, ? extends Boolean>, Unit>(this){
            final /* synthetic */ ChartPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Pair<ChartData, Boolean> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChartPanel.access$update(this.this$0, (ChartData)it.getFirst(), (Boolean)it.getSecond());
                this.this$0.repaint();
            }
        });
        session.getOnMessageCheckDelayEvent().advise(lifetime, (Function1)new Function1<Unit, Unit>(this){
            final /* synthetic */ ChartPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.repaint();
            }
        });
        lifetime.onTermination((Function0)new Function0<Unit>(session, this){
            final /* synthetic */ ChartSession $session;
            final /* synthetic */ ChartPanel this$0;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ChartPanel.access$getLogger$cp().trace("unbind pid:" + this.$session.getPid());
                this.this$0.setSession(null);
                Iterable $this$forEach$iv = ChartPanel.access$getCharts$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    MonitoringChart p0 = (MonitoringChart)((Object)element$iv);
                    boolean bl = false;
                    p0.reset();
                }
                this.this$0.repaint();
            }
        });
    }

    private final void update(ChartData aggregatedChartValue, boolean isUpdate) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart it = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            it.update(aggregatedChartValue, isUpdate);
        }
    }

    public static final /* synthetic */ void access$applyDotNetDatasetsAndOverlays(ChartPanel $this, ChartSession session, Function1 preAction, Function2 postAction) {
        $this.applyDotNetDatasetsAndOverlays(session, preAction, postAction);
    }

    public static final /* synthetic */ void access$update(ChartPanel $this, ChartData aggregatedChartValue, boolean isUpdate) {
        $this.update(aggregatedChartValue, isUpdate);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ List access$getCharts$p(ChartPanel $this) {
        return $this.charts;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChartPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChartPanel.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel$ChartMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "chartToRepaint", "Lcom/intellij/ui/charts/XYLineChart;", "", "", "(Lcom/intellij/ui/charts/XYLineChart;)V", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "intellij.rider.plugins.dpa"})
    private static final class ChartMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final XYLineChart<Long, Double> chartToRepaint;

        public ChartMouseAdapter(@NotNull XYLineChart<Long, Double> chartToRepaint) {
            Intrinsics.checkNotNullParameter(chartToRepaint, (String)"chartToRepaint");
            this.chartToRepaint = chartToRepaint;
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

