/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.sessions;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.OS;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogCollectItemsUtilKt;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogProcessItem;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachItemsInfo;
import com.jetbrains.dpa.DpaSessions;
import com.jetbrains.dpa.monitoring.MonitoringUsagesCollector;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.services.FallbackProtocolSessions;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.sessions.CounterSession;
import com.jetbrains.dpa.monitoring.sessions.MemoryProfilingSession;
import com.jetbrains.dpa.monitoring.sessions.PerformanceProfilingSession;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.attach.dotnet.MsNetAttachDebugger;
import com.jetbrains.rider.model.CollectorControllerMode;
import com.jetbrains.rider.model.DesktopClrRuntime;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.ExceptionEvent;
import com.jetbrains.rider.model.GenericCoreClrRuntime;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.model.MonitoringToolModel;
import com.jetbrains.rider.model.MonitoringToolModel_PregeneratedKt;
import com.jetbrains.rider.model.MonoRuntime;
import com.jetbrains.rider.model.ProcessRuntimeInformation;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.model.UwpCoreClrRuntime;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 U2\u00020\u0001:\u0004TUVWB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010?\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010AJ\u0016\u0010B\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010AJ\u000f\u0010C\u001a\u0004\u0018\u00010@H\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020@H\u0002J\u000f\u0010F\u001a\u0004\u0018\u00010@H\u0002\u00a2\u0006\u0002\u0010DJ\b\u0010G\u001a\u00020@H\u0002J@\u0010H\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020:0J2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020:0J2\u0012\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0M0JH\u0002J\u000e\u0010O\u001a\u00020@2\u0006\u0010P\u001a\u00020\u001bJ\u001a\u0010Q\u001a\u00020@2\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010=\u001a\u00020\u001bH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001eR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\"R\u0011\u0010#\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001eR\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0011\u0010%\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001eR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020403\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020<03X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b03\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u00106\u00a8\u0006X"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session;", "", "project", "Lcom/intellij/openapi/project/Project;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "pid", "", "mode", "Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/process/ProcessHandler;ILcom/jetbrains/dpa/monitoring/sessions/Session$Mode;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/CoroutineScope;)V", "applicationKind", "Lcom/jetbrains/dpa/monitoring/sessions/Session$ApplicationKind;", "chartSession", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "getChartSession", "()Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "counterSession", "Lcom/jetbrains/dpa/monitoring/sessions/CounterSession;", "getCounterSession", "()Lcom/jetbrains/dpa/monitoring/sessions/CounterSession;", "isAllowedToStart", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "", "()Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "isMemoryProfilingAvailable", "()Z", "isProfilingRunning", "isRunning", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "isSamplingProfilingAvailable", "isStackTraceCollectingAvailable", "isTimelineProfilingAvailable", "memoryProfilingSession", "Lcom/jetbrains/dpa/monitoring/sessions/MemoryProfilingSession;", "getMemoryProfilingSession", "()Lcom/jetbrains/dpa/monitoring/sessions/MemoryProfilingSession;", "getMode", "()Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "performanceProfilingSession", "Lcom/jetbrains/dpa/monitoring/sessions/PerformanceProfilingSession;", "getPerformanceProfilingSession", "()Lcom/jetbrains/dpa/monitoring/sessions/PerformanceProfilingSession;", "getPid", "()I", "processInfoProperty", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "getProcessInfoProperty", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "processingLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "protocolSession", "Lcom/jetbrains/rider/model/ProtocolSession;", "state", "Lcom/jetbrains/dpa/monitoring/sessions/Session$State;", "uiActivated", "getUiActivated", "detectApplicationKind", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fixProcessInfoOnLinux", "pause", "()Lkotlin/Unit;", "reportStatistics", "restart", "start", "startDotNetSession", "chartSessionPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "counterSessionPromise", "exceptionSignalPromise", "Lcom/jetbrains/rd/util/reactive/IAsyncSignal;", "Lcom/jetbrains/rider/model/ExceptionEvent;", "stop", "willBeDestroyed", "updateState", "startMode", "Lcom/jetbrains/rider/model/MonitoringStartMode;", "ApplicationKind", "Companion", "Mode", "State", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\ncom/jetbrains/dpa/monitoring/sessions/Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,272:1\n1#2:273\n288#3,2:274\n800#3,11:276\n1549#3:287\n1620#3,3:288\n1747#3,3:291\n1747#3,3:294\n1747#3,3:297\n13#4:300\n13#5:301\n*S KotlinDebug\n*F\n+ 1 Session.kt\ncom/jetbrains/dpa/monitoring/sessions/Session\n*L\n180#1:274,2\n181#1:276,11\n181#1:287\n181#1:288,3\n183#1:291,3\n185#1:294,3\n187#1:297,3\n29#1:300\n29#1:301\n*E\n"})
public final class Session {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProcessHandler processHandler;
    private final int pid;
    @NotNull
    private final Mode mode;
    @NotNull
    private IProperty<State> state;
    @NotNull
    private final IPropertyView<Boolean> isRunning;
    @NotNull
    private final IProperty<Boolean> uiActivated;
    @NotNull
    private final IOptPropertyView<Boolean> isAllowedToStart;
    @NotNull
    private final ChartSession chartSession;
    @NotNull
    private final CounterSession counterSession;
    @NotNull
    private final PerformanceProfilingSession performanceProfilingSession;
    @NotNull
    private final MemoryProfilingSession memoryProfilingSession;
    @NotNull
    private final IProperty<ProcessInfo> processInfoProperty;
    @NotNull
    private volatile ApplicationKind applicationKind;
    @NotNull
    private final LifetimeDefinition processingLifetimeDefinition;
    @Nullable
    private ProtocolSession protocolSession;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public Session(@NotNull Project project, @NotNull ProcessHandler processHandler, int pid, @NotNull Mode mode, @NotNull Lifetime lifetime, @NotNull CoroutineScope coroutineScope) {
        void $this$_init__u24lambda_u242;
        LifetimeDefinition lifetimeDefinition;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.processHandler = processHandler;
        this.pid = pid;
        this.mode = mode;
        this.state = (IProperty)new Property((Object)State.Disabled);
        this.isRunning = PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)this.state), (Function1)isRunning.1.INSTANCE);
        this.uiActivated = (IProperty)new Property((Object)false);
        this.applicationKind = ApplicationKind.Native;
        logger.trace("init processHandler:" + this.processHandler + " pid:" + this.pid + " mode:" + this.mode);
        final MonitoringToolModel model = MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        LifetimeDefinition lifetimeDefinition2 = lifetimeDefinition = lifetime.createNested();
        Session session = this;
        boolean bl = false;
        $this$_init__u24lambda_u242.setId((Object)("session processing for processHandler:" + this.processHandler + " pid:" + this.pid));
        session.processingLifetimeDefinition = lifetimeDefinition;
        MonitoringStartMode monitoringStartMode = (MonitoringStartMode)model.getStartMode().getValueOrNull();
        this.isAllowedToStart = (IOptPropertyView)new OptProperty((Object)(switch (monitoringStartMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[monitoringStartMode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> {
                if (this.mode == Mode.Debug) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        }));
        ProcessInfo processInfo = ProcessInfo.Companion.create(this.pid);
        if (processInfo == null) {
            throw new IllegalStateException("Failed to collect process information for " + this.pid);
        }
        ProcessInfo processInfo2 = processInfo;
        this.processInfoProperty = (IProperty)new Property((Object)processInfo2);
        AsyncPromise chartSessionPromise = new AsyncPromise();
        AsyncPromise counterSessionPromise = new AsyncPromise();
        AsyncPromise exceptionSignalPromise = new AsyncPromise();
        this.chartSession = new ChartSession((Lifetime)this.processingLifetimeDefinition, this.pid, this.isAllowedToStart, coroutineScope, (Promise<ProtocolSession>)((Promise)chartSessionPromise), (Promise<IAsyncSignal<ExceptionEvent>>)((Promise)exceptionSignalPromise));
        this.counterSession = new CounterSession((Lifetime)this.processingLifetimeDefinition, (Promise<ProtocolSession>)((Promise)counterSessionPromise));
        if (BoolPropertyExKt.getHasTrueValue(this.isAllowedToStart)) {
            this.startDotNetSession(lifetime, (AsyncPromise<ProtocolSession>)chartSessionPromise, (AsyncPromise<ProtocolSession>)counterSessionPromise, (AsyncPromise<IAsyncSignal<ExceptionEvent>>)exceptionSignalPromise);
        }
        this.memoryProfilingSession = new MemoryProfilingSession((Lifetime)this.processingLifetimeDefinition, this.project, this.pid, processInfo2.getProcessName());
        this.performanceProfilingSession = new PerformanceProfilingSession((Lifetime)this.processingLifetimeDefinition, this.project, this.pid, processInfo2.getProcessName());
        model.getStartMode().advise((Lifetime)this.processingLifetimeDefinition, (Function1)new Function1<MonitoringStartMode, Unit>(){

            public final void invoke(@NotNull MonitoringStartMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                logger.trace("model.startMode changed  state:" + state.getValue() + " processHandler:" + processHandler + " pid:" + this.getPid() + " mode:" + it);
                this.updateState(it, (Boolean)this.getUiActivated().getValue());
            }
        });
        SourceExKt.adviseUntil((ISource)((ISource)this.uiActivated), (Lifetime)((Lifetime)this.processingLifetimeDefinition), (Function1)((Function1)new Function1<Boolean, Boolean>(){

            @NotNull
            public final Boolean invoke(boolean isUiActivated) {
                logger.trace("uiActivated changed processHandler:" + processHandler + " pid:" + this.getPid() + " mode:" + this.getUiActivated());
                this.updateState((MonitoringStartMode)model.getStartMode().getValueOrNull(), isUiActivated);
                return isUiActivated;
            }
        }));
        if (BoolPropertyExKt.getHasTrueValue(this.isAllowedToStart)) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lifetime, null){
                int label;
                final /* synthetic */ Session this$0;
                final /* synthetic */ Lifetime $lifetime;
                {
                    this.this$0 = $receiver;
                    this.$lifetime = $lifetime;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.detectApplicationKind(this.$lifetime, (Continuation<? super Unit>)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            if (OS.CURRENT == OS.Linux) {
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lifetime, null){
                    int label;
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ Lifetime $lifetime;
                    {
                        this.this$0 = $receiver;
                        this.$lifetime = $lifetime;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.fixProcessInfoOnLinux(this.$lifetime, (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    @NotNull
    public final IPropertyView<Boolean> isRunning() {
        return this.isRunning;
    }

    @NotNull
    public final IProperty<Boolean> getUiActivated() {
        return this.uiActivated;
    }

    @NotNull
    public final IOptPropertyView<Boolean> isAllowedToStart() {
        return this.isAllowedToStart;
    }

    @NotNull
    public final ChartSession getChartSession() {
        return this.chartSession;
    }

    @NotNull
    public final CounterSession getCounterSession() {
        return this.counterSession;
    }

    @NotNull
    public final PerformanceProfilingSession getPerformanceProfilingSession() {
        return this.performanceProfilingSession;
    }

    @NotNull
    public final MemoryProfilingSession getMemoryProfilingSession() {
        return this.memoryProfilingSession;
    }

    @NotNull
    public final IProperty<ProcessInfo> getProcessInfoProperty() {
        return this.processInfoProperty;
    }

    private final boolean isProfilingRunning() {
        return this.memoryProfilingSession.isUnderProfiling() || this.performanceProfilingSession.isUnderProfiling();
    }

    public final boolean isStackTraceCollectingAvailable() {
        return this.state.getValue() == State.Ready && !this.isProfilingRunning() && this.applicationKind == ApplicationKind.NetCore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMemoryProfilingAvailable() {
        if (this.state.getValue() != State.Ready) return false;
        if (this.isProfilingRunning()) return false;
        ApplicationKind it = this.applicationKind;
        boolean bl = false;
        if (it == ApplicationKind.NetCore) return true;
        if (it != ApplicationKind.NetFramework) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isSamplingProfilingAvailable() {
        if (this.state.getValue() != State.Ready) return false;
        if (this.isProfilingRunning()) return false;
        ApplicationKind it = this.applicationKind;
        boolean bl = false;
        if (it == ApplicationKind.NetCore) return true;
        if (it != ApplicationKind.NetFramework) return false;
        return true;
    }

    public final boolean isTimelineProfilingAvailable() {
        return this.state.getValue() == State.Ready && !this.isProfilingRunning() && (SystemInfo.isWindows || this.applicationKind == ApplicationKind.NetCore);
    }

    private final void startDotNetSession(Lifetime lifetime, AsyncPromise<ProtocolSession> chartSessionPromise, AsyncPromise<ProtocolSession> counterSessionPromise, AsyncPromise<IAsyncSignal<ExceptionEvent>> exceptionSignalPromise) {
        Promise<ProtocolSession> dpaSessionPromise = DpaSessions.Companion.getInstance(this.project).tryWaitSession(this.processHandler, lifetime);
        dpaSessionPromise.onSuccess(arg_0 -> Session.startDotNetSession$lambda$3((Function1)new Function1<ProtocolSession, Unit>(chartSessionPromise, this, counterSessionPromise, exceptionSignalPromise){
            final /* synthetic */ AsyncPromise<ProtocolSession> $chartSessionPromise;
            final /* synthetic */ Session this$0;
            final /* synthetic */ AsyncPromise<ProtocolSession> $counterSessionPromise;
            final /* synthetic */ AsyncPromise<IAsyncSignal<ExceptionEvent>> $exceptionSignalPromise;
            {
                this.$chartSessionPromise = $chartSessionPromise;
                this.this$0 = $receiver;
                this.$counterSessionPromise = $counterSessionPromise;
                this.$exceptionSignalPromise = $exceptionSignalPromise;
                super(1);
            }

            public final void invoke(ProtocolSession dpaSession) {
                this.$chartSessionPromise.setResult((Object)dpaSession);
                if (DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)Session.access$getProject$p(this.this$0))).getCollectorMode().getValueOrNull() == CollectorControllerMode.EventPipe) {
                    this.$counterSessionPromise.setResult((Object)dpaSession);
                    this.$exceptionSignalPromise.setResult((Object)dpaSession.getOnException());
                } else {
                    ProtocolSession dependentCountersSession = FallbackProtocolSessions.Companion.getInstance(Session.access$getProject$p(this.this$0)).getCounterSession(this.this$0.getPid(), (Lifetime)Session.access$getProcessingLifetimeDefinition$p(this.this$0));
                    dpaSession.isFinished().advise((Lifetime)Session.access$getProcessingLifetimeDefinition$p(this.this$0), (Function1)new Function1<Boolean, Unit>(dependentCountersSession){
                        final /* synthetic */ ProtocolSession $dependentCountersSession;
                        {
                            this.$dependentCountersSession = $dependentCountersSession;
                            super(1);
                        }

                        public final void invoke(boolean isFinished) {
                            if (isFinished) {
                                this.$dependentCountersSession.isActive().set((Object)false);
                            }
                        }
                    });
                    this.$counterSessionPromise.setResult((Object)dependentCountersSession);
                    this.$exceptionSignalPromise.setResult((Object)dependentCountersSession.getOnException());
                    Session.access$setProtocolSession$p(this.this$0, dependentCountersSession);
                }
            }
        }, arg_0));
        dpaSessionPromise.onError(arg_0 -> Session.startDotNetSession$lambda$4((Function1)new Function1<Throwable, Unit>(this, chartSessionPromise, counterSessionPromise, exceptionSignalPromise){
            final /* synthetic */ Session this$0;
            final /* synthetic */ AsyncPromise<ProtocolSession> $chartSessionPromise;
            final /* synthetic */ AsyncPromise<ProtocolSession> $counterSessionPromise;
            final /* synthetic */ AsyncPromise<IAsyncSignal<ExceptionEvent>> $exceptionSignalPromise;
            {
                this.this$0 = $receiver;
                this.$chartSessionPromise = $chartSessionPromise;
                this.$counterSessionPromise = $counterSessionPromise;
                this.$exceptionSignalPromise = $exceptionSignalPromise;
                super(1);
            }

            public final void invoke(Throwable it) {
                ProtocolSession fallbackSession = FallbackProtocolSessions.Companion.getInstance(Session.access$getProject$p(this.this$0)).getFullSession(this.this$0.getPid(), (Lifetime)Session.access$getProcessingLifetimeDefinition$p(this.this$0));
                this.$chartSessionPromise.setResult((Object)fallbackSession);
                this.$counterSessionPromise.setResult((Object)fallbackSession);
                this.$exceptionSignalPromise.setResult((Object)fallbackSession.getOnException());
                Session.access$setProtocolSession$p(this.this$0, fallbackSession);
            }
        }, arg_0));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object detectApplicationKind(Lifetime var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof detectApplicationKind.1)) ** GOTO lbl-1000
        var19_3 = var2_2;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$detectApplicationKind(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 3 sources

                while (RLifetimeKt.isAlive((Lifetime)lifetime) && Intrinsics.areEqual((Object)this.isAllowedToStart.getValueOrNull(), (Object)Boxing.boxBoolean((boolean)true))) {
                    v0 = LocalAttachHost.INSTANCE;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"INSTANCE");
                    $continuation.L$0 = this;
                    $continuation.L$1 = lifetime;
                    $continuation.label = 1;
                    v1 = AttachDialogCollectItemsUtilKt.collectAttachProcessItemsGroupByProcessInfo((Project)this.project, (XAttachHost)((XAttachHost)v0), (List)XAttachDebuggerProvider.EP.getExtensionList(), (Continuation)$continuation);
                    if (v1 == var20_5) {
                        return var20_5;
                    }
                    ** GOTO lbl28
                }
                break;
            }
            case 1: {
                lifetime = (Lifetime)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                $this$firstOrNull$iv = ((AttachItemsInfo)v1).getProcessItems();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it /* !! */  = (AttachDialogProcessItem)element$iv;
                    $i$a$-firstOrNull-Session$detectApplicationKind$runtimes$1 = false;
                    if (!(it /* !! */ .getProcessInfo().getPid() == this.pid)) continue;
                    v2 = element$iv;
                    ** GOTO lbl37
                }
                v2 = null;
lbl37:
                // 2 sources

                var4_7 /* !! */  = v2;
                if (var4_7 /* !! */  != null && ($this$firstOrNull$iv = var4_7 /* !! */ .getDebuggers()) != null) {
                    $this$filterIsInstance$iv = $this$firstOrNull$iv;
                    $i$f$filterIsInstance = false;
                    it /* !! */  = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof MsNetAttachDebugger)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$map = false;
                    $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var14_31 = (MsNetAttachDebugger)item$iv$iv;
                        var16_33 = destination$iv$iv;
                        $i$a$-map-Session$detectApplicationKind$runtimes$2 = false;
                        var16_33.add(it.getRuntime());
                    }
                    v3 = (List)destination$iv$iv;
                } else {
                    v3 = null;
                }
                runtimes = v3;
                v4 = this;
                v5 = runtimes;
                if (v5 == null) ** GOTO lbl86
                var4_7 /* !! */  = v5;
                var16_33 = v4;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl75
                v6 = false;
                ** GOTO lbl82
lbl75:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (ProcessRuntimeInformation)element$iv;
                    $i$a$-any-Session$detectApplicationKind$2 = false;
                    if (!(it instanceof DesktopClrRuntime)) continue;
                    v6 = true;
                    ** GOTO lbl82
                }
                v6 = false;
lbl82:
                // 3 sources

                var17_34 = v6;
                v4 = var16_33;
                v7 = var17_34;
                ** GOTO lbl87
lbl86:
                // 1 sources

                v7 = false;
lbl87:
                // 2 sources

                if (!v7) ** GOTO lbl90
                v8 = ApplicationKind.NetFramework;
                ** GOTO lbl134
lbl90:
                // 1 sources

                v9 = runtimes;
                if (v9 == null) ** GOTO lbl109
                $this$any$iv = v9;
                var16_33 = v4;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl98
                v10 = false;
                ** GOTO lbl105
lbl98:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (ProcessRuntimeInformation)element$iv;
                    $i$a$-any-Session$detectApplicationKind$3 = false;
                    if (!(it instanceof GenericCoreClrRuntime != false || it instanceof UwpCoreClrRuntime != false)) continue;
                    v10 = true;
                    ** GOTO lbl105
                }
                v10 = false;
lbl105:
                // 3 sources

                var17_34 = v10;
                v4 = var16_33;
                v11 = var17_34;
                ** GOTO lbl110
lbl109:
                // 1 sources

                v11 = false;
lbl110:
                // 2 sources

                if (!v11) ** GOTO lbl113
                v8 = ApplicationKind.NetCore;
                ** GOTO lbl134
lbl113:
                // 1 sources

                v12 = runtimes;
                if (v12 == null) ** GOTO lbl132
                $this$any$iv = v12;
                var16_33 = v4;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl121
                v13 = false;
                ** GOTO lbl128
lbl121:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (ProcessRuntimeInformation)element$iv;
                    $i$a$-any-Session$detectApplicationKind$4 = false;
                    if (!(it instanceof MonoRuntime)) continue;
                    v13 = true;
                    ** GOTO lbl128
                }
                v13 = false;
lbl128:
                // 3 sources

                var17_34 = v13;
                v4 = var16_33;
                v14 = var17_34;
                ** GOTO lbl133
lbl132:
                // 1 sources

                v14 = false;
lbl133:
                // 2 sources

                v8 = v4.applicationKind = v14 != false ? ApplicationKind.Mono : ApplicationKind.Native;
lbl134:
                // 3 sources

                if (this.applicationKind != ApplicationKind.Native) {
                    ActivityTracker.getInstance().inc();
                    break;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = lifetime;
                $continuation.label = 2;
                v15 = DelayKt.delay((long)5000L, (Continuation)$continuation);
                if (v15 != var20_5) ** GOTO lbl12
                return var20_5;
            }
            case 2: {
                lifetime = (Lifetime)$continuation.L$1;
                this = (Session)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
                ** GOTO lbl12
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object fixProcessInfoOnLinux(Lifetime var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof fixProcessInfoOnLinux.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$fixProcessInfoOnLinux(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attempts_count = 10;
                try {
                    i = 0;
                }
                catch (Exception e) {
                    Session.logger.warn((Throwable)e);
                    return Unit.INSTANCE;
                }
lbl20:
                // 2 sources

                while (true) {
                    if (RLifetimeKt.isNotAlive((Lifetime)lifetime) || !Intrinsics.areEqual((Object)this.isAllowedToStart.getValueOrNull(), (Object)Boxing.boxBoolean((boolean)true))) {
                        return Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNull((Object)ProcessInfo.Companion.create(this.pid));
                    if (!Intrinsics.areEqual((Object)((ProcessInfo)this.processInfoProperty.getValue()).getCommandLine(), (Object)processInfo.getCommandLine())) {
                        this.processInfoProperty.set((Object)processInfo);
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = lifetime;
                    $continuation.I$0 = attempts_count;
                    $continuation.I$1 = i;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)500L, (Continuation)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl44
                    break;
                }
            }
            case 1: {
                i = $continuation.I$1;
                attempts_count = $continuation.I$0;
                lifetime = (Lifetime)$continuation.L$1;
                this = (Session)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    if (i == attempts_count) return Unit.INSTANCE;
                    ++i;
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateState(MonitoringStartMode startMode, boolean uiActivated) {
        Boolean shouldBeActive = uiActivated ? (Boolean)this.isAllowedToStart.getValueOrNull() : Boolean.valueOf(false);
        logger.trace("shouldBeActive:" + shouldBeActive + " state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid + " mode:" + startMode + " uiActivated: " + uiActivated);
        if (this.state.getValue() == State.Disabled && Intrinsics.areEqual((Object)shouldBeActive, (Object)true)) {
            this.start();
        } else if (this.state.getValue() == State.Paused && Intrinsics.areEqual((Object)shouldBeActive, (Object)true)) {
            this.restart();
            this.state.set((Object)State.Ready);
        } else if (this.state.getValue() == State.Ready && Intrinsics.areEqual((Object)shouldBeActive, (Object)false)) {
            this.pause();
            this.state.set((Object)State.Paused);
        }
    }

    private final void reportStatistics() {
        logger.trace("lifetime.onTermination state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        Object it = this.chartSession;
        boolean bl = false;
        MonitoringUsagesCollector.CPU_PANEL_SHOW_COUNT.log((Object)((ChartSession)it).getShowCounterCpuPanel());
        MonitoringUsagesCollector.MEMORY_PANEL_SHOW_COUNT.log((Object)((ChartSession)it).getShowCounterMemoryPanel());
        it = this.counterSession;
        boolean bl2 = false;
        MonitoringUsagesCollector.COUNTERS_SHOW_COUNT.log((Object)((CounterSession)it).getShowCounter());
    }

    private final void start() {
        logger.trace("start state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        this.state.set((Object)State.Ready);
        logger.trace("after initialization state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
    }

    public final void stop(boolean willBeDestroyed) {
        logger.trace("stop state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        ProtocolSession session = this.protocolSession;
        if (session != null) {
            session.getProcessTerminating().setValue((Object)willBeDestroyed);
        } else {
            logger.trace("ignore stop state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.processingLifetimeDefinition, (boolean)false, (int)1, null);
        this.reportStatistics();
        this.state.set((Object)State.Stopped);
    }

    private final Unit pause() {
        Unit unit;
        ProtocolSession protocolSession = this.protocolSession;
        if (protocolSession != null && (protocolSession = protocolSession.isActive()) != null) {
            protocolSession.set((Object)false);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit restart() {
        Unit unit;
        ProtocolSession protocolSession = this.protocolSession;
        if (protocolSession != null && (protocolSession = protocolSession.isActive()) != null) {
            protocolSession.set((Object)true);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void startDotNetSession$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void startDotNetSession$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(Session $this) {
        return $this.project;
    }

    public static final /* synthetic */ LifetimeDefinition access$getProcessingLifetimeDefinition$p(Session $this) {
        return $this.processingLifetimeDefinition;
    }

    public static final /* synthetic */ void access$setProtocolSession$p(Session $this, ProtocolSession protocolSession) {
        $this.protocolSession = protocolSession;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Session.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Session.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$ApplicationKind;", "", "(Ljava/lang/String;I)V", "NetCore", "NetFramework", "Mono", "Native", "intellij.rider.plugins.dpa"})
    public static final class ApplicationKind
    extends Enum<ApplicationKind> {
        public static final /* enum */ ApplicationKind NetCore = new ApplicationKind();
        public static final /* enum */ ApplicationKind NetFramework = new ApplicationKind();
        public static final /* enum */ ApplicationKind Mono = new ApplicationKind();
        public static final /* enum */ ApplicationKind Native = new ApplicationKind();
        private static final /* synthetic */ ApplicationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ApplicationKind[] values() {
            return (ApplicationKind[])$VALUES.clone();
        }

        public static ApplicationKind valueOf(String value) {
            return Enum.valueOf(ApplicationKind.class, value);
        }

        @NotNull
        public static EnumEntries<ApplicationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicationKindArray = new ApplicationKind[]{ApplicationKind.NetCore, ApplicationKind.NetFramework, ApplicationKind.Mono, ApplicationKind.Native};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "", "(Ljava/lang/String;I)V", "Run", "Debug", "intellij.rider.plugins.dpa"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Run = new Mode();
        public static final /* enum */ Mode Debug = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Run, Mode.Debug};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$State;", "", "(Ljava/lang/String;I)V", "Disabled", "Ready", "Paused", "Stopped", "intellij.rider.plugins.dpa"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Disabled = new State();
        public static final /* enum */ State Ready = new State();
        public static final /* enum */ State Paused = new State();
        public static final /* enum */ State Stopped = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Disabled, State.Ready, State.Paused, State.Stopped};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MonitoringStartMode.values().length];
            try {
                nArray[MonitoringStartMode.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitoringStartMode.Always.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitoringStartMode.OnDebug.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

