/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.sessions;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.dotCommon.ProcessInfoApi;
import com.jetbrains.dpa.monitoring.sessions.BaseChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.sessions.HeapChartData;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.model.AllocationKind;
import com.jetbrains.rider.model.ExceptionEvent;
import com.jetbrains.rider.model.GcEvent;
import com.jetbrains.rider.model.HeapAllocation;
import com.jetbrains.rider.model.HeapStat;
import com.jetbrains.rider.model.MessageCheckDelay;
import com.jetbrains.rider.model.ProtocolSession;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import kotlin.Function;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.AdaptedFunctionReference;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 d2\u00020\u0001:\u0002deBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\f\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010C\u001a\u0002002\u0006\u0010\u0004\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010DJ\u0018\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020,2\u0006\u0010G\u001a\u00020\bH\u0002J\u0018\u0010E\u001a\u0002002\u0006\u0010H\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\bH\u0002J\u000e\u0010I\u001a\u00020,2\u0006\u0010H\u001a\u00020\u0005J\u001a\u0010J\u001a\u00020\u00182\u0006\u0010K\u001a\u00020LH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bM\u0010NJ\u0010\u0010O\u001a\u0002002\u0006\u0010P\u001a\u00020 H\u0002J\u0010\u0010Q\u001a\u0002002\u0006\u0010F\u001a\u00020\u0014H\u0002J\u0010\u0010R\u001a\u0002002\u0006\u0010S\u001a\u00020\u0010H\u0002J\u0010\u0010T\u001a\u0002002\u0006\u0010U\u001a\u00020\u0018H\u0002J\u0010\u0010V\u001a\u0002002\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u0002002\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u0002002\u0006\u0010]\u001a\u00020'H\u0002J\b\u0010^\u001a\u000200H\u0002J\"\u0010_\u001a\u0002002\u0006\u0010U\u001a\u00020\u00182\u0006\u0010`\u001a\u00020aH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bb\u0010cR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u001e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0$\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R#\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\b0+0*\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u0002000*\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001e\u00104\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00109\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u0010:\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00103\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u00103\"\u0004\b@\u0010=R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00140BX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006f"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "pid", "", "isAllowedToRun", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "protocolSessionPromise", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/model/ProtocolSession;", "exceptionSignalPromise", "Lcom/jetbrains/rd/util/reactive/IAsyncSignal;", "Lcom/jetbrains/rider/model/ExceptionEvent;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ILcom/jetbrains/rd/util/reactive/IOptPropertyView;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/concurrency/Promise;Lorg/jetbrains/concurrency/Promise;)V", "cachedData", "", "Lcom/jetbrains/dpa/monitoring/sessions/BaseChartData;", "getCachedData", "()Ljava/util/List;", "clrInstancesHeapData", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$HeapData;", "getClrInstancesHeapData", "<set-?>", "collectCpuUsageAndPrivateMemoryViaSystemAPI", "getCollectCpuUsageAndPrivateMemoryViaSystemAPI", "()Z", "gcData", "Ljava/util/LinkedList;", "Lcom/jetbrains/rider/model/GcEvent;", "getGcData", "()Ljava/util/LinkedList;", "isDotNetSession", "Lcom/jetbrains/rd/util/reactive/IProperty;", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "messageCheckDelayData", "Lcom/jetbrains/rider/model/MessageCheckDelay;", "getMessageCheckDelayData", "onChartEvent", "Lcom/jetbrains/rd/util/reactive/ISignal;", "Lkotlin/Pair;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "getOnChartEvent", "()Lcom/jetbrains/rd/util/reactive/ISignal;", "onMessageCheckDelayEvent", "", "getOnMessageCheckDelayEvent", "getPid", "()I", "raiseUpdateFromRequired", "getRaiseUpdateFromRequired", "()Ljava/lang/Integer;", "setRaiseUpdateFromRequired", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "showCounterCpuPanel", "getShowCounterCpuPanel", "setShowCounterCpuPanel", "(I)V", "showCounterMemoryPanel", "getShowCounterMemoryPanel", "setShowCounterMemoryPanel", "uiFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "collectCpuUsageAndPrivateMemory", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fireChartEvent", "chartData", "isUpdate", "index", "getChartData", "getHeapData", "clrInstanceId", "Lkotlin/UShort;", "getHeapData-xj2QHRw", "(S)Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$HeapData;", "handleGcEvent", "it", "handleNativeCounters", "onException", "exception", "onFinishHeapData", "heapData", "onHeapAllocation", "heapAllocation", "Lcom/jetbrains/rider/model/HeapAllocation;", "onHeapStat", "heapStat", "Lcom/jetbrains/rider/model/HeapStat;", "onMessageCheckDelay", "messageCheckDelay", "tryUpdate", "updateHeapData", "qpcTimestamp", "Lkotlin/ULong;", "updateHeapData-2TYgG_w", "(Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$HeapData;J)V", "Companion", "HeapData", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nChartSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartSession.kt\ncom/jetbrains/dpa/monitoring/sessions/ChartSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,342:1\n1#2:343\n1855#3,2:344\n288#3,2:346\n1855#3,2:348\n1855#3,2:350\n13#4:352\n13#5:353\n*S KotlinDebug\n*F\n+ 1 ChartSession.kt\ncom/jetbrains/dpa/monitoring/sessions/ChartSession\n*L\n199#1:344,2\n226#1:346,2\n304#1:348,2\n310#1:350,2\n53#1:352\n53#1:353\n*E\n"})
public final class ChartSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @NotNull
    private final ISignal<Pair<ChartData, Boolean>> onChartEvent;
    @NotNull
    private final IProperty<Boolean> isDotNetSession;
    @NotNull
    private final ISignal<Unit> onMessageCheckDelayEvent;
    @NotNull
    private final List<BaseChartData> cachedData;
    @NotNull
    private final LinkedList<GcEvent> gcData;
    @NotNull
    private final LinkedList<MessageCheckDelay> messageCheckDelayData;
    @NotNull
    private final List<HeapData> clrInstancesHeapData;
    @Nullable
    private Integer raiseUpdateFromRequired;
    private int showCounterMemoryPanel;
    private int showCounterCpuPanel;
    private boolean collectCpuUsageAndPrivateMemoryViaSystemAPI;
    @NotNull
    private final MutableSharedFlow<BaseChartData> uiFlow;
    @NotNull
    private static final Logger logger;

    public ChartSession(final @NotNull Lifetime lifetime, int pid, @NotNull IOptPropertyView<Boolean> isAllowedToRun, final @NotNull CoroutineScope coroutineScope, @NotNull Promise<ProtocolSession> protocolSessionPromise, @NotNull Promise<IAsyncSignal<ExceptionEvent>> exceptionSignalPromise) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(isAllowedToRun, (String)"isAllowedToRun");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(protocolSessionPromise, (String)"protocolSessionPromise");
        Intrinsics.checkNotNullParameter(exceptionSignalPromise, (String)"exceptionSignalPromise");
        this.pid = pid;
        this.onChartEvent = (ISignal)new Signal();
        this.isDotNetSession = (IProperty)new Property((Object)false);
        this.onMessageCheckDelayEvent = (ISignal)new Signal();
        this.cachedData = new ArrayList();
        this.gcData = new LinkedList();
        this.messageCheckDelayData = new LinkedList();
        this.clrInstancesHeapData = new ArrayList();
        this.collectCpuUsageAndPrivateMemoryViaSystemAPI = true;
        BufferOverflow bufferOverflow = BufferOverflow.DROP_OLDEST;
        this.uiFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)60, (BufferOverflow)bufferOverflow, (int)1, null);
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lifetime, this, null){
            int label;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ ChartSession this$0;
            {
                this.$lifetime = $lifetime;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = LifetimeCoroutineUtilKt.lifetimedCoroutineScope((Lifetime)this.$lifetime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ ChartSession this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        final ChartSession chartSession = this.this$0;
                                        this.label = 1;
                                        Object object3 = this.this$0.uiFlow.collect(new FlowCollector(){

                                            @Nullable
                                            public final Object emit(@NotNull BaseChartData p0, @NotNull Continuation<? super Unit> $completion) {
                                                Object object = 1.invokeSuspend$handleNativeCounters(chartSession, p0, $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }

                                            @NotNull
                                            public final Function<?> getFunctionDelegate() {
                                                return (Function)new AdaptedFunctionReference(2, (Object)chartSession, ChartSession.class, "handleNativeCounters", "handleNativeCounters(Lcom/jetbrains/dpa/monitoring/sessions/BaseChartData;)V", 4);
                                            }

                                            public final boolean equals(@Nullable Object other) {
                                                return other instanceof FlowCollector ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                                            }

                                            public final int hashCode() {
                                                return this.getFunctionDelegate().hashCode();
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) throw new KotlinNothingValueException();
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final /* synthetic */ Object invokeSuspend$handleNativeCounters(ChartSession $this$invokeSuspend_u24handleNativeCounters, BaseChartData p0, Continuation $completion) {
                                $this$invokeSuspend_u24handleNativeCounters.handleNativeCounters(p0);
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        isAllowedToRun.advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (!it) {
                    collectCpuUsageAndPrivateMemoryViaSystemAPI = false;
                    return;
                }
                collectCpuUsageAndPrivateMemoryViaSystemAPI = true;
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lifetime, this, null){
                    int label;
                    final /* synthetic */ Lifetime $lifetime;
                    final /* synthetic */ ChartSession this$0;
                    {
                        this.$lifetime = $lifetime;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = LifetimeCoroutineUtilKt.lifetimedCoroutineScope((Lifetime)this.$lifetime, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ ChartSession this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.collectCpuUsageAndPrivateMemory(this.this$0.getPid(), (Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        exceptionSignalPromise.onSuccess(arg_0 -> ChartSession._init_$lambda$0((Function1)new Function1<IAsyncSignal<ExceptionEvent>, Unit>(){

            public final void invoke(IAsyncSignal<ExceptionEvent> it) {
                it.advise(lifetime, (Function1)new Function1<ExceptionEvent, Unit>((Object)this){

                    public final void invoke(@NotNull ExceptionEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ChartSession)this.receiver).onException(p0);
                    }
                });
            }
        }, arg_0));
        protocolSessionPromise.onSuccess(arg_0 -> ChartSession._init_$lambda$1((Function1)new Function1<ProtocolSession, Unit>(){

            public final void invoke(ProtocolSession protocolSession) {
                protocolSession.getOnMessageCheckDelay().advise(lifetime, (Function1)new Function1<MessageCheckDelay, Unit>((Object)this){

                    public final void invoke(@NotNull MessageCheckDelay p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ChartSession)this.receiver).onMessageCheckDelay(p0);
                    }
                });
                protocolSession.getOnHeapAllocation().advise(lifetime, (Function1)new Function1<HeapAllocation, Unit>((Object)this){

                    public final void invoke(@NotNull HeapAllocation p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ChartSession)this.receiver).onHeapAllocation(p0);
                    }
                });
                protocolSession.getOnHeapStat().advise(lifetime, (Function1)new Function1<HeapStat, Unit>((Object)this){

                    public final void invoke(@NotNull HeapStat p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ChartSession)this.receiver).onHeapStat(p0);
                    }
                });
                protocolSession.getOnGcEvent().advise(lifetime, (Function1)new Function1<GcEvent, Unit>((Object)this){

                    public final void invoke(@NotNull GcEvent p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((ChartSession)this.receiver).handleGcEvent(p0);
                    }
                });
                protocolSession.isFinished().advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(boolean isFinished) {
                        if (isFinished) {
                            void $this$forEach$iv;
                            logger.trace("DotNet session is finished");
                            Iterable iterable = this.getClrInstancesHeapData();
                            ChartSession chartSession = this;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                HeapData p0 = (HeapData)element$iv;
                                boolean bl = false;
                                chartSession.onFinishHeapData(p0);
                            }
                        }
                    }
                });
                final SequentialLifetimes isAttachedLifetimes = new SequentialLifetimes(lifetime);
                protocolSession.isAttached().advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

                    public final void invoke(boolean isAttached) {
                        if (isAttached) {
                            logger.trace("DotNet session bound");
                            this.isDotNetSession().setValue((Object)true);
                            LifetimeDefinition currentAttachLifetime = isAttachedLifetimes.next();
                            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentAttachLifetime, this, null){
                                int label;
                                final /* synthetic */ LifetimeDefinition $currentAttachLifetime;
                                final /* synthetic */ ChartSession this$0;
                                {
                                    this.$currentAttachLifetime = $currentAttachLifetime;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Exception decompiling
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                        } else {
                            logger.trace("DotNet session unbound");
                            this.isDotNetSession().setValue((Object)false);
                            isAttachedLifetimes.terminateCurrent();
                        }
                    }
                });
            }
        }, arg_0));
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final ISignal<Pair<ChartData, Boolean>> getOnChartEvent() {
        return this.onChartEvent;
    }

    @NotNull
    public final IProperty<Boolean> isDotNetSession() {
        return this.isDotNetSession;
    }

    @NotNull
    public final ISignal<Unit> getOnMessageCheckDelayEvent() {
        return this.onMessageCheckDelayEvent;
    }

    @NotNull
    public final List<BaseChartData> getCachedData() {
        return this.cachedData;
    }

    @NotNull
    public final LinkedList<GcEvent> getGcData() {
        return this.gcData;
    }

    @NotNull
    public final LinkedList<MessageCheckDelay> getMessageCheckDelayData() {
        return this.messageCheckDelayData;
    }

    @NotNull
    public final List<HeapData> getClrInstancesHeapData() {
        return this.clrInstancesHeapData;
    }

    @Nullable
    public final Integer getRaiseUpdateFromRequired() {
        return this.raiseUpdateFromRequired;
    }

    public final void setRaiseUpdateFromRequired(@Nullable Integer n) {
        this.raiseUpdateFromRequired = n;
    }

    public final int getShowCounterMemoryPanel() {
        return this.showCounterMemoryPanel;
    }

    public final void setShowCounterMemoryPanel(int n) {
        this.showCounterMemoryPanel = n;
    }

    public final int getShowCounterCpuPanel() {
        return this.showCounterCpuPanel;
    }

    public final void setShowCounterCpuPanel(int n) {
        this.showCounterCpuPanel = n;
    }

    public final boolean getCollectCpuUsageAndPrivateMemoryViaSystemAPI() {
        return this.collectCpuUsageAndPrivateMemoryViaSystemAPI;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object collectCpuUsageAndPrivateMemory(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof collectCpuUsageAndPrivateMemory.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ChartSession this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ChartSession.access$collectCpuUsageAndPrivateMemory(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var4_6 = new long[]{0L, 0L};
                    previousTimes = var4_6;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Throwable e) {
                    ChartSession.logger.warn(e);
                    return Unit.INSTANCE;
                }
lbl22:
                // 3 sources

                while (this.collectCpuUsageAndPrivateMemoryViaSystemAPI) {
                    timestamp = ZonedDateTime.now().toEpochSecond();
                    qpcTimestamp = ULong.constructor-impl((long)ProcessInfoApi.INSTANCE.getQpcTimestamp());
                    privateMemory = ProcessInfoApi.INSTANCE.getProcessPrivateMemory(pid);
                    cpuUsage = ProcessInfoApi.INSTANCE.getProcessCpuUsage(pid, previousTimes);
                    this.uiFlow.tryEmit((Object)new BaseChartData(timestamp, qpcTimestamp, cpuUsage, privateMemory, 0L, null));
                    $continuation.L$0 = this;
                    $continuation.L$1 = previousTimes;
                    $continuation.I$0 = pid;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                    if (v0 != var14_5) continue;
                    return var14_5;
                }
                return Unit.INSTANCE;
            }
            case 1: {
                pid = $continuation.I$0;
                previousTimes = (long[])$continuation.L$1;
                this = (ChartSession)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl22
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void fireChartEvent(ChartData chartData, boolean isUpdate) {
        this.onChartEvent.fire((Object)TuplesKt.to((Object)chartData, (Object)isUpdate));
    }

    private final void onMessageCheckDelay(MessageCheckDelay messageCheckDelay) {
        if (this.cachedData.size() != 0) {
            this.messageCheckDelayData.add(messageCheckDelay);
            InterfacesKt.fire(this.onMessageCheckDelayEvent);
        }
    }

    private final void onException(ExceptionEvent exception) {
        if (this.cachedData.size() != 0) {
            BaseChartData baseChartData;
            block3: {
                List<BaseChartData> list = this.cachedData;
                ListIterator<BaseChartData> listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    BaseChartData baseChartData2;
                    BaseChartData it = baseChartData2 = listIterator.previous();
                    boolean bl = false;
                    if (!(Long.compareUnsigned(it.getQpcTimeStamp-s-VKNKU(), exception.getQpcTimeStamp-s-VKNKU()) <= 0)) continue;
                    baseChartData = baseChartData2;
                    break block3;
                }
                baseChartData = null;
            }
            BaseChartData lastData = baseChartData;
            if (lastData != null) {
                lastData.setExceptionCount-VKZWuLQ(ULong.constructor-impl((long)(lastData.getExceptionCount-s-VKNKU() + exception.getCount-s-VKNKU())));
            }
        }
    }

    @NotNull
    public final ChartData getChartData(int index) {
        BaseChartData baseChartData = this.cachedData.get(index);
        ChartData data = new ChartData(baseChartData.getTimeStamp(), baseChartData.getQpcTimeStamp-s-VKNKU(), baseChartData.getCpuUsage(), baseChartData.getTotalMemory(), 0.0, 0.0, 0.0, 0.0, 0.0, baseChartData.getExceptionCount-s-VKNKU(), null);
        Iterable $this$forEach$iv = this.clrInstancesHeapData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapData heapData = (HeapData)element$iv;
            boolean bl = false;
            HeapChartData cachedData = heapData.getCachedData().get(index);
            data.setLoh(data.getLoh() + UnsignedKt.ulongToDouble((long)cachedData.getLoh-s-VKNKU()));
            data.setPoh(data.getPoh() + UnsignedKt.ulongToDouble((long)cachedData.getPoh-s-VKNKU()));
            data.setGen0(data.getGen0() + UnsignedKt.ulongToDouble((long)cachedData.getGen0-s-VKNKU()));
            data.setGen1(data.getGen1() + UnsignedKt.ulongToDouble((long)cachedData.getGen1-s-VKNKU()));
            data.setGen2(data.getGen2() + UnsignedKt.ulongToDouble((long)cachedData.getGen2-s-VKNKU()));
        }
        return data;
    }

    private final void fireChartEvent(int index, boolean isUpdate) {
        this.fireChartEvent(this.getChartData(index), isUpdate);
    }

    private final void tryUpdate() {
        Integer from = this.raiseUpdateFromRequired;
        if (from == null) {
            return;
        }
        int n = this.cachedData.size();
        for (int i = from.intValue(); i < n; ++i) {
            this.fireChartEvent(i, true);
        }
        this.raiseUpdateFromRequired = null;
    }

    private final HeapData getHeapData-xj2QHRw(short clrInstanceId) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this.clrInstancesHeapData;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeapData it = (HeapData)element$iv;
                boolean bl = false;
                if (!(it.getClrInstanceId-Mh2AYeg() == clrInstanceId)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        HeapData heapData = v0;
        if (heapData == null) {
            HeapChartData emptyHeapData = new HeapChartData(0L, 0L, 0L, 0L, 0L, null);
            int n = this.cachedData.size();
            ArrayList<HeapChartData> arrayList = new ArrayList<HeapChartData>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<HeapChartData> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(emptyHeapData);
            }
            List cachedData = arrayList;
            heapData = new HeapData(clrInstanceId, new HeapStat(0L, 0, 0L, 0L, 0L, 0L, 0L, null), cachedData, 0L, 0L, -1, null);
            this.clrInstancesHeapData.add(heapData);
        }
        return heapData;
    }

    private final void updateHeapData-2TYgG_w(HeapData heapData, long qpcTimestamp) {
        if (this.cachedData.size() == 0) {
            return;
        }
        if (heapData.getCurrentUpdateIndex() < 0) {
            heapData.setCurrentUpdateIndex(0);
        }
        while (heapData.getCurrentUpdateIndex() < this.cachedData.size() - 1 && Long.compareUnsigned(this.cachedData.get(heapData.getCurrentUpdateIndex()).getQpcTimeStamp-s-VKNKU(), qpcTimestamp) <= 0) {
            int n = heapData.getCurrentUpdateIndex();
            heapData.setCurrentUpdateIndex(n + 1);
        }
        Integer from = this.raiseUpdateFromRequired;
        if (from == null || from > heapData.getCurrentUpdateIndex()) {
            this.raiseUpdateFromRequired = heapData.getCurrentUpdateIndex();
        }
        HeapChartData currentHeapChartData = new HeapChartData(ULong.constructor-impl((long)(heapData.getLastHeapStat().getLohSize-s-VKNKU() + heapData.getHeapAllocationLoh-s-VKNKU())), heapData.getLastHeapStat().getPohSize-s-VKNKU(), heapData.getLastHeapStat().getGen2Size-s-VKNKU(), heapData.getLastHeapStat().getGen1Size-s-VKNKU(), ULong.constructor-impl((long)(heapData.getLastHeapStat().getGen0Size-s-VKNKU() + heapData.getHeapAllocationSoh-s-VKNKU())), null);
        int n = this.cachedData.size();
        for (int i = heapData.getCurrentUpdateIndex(); i < n; ++i) {
            heapData.getCachedData().set(i, currentHeapChartData);
        }
    }

    private final void onFinishHeapData(HeapData heapData) {
        if (this.cachedData.size() == 0) {
            return;
        }
        int n = heapData.getCurrentUpdateIndex();
        heapData.setCurrentUpdateIndex(n + 1);
        if (heapData.getCurrentUpdateIndex() < 0) {
            heapData.setCurrentUpdateIndex(0);
        }
        if (heapData.getCurrentUpdateIndex() == this.cachedData.size()) {
            heapData.setCurrentUpdateIndex(this.cachedData.size() - 1);
        }
        HeapChartData currentHeapChartData = new HeapChartData(0L, 0L, 0L, 0L, 0L, null);
        int n2 = this.cachedData.size();
        for (int i = heapData.getCurrentUpdateIndex(); i < n2; ++i) {
            heapData.getCachedData().set(i, currentHeapChartData);
        }
    }

    private final void onHeapStat(HeapStat heapStat) {
        HeapData heapData = this.getHeapData-xj2QHRw(heapStat.getClrInstanceId-Mh2AYeg());
        this.updateHeapData-2TYgG_w(heapData, heapStat.getQpcTimestamp-s-VKNKU());
        heapData.setLastHeapStat(heapStat);
        heapData.setHeapAllocationSoh-VKZWuLQ(0L);
        heapData.setHeapAllocationLoh-VKZWuLQ(0L);
    }

    private final void onHeapAllocation(HeapAllocation heapAllocation) {
        HeapData heapData = this.getHeapData-xj2QHRw(heapAllocation.getClrInstanceId-Mh2AYeg());
        if (Long.compareUnsigned(heapAllocation.getQpcTimestamp-s-VKNKU(), heapData.getLastHeapStat().getQpcTimestamp-s-VKNKU()) < 0) {
            return;
        }
        this.updateHeapData-2TYgG_w(heapData, heapAllocation.getQpcTimestamp-s-VKNKU());
        switch (WhenMappings.$EnumSwitchMapping$0[heapAllocation.getKind().ordinal()]) {
            case 1: {
                heapData.setHeapAllocationSoh-VKZWuLQ(ULong.constructor-impl((long)(heapData.getHeapAllocationSoh-s-VKNKU() + heapAllocation.getSize-s-VKNKU())));
                break;
            }
            case 2: {
                heapData.setHeapAllocationLoh-VKZWuLQ(ULong.constructor-impl((long)(heapData.getHeapAllocationLoh-s-VKNKU() + heapAllocation.getSize-s-VKNKU())));
            }
        }
    }

    private final void handleNativeCounters(BaseChartData chartData) {
        this.cachedData.add(chartData);
        Iterable $this$forEach$iv = this.clrInstancesHeapData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HeapData heapData = (HeapData)element$iv;
            boolean bl = false;
            List<HeapChartData> list = heapData.getCachedData();
            HeapChartData heapChartData = (HeapChartData)CollectionsKt.lastOrNull(heapData.getCachedData());
            if (heapChartData == null) {
                heapChartData = new HeapChartData(0L, 0L, 0L, 0L, 0L, null);
            }
            list.add(heapChartData);
        }
        while (this.cachedData.get(0).getTimeStamp() < chartData.getTimeStamp() - (long)60) {
            CollectionsKt.removeFirst(this.cachedData);
            $this$forEach$iv = this.clrInstancesHeapData;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HeapData it = (HeapData)element$iv;
                boolean bl = false;
                CollectionsKt.removeFirst(it.getCachedData());
                int n = it.getCurrentUpdateIndex();
                it.setCurrentUpdateIndex(n + -1);
            }
        }
        long firstTimestamp = this.cachedData.get(0).getQpcTimeStamp-s-VKNKU();
        while (!this.messageCheckDelayData.isEmpty() && Long.compareUnsigned(this.messageCheckDelayData.getFirst().getQpcTimestamp-s-VKNKU(), firstTimestamp) < 0) {
            this.messageCheckDelayData.removeFirst();
        }
        while (!this.gcData.isEmpty() && Long.compareUnsigned(this.gcData.getFirst().getQpcTimeStamp-s-VKNKU(), firstTimestamp) < 0) {
            this.gcData.removeFirst();
        }
        this.fireChartEvent(this.cachedData.size() - 1, false);
    }

    private final void handleGcEvent(GcEvent it) {
        if (this.gcData.isEmpty()) {
            this.gcData.add(it);
        } else if (Long.compareUnsigned(this.gcData.getLast().getQpcTimeStamp-s-VKNKU(), it.getQpcTimeStamp-s-VKNKU()) < 0) {
            this.gcData.add(it);
        } else {
            int idx = 0;
            Iterator<GcEvent> iterator = this.gcData.descendingIterator();
            while (iterator.hasNext() && Long.compareUnsigned(iterator.next().getQpcTimeStamp-s-VKNKU(), it.getQpcTimeStamp-s-VKNKU()) >= 0) {
                ++idx;
            }
            this.gcData.add(this.gcData.size() - idx, it);
        }
    }

    private static final void _init_$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$tryUpdate(ChartSession $this) {
        $this.tryUpdate();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChartSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChartSession.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010#\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010\u0012J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u0016\u0010'\u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010\u0019J\u0016\u0010)\u001a\u00020\nH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b*\u0010\u0019J\t\u0010+\u001a\u00020\rH\u00c6\u0003JU\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b-\u0010.J\u0013\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00102\u001a\u00020\rH\u00d6\u0001J\t\u00103\u001a\u000204H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\t\u001a\u00020\nX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00065"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$HeapData;", "", "clrInstanceId", "Lkotlin/UShort;", "lastHeapStat", "Lcom/jetbrains/rider/model/HeapStat;", "cachedData", "", "Lcom/jetbrains/dpa/monitoring/sessions/HeapChartData;", "heapAllocationLoh", "Lkotlin/ULong;", "heapAllocationSoh", "currentUpdateIndex", "", "(SLcom/jetbrains/rider/model/HeapStat;Ljava/util/List;JJILkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCachedData", "()Ljava/util/List;", "getClrInstanceId-Mh2AYeg", "()S", "S", "getCurrentUpdateIndex", "()I", "setCurrentUpdateIndex", "(I)V", "getHeapAllocationLoh-s-VKNKU", "()J", "setHeapAllocationLoh-VKZWuLQ", "(J)V", "J", "getHeapAllocationSoh-s-VKNKU", "setHeapAllocationSoh-VKZWuLQ", "getLastHeapStat", "()Lcom/jetbrains/rider/model/HeapStat;", "setLastHeapStat", "(Lcom/jetbrains/rider/model/HeapStat;)V", "component1", "component1-Mh2AYeg", "component2", "component3", "component4", "component4-s-VKNKU", "component5", "component5-s-VKNKU", "component6", "copy", "copy-s6RrwnQ", "(SLcom/jetbrains/rider/model/HeapStat;Ljava/util/List;JJI)Lcom/jetbrains/dpa/monitoring/sessions/ChartSession$HeapData;", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.dpa"})
    public static final class HeapData {
        private final short clrInstanceId;
        @NotNull
        private HeapStat lastHeapStat;
        @NotNull
        private final List<HeapChartData> cachedData;
        private long heapAllocationLoh;
        private long heapAllocationSoh;
        private int currentUpdateIndex;

        private HeapData(short clrInstanceId, HeapStat lastHeapStat, List<HeapChartData> cachedData, long heapAllocationLoh, long heapAllocationSoh, int currentUpdateIndex) {
            Intrinsics.checkNotNullParameter((Object)lastHeapStat, (String)"lastHeapStat");
            Intrinsics.checkNotNullParameter(cachedData, (String)"cachedData");
            this.clrInstanceId = clrInstanceId;
            this.lastHeapStat = lastHeapStat;
            this.cachedData = cachedData;
            this.heapAllocationLoh = heapAllocationLoh;
            this.heapAllocationSoh = heapAllocationSoh;
            this.currentUpdateIndex = currentUpdateIndex;
        }

        public final short getClrInstanceId-Mh2AYeg() {
            return this.clrInstanceId;
        }

        @NotNull
        public final HeapStat getLastHeapStat() {
            return this.lastHeapStat;
        }

        public final void setLastHeapStat(@NotNull HeapStat heapStat) {
            Intrinsics.checkNotNullParameter((Object)heapStat, (String)"<set-?>");
            this.lastHeapStat = heapStat;
        }

        @NotNull
        public final List<HeapChartData> getCachedData() {
            return this.cachedData;
        }

        public final long getHeapAllocationLoh-s-VKNKU() {
            return this.heapAllocationLoh;
        }

        public final void setHeapAllocationLoh-VKZWuLQ(long l) {
            this.heapAllocationLoh = l;
        }

        public final long getHeapAllocationSoh-s-VKNKU() {
            return this.heapAllocationSoh;
        }

        public final void setHeapAllocationSoh-VKZWuLQ(long l) {
            this.heapAllocationSoh = l;
        }

        public final int getCurrentUpdateIndex() {
            return this.currentUpdateIndex;
        }

        public final void setCurrentUpdateIndex(int n) {
            this.currentUpdateIndex = n;
        }

        public final short component1-Mh2AYeg() {
            return this.clrInstanceId;
        }

        @NotNull
        public final HeapStat component2() {
            return this.lastHeapStat;
        }

        @NotNull
        public final List<HeapChartData> component3() {
            return this.cachedData;
        }

        public final long component4-s-VKNKU() {
            return this.heapAllocationLoh;
        }

        public final long component5-s-VKNKU() {
            return this.heapAllocationSoh;
        }

        public final int component6() {
            return this.currentUpdateIndex;
        }

        @NotNull
        public final HeapData copy-s6RrwnQ(short clrInstanceId, @NotNull HeapStat lastHeapStat, @NotNull List<HeapChartData> cachedData, long heapAllocationLoh, long heapAllocationSoh, int currentUpdateIndex) {
            Intrinsics.checkNotNullParameter((Object)lastHeapStat, (String)"lastHeapStat");
            Intrinsics.checkNotNullParameter(cachedData, (String)"cachedData");
            return new HeapData(clrInstanceId, lastHeapStat, cachedData, heapAllocationLoh, heapAllocationSoh, currentUpdateIndex, null);
        }

        public static /* synthetic */ HeapData copy-s6RrwnQ$default(HeapData heapData, short s, HeapStat heapStat, List list, long l, long l2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                s = heapData.clrInstanceId;
            }
            if ((n2 & 2) != 0) {
                heapStat = heapData.lastHeapStat;
            }
            if ((n2 & 4) != 0) {
                list = heapData.cachedData;
            }
            if ((n2 & 8) != 0) {
                l = heapData.heapAllocationLoh;
            }
            if ((n2 & 0x10) != 0) {
                l2 = heapData.heapAllocationSoh;
            }
            if ((n2 & 0x20) != 0) {
                n = heapData.currentUpdateIndex;
            }
            return heapData.copy-s6RrwnQ(s, heapStat, list, l, l2, n);
        }

        @NotNull
        public String toString() {
            return "HeapData(clrInstanceId=" + UShort.toString-impl((short)this.clrInstanceId) + ", lastHeapStat=" + this.lastHeapStat + ", cachedData=" + this.cachedData + ", heapAllocationLoh=" + ULong.toString-impl((long)this.heapAllocationLoh) + ", heapAllocationSoh=" + ULong.toString-impl((long)this.heapAllocationSoh) + ", currentUpdateIndex=" + this.currentUpdateIndex + ")";
        }

        public int hashCode() {
            int result = UShort.hashCode-impl((short)this.clrInstanceId);
            result = result * 31 + this.lastHeapStat.hashCode();
            result = result * 31 + ((Object)this.cachedData).hashCode();
            result = result * 31 + ULong.hashCode-impl((long)this.heapAllocationLoh);
            result = result * 31 + ULong.hashCode-impl((long)this.heapAllocationSoh);
            result = result * 31 + Integer.hashCode(this.currentUpdateIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeapData)) {
                return false;
            }
            HeapData heapData = (HeapData)other;
            if (this.clrInstanceId != heapData.clrInstanceId) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lastHeapStat, (Object)heapData.lastHeapStat)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cachedData, heapData.cachedData)) {
                return false;
            }
            if (this.heapAllocationLoh != heapData.heapAllocationLoh) {
                return false;
            }
            if (this.heapAllocationSoh != heapData.heapAllocationSoh) {
                return false;
            }
            return this.currentUpdateIndex == heapData.currentUpdateIndex;
        }

        public /* synthetic */ HeapData(short clrInstanceId, HeapStat lastHeapStat, List cachedData, long heapAllocationLoh, long heapAllocationSoh, int currentUpdateIndex, DefaultConstructorMarker $constructor_marker) {
            this(clrInstanceId, lastHeapStat, cachedData, heapAllocationLoh, heapAllocationSoh, currentUpdateIndex);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AllocationKind.values().length];
            try {
                nArray[AllocationKind.Soh.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AllocationKind.Loh.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

