/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.services;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactoryKt;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IProperty;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/services/ToolWindowActivationService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "Companion", "intellij.rider.plugins.dpa"})
public final class ToolWindowActivationService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ToolWindowActivationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        IProperty<Session> activeSession = SessionsController.Companion.getInstance(this.project).getActiveSession();
        final SequentialLifetimes bindLifetimes = new SequentialLifetimes(this.getServiceLifetime());
        activeSession.advise(this.getServiceLifetime(), (Function1)new Function1<Session, Unit>(){

            public final void invoke(@Nullable Session it) {
                if (it != null) {
                    Lifetime lifetime = bindLifetimes.next().getLifetime();
                    MonitoringToolWindowFactoryKt.showMonitoringToolWindow(project, it, lifetime);
                } else {
                    MonitoringToolWindowFactoryKt.hideMonitoringToolWindow(project);
                    bindLifetimes.terminateCurrent();
                }
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dpa/monitoring/services/ToolWindowActivationService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/dpa/monitoring/services/ToolWindowActivationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nToolWindowActivationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowActivationService.kt\ncom/jetbrains/dpa/monitoring/services/ToolWindowActivationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,31:1\n31#2,2:32\n*S KotlinDebug\n*F\n+ 1 ToolWindowActivationService.kt\ncom/jetbrains/dpa/monitoring/services/ToolWindowActivationService$Companion\n*L\n14#1:32,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolWindowActivationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ToolWindowActivationService> serviceClass$iv = ToolWindowActivationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ToolWindowActivationService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

