/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.listeners;

import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactory;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactoryKt;
import com.jetbrains.dpa.monitoring.MonitoringUsagesCollector;
import com.jetbrains.dpa.monitoring.listeners.MonitoringToolWindowManagerListener;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "activeProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "lastReportedTab", "Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$ContentType;", "getProject", "()Lcom/intellij/openapi/project/Project;", "onExecutionFinished", "", "processHandler", "stateChanged", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "changeType", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener$ToolWindowManagerEventType;", "tryFinishPreviousExecution", "content", "Lcom/intellij/ui/content/Content;", "currentProcessHandler", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringToolWindowManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringToolWindowManagerListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n13#2:138\n13#3:139\n*S KotlinDebug\n*F\n+ 1 MonitoringToolWindowManagerListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener\n*L\n26#1:138\n26#1:139\n*E\n"})
public final class MonitoringToolWindowManagerListener
implements ToolWindowManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ProcessHandler activeProcessHandler;
    @Nullable
    private MonitoringToolWindowFactory.ContentType lastReportedTab;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<ProcessHandler> PREVIOUS_PROCESS_HANDLER_KEY;
    @NotNull
    public static final String RUN_TOOLWINDOW_ID = "Run";
    @NotNull
    public static final String DEBUG_TOOLWINDOW_ID = "Debug";

    public MonitoringToolWindowManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void onExecutionFinished(ProcessHandler processHandler) {
        logger.trace("onExecutionFinished processHandler:" + processHandler);
        SessionsController.Companion.getInstance(this.project).deleteSession(processHandler);
    }

    private final void tryFinishPreviousExecution(Content content2, ProcessHandler currentProcessHandler) {
        ProcessHandler previousProcessHandler = (ProcessHandler)content2.getUserData(PREVIOUS_PROCESS_HANDLER_KEY);
        if (previousProcessHandler != null && !Intrinsics.areEqual((Object)previousProcessHandler, (Object)currentProcessHandler)) {
            this.onExecutionFinished(previousProcessHandler);
        }
        if (!Intrinsics.areEqual((Object)previousProcessHandler, (Object)currentProcessHandler)) {
            logger.trace("checkExecutionIdFinished new processHandler:" + currentProcessHandler);
            content2.putUserData(PREVIOUS_PROCESS_HANDLER_KEY, (Object)currentProcessHandler);
        }
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindow toolWindow, @NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
        if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Monitoring")) {
            if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow) {
                Object object = toolWindow.getContentManager().getSelectedContent();
                if (object != null && (object = (MonitoringToolWindowFactory.ContentType)((Object)object.getUserData(MonitoringToolWindowFactoryKt.getCONTENT_TYPE_KEY()))) != null) {
                    Object it = object;
                    boolean bl = false;
                    if (this.lastReportedTab != it) {
                        MonitoringUsagesCollector.TAB_ACTIVATED.log(it);
                        this.lastReportedTab = it;
                    }
                }
            }
        } else if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Services")) {
            if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow) {
                logger.trace("Toolwindow activated " + toolWindow.getId());
                Content content2 = RunDashboardManager.getInstance((Project)this.project).getDashboardContentManager().getSelectedContent();
                if (content2 == null || (content2 = (RunContentDescriptor)content2.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) == null || (content2 = content2.getProcessHandler()) == null) {
                    return;
                }
                Content processHandler = content2;
                this.activeProcessHandler = processHandler;
                logger.trace("processHandler:" + (ProcessHandler)processHandler);
                SessionsController.Companion.getInstance(this.project).activateSession((ProcessHandler)processHandler);
            } else if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow) {
                logger.trace("service tool window RegisterToolWindow");
                RunDashboardManager.getInstance((Project)this.project).getDashboardContentManager().addContentManagerListener(new ContentManagerListener(this){
                    final /* synthetic */ MonitoringToolWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("RunDashboardManager contentRemoved event:" + event.getOperation());
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                        MonitoringToolWindowManagerListener.access$onExecutionFinished(this.this$0, (ProcessHandler)processHandler);
                    }

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("RunDashboardManager selectionChanged event:" + event.getOperation());
                        ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                        switch (contentOperation == null ? -1 : stateChanged.WhenMappings.$EnumSwitchMapping$0[contentOperation.ordinal()]) {
                            case 1: {
                                RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                                if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                                    return;
                                }
                                RunContentDescriptor processHandler = runContentDescriptor;
                                MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                                SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession((ProcessHandler)processHandler);
                                Content content2 = event.getContent();
                                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                                MonitoringToolWindowManagerListener.access$tryFinishPreviousExecution(this.this$0, content2, (ProcessHandler)processHandler);
                                break;
                            }
                            case 2: {
                                RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                                if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                                    return;
                                }
                                RunContentDescriptor processHandler = runContentDescriptor;
                                MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                                SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession(null);
                                break;
                            }
                            case 3: {
                                throw new Error("unknown operation: " + event.getOperation());
                            }
                        }
                    }
                });
            }
        } else if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)RUN_TOOLWINDOW_ID) || Intrinsics.areEqual((Object)toolWindow.getId(), (Object)DEBUG_TOOLWINDOW_ID)) {
            if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow) {
                Content content3 = toolWindow.getContentManager().getSelectedContent();
                if (content3 == null || (content3 = (RunContentDescriptor)content3.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) == null || (content3 = content3.getProcessHandler()) == null) {
                    return;
                }
                Content processHandler = content3;
                this.activeProcessHandler = processHandler;
                logger.trace("Toolwindow activated " + toolWindow + ".id processHandler:" + (ProcessHandler)processHandler);
                SessionsController.Companion.getInstance(this.project).activateSession((ProcessHandler)processHandler);
            } else if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow) {
                toolWindow.getContentManager().addContentManagerListener(new ContentManagerListener(this){
                    final /* synthetic */ MonitoringToolWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void contentRemoved(@NotNull ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("debug contentRemoved processHandler:" + (ProcessHandler)processHandler);
                        MonitoringToolWindowManagerListener.access$onExecutionFinished(this.this$0, (ProcessHandler)processHandler);
                    }

                    public void selectionChanged(@NotNull ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                            return;
                        }
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession((ProcessHandler)processHandler);
                        Content content2 = event.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"getContent(...)");
                        MonitoringToolWindowManagerListener.access$tryFinishPreviousExecution(this.this$0, content2, (ProcessHandler)processHandler);
                    }
                });
            }
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$onExecutionFinished(MonitoringToolWindowManagerListener $this, ProcessHandler processHandler) {
        $this.onExecutionFinished(processHandler);
    }

    public static final /* synthetic */ void access$tryFinishPreviousExecution(MonitoringToolWindowManagerListener $this, Content content2, ProcessHandler currentProcessHandler) {
        $this.tryFinishPreviousExecution(content2, currentProcessHandler);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringToolWindowManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringToolWindowManagerListener.logger = logger;
        Key key = Key.create((String)"PreviousProcessHandler");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREVIOUS_PROCESS_HANDLER_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener$Companion;", "", "()V", "DEBUG_TOOLWINDOW_ID", "", "PREVIOUS_PROCESS_HANDLER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/process/ProcessHandler;", "getPREVIOUS_PROCESS_HANDLER_KEY", "()Lcom/intellij/openapi/util/Key;", "RUN_TOOLWINDOW_ID", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ProcessHandler> getPREVIOUS_PROCESS_HANDLER_KEY() {
            return PREVIOUS_PROCESS_HANDLER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

