/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.listeners;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.dpa.DpaSessions;
import com.jetbrains.dpa.monitoring.listeners.MonitoringProcessTerminationListener;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.cpp.debugger.RiderCppDebugRunner;
import com.jetbrains.rider.cpp.debugger.RiderCppLocalDebugProcess;
import com.jetbrains.rider.cpp.run.RiderCppRunner;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.DotNetDebugRunner;
import com.jetbrains.rider.debugger.DotNetProgramRunner;
import com.jetbrains.rider.debugger.multiPlatform.mac.runners.MacDebugRunner;
import com.jetbrains.rider.debugger.multiPlatform.mac.runners.MacProgramRunner;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.configurations.unity.UnityAttachRunConfiguration;
import com.jetbrains.rider.run.uwp.UwpProgramRunner;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\u0014\u001a\u00020\u000e*\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "handleStartViaDpaRunner", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "isRunnerAllowed", "", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "processStarted", "executorId", "", "isRunViaDpaRunner", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringExecutionListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,163:1\n13#2:164\n13#3:165\n*S KotlinDebug\n*F\n+ 1 MonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringExecutionListener\n*L\n39#1:164\n39#1:165\n*E\n"})
public final class MonitoringExecutionListener
implements ExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String DEBUG_EXECUTOR_ID = "Debug";
    @NotNull
    private static final String RUN_EXECUTOR_ID = "Run";
    @NotNull
    public static final String RIDER_CPP_PLUGIN_NAME = "com.jetbrains.rider-cpp";
    @NotNull
    public static final String RESHARPER_UNITY_PLUGIN_NAME = "com.intellij.resharper.unity";

    public MonitoringExecutionListener(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRunnerAllowed(ProgramRunner<?> runner) {
        if (runner instanceof DotNetProgramRunner) return true;
        if (runner instanceof DotNetDebugRunner) return true;
        if (runner instanceof UwpProgramRunner) return true;
        if (runner instanceof MacProgramRunner) return true;
        if (runner instanceof MacDebugRunner) return true;
        PluginId pluginId = PluginId.getId((String)RIDER_CPP_PLUGIN_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        if (!Companion.isPluginInstalledAndEnabled(pluginId)) return false;
        if (runner instanceof RiderCppRunner) return true;
        if (!(runner instanceof RiderCppDebugRunner)) return false;
        return true;
    }

    private final boolean isRunViaDpaRunner(ProcessHandler $this$isRunViaDpaRunner) {
        String string;
        ProcessHandler processHandler = $this$isRunViaDpaRunner;
        if (processHandler instanceof BaseOSProcessHandler) {
            string = ((BaseOSProcessHandler)$this$isRunViaDpaRunner).getCommandLine();
        } else if (processHandler instanceof ExternalConsoleProcessHandler) {
            string = ((ExternalConsoleProcessHandler)$this$isRunViaDpaRunner).getCommandLineString();
        } else {
            throw new IllegalArgumentException("Unsupported process handler type: " + $this$isRunViaDpaRunner.getClass().getName());
        }
        String commandLine = string;
        Intrinsics.checkNotNull((Object)commandLine);
        return StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"JetBrains.DPA.Runner.exe", (boolean)false, (int)2, null);
    }

    private final void handleStartViaDpaRunner(ExecutionEnvironment env, ProcessHandler processHandler) {
        logger.trace("JetBrains.DPA.Runner found");
        ProtocolSession dpaSession = DpaSessions.Companion.getInstance(this.project).tryGetSession(processHandler);
        if (dpaSession != null) {
            logger.trace("dpa session found");
            Integer pid = (Integer)dpaSession.getPid().getValue();
            if (pid != null) {
                logger.trace("pid:" + pid + " mapped for processHandler:" + processHandler);
                SessionsController.Companion.getInstance(this.project).startSession(processHandler, pid, Session.Mode.Run);
            } else {
                SourceExKt.adviseUntil((ISource)((ISource)dpaSession.getPid()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), (Function1)((Function1)new Function1<Integer, Boolean>(this, processHandler){
                    final /* synthetic */ MonitoringExecutionListener this$0;
                    final /* synthetic */ ProcessHandler $processHandler;
                    {
                        this.this$0 = $receiver;
                        this.$processHandler = $processHandler;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@Nullable Integer pid) {
                        if (pid != null) {
                            BuildersKt.launch$default((CoroutineScope)MonitoringExecutionListener.access$getCoroutineScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pid, this.$processHandler, this.this$0, null){
                                int label;
                                final /* synthetic */ Integer $pid;
                                final /* synthetic */ ProcessHandler $processHandler;
                                final /* synthetic */ MonitoringExecutionListener this$0;
                                {
                                    this.$pid = $pid;
                                    this.$processHandler = $processHandler;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            MonitoringExecutionListener.access$getLogger$cp().trace("pid:" + this.$pid + " mapped for processHandler:" + this.$processHandler);
                                            SessionsController.Companion.getInstance(MonitoringExecutionListener.access$getProject$p(this.this$0)).startSession(this.$processHandler, this.$pid, Session.Mode.Run);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                        }
                        return pid != null;
                    }
                }));
            }
        }
    }

    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (processHandler.isProcessTerminating() || processHandler.isProcessTerminated()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)executorId, (Object)DEBUG_EXECUTOR_ID) && !Intrinsics.areEqual((Object)executorId, (Object)RUN_EXECUTOR_ID)) {
            return;
        }
        ProgramRunner programRunner = env.getRunner();
        Intrinsics.checkNotNullExpressionValue((Object)programRunner, (String)"getRunner(...)");
        if (!this.isRunnerAllowed(programRunner)) {
            return;
        }
        logger.trace("processStarted with executorId:" + executorId);
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 instanceof BaseOSProcessHandler ? true : processHandler2 instanceof ExternalConsoleProcessHandler) {
            if (this.isRunViaDpaRunner(processHandler)) {
                logger.trace("run via JetBrains.DPA.Runner");
                this.handleStartViaDpaRunner(env, processHandler);
            } else {
                logger.trace("normal run");
                SessionsController sessionsController = SessionsController.Companion.getInstance(this.project);
                Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
                Intrinsics.checkNotNull((Object)n);
                sessionsController.startSession(processHandler, n, Session.Mode.Run);
            }
        } else if (processHandler2 instanceof DebuggerWorkerProcessHandler) {
            Integer unityEditorPid;
            PluginId pluginId = PluginId.getId((String)RESHARPER_UNITY_PLUGIN_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            if (Companion.isPluginInstalledAndEnabled(pluginId)) {
                RunProfile runProfile = env.getRunProfile();
                UnityAttachRunConfiguration unityAttachRunConfiguration = runProfile instanceof UnityAttachRunConfiguration ? (UnityAttachRunConfiguration)runProfile : null;
                v5 = unityAttachRunConfiguration != null ? unityAttachRunConfiguration.getUnityEditorPid() : null;
            } else {
                v5 = unityEditorPid = null;
            }
            if (unityEditorPid != null) {
                SessionsController.Companion.getInstance(this.project).startSession(processHandler, unityEditorPid, Session.Mode.Debug);
            } else {
                ((DebuggerWorkerProcessHandler)processHandler).getWorkerModel().getActiveSession().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), (Function1)new Function1<DotNetDebuggerSessionModel, Unit>(env, this, processHandler){
                    final /* synthetic */ ExecutionEnvironment $env;
                    final /* synthetic */ MonitoringExecutionListener this$0;
                    final /* synthetic */ ProcessHandler $processHandler;
                    {
                        this.$env = $env;
                        this.this$0 = $receiver;
                        this.$processHandler = $processHandler;
                        super(1);
                    }

                    public final void invoke(@Nullable DotNetDebuggerSessionModel it) {
                        if (it == null) {
                            return;
                        }
                        MonitoringExecutionListener.access$getLogger$cp().trace("debug workerModel has active session");
                        SourceExKt.adviseOnce((ISource)it.getTargetReady(), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.$env)), (Function1)((Function1)new Function1<DebuggerSessionInfo, Unit>(this.this$0, this.$processHandler){
                            final /* synthetic */ MonitoringExecutionListener this$0;
                            final /* synthetic */ ProcessHandler $processHandler;
                            {
                                this.this$0 = $receiver;
                                this.$processHandler = $processHandler;
                                super(1);
                            }

                            public final void invoke(@NotNull DebuggerSessionInfo debuggerSessionInfo) {
                                Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"debuggerSessionInfo");
                                MonitoringExecutionListener.access$getLogger$cp().trace("debug workerModel targetReady");
                                if (debuggerSessionInfo.getProcessId() == -1) {
                                    MonitoringExecutionListener.access$getLogger$cp().trace("invalid pid=" + debuggerSessionInfo.getProcessId() + " received from debug workerModel, can't run monitoring");
                                    return;
                                }
                                SessionsController.Companion.getInstance(MonitoringExecutionListener.access$getProject$p(this.this$0)).startSession(this.$processHandler, debuggerSessionInfo.getProcessId(), Session.Mode.Debug);
                            }
                        }));
                    }
                });
            }
        } else {
            PluginId pluginId = PluginId.getId((String)RIDER_CPP_PLUGIN_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
            if (!Companion.isPluginInstalledAndEnabled(pluginId)) {
                return;
            }
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.project).getCurrentSession();
            if (xDebugSession == null || (xDebugSession = xDebugSession.getDebugProcess()) == null) {
                return;
            }
            XDebugSession debugProcess = xDebugSession;
            if (debugProcess instanceof RiderCppLocalDebugProcess) {
                SourceExKt.adviseOnce((ISource)((ISource)((RiderCppLocalDebugProcess)debugProcess).getProcessId()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), (Function1)((Function1)new Function1<Long, Unit>(this, processHandler){
                    final /* synthetic */ MonitoringExecutionListener this$0;
                    final /* synthetic */ ProcessHandler $processHandler;
                    {
                        this.this$0 = $receiver;
                        this.$processHandler = $processHandler;
                        super(1);
                    }

                    public final void invoke(long it) {
                        MonitoringExecutionListener.access$getLogger$cp().trace("debugProcess processId " + it);
                        BuildersKt.launch$default((CoroutineScope)MonitoringExecutionListener.access$getCoroutineScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$processHandler, it, null){
                            int label;
                            final /* synthetic */ MonitoringExecutionListener this$0;
                            final /* synthetic */ ProcessHandler $processHandler;
                            final /* synthetic */ long $it;
                            {
                                this.this$0 = $receiver;
                                this.$processHandler = $processHandler;
                                this.$it = $it;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        SessionsController.Companion.getInstance(MonitoringExecutionListener.access$getProject$p(this.this$0)).startSession(this.$processHandler, (int)this.$it, Session.Mode.Debug);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }));
            } else {
                return;
            }
        }
        processHandler.addProcessListener((ProcessListener)new MonitoringProcessTerminationListener(this.project, this.coroutineScope), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null));
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(MonitoringExecutionListener $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(MonitoringExecutionListener $this) {
        return $this.project;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringExecutionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringExecutionListener.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringExecutionListener$Companion;", "", "()V", "DEBUG_EXECUTOR_ID", "", "RESHARPER_UNITY_PLUGIN_NAME", "RIDER_CPP_PLUGIN_NAME", "RUN_EXECUTOR_ID", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isPluginInstalledAndEnabled", "", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isPluginInstalledAndEnabled(@NotNull PluginId pluginId) {
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            return PluginManager.isPluginInstalled((PluginId)pluginId) && !PluginManagerCore.isDisabled((PluginId)pluginId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

