/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.DpaMonitoringSettings;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactory;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactoryKt;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.dpa.monitoring.view.CounterPanel;
import com.jetbrains.dpa.monitoring.view.SessionToolWindowPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.model.Counter;
import icons.RiderIcons;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aY\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u00102\u0006\u0010\u0015\u001a\u00020\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u001e\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a \u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u001e*\u00020 H\u0002\u001a\n\u0010!\u001a\u00020\t*\u00020 \u001a\u001a\u0010\"\u001a\u00020\t*\u00020 2\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0007\"D\u0010\u0000\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\u0006\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0004\u0012\b\b\u0005\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"CONTENT_BINDABLE_KEY", "Lcom/intellij/openapi/util/Key;", "Lkotlin/Function2;", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "Lkotlin/ParameterName;", "name", "session", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime", "", "CONTENT_TYPE_KEY", "Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$ContentType;", "getCONTENT_TYPE_KEY", "()Lcom/intellij/openapi/util/Key;", "createContent", "Lcom/intellij/ui/content/Content;", "PanelType", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "contentFactory", "Lcom/intellij/ui/content/ContentFactory;", "panel", "contentType", "displayName", "", "bindFn", "Lkotlin/Function3;", "(Lcom/intellij/ui/content/ContentFactory;Lcom/intellij/util/ui/components/BorderLayoutPanel;Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$ContentType;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)Lcom/intellij/ui/content/Content;", "setIconIndicator", "bindingLifetime", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "getMonitoringToolWindow", "Lcom/intellij/openapi/project/Project;", "hideMonitoringToolWindow", "showMonitoringToolWindow", "intellij.rider.plugins.dpa"})
public final class MonitoringToolWindowFactoryKt {
    @NotNull
    private static final Key<MonitoringToolWindowFactory.ContentType> CONTENT_TYPE_KEY;
    @NotNull
    private static final Key<Function2<Session, Lifetime, Unit>> CONTENT_BINDABLE_KEY;

    @NotNull
    public static final Key<MonitoringToolWindowFactory.ContentType> getCONTENT_TYPE_KEY() {
        return CONTENT_TYPE_KEY;
    }

    private static final <PanelType extends BorderLayoutPanel> Content createContent(ContentFactory contentFactory, PanelType panel, MonitoringToolWindowFactory.ContentType contentType, @NlsSafe String displayName, Function3<? super PanelType, ? super Session, ? super Lifetime, Unit> bindFn) {
        Content content2;
        SessionToolWindowPanel sessionPanel = new SessionToolWindowPanel((JComponent)panel);
        Content content3 = contentFactory.createContent((JComponent)((Object)sessionPanel), displayName, false);
        Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"createContent(...)");
        Content $this$createContent_u24lambda_u240 = content2 = content3;
        boolean bl = false;
        $this$createContent_u24lambda_u240.setCloseable(false);
        $this$createContent_u24lambda_u240.putUserData(CONTENT_TYPE_KEY, (Object)contentType);
        $this$createContent_u24lambda_u240.putUserData(CONTENT_BINDABLE_KEY, (Object)new Function2<Session, Lifetime, Unit>(sessionPanel, bindFn, panel){
            final /* synthetic */ SessionToolWindowPanel $sessionPanel;
            final /* synthetic */ Function3<PanelType, Session, Lifetime, Unit> $bindFn;
            final /* synthetic */ PanelType $panel;
            {
                this.$sessionPanel = $sessionPanel;
                this.$bindFn = $bindFn;
                this.$panel = $panel;
                super(2);
            }

            public final void invoke(@NotNull Session session, @NotNull Lifetime lifetime) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                this.$sessionPanel.bind(session, lifetime);
                this.$bindFn.invoke(this.$panel, (Object)session, (Object)lifetime);
            }
        });
        return content2;
    }

    private static final ToolWindow getMonitoringToolWindow(Project $this$getMonitoringToolWindow) {
        return ToolWindowManager.Companion.getInstance($this$getMonitoringToolWindow).getToolWindow("Monitoring");
    }

    private static final void setIconIndicator(Session session, Lifetime bindingLifetime, ToolWindow toolWindow) {
        session.isRunning().advise(bindingLifetime, (Function1)new Function1<Boolean, Unit>(toolWindow){
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.$toolWindow = $toolWindow;
                super(1);
            }

            public final void invoke(boolean isRunning2) {
                Icon icon;
                if (isRunning2) {
                    if (ExperimentalUI.Companion.isNewUI()) {
                        IconManager iconManager = IconManager.Companion.getInstance();
                        Icon icon2 = RiderIcons.Toolwindows.ToolWindowMonitoring;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolWindowMonitoring");
                        Color color = JBUI.CurrentTheme.IconBadge.SUCCESS;
                        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"SUCCESS");
                        icon = iconManager.withIconBadge(icon2, (Paint)color);
                    } else {
                        Icon icon3 = ExecutionUtil.getLiveIndicator((Icon)RiderIcons.Toolwindows.ToolWindowMonitoring);
                        icon = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getLiveIndicator(...)");
                    }
                } else {
                    Icon icon4 = RiderIcons.Toolwindows.ToolWindowMonitoring;
                    icon = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"ToolWindowMonitoring");
                }
                Icon icon5 = icon;
                this.$toolWindow.setIcon(icon5);
            }
        });
    }

    public static final void showMonitoringToolWindow(@NotNull Project $this$showMonitoringToolWindow, @NotNull Session session, @NotNull Lifetime bindingLifetime) {
        Intrinsics.checkNotNullParameter((Object)$this$showMonitoringToolWindow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)bindingLifetime, (String)"bindingLifetime");
        ToolWindow toolWindow = MonitoringToolWindowFactoryKt.getMonitoringToolWindow($this$showMonitoringToolWindow);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        MonitoringToolWindowFactory.Companion.getLogger().trace("show session for pid: " + session.getPid());
        MonitoringToolWindowFactoryKt.setIconIndicator(session, bindingLifetime, toolWindow2);
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content[] contentArray = toolWindow2.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        for (Content content2 : contentArray) {
            Function2 function2 = (Function2)content2.getUserData(CONTENT_BINDABLE_KEY);
            if (function2 == null) continue;
            function2.invoke((Object)session, (Object)bindingLifetime);
        }
        Intrinsics.checkNotNull((Object)contentFactory);
        Content countersContent2 = MonitoringToolWindowFactoryKt.createContent(contentFactory, (BorderLayoutPanel)new CounterPanel(), MonitoringToolWindowFactory.ContentType.Counters, MonitoringToolBundle.Companion.message("toolwindow.tab.counters", new Object[0]), showMonitoringToolWindow.countersContent.1.INSTANCE);
        LifetimeDefinition countersActivationLifetime = bindingLifetime.createNested();
        session.getCounterSession().getOnCounter().advise((Lifetime)countersActivationLifetime, (Function1)new Function1<Counter, Unit>(countersActivationLifetime, bindingLifetime, contentManager2, countersContent2, session){
            final /* synthetic */ LifetimeDefinition $countersActivationLifetime;
            final /* synthetic */ Lifetime $bindingLifetime;
            final /* synthetic */ ContentManager $contentManager;
            final /* synthetic */ Content $countersContent;
            final /* synthetic */ Session $session;
            {
                this.$countersActivationLifetime = $countersActivationLifetime;
                this.$bindingLifetime = $bindingLifetime;
                this.$contentManager = $contentManager;
                this.$countersContent = $countersContent;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull Counter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$countersActivationLifetime, (boolean)false, (int)1, null);
                this.$bindingLifetime.bracketIfAlive((Function0)new Function0<Unit>(this.$contentManager, this.$countersContent, this.$session, this.$bindingLifetime){
                    final /* synthetic */ ContentManager $contentManager;
                    final /* synthetic */ Content $countersContent;
                    final /* synthetic */ Session $session;
                    final /* synthetic */ Lifetime $bindingLifetime;
                    {
                        this.$contentManager = $contentManager;
                        this.$countersContent = $countersContent;
                        this.$session = $session;
                        this.$bindingLifetime = $bindingLifetime;
                        super(0);
                    }

                    public final void invoke() {
                        Unit unit;
                        this.$contentManager.addContent(this.$countersContent, 1);
                        Function2 function2 = (Function2)this.$countersContent.getUserData(MonitoringToolWindowFactoryKt.access$getCONTENT_BINDABLE_KEY$p());
                        if (function2 != null) {
                            function2.invoke((Object)this.$session, (Object)this.$bindingLifetime);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        if (unit == null) {
                            // empty if block
                        }
                    }
                }, (Function0)new Function0<Unit>(this.$contentManager, this.$countersContent){
                    final /* synthetic */ ContentManager $contentManager;
                    final /* synthetic */ Content $countersContent;
                    {
                        this.$contentManager = $contentManager;
                        this.$countersContent = $countersContent;
                        super(0);
                    }

                    public final void invoke() {
                        this.$contentManager.removeContent(this.$countersContent, true);
                    }
                });
            }
        });
        if (!toolWindow2.isVisible()) {
            toolWindow2.setAvailable(true);
            if (((DpaMonitoringSettings.State)DpaMonitoringSettings.Companion.getInstance($this$showMonitoringToolWindow).getState()).getAutoShow()) {
                toolWindow2.show();
            }
        }
    }

    public static final void hideMonitoringToolWindow(@NotNull Project $this$hideMonitoringToolWindow) {
        Intrinsics.checkNotNullParameter((Object)$this$hideMonitoringToolWindow, (String)"<this>");
        ToolWindow toolWindow = MonitoringToolWindowFactoryKt.getMonitoringToolWindow($this$hideMonitoringToolWindow);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        MonitoringToolWindowFactory.Companion.getLogger().trace("hide");
        if (toolWindow2.isAvailable()) {
            toolWindow2.setAvailable(false);
        }
    }

    public static final /* synthetic */ Content access$createContent(ContentFactory contentFactory, BorderLayoutPanel panel, MonitoringToolWindowFactory.ContentType contentType, String displayName, Function3 bindFn) {
        return MonitoringToolWindowFactoryKt.createContent(contentFactory, panel, contentType, displayName, bindFn);
    }

    public static final /* synthetic */ Key access$getCONTENT_BINDABLE_KEY$p() {
        return CONTENT_BINDABLE_KEY;
    }

    static {
        Key key = Key.create((String)"ContentType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CONTENT_TYPE_KEY = key;
        Key key2 = Key.create((String)"ContentBindable");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CONTENT_BINDABLE_KEY = key2;
    }
}

