/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jetbrains.dpa.monitoring.DpaMonitoringSettings;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactory;
import com.jetbrains.dpa.monitoring.MonitoringToolWindowFactoryKt;
import com.jetbrains.dpa.monitoring.view.ChartPanel;
import com.jetbrains.dpa.monitoring.view.ProcessDashboardPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.ui.RiderToolWindowFactory;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory;", "Lcom/jetbrains/rider/ui/RiderToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "init", "shouldBeAvailable", "", "Companion", "ContentType", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,172:1\n13#2:173\n13#3:174\n*S KotlinDebug\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n*L\n38#1:173\n38#1:174\n*E\n"})
public final class MonitoringToolWindowFactory
extends RiderToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String MONITORING_TOOL_WINDOW_ID = "Monitoring";

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return false;
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(MonitoringToolBundle.Companion.message("toolwindow.title", new Object[0]));
        super.init(toolWindow);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        toolWindow.setTitleActions(CollectionsKt.listOf((Object)ActionManager.getInstance().getAction("MonitoringTool.OptionsAction")));
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        ContentFactory contentFactory = ContentFactory.getInstance();
        Intrinsics.checkNotNull((Object)contentFactory);
        Content chartContent2 = MonitoringToolWindowFactoryKt.access$createContent(contentFactory, new ChartPanel(), ContentType.Chart, MonitoringToolBundle.Companion.message("toolwindow.tab.chart", new Object[0]), createToolWindowContent.chartContent.1.INSTANCE);
        contentManager2.addContent(chartContent2);
        Content envContent2 = MonitoringToolWindowFactoryKt.access$createContent(contentFactory, new ProcessDashboardPanel(), ContentType.Environment, MonitoringToolBundle.Companion.message("toolwindow.tab.environment", new Object[0]), createToolWindowContent.envContent.1.INSTANCE);
        contentManager2.addContent(envContent2);
        JComponent jComponent = contentManager2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        UiNotifyConnector.Companion.installOn((Component)jComponent, new Activatable(project, toolWindow){
            final /* synthetic */ Project $project;
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.$project = $project;
                this.$toolWindow = $toolWindow;
            }

            public void showNotify() {
                if (this.$project.isDisposed()) {
                    return;
                }
                ((DpaMonitoringSettings.State)DpaMonitoringSettings.Companion.getInstance(this.$project).getState()).setAutoShow(true);
            }

            public void hideNotify() {
                if (this.$project.isDisposed()) {
                    return;
                }
                if (this.$toolWindow.isAvailable()) {
                    ((DpaMonitoringSettings.State)DpaMonitoringSettings.Companion.getInstance(this.$project).getState()).setAutoShow(false);
                }
            }
        });
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringToolWindowFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringToolWindowFactory.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$Companion;", "", "()V", "MONITORING_TOOL_WINDOW_ID", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$ContentType;", "", "(Ljava/lang/String;I)V", "Chart", "Counters", "Environment", "intellij.rider.plugins.dpa"})
    public static final class ContentType
    extends Enum<ContentType> {
        public static final /* enum */ ContentType Chart = new ContentType();
        public static final /* enum */ ContentType Counters = new ContentType();
        public static final /* enum */ ContentType Environment = new ContentType();
        private static final /* synthetic */ ContentType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ContentType[] values() {
            return (ContentType[])$VALUES.clone();
        }

        public static ContentType valueOf(String value) {
            return Enum.valueOf(ContentType.class, value);
        }

        @NotNull
        public static EnumEntries<ContentType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = contentTypeArray = new ContentType[]{ContentType.Chart, ContentType.Counters, ContentType.Environment};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

