/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IMutableViewableSet;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.model.MonitoringToolModel;
import com.jetbrains.rider.model.MonitoringToolModel_PregeneratedKt;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.model.SessionFlags;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\tJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/dpa/DpaSessions;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "preparingProcessHandlerSet", "Lcom/jetbrains/rd/util/reactive/IMutableViewableSet;", "Lcom/intellij/execution/process/ProcessHandler;", "processHandlerToSessionMap", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "", "sessionUsagesCounter", "Ljava/util/HashMap;", "Lcom/jetbrains/dpa/DpaSessions$SessionInfo;", "Lkotlin/collections/HashMap;", "addSession", "", "processHandler", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "dpaSessionId", "cancelSession", "prepareSession", "tryGetSession", "Lcom/jetbrains/rider/model/ProtocolSession;", "tryWaitSession", "Lorg/jetbrains/concurrency/Promise;", "Companion", "SessionInfo", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nDpaSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaSessions.kt\ncom/jetbrains/dpa/DpaSessions\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 PlatformDependent.kt\ncom/jetbrains/rd/util/PlatformDependentKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n13#2:137\n13#3:138\n88#4:139\n1#5:140\n*S KotlinDebug\n*F\n+ 1 DpaSessions.kt\ncom/jetbrains/dpa/DpaSessions\n*L\n25#1:137\n25#1:138\n57#1:139\n57#1:140\n*E\n"})
public final class DpaSessions
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private final IMutableViewableMap<ProcessHandler, Long> processHandlerToSessionMap;
    @NotNull
    private final IMutableViewableSet<ProcessHandler> preparingProcessHandlerSet;
    @NotNull
    private final HashMap<Long, SessionInfo> sessionUsagesCounter;

    public DpaSessions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DpaSessions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.processHandlerToSessionMap = (IMutableViewableMap)new ViewableMap(null, 1, null);
        this.preparingProcessHandlerSet = (IMutableViewableSet)new ViewableSet(null, 1, null);
        this.sessionUsagesCounter = new HashMap();
    }

    public final void prepareSession(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (this.processHandlerToSessionMap.containsKey((Object)processHandler)) {
            this.logger.trace("processHandlerToSessionMap already contains " + processHandler + " for session:" + this.processHandlerToSessionMap.get((Object)processHandler));
        }
        if (this.preparingProcessHandlerSet.contains((Object)processHandler)) {
            this.logger.trace("preparingProcessHandlerSet already contains " + processHandler + " for session:" + this.processHandlerToSessionMap.get((Object)processHandler));
        }
        this.preparingProcessHandlerSet.add((Object)processHandler);
    }

    public final void cancelSession(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (!this.preparingProcessHandlerSet.contains((Object)processHandler)) {
            this.logger.trace("preparingProcessHandlerSet doesn't contains " + processHandler + " for session:" + this.processHandlerToSessionMap.get((Object)processHandler));
        }
        this.preparingProcessHandlerSet.remove((Object)processHandler);
    }

    public final void addSession(@NotNull ProcessHandler processHandler, @NotNull Lifetime lifetime, long dpaSessionId) {
        EnumSet<SessionFlags> enumSet;
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (this.processHandlerToSessionMap.containsKey((Object)processHandler)) {
            this.logger.trace("pidToSessionMap already contains " + processHandler + " for session:" + this.processHandlerToSessionMap.get((Object)processHandler));
        }
        Object[] objectArray = new SessionFlags[]{SessionFlags.Counters, SessionFlags.Gc};
        Set values$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$enumSetOf = false;
        EnumSet<SessionFlags> $this$enumSetOf_u24lambda_u243$iv = enumSet = EnumSet.noneOf(SessionFlags.class);
        boolean bl = false;
        $this$enumSetOf_u24lambda_u243$iv.addAll(values$iv);
        EnumSet<SessionFlags> enumSet2 = enumSet;
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"noneOf(T::class.java).apply { addAll(values) }");
        ProtocolSession session = new ProtocolSession(enumSet2);
        MonitoringToolModel model = MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        SessionInfo sessionInfo = this.sessionUsagesCounter.get(dpaSessionId);
        if (sessionInfo == null) {
            LifetimeDefinition dpaSessionLifetime = this.getServiceLifetime().createNested();
            Long l = dpaSessionId;
            ((Map)this.sessionUsagesCounter).put(l, new SessionInfo(1, dpaSessionLifetime));
            CollectionExKt.addUnique((Map)((Map)model.getDpaSessions()), (Lifetime)((Lifetime)dpaSessionLifetime), (Object)dpaSessionId, (Object)session);
        } else {
            int n = sessionInfo.getReferenceCount();
            sessionInfo.setReferenceCount(n + 1);
        }
        Long l = dpaSessionId;
        ((Map)this.processHandlerToSessionMap).put(processHandler, l);
        if (this.preparingProcessHandlerSet.contains((Object)processHandler)) {
            this.logger.trace("preparingProcessHandlerSet remove " + processHandler + " for session:" + this.processHandlerToSessionMap.get((Object)processHandler));
            this.preparingProcessHandlerSet.remove((Object)processHandler);
        }
        lifetime.onTermination((Function0)new Function0<Unit>(this, dpaSessionId){
            final /* synthetic */ DpaSessions this$0;
            final /* synthetic */ long $dpaSessionId;
            {
                this.this$0 = $receiver;
                this.$dpaSessionId = $dpaSessionId;
                super(0);
            }

            public final void invoke() {
                SessionInfo sessionInfo = (SessionInfo)DpaSessions.access$getSessionUsagesCounter$p(this.this$0).get(this.$dpaSessionId);
                if (sessionInfo != null) {
                    if (sessionInfo.getReferenceCount() == 1) {
                        DpaSessions.access$getSessionUsagesCounter$p(this.this$0).remove(this.$dpaSessionId);
                        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionInfo.getLifetime(), (boolean)false, (int)1, null);
                    } else {
                        int n = sessionInfo.getReferenceCount();
                        sessionInfo.setReferenceCount(n + -1);
                    }
                }
            }
        });
    }

    @Nullable
    public final ProtocolSession tryGetSession(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Long dpaSessionId = (Long)this.processHandlerToSessionMap.get((Object)processHandler);
        if (dpaSessionId == null) {
            this.logger.trace("No dpa session for processHandler:" + processHandler);
            return null;
        }
        return (ProtocolSession)MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getDpaSessions().get((Object)dpaSessionId);
    }

    @NotNull
    public final Promise<ProtocolSession> tryWaitSession(@NotNull ProcessHandler processHandler, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        AsyncPromise promise = new AsyncPromise();
        Long dpaSessionId = (Long)this.processHandlerToSessionMap.get((Object)processHandler);
        if (dpaSessionId != null) {
            Object object = MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getDpaSessions().get((Object)dpaSessionId);
            Intrinsics.checkNotNull((Object)object);
            promise.setResult(object);
            return (Promise)promise;
        }
        if (!this.preparingProcessHandlerSet.contains((Object)processHandler)) {
            promise.setError("No DPA preparing session");
            return (Promise)promise;
        }
        LifetimeDefinition subscriptionLifetime = lifetime.createNested();
        SourceExKt.adviseOnce((ISource)((ISource)this.preparingProcessHandlerSet), (Lifetime)((Lifetime)subscriptionLifetime), (Function1)((Function1)new Function1<IViewableSet.Event<ProcessHandler>, Unit>(processHandler, (AsyncPromise<ProtocolSession>)promise, subscriptionLifetime){
            final /* synthetic */ ProcessHandler $processHandler;
            final /* synthetic */ AsyncPromise<ProtocolSession> $promise;
            final /* synthetic */ LifetimeDefinition $subscriptionLifetime;
            {
                this.$processHandler = $processHandler;
                this.$promise = $promise;
                this.$subscriptionLifetime = $subscriptionLifetime;
                super(1);
            }

            public final void invoke(@NotNull IViewableSet.Event<ProcessHandler> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (event.getKind() == AddRemove.Remove && Intrinsics.areEqual((Object)event.getValue(), (Object)this.$processHandler)) {
                    if (!this.$promise.isDone()) {
                        this.$promise.setError("DPA session cancelled");
                    }
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$subscriptionLifetime, (boolean)false, (int)1, null);
                }
            }
        }));
        this.processHandlerToSessionMap.advise((Lifetime)subscriptionLifetime, (Function1)new Function1<IViewableMap.Event<ProcessHandler, ? extends Long>, Unit>(processHandler, (AsyncPromise<ProtocolSession>)promise, this, subscriptionLifetime){
            final /* synthetic */ ProcessHandler $processHandler;
            final /* synthetic */ AsyncPromise<ProtocolSession> $promise;
            final /* synthetic */ DpaSessions this$0;
            final /* synthetic */ LifetimeDefinition $subscriptionLifetime;
            {
                this.$processHandler = $processHandler;
                this.$promise = $promise;
                this.this$0 = $receiver;
                this.$subscriptionLifetime = $subscriptionLifetime;
                super(1);
            }

            public final void invoke(@NotNull IViewableMap.Event<ProcessHandler, Long> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Long l = (Long)it.getNewValueOpt();
                if (l == null) {
                    return;
                }
                long newValue = l;
                if (Intrinsics.areEqual((Object)it.getKey(), (Object)this.$processHandler)) {
                    Object object = MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)DpaSessions.access$getProject$p(this.this$0))).getDpaSessions().get((Object)newValue);
                    Intrinsics.checkNotNull((Object)object);
                    this.$promise.setResult(object);
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$subscriptionLifetime, (boolean)false, (int)1, null);
                }
            }
        });
        return (Promise)promise;
    }

    public static final /* synthetic */ HashMap access$getSessionUsagesCounter$p(DpaSessions $this) {
        return $this.sessionUsagesCounter;
    }

    public static final /* synthetic */ Project access$getProject$p(DpaSessions $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dpa/DpaSessions$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/dpa/DpaSessions;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nDpaSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaSessions.kt\ncom/jetbrains/dpa/DpaSessions$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,136:1\n31#2,2:137\n*S KotlinDebug\n*F\n+ 1 DpaSessions.kt\ncom/jetbrains/dpa/DpaSessions$Companion\n*L\n27#1:137,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DpaSessions getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DpaSessions> serviceClass$iv = DpaSessions.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DpaSessions)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/dpa/DpaSessions$SessionInfo;", "", "referenceCount", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(ILcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getReferenceCount", "()I", "setReferenceCount", "(I)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider.plugins.dpa"})
    public static final class SessionInfo {
        private int referenceCount;
        @NotNull
        private final LifetimeDefinition lifetime;

        public SessionInfo(int referenceCount, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.referenceCount = referenceCount;
            this.lifetime = lifetime;
        }

        public final int getReferenceCount() {
            return this.referenceCount;
        }

        public final void setReferenceCount(int n) {
            this.referenceCount = n;
        }

        @NotNull
        public final LifetimeDefinition getLifetime() {
            return this.lifetime;
        }

        public final int component1() {
            return this.referenceCount;
        }

        @NotNull
        public final LifetimeDefinition component2() {
            return this.lifetime;
        }

        @NotNull
        public final SessionInfo copy(int referenceCount, @NotNull LifetimeDefinition lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            return new SessionInfo(referenceCount, lifetime);
        }

        public static /* synthetic */ SessionInfo copy$default(SessionInfo sessionInfo, int n, LifetimeDefinition lifetimeDefinition, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sessionInfo.referenceCount;
            }
            if ((n2 & 2) != 0) {
                lifetimeDefinition = sessionInfo.lifetime;
            }
            return sessionInfo.copy(n, lifetimeDefinition);
        }

        @NotNull
        public String toString() {
            return "SessionInfo(referenceCount=" + this.referenceCount + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.referenceCount);
            result = result * 31 + this.lifetime.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SessionInfo)) {
                return false;
            }
            SessionInfo sessionInfo = (SessionInfo)other;
            if (this.referenceCount != sessionInfo.referenceCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lifetime, (Object)sessionInfo.lifetime);
        }
    }
}

