/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.system.CpuArch;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBundle;
import com.jetbrains.dpa.DpaExtension;
import com.jetbrains.dpa.DpaHost;
import com.jetbrains.dpa.DpaSessions;
import com.jetbrains.dpa.DpaStatistics;
import com.jetbrains.dpa.IntegrationLevel;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.threading.SynchronousScheduler;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.RiderDebugRunner;
import com.jetbrains.rider.model.CollectorControllerMode;
import com.jetbrains.rider.model.DetachSessionArgs;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.RunType;
import com.jetbrains.rider.model.SessionResult;
import com.jetbrains.rider.model.StartSessionArgs;
import com.jetbrains.rider.model.StartSessionResult;
import com.jetbrains.rider.model.StartSessionWithoutCollectorArgs;
import com.jetbrains.rider.model.StartSessionWithoutCollectorResult;
import com.jetbrains.rider.plugins.RiderBundledPluginHelpers;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.run.PatchCommandLineExtension;
import com.jetbrains.rider.run.WorkerRunInfo;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005*\u0003\u0011\u001b2\u0018\u00002\u00020\u0001:\u0003EFGB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J'\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010!\u001a\u00020\"2\u0014\b\u0001\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060$H\u0002J0\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J9\u00101\u001a\u0002022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u0016\u001a\f0\u0006\u00a2\u0006\u0002\b3\u00a2\u0006\u0002\b42\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u00105J6\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u0016\u001a\f0\u0006\u00a2\u0006\u0002\b3\u00a2\u0006\u0002\b42\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010\u0012\u001a\u00020\u0013H\u0002JO\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010<\"\u0004\b\u0001\u0010;2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u0002H<\u0012\u0004\u0012\u0002H;0>2\u0006\u0010?\u001a\u0002H<2\u0006\u0010@\u001a\u00020\u000f2\u0012\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H;\u0012\u0004\u0012\u00020C0B\u00a2\u0006\u0002\u0010DR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/jetbrains/dpa/DpaExtension;", "Lcom/jetbrains/rider/run/PatchCommandLineExtension;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "dpaIsNotPreparedPrefix", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "pathToDebuggerDebugInjector", "Lkotlin/Lazy;", "Ljava/io/File;", "pathToDpaDebugInjector", "pathToRunner", "prepareCommandTimeouts", "Lcom/jetbrains/rd/framework/impl/RpcTimeouts;", "createAttachChildrenProcessListener", "com/jetbrains/dpa/DpaExtension$createAttachChildrenProcessListener$1", "project", "Lcom/intellij/openapi/project/Project;", "buildConfigurationId", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "exePath", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;Ljava/lang/String;Lcom/intellij/execution/configurations/GeneralCommandLine;)Lcom/jetbrains/dpa/DpaExtension$createAttachChildrenProcessListener$1;", "createProcessListener", "com/jetbrains/dpa/DpaExtension$createProcessListener$1", "sessionId", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;J)Lcom/jetbrains/dpa/DpaExtension$createProcessListener$1;", "disabledByUser", "", "getDpaEnvVars", "Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "environment", "", "patchDebugCommandLine", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/run/WorkerRunInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "workerRunInfo", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "patchRunCommandLine", "Lcom/intellij/execution/process/ProcessListener;", "dotNetRuntime", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "patchRunCommandLineAttach", "com/jetbrains/dpa/DpaExtension$patchRunCommandLineAttach$1", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;Ljava/lang/String;Lcom/intellij/execution/configurations/GeneralCommandLine;)Lcom/jetbrains/dpa/DpaExtension$patchRunCommandLineAttach$1;", "patchRunCommandLineDpaRunner", "Lcom/jetbrains/dpa/DpaExtension$DpaProcessAdapter;", "probingPathsEnvVar", "Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "sync", "TRes", "TReq", "call", "Lcom/jetbrains/rd/framework/impl/RdCall;", "request", "timeouts", "onSuccessAfterTimeout", "Lkotlin/Function1;", "", "(Lcom/jetbrains/rd/framework/impl/RdCall;Ljava/lang/Object;Lcom/jetbrains/rd/framework/impl/RpcTimeouts;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "DpaEnvVars", "DpaProcessAdapter", "ProbingPathsEnvVar", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nDpaExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 TaskInterfaces.kt\ncom/jetbrains/rd/framework/TaskInterfacesKt\n+ 5 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 StructuredLogging.kt\ncom/jetbrains/rd/platform/diagnostics/StructuredLoggingKt\n*L\n1#1,410:1\n13#2:411\n13#3:412\n86#3,3:413\n86#3,2:435\n88#3:453\n95#4:416\n96#4:424\n23#5,7:417\n30#5,9:426\n1#6:425\n144#7,5:437\n161#7,2:442\n150#7,9:444\n*S KotlinDebug\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n*L\n216#1:411\n216#1:412\n78#1:413,3\n325#1:435,2\n325#1:453\n304#1:416\n304#1:424\n304#1:417,7\n304#1:426,9\n304#1:425\n326#1:437,5\n326#1:442,2\n326#1:444,9\n*E\n"})
public final class DpaExtension
implements PatchCommandLineExtension {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String dpaIsNotPreparedPrefix;
    @NotNull
    private final RpcTimeouts prepareCommandTimeouts;
    @NotNull
    private final Lazy<File> pathToRunner;
    @NotNull
    private final Lazy<File> pathToDpaDebugInjector;
    @NotNull
    private final Lazy<File> pathToDebuggerDebugInjector;
    @NotNull
    private final Logger logger;

    public DpaExtension(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.dpaIsNotPreparedPrefix = DpaBundle.INSTANCE.message("dpa.extentions.dpa.is.not.prepared.prefix", new Object[0]);
        this.prepareCommandTimeouts = new RpcTimeouts(3000L, 3000L);
        this.pathToRunner = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ DpaExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final File invoke() {
                Object object;
                void $this$runAndLogException$iv;
                Logger logger = DpaExtension.access$getLogger$p(this.this$0);
                DpaExtension dpaExtension = this.this$0;
                boolean $i$f$runAndLogException = false;
                void var4_4 = $this$runAndLogException$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv = var4_4;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(dpaExtension.getClass(), "JetBrains.DPA.Runner.exe", DpaExtension.access$getLogger$p(dpaExtension));
                    if (file == null) {
                        throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.dpa.runner", new Object[0]));
                    }
                    object = Result.constructor-impl((Object)file);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            }
        }));
        this.pathToDpaDebugInjector = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ DpaExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final File invoke() {
                Object object;
                void $this$runAndLogException$iv;
                Logger logger = DpaExtension.access$getLogger$p(this.this$0);
                DpaExtension dpaExtension = this.this$0;
                boolean $i$f$runAndLogException = false;
                void var4_4 = $this$runAndLogException$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv = var4_4;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(dpaExtension.getClass(), "JetBrains.DPA.DebugInjector.dll", DpaExtension.access$getLogger$p(dpaExtension));
                    if (file == null) {
                        throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.dpa.debug.injector", new Object[0]));
                    }
                    object = Result.constructor-impl((Object)file);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            }
        }));
        this.pathToDebuggerDebugInjector = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ DpaExtension this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final File invoke() {
                Object object;
                void $this$runAndLogException$iv;
                Logger logger = DpaExtension.access$getLogger$p(this.this$0);
                DpaExtension dpaExtension = this.this$0;
                boolean $i$f$runAndLogException = false;
                void var4_4 = $this$runAndLogException$iv;
                try {
                    void $this$runAndLogException_u24lambda_u240$iv = var4_4;
                    boolean bl = false;
                    boolean bl2 = false;
                    File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(dpaExtension.getClass(), "JetBrains.Debugger.DebugInjector.dll", DpaExtension.access$getLogger$p(dpaExtension));
                    if (file == null) {
                        throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.debugger.debug.injector", new Object[0]));
                    }
                    object = Result.constructor-impl((Object)file);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
            }
        }));
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DpaExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final ProbingPathsEnvVar probingPathsEnvVar(Project project) {
        Logger $this$runAndLogException$iv = this.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            IProtocolHost iProtocolHost = ApplicationProtocolKt.getProtocolHost((Project)project);
            Object object = iProtocolHost instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)iProtocolHost : null;
            if (object == null || (object = object.getResharperProcess()) == null || (object = object.getDotNetPluginsExtraDirs()) == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.get.plugin.extra.directories", new Object[0]));
            }
            Object paths = object;
            ProbingPathsEnvVar envVar = new ProbingPathsEnvVar("RIDER_PLUGIN_ADDITIONAL_PROBING_PATHS", (String)paths);
            this.logger.trace(envVar.getKey() + ":" + envVar.getValue());
            return envVar;
        }
        catch (Throwable throwable) {
            return (ProbingPathsEnvVar)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)$this$runAndLogException$iv);
        }
    }

    private final DpaEnvVars getDpaEnvVars(@NotNull Map<String, String> environment) {
        return new DpaEnvVars(environment.getOrDefault("JETBRAINS_DPA_MODE", ""), environment.getOrDefault("JETBRAINS_DPA_AGENT_ENABLE", ""), environment.getOrDefault("CORECLR_ENABLE_PROFILING", ""), environment.getOrDefault("COR_ENABLE_PROFILING", ""));
    }

    private final boolean disabledByUser(Project project) {
        return !DpaHost.Companion.getInstance(project).getEnabled();
    }

    @NotNull
    public Promise<WorkerRunInfo> patchDebugCommandLine(@NotNull Lifetime lifetime, @NotNull WorkerRunInfo workerRunInfo, @Nullable ProcessInfo processInfo, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)workerRunInfo, (String)"workerRunInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || this.disabledByUser(project)) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File file = (File)this.pathToDpaDebugInjector.getValue();
        if (file == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File dpaDebugInjector = file;
        File file2 = (File)this.pathToDebuggerDebugInjector.getValue();
        if (file2 == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File debuggerDebugInjector = file2;
        ProbingPathsEnvVar probingPathsEnvVar = this.probingPathsEnvVar(project);
        if (probingPathsEnvVar == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        ProbingPathsEnvVar probingPaths = probingPathsEnvVar;
        AsyncPromise promise = new AsyncPromise();
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        boolean attachChildren = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectorMode().getValueOrNull() == CollectorControllerMode.ETW && processInfo == null ? true : Registry.is((String)"dpa.enableProcessMonitoringForUnix", (boolean)false);
        String string = workerRunInfo.getCommandLine().getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        ProcessInfo processInfo2 = processInfo;
        StartSessionWithoutCollectorArgs request = new StartSessionWithoutCollectorArgs(buildConfigurationId, true, string, processInfo2 != null ? Integer.valueOf(processInfo2.getPid()) : null, attachChildren);
        SourceExKt.adviseOnce((ISource)((ISource)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getStartSessionWithoutCollector().start((Object)request).getResult()), (Lifetime)lifetime, (Function1)((Function1)new Function1<RdTaskResult<? extends StartSessionWithoutCollectorResult>, Unit>(this, (AsyncPromise<WorkerRunInfo>)promise, workerRunInfo, project, buildConfigurationId, dpaDebugInjector, debuggerDebugInjector, probingPaths){
            final /* synthetic */ DpaExtension this$0;
            final /* synthetic */ AsyncPromise<WorkerRunInfo> $promise;
            final /* synthetic */ WorkerRunInfo $workerRunInfo;
            final /* synthetic */ Project $project;
            final /* synthetic */ RdConfigurationAndPlatform $buildConfigurationId;
            final /* synthetic */ File $dpaDebugInjector;
            final /* synthetic */ File $debuggerDebugInjector;
            final /* synthetic */ ProbingPathsEnvVar $probingPaths;
            {
                this.this$0 = $receiver;
                this.$promise = $promise;
                this.$workerRunInfo = $workerRunInfo;
                this.$project = $project;
                this.$buildConfigurationId = $buildConfigurationId;
                this.$dpaDebugInjector = $dpaDebugInjector;
                this.$debuggerDebugInjector = $debuggerDebugInjector;
                this.$probingPaths = $probingPaths;
                super(1);
            }

            public final void invoke(@NotNull RdTaskResult<StartSessionWithoutCollectorResult> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                RdTaskResult<StartSessionWithoutCollectorResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    CharSequence charSequence;
                    Object v3;
                    String plugins;
                    GeneralCommandLine $this$invoke_u24lambda_u242;
                    ProbingPathsEnvVar probingPathsEnvVar;
                    Project project;
                    File file;
                    block19: {
                        Object v1;
                        String param;
                        boolean $i$f$firstOrNull;
                        Iterable $this$firstOrNull$iv;
                        File file2;
                        block18: {
                            if (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getSessionResult() != SessionResult.Success && (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getSessionResult() != SessionResult.UnderDpa || ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getFlags-pVg5ArA() == 0)) {
                                DpaExtension.access$getLogger$p(this.this$0).warn(DpaExtension.access$getDpaIsNotPreparedPrefix$p(this.this$0) + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getSessionResult());
                                this.$promise.setResult((Object)this.$workerRunInfo);
                                return;
                            }
                            GeneralCommandLine generalCommandLine = this.$workerRunInfo.getCommandLine();
                            file2 = this.$dpaDebugInjector;
                            file = this.$debuggerDebugInjector;
                            project = this.$project;
                            probingPathsEnvVar = this.$probingPaths;
                            $this$invoke_u24lambda_u242 = generalCommandLine;
                            boolean bl = false;
                            List list = $this$invoke_u24lambda_u242.getParametersList().getParameters();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
                            $this$firstOrNull$iv = list;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                param = (String)element$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNull((Object)param);
                                if (!StringsKt.startsWith$default((String)param, (String)"--plugins", (boolean)false, (int)2, null)) continue;
                                v1 = element$iv;
                                break block18;
                            }
                            v1 = null;
                        }
                        plugins = v1;
                        if (plugins != null) {
                            $this$invoke_u24lambda_u242.getParametersList().replaceOrAppend(plugins, plugins + ";" + file2.getAbsolutePath());
                        } else {
                            $this$invoke_u24lambda_u242.getParametersList().add("--plugins=" + file2.getAbsolutePath());
                        }
                        List list = $this$invoke_u24lambda_u242.getParametersList().getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
                        $this$firstOrNull$iv = list;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            param = (String)element$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)param);
                            if (!StringsKt.startsWith$default((String)param, (String)"--plugins", (boolean)false, (int)2, null)) continue;
                            v3 = element$iv;
                            break block19;
                        }
                        v3 = null;
                    }
                    plugins = v3;
                    if (plugins != null) {
                        $this$invoke_u24lambda_u242.getParametersList().replaceOrAppend(plugins, plugins + ";" + file.getAbsolutePath());
                    } else {
                        $this$invoke_u24lambda_u242.getParametersList().add("--plugins=" + file.getAbsolutePath());
                    }
                    $this$invoke_u24lambda_u242.getParametersList().add("--dpa-flags=" + UInt.toString-impl((int)((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getFlags-pVg5ArA()));
                    if (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getRefreshInterval() != null) {
                        $this$invoke_u24lambda_u242.getParametersList().add("--dpa-refresh-interval=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getRefreshInterval());
                    }
                    if (!((charSequence = (CharSequence)((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getCounterProviders()) == null || charSequence.length() == 0)) {
                        $this$invoke_u24lambda_u242.getParametersList().add("--dpa-counters=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getCounterProviders());
                    }
                    if (!((charSequence = (CharSequence)((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMetrics()) == null || charSequence.length() == 0)) {
                        $this$invoke_u24lambda_u242.getParametersList().add("--dpa-metrics=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMetrics());
                        if (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMaxTimeSeries() != null) {
                            $this$invoke_u24lambda_u242.getParametersList().add("--dpa-max-time-series=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMaxTimeSeries());
                        }
                        if (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMaxHistograms() != null) {
                            $this$invoke_u24lambda_u242.getParametersList().add("--dpa-max-histograms=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs().getMaxHistograms());
                        }
                    }
                    if (((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getHandle() != 0L) {
                        $this$invoke_u24lambda_u242.getParametersList().add("--dpa-backend-pid=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getPid());
                        $this$invoke_u24lambda_u242.getParametersList().add("--dpa-handle=" + ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getHandle());
                    }
                    $this$invoke_u24lambda_u242.getParametersList().add("--dpa-collector-mode=" + DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectorMode().getValueOrNull());
                    $this$invoke_u24lambda_u242.withEnvironment(probingPathsEnvVar.getKey(), probingPathsEnvVar.getValue());
                    this.$workerRunInfo.addProcessListener((ProcessListener)DpaExtension.access$createProcessListener(this.this$0, this.$project, this.$buildConfigurationId, ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getSessionId()));
                    DpaStatistics.Companion.getInstance(this.$project).runExecuted(RunType.Debug, ((StartSessionWithoutCollectorResult)((RdTaskResult.Success)it).getValue()).getStatisticsActivityId());
                    this.$promise.setResult((Object)this.$workerRunInfo);
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    DpaExtension.access$getLogger$p(this.this$0).warn((Throwable)((RdTaskResult.Fault)it).getError());
                    this.$promise.setResult((Object)this.$workerRunInfo);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    DpaExtension.access$getLogger$p(this.this$0).info("DPA prepare for debug was cancelled");
                    this.$promise.setResult((Object)this.$workerRunInfo);
                }
            }
        }));
        return (Promise)promise;
    }

    @Nullable
    public ProcessListener patchRunCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull DotNetRuntime dotNetRuntime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)dotNetRuntime, (String)"dotNetRuntime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || this.disabledByUser(project)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)dotNetRuntime.getType(), (Object)MonoRuntimeType.INSTANCE)) {
            return null;
        }
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        String string = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String exePath = string;
        return DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectorMode().getValueOrNull() == CollectorControllerMode.ETW && !CpuArch.isArm64() ? (ProcessListener)this.patchRunCommandLineDpaRunner(project, buildConfigurationId, exePath, commandLine) : (ProcessListener)this.patchRunCommandLineAttach(project, buildConfigurationId, exePath, commandLine);
    }

    private final patchRunCommandLineAttach.1 patchRunCommandLineAttach(Project project, RdConfigurationAndPlatform buildConfigurationId, String exePath, GeneralCommandLine commandLine) {
        CoroutineScope coroutineScope = this.coroutineScope;
        return new DpaProcessAdapter(commandLine, project, buildConfigurationId, this, exePath, coroutineScope){
            private boolean alreadyTerminated;
            @NotNull
            private Map<String, String> environment;
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ Project $project;
            final /* synthetic */ RdConfigurationAndPlatform $buildConfigurationId;
            final /* synthetic */ DpaExtension this$0;
            final /* synthetic */ String $exePath;
            {
                this.$commandLine = $commandLine;
                this.$project = $project;
                this.$buildConfigurationId = $buildConfigurationId;
                this.this$0 = $receiver;
                this.$exePath = $exePath;
                super($super_call_param$1, $project, $buildConfigurationId);
                Map map = $commandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                this.environment = map;
            }

            public final boolean getAlreadyTerminated() {
                return this.alreadyTerminated;
            }

            public final void setAlreadyTerminated(boolean bl) {
                this.alreadyTerminated = bl;
            }

            @NotNull
            public final Map<String, String> getEnvironment() {
                return this.environment;
            }

            public final void setEnvironment(@NotNull Map<String, String> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.environment = map;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void startNotified(@NotNull ProcessEvent event) {
                Object object;
                void $this$runAndLogException$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DpaExtension.access$getLogger$p(this.this$0).info("patchRunCommandLineAttach " + this.$exePath);
                Ref.BooleanRef attachChildren = new Ref.BooleanRef();
                int pid = 0;
                DpaSessions dpaSessions = DpaSessions.Companion.getInstance(this.$project);
                Logger logger = DpaExtension.access$getLogger$p(this.this$0);
                DpaExtension dpaExtension = this.this$0;
                Project project = this.$project;
                RdConfigurationAndPlatform rdConfigurationAndPlatform = this.$buildConfigurationId;
                String string = this.$exePath;
                boolean $i$f$runAndLogException = false;
                void var12_11 = $this$runAndLogException$iv;
                try {
                    IRdTask iRdTask;
                    void $this$runAndLogException_u24lambda_u240$iv = var12_11;
                    boolean bl = false;
                    boolean bl2 = false;
                    ProcessHandler processHandler = event.getProcessHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                    Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
                    if (n == null) {
                        iRdTask = null;
                    } else {
                        void $this$doCalculation_u24default$iv;
                        IRdTask iRdTask2;
                        pid = n;
                        ProcessHandler processHandler2 = event.getProcessHandler();
                        Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
                        dpaSessions.prepareSession(processHandler2);
                        Logger logger2 = DpaExtension.access$getLogger$p(dpaExtension);
                        String key$iv = "askBackendToAttach";
                        Object message$iv = null;
                        boolean $i$f$doCalculation = false;
                        boolean hadException$iv = false;
                        long startTime$iv = System.nanoTime();
                        try {
                            boolean bl3 = false;
                            DpaEnvVars dpaEnvVars = DpaExtension.access$getDpaEnvVars(dpaExtension, this.environment);
                            attachChildren.element = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectorMode().getValueOrNull() == CollectorControllerMode.ETW || Registry.is((String)"dpa.enableProcessMonitoringForUnix", (boolean)false);
                            StartSessionArgs request = new StartSessionArgs(rdConfigurationAndPlatform, false, false, attachChildren.element, string, pid, null, dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling());
                            iRdTask2 = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getStartSession().start((Object)request);
                        }
                        catch (Throwable t$iv) {
                            try {
                                String eventKind$iv = t$iv instanceof ProcessCanceledException || t$iv instanceof CancellationException ? "Cancelled" : "Exception";
                                hadException$iv = true;
                                StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<" + eventKind$iv + "> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                                throw t$iv;
                            }
                            catch (Throwable throwable) {
                                if (!hadException$iv) {
                                    StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                                }
                                throw throwable;
                            }
                        }
                        StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                        iRdTask = iRdTask2;
                    }
                    object = Result.constructor-impl(iRdTask);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                IRdTask iRdTask = (IRdTask)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                if (iRdTask == null) {
                    return;
                }
                IRdTask attachResult = iRdTask;
                RdTaskUtilKt.toAsyncPromise((IRdTask)attachResult, (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.$project))).onSuccess(arg_0 -> patchRunCommandLineAttach.1.startNotified$lambda$2((Function1)new Function1<StartSessionResult, Unit>(this.$project, this, this.$buildConfigurationId, dpaSessions, event, attachChildren, this.this$0, this.$exePath, this.$commandLine){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ patchRunCommandLineAttach.1 this$0;
                    final /* synthetic */ RdConfigurationAndPlatform $buildConfigurationId;
                    final /* synthetic */ DpaSessions $dpaSessions;
                    final /* synthetic */ ProcessEvent $event;
                    final /* synthetic */ Ref.BooleanRef $attachChildren;
                    final /* synthetic */ DpaExtension this$1;
                    final /* synthetic */ String $exePath;
                    final /* synthetic */ GeneralCommandLine $commandLine;
                    {
                        this.$project = $project;
                        this.this$0 = $receiver;
                        this.$buildConfigurationId = $buildConfigurationId;
                        this.$dpaSessions = $dpaSessions;
                        this.$event = $event;
                        this.$attachChildren = $attachChildren;
                        this.this$1 = $receiver2;
                        this.$exePath = $exePath;
                        this.$commandLine = $commandLine;
                        super(1);
                    }

                    public final void invoke(@NotNull StartSessionResult it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (it.getSessionResult() == SessionResult.Success) {
                            DpaStatistics.Companion.getInstance(this.$project).runExecuted(RunType.Run, it.getStatisticsActivityId());
                            if (this.this$0.getAlreadyTerminated()) {
                                DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.$project)).getDetachSession().fire((Object)new DetachSessionArgs(this.$buildConfigurationId, it.getSessionId(), false));
                                ProcessHandler processHandler = this.$event.getProcessHandler();
                                Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                                this.$dpaSessions.cancelSession(processHandler);
                            } else {
                                ProcessHandler processHandler = this.$event.getProcessHandler();
                                Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                                this.this$0.initSession(processHandler, it.getSessionId());
                            }
                        } else {
                            ProcessHandler processHandler = this.$event.getProcessHandler();
                            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                            this.$dpaSessions.cancelSession(processHandler);
                            if (it.getSessionResult() == SessionResult.RootProcessFiltered && this.$attachChildren.element) {
                                DpaExtension.access$createAttachChildrenProcessListener(this.this$1, this.$project, this.$buildConfigurationId, this.$exePath, this.$commandLine);
                            } else {
                                DpaExtension.access$getLogger$p(this.this$1).warn(DpaExtension.access$getDpaIsNotPreparedPrefix$p(this.this$1) + it.getSessionResult());
                            }
                        }
                    }
                }, arg_0)).onError(arg_0 -> patchRunCommandLineAttach.1.startNotified$lambda$3((Function1)new Function1<Throwable, Unit>(dpaSessions, event, this.this$0){
                    final /* synthetic */ DpaSessions $dpaSessions;
                    final /* synthetic */ ProcessEvent $event;
                    final /* synthetic */ DpaExtension this$0;
                    {
                        this.$dpaSessions = $dpaSessions;
                        this.$event = $event;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ProcessHandler processHandler = this.$event.getProcessHandler();
                        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                        this.$dpaSessions.cancelSession(processHandler);
                        DpaExtension.access$getLogger$p(this.this$0).warn(it);
                    }
                }, arg_0));
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.alreadyTerminated = true;
                super.processWillTerminate(event, willBeDestroyed);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.alreadyTerminated = true;
                super.processTerminated(event);
            }

            private static final void startNotified$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void startNotified$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final <TReq, TRes> TRes sync(@NotNull RdCall<TReq, TRes> call, TReq request, @NotNull RpcTimeouts timeouts, @NotNull Function1<? super TRes, Unit> onSuccessAfterTimeout) {
        boolean bl;
        IRdTask task;
        block5: {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter(call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)timeouts, (String)"timeouts");
            Intrinsics.checkNotNullParameter(onSuccessAfterTimeout, (String)"onSuccessAfterTimeout");
            IRdTask iRdTask = task = call.start(Lifetime.Companion.getEternal(), request, (IScheduler)SynchronousScheduler.INSTANCE);
            long timeoutMs$iv = this.prepareCommandTimeouts.getErrorAwaitTimeMs();
            boolean $i$f$wait = false;
            SpinWait.Companion companion = SpinWait.Companion;
            Lifetime lifetime$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil = false;
            void var13_12 = this_$iv$iv;
            Duration duration = Duration.ofMillis(timeoutMs$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv = duration;
            boolean $i$f$spinUntil2 = false;
            long start$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv = 0L;
            while (true) {
                void $this$wait$iv;
                boolean bl2;
                boolean bl3 = false;
                boolean $this$wait_u24lambda_u241_u24lambda_u240$iv = bl2 = InterfacesKt.getHasValue((IOptPropertyView)$this$wait$iv.getResult());
                boolean bl4 = false;
                if (!$this$wait_u24lambda_u241_u24lambda_u240$iv) {
                    boolean bl5 = false;
                }
                if (bl2) break;
                if (!RLifetimeKt.isAlive((Lifetime)lifetime$iv$iv) || System.nanoTime() - start$iv$iv$iv > duration$iv$iv$iv.toNanos()) {
                    bl = false;
                    break block5;
                }
                long l = spins$iv$iv$iv;
                spins$iv$iv$iv = l + 1L;
                if (l < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv / (long)100);
            }
            bl = true;
        }
        if (!bl) {
            SourceExKt.adviseOnce((ISource)((ISource)task.getResult()), (Lifetime)Lifetime.Companion.getEternal(), (Function1)new Function1<RdTaskResult<? extends TRes>, Unit>(onSuccessAfterTimeout){
                final /* synthetic */ Function1<TRes, Unit> $onSuccessAfterTimeout;
                {
                    this.$onSuccessAfterTimeout = $onSuccessAfterTimeout;
                    super(1);
                }

                public final void invoke(@NotNull RdTaskResult<? extends TRes> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    if (it instanceof RdTaskResult.Success) {
                        this.$onSuccessAfterTimeout.invoke(((RdTaskResult.Success)it).getValue());
                    }
                }
            });
            throw new TimeoutException("Sync execution of rpc `" + call + ".location` is timed out in " + timeouts.getErrorAwaitTimeMs() + " ms");
        }
        return (TRes)((RdTaskResult)InterfacesKt.getValueOrThrow((IOptPropertyView)task.getResult())).unwrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final DpaProcessAdapter patchRunCommandLineDpaRunner(Project project, RdConfigurationAndPlatform buildConfigurationId, String exePath, GeneralCommandLine commandLine) {
        Object object;
        this.logger.info("patchRunCommandLineDpaRunner " + exePath);
        File file = (File)this.pathToRunner.getValue();
        if (file == null) {
            return null;
        }
        File runner = file;
        ProbingPathsEnvVar probingPathsEnvVar = this.probingPathsEnvVar(project);
        if (probingPathsEnvVar == null) {
            return null;
        }
        ProbingPathsEnvVar probingPaths = probingPathsEnvVar;
        Logger $this$runAndLogException$iv = this.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            void $this$doCalculation_u24default$iv;
            StartSessionWithoutCollectorResult startSessionWithoutCollectorResult;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Logger logger2 = this.logger;
            String key$iv = "getHandleFromBackend";
            Object message$iv = null;
            boolean $i$f$doCalculation = false;
            boolean hadException$iv = false;
            long startTime$iv = System.nanoTime();
            try {
                boolean bl3 = false;
                StartSessionWithoutCollectorArgs request = new StartSessionWithoutCollectorArgs(buildConfigurationId, false, exePath, null, true);
                startSessionWithoutCollectorResult = (StartSessionWithoutCollectorResult)this.sync(DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getStartSessionWithoutCollector(), request, this.prepareCommandTimeouts, (Function1)new Function1<StartSessionWithoutCollectorResult, Unit>(project, buildConfigurationId){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RdConfigurationAndPlatform $buildConfigurationId;
                    {
                        this.$project = $project;
                        this.$buildConfigurationId = $buildConfigurationId;
                        super(1);
                    }

                    public final void invoke(@NotNull StartSessionWithoutCollectorResult it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.$project)).getDetachSession().fire((Object)new DetachSessionArgs(this.$buildConfigurationId, it.getSessionId(), true));
                    }
                });
            }
            catch (Throwable t$iv) {
                try {
                    String eventKind$iv = t$iv instanceof ProcessCanceledException || t$iv instanceof CancellationException ? "Cancelled" : "Exception";
                    hadException$iv = true;
                    StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<" + eventKind$iv + "> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    throw t$iv;
                }
                catch (Throwable throwable) {
                    if (!hadException$iv) {
                        StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    }
                    throw throwable;
                }
            }
            StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
            object = Result.constructor-impl((Object)startSessionWithoutCollectorResult);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        StartSessionWithoutCollectorResult startSessionWithoutCollectorResult = (StartSessionWithoutCollectorResult)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        if (startSessionWithoutCollectorResult == null) {
            return null;
        }
        StartSessionWithoutCollectorResult prepareForRunResult2 = startSessionWithoutCollectorResult;
        if (prepareForRunResult2.getSessionResult() != SessionResult.Success) {
            DpaProcessAdapter dpaProcessAdapter;
            if (prepareForRunResult2.getSessionResult() == SessionResult.RootProcessFiltered) {
                dpaProcessAdapter = this.createAttachChildrenProcessListener(project, buildConfigurationId, exePath, commandLine);
            } else {
                this.logger.warn(this.dpaIsNotPreparedPrefix + prepareForRunResult2.getSessionResult());
                dpaProcessAdapter = null;
            }
            return dpaProcessAdapter;
        }
        if (prepareForRunResult2.getDetachEventName() == null) {
            this.logger.warn(this.dpaIsNotPreparedPrefix + "detachEventName is null");
            return null;
        }
        File workerLogDir = RiderDebugRunner.Companion.createLogSubDir(project, "DpaRunner", "JetBrains.DPA.Runner");
        GeneralCommandLine $this$patchRunCommandLineDpaRunner_u24lambda_u244 = commandLine;
        boolean bl = false;
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.withExePath(runner.getAbsolutePath());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.getParametersList().addAt(0, exePath);
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.getParametersList().addAt(0, "--detach-event-name=" + prepareForRunResult2.getDetachEventName());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.getParametersList().addAt(0, "--etw-collect-flags=" + UInt.toString-impl((int)prepareForRunResult2.getCollectorSessionArgs().getFlags-pVg5ArA()));
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.getParametersList().addAt(0, "--backend-pid=" + prepareForRunResult2.getPid());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.getParametersList().addAt(0, "--handle=" + prepareForRunResult2.getHandle());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.withEnvironment("RESHARPER_HOST_LOG_DIR", workerLogDir.getAbsolutePath());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.withEnvironment("RESHARPER_LOG_CONF", RiderEnvironment.INSTANCE.getLogBackendConf());
        $this$patchRunCommandLineDpaRunner_u24lambda_u244.withEnvironment(probingPaths.getKey(), probingPaths.getValue());
        DpaStatistics.Companion.getInstance(project).runExecuted(RunType.Run, prepareForRunResult2.getStatisticsActivityId());
        return this.createProcessListener(project, buildConfigurationId, prepareForRunResult2.getSessionId());
    }

    private final createProcessListener.1 createProcessListener(Project project, RdConfigurationAndPlatform buildConfigurationId, long sessionId) {
        CoroutineScope coroutineScope = this.coroutineScope;
        return new DpaProcessAdapter(project, buildConfigurationId, sessionId, coroutineScope){
            final /* synthetic */ long $sessionId;
            {
                this.$sessionId = $sessionId;
                super($super_call_param$1, $project, $buildConfigurationId);
            }

            public void startNotified(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.startNotified(event);
                ProcessHandler processHandler = event.getProcessHandler();
                Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                this.initSession(processHandler, this.$sessionId);
            }
        };
    }

    private final createAttachChildrenProcessListener.1 createAttachChildrenProcessListener(Project project, RdConfigurationAndPlatform buildConfigurationId, String exePath, GeneralCommandLine commandLine) {
        CoroutineScope coroutineScope = this.coroutineScope;
        return new DpaProcessAdapter(commandLine, project, buildConfigurationId, this, exePath, coroutineScope){
            @NotNull
            private Map<String, String> environment;
            final /* synthetic */ Project $project;
            final /* synthetic */ RdConfigurationAndPlatform $buildConfigurationId;
            final /* synthetic */ DpaExtension this$0;
            final /* synthetic */ String $exePath;
            {
                this.$project = $project;
                this.$buildConfigurationId = $buildConfigurationId;
                this.this$0 = $receiver;
                this.$exePath = $exePath;
                super($super_call_param$1, $project, $buildConfigurationId);
                Map map = $commandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                this.environment = map;
            }

            @NotNull
            public final Map<String, String> getEnvironment() {
                return this.environment;
            }

            public final void setEnvironment(@NotNull Map<String, String> map) {
                Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
                this.environment = map;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void startNotified(@NotNull ProcessEvent event) {
                Object object;
                void $this$runAndLogException$iv;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                DpaExtension.access$getLogger$p(this.this$0).info("createAttachChildrenProcessListener " + this.$exePath);
                Logger logger = DpaExtension.access$getLogger$p(this.this$0);
                DpaExtension dpaExtension = this.this$0;
                RdConfigurationAndPlatform rdConfigurationAndPlatform = this.$buildConfigurationId;
                String string = this.$exePath;
                Project project = this.$project;
                boolean $i$f$runAndLogException = false;
                void var9_8 = $this$runAndLogException$iv;
                try {
                    StartSessionResult startSessionResult;
                    void $this$runAndLogException_u24lambda_u240$iv = var9_8;
                    boolean bl = false;
                    boolean bl2 = false;
                    ProcessHandler processHandler = event.getProcessHandler();
                    BaseOSProcessHandler baseOSProcessHandler = processHandler instanceof BaseOSProcessHandler ? (BaseOSProcessHandler)processHandler : null;
                    if (baseOSProcessHandler == null) {
                        startSessionResult = null;
                    } else {
                        void $this$doCalculation_u24default$iv;
                        StartSessionResult startSessionResult2;
                        BaseOSProcessHandler handler = baseOSProcessHandler;
                        Process process = handler.getProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
                        Process process2 = process;
                        int pid = OSProcessUtil.getProcessID((Process)process2);
                        Logger logger2 = DpaExtension.access$getLogger$p(dpaExtension);
                        String key$iv = "askBackendToAttach";
                        Object message$iv = null;
                        boolean $i$f$doCalculation = false;
                        boolean hadException$iv = false;
                        long startTime$iv = System.nanoTime();
                        try {
                            boolean bl3 = false;
                            DpaEnvVars dpaEnvVars = DpaExtension.access$getDpaEnvVars(dpaExtension, this.environment);
                            StartSessionArgs request = new StartSessionArgs(rdConfigurationAndPlatform, false, true, true, string, pid, null, dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling());
                            startSessionResult2 = (StartSessionResult)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getStartSession().sync((Object)request, DpaExtension.access$getPrepareCommandTimeouts$p(dpaExtension));
                        }
                        catch (Throwable t$iv) {
                            try {
                                String eventKind$iv = t$iv instanceof ProcessCanceledException || t$iv instanceof CancellationException ? "Cancelled" : "Exception";
                                hadException$iv = true;
                                StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<" + eventKind$iv + "> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                                throw t$iv;
                            }
                            catch (Throwable throwable) {
                                if (!hadException$iv) {
                                    StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                                }
                                throw throwable;
                            }
                        }
                        StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                        startSessionResult = startSessionResult2;
                    }
                    object = Result.constructor-impl(startSessionResult);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                StartSessionResult startSessionResult = (StartSessionResult)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
                if (startSessionResult == null) {
                    return;
                }
                StartSessionResult attachResult = startSessionResult;
                if (attachResult.getSessionResult() != SessionResult.Success) {
                    DpaExtension.access$getLogger$p(this.this$0).warn(DpaExtension.access$getDpaIsNotPreparedPrefix$p(this.this$0) + attachResult.getSessionResult());
                    return;
                }
                ProcessHandler processHandler = event.getProcessHandler();
                Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                this.initSession(processHandler, attachResult.getSessionId());
            }
        };
    }

    public static final /* synthetic */ Logger access$getLogger$p(DpaExtension $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getDpaIsNotPreparedPrefix$p(DpaExtension $this) {
        return $this.dpaIsNotPreparedPrefix;
    }

    public static final /* synthetic */ createProcessListener.1 access$createProcessListener(DpaExtension $this, Project project, RdConfigurationAndPlatform buildConfigurationId, long sessionId) {
        return $this.createProcessListener(project, buildConfigurationId, sessionId);
    }

    public static final /* synthetic */ createAttachChildrenProcessListener.1 access$createAttachChildrenProcessListener(DpaExtension $this, Project project, RdConfigurationAndPlatform buildConfigurationId, String exePath, GeneralCommandLine commandLine) {
        return $this.createAttachChildrenProcessListener(project, buildConfigurationId, exePath, commandLine);
    }

    public static final /* synthetic */ DpaEnvVars access$getDpaEnvVars(DpaExtension $this, Map environment) {
        return $this.getDpaEnvVars(environment);
    }

    public static final /* synthetic */ RpcTimeouts access$getPrepareCommandTimeouts$p(DpaExtension $this) {
        return $this.prepareCommandTimeouts;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "", "dpaMode", "", "dpaAgentEnable", "clrEnableProfiling", "enableProfiling", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClrEnableProfiling", "()Ljava/lang/String;", "getDpaAgentEnable", "getDpaMode", "getEnableProfiling", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class DpaEnvVars {
        @NotNull
        private final String dpaMode;
        @NotNull
        private final String dpaAgentEnable;
        @NotNull
        private final String clrEnableProfiling;
        @NotNull
        private final String enableProfiling;

        public DpaEnvVars(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            this.dpaMode = dpaMode;
            this.dpaAgentEnable = dpaAgentEnable;
            this.clrEnableProfiling = clrEnableProfiling;
            this.enableProfiling = enableProfiling;
        }

        @NotNull
        public final String getDpaMode() {
            return this.dpaMode;
        }

        @NotNull
        public final String getDpaAgentEnable() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String getClrEnableProfiling() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String getEnableProfiling() {
            return this.enableProfiling;
        }

        @NotNull
        public final String component1() {
            return this.dpaMode;
        }

        @NotNull
        public final String component2() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String component3() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String component4() {
            return this.enableProfiling;
        }

        @NotNull
        public final DpaEnvVars copy(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            return new DpaEnvVars(dpaMode, dpaAgentEnable, clrEnableProfiling, enableProfiling);
        }

        public static /* synthetic */ DpaEnvVars copy$default(DpaEnvVars dpaEnvVars, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dpaEnvVars.dpaMode;
            }
            if ((n & 2) != 0) {
                string2 = dpaEnvVars.dpaAgentEnable;
            }
            if ((n & 4) != 0) {
                string3 = dpaEnvVars.clrEnableProfiling;
            }
            if ((n & 8) != 0) {
                string4 = dpaEnvVars.enableProfiling;
            }
            return dpaEnvVars.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DpaEnvVars(dpaMode=" + this.dpaMode + ", dpaAgentEnable=" + this.dpaAgentEnable + ", clrEnableProfiling=" + this.clrEnableProfiling + ", enableProfiling=" + this.enableProfiling + ")";
        }

        public int hashCode() {
            int result = this.dpaMode.hashCode();
            result = result * 31 + this.dpaAgentEnable.hashCode();
            result = result * 31 + this.clrEnableProfiling.hashCode();
            result = result * 31 + this.enableProfiling.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DpaEnvVars)) {
                return false;
            }
            DpaEnvVars dpaEnvVars = (DpaEnvVars)other;
            if (!Intrinsics.areEqual((Object)this.dpaMode, (Object)dpaEnvVars.dpaMode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dpaAgentEnable, (Object)dpaEnvVars.dpaAgentEnable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clrEnableProfiling, (Object)dpaEnvVars.clrEnableProfiling)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enableProfiling, (Object)dpaEnvVars.enableProfiling);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010(\u001a\u00020\nH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DpaProcessAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "buildConfigurationId", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;)V", "alreadyDetached", "", "getAlreadyDetached", "()Z", "setAlreadyDetached", "(Z)V", "getBuildConfigurationId", "()Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "dpaSessionLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getDpaSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "setDpaSessionLifetime", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "sessionId", "", "getSessionId", "()Ljava/lang/Long;", "setSessionId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "initSession", "", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "processTerminated", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processWillTerminate", "willBeDestroyed", "intellij.rider.plugins.dpa"})
    private static class DpaProcessAdapter
    extends ProcessAdapter {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final Project project;
        @Nullable
        private final RdConfigurationAndPlatform buildConfigurationId;
        @Nullable
        private Long sessionId;
        private boolean alreadyDetached;
        @NotNull
        private LifetimeDefinition dpaSessionLifetime;

        public DpaProcessAdapter(@NotNull CoroutineScope coroutineScope, @NotNull Project project, @Nullable RdConfigurationAndPlatform buildConfigurationId) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.coroutineScope = coroutineScope;
            this.project = project;
            this.buildConfigurationId = buildConfigurationId;
            this.dpaSessionLifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public final RdConfigurationAndPlatform getBuildConfigurationId() {
            return this.buildConfigurationId;
        }

        @Nullable
        protected final Long getSessionId() {
            return this.sessionId;
        }

        protected final void setSessionId(@Nullable Long l) {
            this.sessionId = l;
        }

        protected final boolean getAlreadyDetached() {
            return this.alreadyDetached;
        }

        protected final void setAlreadyDetached(boolean bl) {
            this.alreadyDetached = bl;
        }

        @NotNull
        protected final LifetimeDefinition getDpaSessionLifetime() {
            return this.dpaSessionLifetime;
        }

        protected final void setDpaSessionLifetime(@NotNull LifetimeDefinition lifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"<set-?>");
            this.dpaSessionLifetime = lifetimeDefinition;
        }

        protected final void initSession(@NotNull ProcessHandler processHandler, long sessionId) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            this.sessionId = sessionId;
            DpaSessions.Companion.getInstance(this.project).addSession(processHandler, (Lifetime)this.dpaSessionLifetime, sessionId);
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ DpaProcessAdapter this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                LifetimeDefinition.terminate$default((LifetimeDefinition)this.this$0.getDpaSessionLifetime(), (boolean)false, (int)1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                Long l = this.sessionId;
                if (l == null) break block0;
                long it = ((Number)l).longValue();
                boolean bl = false;
                SwingUtilities.invokeLater(() -> DpaProcessAdapter.processWillTerminate$lambda$1$lambda$0(this, willBeDestroyed, it));
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Long l = this.sessionId;
                if (l == null) break block0;
                long it = ((Number)l).longValue();
                boolean bl = false;
                SwingUtilities.invokeLater(() -> DpaProcessAdapter.processTerminated$lambda$3$lambda$2(this, it));
            }
        }

        private static final void processWillTerminate$lambda$1$lambda$0(DpaProcessAdapter this$0, boolean $willBeDestroyed, long $it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (!(this$0.project.isDisposed() || $willBeDestroyed || this$0.alreadyDetached)) {
                DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getDetachSession().fire((Object)new DetachSessionArgs(this$0.buildConfigurationId, $it, false));
                this$0.alreadyDetached = true;
            }
        }

        private static final void processTerminated$lambda$3$lambda$2(DpaProcessAdapter this$0, long $it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (!this$0.project.isDisposed() && !this$0.alreadyDetached) {
                DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getDetachSession().fire((Object)new DetachSessionArgs(this$0.buildConfigurationId, $it, true));
                this$0.alreadyDetached = true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class ProbingPathsEnvVar {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public ProbingPathsEnvVar(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final ProbingPathsEnvVar copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ProbingPathsEnvVar(key, value);
        }

        public static /* synthetic */ ProbingPathsEnvVar copy$default(ProbingPathsEnvVar probingPathsEnvVar, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = probingPathsEnvVar.key;
            }
            if ((n & 2) != 0) {
                string2 = probingPathsEnvVar.value;
            }
            return probingPathsEnvVar.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ProbingPathsEnvVar(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProbingPathsEnvVar)) {
                return false;
            }
            ProbingPathsEnvVar probingPathsEnvVar = (ProbingPathsEnvVar)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)probingPathsEnvVar.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)probingPathsEnvVar.value);
        }
    }
}

