/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.portForwarding.socket;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.codeWithMe.model.DebugTrafficInfo;
import com.jetbrains.codeWithMe.model.PortStrategy;
import com.jetbrains.codeWithMe.model.RdConnection;
import com.jetbrains.codeWithMe.model.RdForwardedPort;
import com.jetbrains.codeWithMe.model.RdPortState;
import com.jetbrains.codeWithMe.model.RdSocketAddress;
import com.jetbrains.codeWithMe.model.SocketState;
import com.jetbrains.codeWithMe.model.v;
import com.jetbrains.rd.platform.codeWithMe.CodeWithMePlatformBundle;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketWrapper;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.utils.PortForwardingUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eJ\b\u0010%\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u000eH\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020#R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006/"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdPort", "Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "uniqueId", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/codeWithMe/model/RdForwardedPort;Ljava/lang/String;)V", "_serverSocket", "Ljava/net/ServerSocket;", "_trafficThread", "Ljava/lang/Thread;", "acceptTimeout", "", "getAcceptTimeout", "()I", "clientConnectionTimeout", "getClientConnectionTimeout", "meter", "Lio/opentelemetry/api/metrics/Meter;", "name", "getRdPort", "()Lcom/jetbrains/codeWithMe/model/RdForwardedPort;", "receivedBytesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "sentBytesCounter", "serverSocket", "getServerSocket", "()Ljava/net/ServerSocket;", "trafficThread", "getTrafficThread", "()Ljava/lang/Thread;", "changeListeningSocket", "", "newPort", "createListeningSocket", "createListeningThread", "socket", "createNewSocket", "port", "monitorOneConnection", "clientSocket", "Ljava/net/Socket;", "start", "Companion", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nServerSocketWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,324:1\n58#2,5:325\n58#2,5:330\n13#2:336\n13#3:335\n*S KotlinDebug\n*F\n+ 1 ServerSocketWrapper.kt\ncom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper\n*L\n144#1:325,5\n281#1:330,5\n33#1:336\n33#1:335\n*E\n"})
public final class ServerSocketWrapper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdForwardedPort rdPort;
    @NotNull
    private final String name;
    @NotNull
    private final Meter meter;
    private final LongCounter sentBytesCounter;
    private final LongCounter receivedBytesCounter;
    @Nullable
    private ServerSocket _serverSocket;
    @Nullable
    private Thread _trafficThread;
    @NotNull
    private static final Logger logger;
    private static final String[] a;
    private static final String[] b;

    public ServerSocketWrapper(@NotNull Lifetime lifetime, @NotNull RdForwardedPort rdPort, @NotNull String uniqueId) {
        long l2 = 97048756194679L;
        int n2 = ServerSocketPortState.N();
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)ServerSocketWrapper.a(-324791460 + -((char)-28538), -324791460 + -7077, (int)l2));
        int n3 = n2;
        Intrinsics.checkNotNullParameter((Object)rdPort, (String)ServerSocketWrapper.a(-324791460 + -((char)-28539), 324791460 + (char)-32516, (int)l2));
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)ServerSocketWrapper.a(-324791460 + -((char)-28536), -324791460 + -19501, (int)l2));
        this.lifetime = lifetime;
        this.rdPort = rdPort;
        this.name = StringsKt.take((String)uniqueId, (int)7);
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.sentBytesCounter = this.meter.counterBuilder(ServerSocketWrapper.a(-324791460 + -((char)-28537), 324791460 + 27594, (int)l2) + this.name).setUnit(ServerSocketWrapper.a(-324791460 + -((char)-28534), -324791460 + -27238, (int)l2)).build();
        this.receivedBytesCounter = this.meter.counterBuilder(ServerSocketWrapper.a(-324791460 + -((char)-28535), 324791460 + (char)-28632, (int)l2) + this.name).setUnit(ServerSocketWrapper.a(-324791460 + -((char)-28532), 324791460 + 14693, (int)l2)).build();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            /*
             * Loose catch block
             */
            public final void invoke() {
                block7: {
                    long l2 = 21907794542357L;
                    int n2 = ServerSocketPortState.N();
                    try {
                        ServerSocket serverSocket;
                        block6: {
                            serverSocket = this.getServerSocket();
                            if (n2 == 0) break block6;
                            try {
                                block8: {
                                    if (serverSocket.isClosed()) break block7;
                                    break block8;
                                    catch (Throwable throwable) {
                                        throw 1.a(throwable);
                                    }
                                }
                                serverSocket = this.getServerSocket();
                            }
                            catch (Throwable throwable) {
                                throw 1.a(throwable);
                            }
                        }
                        serverSocket.close();
                    }
                    catch (Throwable throwable) {
                        Companion.getLogger().warn(throwable);
                    }
                }
            }

            private static Throwable a(Throwable throwable) {
                return throwable;
            }
        });
        if (CodeWithMePlatformBundle.N() != 0) {
            ServerSocketPortState.j(++n3);
        }
    }

    @NotNull
    public final RdForwardedPort getRdPort() {
        return this.rdPort;
    }

    private final int getAcceptTimeout() {
        long l2 = 26138013401658L;
        return Registry.intValue((String)ServerSocketWrapper.a(-1157610240 - -((char)-14180), -1157479170 + -((char)-8340), (int)l2));
    }

    private final int getClientConnectionTimeout() {
        long l2 = 41590334301443L;
        return Registry.intValue((String)ServerSocketWrapper.a(-2128970010 + -21564, 2128970010 + 914, (int)l2));
    }

    private final ServerSocket getServerSocket() {
        ServerSocket serverSocket;
        block5: {
            long l2;
            block4: {
                l2 = 136959378242717L;
                int n2 = ServerSocketPortState.j();
                try {
                    try {
                        if (n2 != 0) break block4;
                        serverSocket = this._serverSocket;
                        if (serverSocket != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
            }
            throw new IllegalStateException(ServerSocketWrapper.a(1461168360 - (char)-2637, 1461037290 + (char)-1960, (int)l2).toString());
        }
        return serverSocket;
    }

    private final Thread getTrafficThread() {
        Thread thread2;
        block5: {
            long l2;
            block4: {
                l2 = 110598367301929L;
                int n2 = ServerSocketPortState.j();
                try {
                    try {
                        if (n2 != 0) break block4;
                        thread2 = this._trafficThread;
                        if (thread2 != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
            }
            throw new IllegalStateException(ServerSocketWrapper.a(-1335472230 + -((char)-3816), -1335603300 - -((char)-20324), (int)l2).toString());
        }
        return thread2;
    }

    public final void start() {
        long l2 = 79418156298852L;
        this._serverSocket = this.createListeningSocket();
        this._trafficThread = this.createListeningThread(this.getServerSocket());
        logger.info(ServerSocketWrapper.a(-84015870 - -((char)-18228), 84015870 - (char)-24238, (int)l2) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + ServerSocketWrapper.a(-84015870 - -((char)-18233), -84015870 - -((char)-29821), (int)l2) + this.rdPort.getPortNumber());
        this.getTrafficThread().start();
    }

    public final void changeListeningSocket(int newPort) {
        ServerSocket serverSocket = this.createNewSocket(newPort);
        Thread thread2 = this.createListeningThread(serverSocket);
        this.getServerSocket().close();
        this._serverSocket = serverSocket;
        this._trafficThread = thread2;
        ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.changeListeningSocket$lambda$0(this), ModalityState.any());
        this.getTrafficThread().start();
    }

    private final ServerSocket createNewSocket(int port) throws IllegalStateException, IOException {
        Object object;
        ServerSocket serverSocket;
        block15: {
            Object object2;
            long l2;
            block12: {
                block13: {
                    l2 = 4242945413706L;
                    serverSocket = new ServerSocket();
                    int n2 = ServerSocketPortState.N();
                    try {
                        try {
                            serverSocket.setReuseAddress(true);
                            object2 = this;
                            if (n2 == 0) break block12;
                            if (((ServerSocketWrapper)object2).getAcceptTimeout() <= 0) break block13;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        serverSocket.setSoTimeout(this.getAcceptTimeout());
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                object2 = this.rdPort.getRdPortState().getValueOrNull();
            }
            try {
                block14: {
                    try {
                        try {
                            try {
                                object = (RdPortState)object2;
                                if (object == null || (object = object.getSocketAddress()) == null) break block14;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw ServerSocketWrapper.a(illegalStateException);
                            }
                            if ((object = PortForwardingUtilsKt.toSocketAddress((RdSocketAddress)object)) == null) break block14;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        if ((object = ((InetSocketAddress)object).getAddress()) != null) break block15;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ServerSocketWrapper.a(illegalStateException);
                    }
                }
                object = Inet4Address.getByName(ServerSocketWrapper.a(-482206530 + -((char)-296), 482206530 + (char)-17408, (int)l2));
            }
            catch (IllegalStateException illegalStateException) {
                throw ServerSocketWrapper.a(illegalStateException);
            }
        }
        Object object3 = object;
        serverSocket.bind(new InetSocketAddress((InetAddress)object3, port), 1000);
        return serverSocket;
    }

    /*
     * Unable to fully structure code
     */
    private final ServerSocket createListeningSocket() {
        block16: {
            block15: {
                block14: {
                    var1_1 = 118931687767925L;
                    var4_2 = this.rdPort.getPortStrategy();
                    var3_3 = ServerSocketPortState.N();
                    if (var3_3 == 0) break block14;
                    try {
                        v0 = this.rdPort.getDesiredSocketAddress();
                        if (v0 != null) break block15;
                        break block14;
                        catch (IOException v1) {
                            throw ServerSocketWrapper.a(v1);
                        }
                    }
                    catch (IOException v2) {
                        throw ServerSocketWrapper.a(v2);
                    }
                }
                v0 = new RdSocketAddress(ServerSocketWrapper.a(-251654400 - -25050, -251654400 + -3631, (int)var1_1), this.rdPort.getPortNumber());
            }
            var5_4 = v0;
            var6_5 = new ServerSocket();
            var6_5.setReuseAddress(true);
            v3 = this;
            if (var3_3 == 0) ** GOTO lbl38
            try {
                block17: {
                    if (v3.getAcceptTimeout() <= 0) break block16;
                    break block17;
                    catch (IOException v4) {
                        throw ServerSocketWrapper.a(v4);
                    }
                }
                var6_5.setSoTimeout(this.getAcceptTimeout());
            }
            catch (IOException v5) {
                throw ServerSocketWrapper.a(v5);
            }
        }
        try {
            var6_5.bind(PortForwardingUtilsKt.toSocketAddress(var5_4), 1000);
            v3 = this;
lbl38:
            // 2 sources

            v3.rdPort.getRdPortState().set((Object)new RdPortState(SocketState.LISTENING, var5_4, null));
            return var6_5;
        }
        catch (IOException var7_6) {
            switch (WhenMappings.$EnumSwitchMapping$0[var4_2.ordinal()]) {
                case 1: {
                    var8_7 = PortForwardingUtilsKt.toSocketAddress(var5_4).getAddress();
                    var6_5.bind(new InetSocketAddress(var8_7, 0), 1000);
                    v6 = this.rdPort.getRdPortState();
                    v7 = var8_7.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)ServerSocketWrapper.a(-251654400 - -25051, -251654400 - -24750, (int)var1_1));
                    v8 = var6_5.getLocalSocketAddress();
                    Intrinsics.checkNotNull((Object)v8, (String)ServerSocketWrapper.a(-251654400 - -25028, 251654400 + 758, (int)var1_1));
                    v6.set((Object)new RdPortState(SocketState.LISTENING, new RdSocketAddress(v7, ((InetSocketAddress)v8).getPort()), null));
                    return var6_5;
                }
                case 2: {
                    throw var7_6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void monitorOneConnection(Socket clientSocket) {
        block9: {
            RdConnection rdConnection;
            block10: {
                Object object;
                Logger logger;
                int n2;
                int n3;
                LifetimeDefinition lifetimeDefinition;
                Logger logger2;
                String string;
                int n4;
                long l2;
                block7: {
                    block8: {
                        l2 = 1527723339235L;
                        int n5 = ServerSocketPortState.j();
                        n4 = this.rdPort.getPortNumber();
                        String string2 = UUID.randomUUID().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)ServerSocketWrapper.a(-1285010280 + -10821, 1285010280 + 16056, (int)l2));
                        string = string2;
                        logger2 = ServerSocketWrapper.logger;
                        lifetimeDefinition = null;
                        boolean bl = false;
                        n3 = n5;
                        try {
                            n2 = logger2.isDebugEnabled();
                            if (n3 != 0) break block7;
                            if (n2 == 0) break block8;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ServerSocketWrapper.a(illegalStateException);
                        }
                        logger = logger2;
                        boolean bl2 = false;
                        String string3 = string;
                        int n6 = n4;
                        String string4 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState())));
                        int n7 = clientSocket.getPort();
                        logger.debug(ServerSocketWrapper.a(-1285010280 + -10824, -1285010280 + -3077, (int)l2) + n7 + ServerSocketWrapper.a(-1285010280 + -10823, 1285010280 + 14238, (int)l2) + string4 + ServerSocketWrapper.a(-1285010280 + -10823, 1285010280 + 14238, (int)l2) + n6 + ServerSocketWrapper.a(-1285010280 + -10818, -1285010280 + -7686, (int)l2) + string3, (Throwable)lifetimeDefinition);
                    }
                    n2 = this.getClientConnectionTimeout();
                }
                try {
                    if (n2 > 0) {
                        clientSocket.setSoTimeout(this.getClientConnectionTimeout());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
                logger2 = new SingleThreadScheduler(this.lifetime, ServerSocketWrapper.a(-1285010280 + -10817, 1285010280 + 14244, (int)l2) + n4);
                lifetimeDefinition = this.lifetime.createNested();
                Lifetime lifetime = lifetimeDefinition.getLifetime();
                Object object2 = object = new RdConnection(string, clientSocket.getPort());
                boolean bl = false;
                PortForwardingUtilsKt.setScheduler(object2, (IScheduler)logger2);
                rdConnection = object;
                rdConnection.getToServerSocket().advise(lifetime, (Function1)new Function1<DebugTrafficInfo, Unit>(this, clientSocket, string, lifetimeDefinition){
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.this$0 = $receiver;
                        this.$clientSocket = $clientSocket;
                        this.$connectionId = $connectionId;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        super(1);
                    }

                    public final void invoke(@NotNull DebugTrafficInfo it) {
                        block4: {
                            long l2;
                            block5: {
                                l2 = 106396897702950L;
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.2.a(1967884980 - (char)-10585, 1967884980 - (char)-10556, (int)l2));
                                Logger logger = ServerSocketWrapper.Companion.getLogger();
                                String string = this.$connectionId;
                                int n2 = ServerSocketPortState.N();
                                boolean bl = false;
                                try {
                                    if (n2 == 0) break block4;
                                    if (!logger.isTraceEnabled()) break block5;
                                }
                                catch (IOException iOException) {
                                    throw monitorOneConnection.2.a(iOException);
                                }
                                Logger logger2 = logger;
                                boolean bl2 = false;
                                String string2 = string;
                                int n3 = it.getBytes().length;
                                int n4 = it.getCounter();
                                logger2.trace(monitorOneConnection.2.a(1967884980 - (char)-10584, -1967884980 - -((char)-17451), (int)l2) + n4 + monitorOneConnection.2.a(1967884980 - (char)-10587, 1967884980 - (char)-8044, (int)l2) + n3 + monitorOneConnection.2.a(1967884980 - (char)-10586, 1967884980 - (char)-29275, (int)l2) + string2);
                            }
                            try {
                                ServerSocketWrapper.access$getReceivedBytesCounter$p(this.this$0).add((long)it.getBytes().length);
                                this.$clientSocket.getOutputStream().write(it.getBytes());
                            }
                            catch (IOException iOException) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.2.a(1967884980 - (char)-10581, 1967884980 - (char)-25300, (int)l2) + this.$connectionId);
                                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                        }
                    }

                    private static IOException a(IOException iOException) {
                        return iOException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[5];
                                var3_1 = 0;
                                var2_2 = "\u00fak\u0010|\u00b4\u00b9\u00e4^\u00e1c\u00cc0z\u0089\bNG=\u00b4\u0013\u00ab\u0098J\b\u0017a\u00c6K\u00c9\u00e7c\u0014o\u0093\u008c\u00a0\u00d9\u00c5\u00dd";
                                var4_3 = "\u00fak\u0010|\u00b4\u00b9\u00e4^\u00e1c\u00cc0z\u0089\bNG=\u00b4\u0013\u00ab\u0098J\b\u0017a\u00c6K\u00c9\u00e7c\u0014o\u0093\u008c\u00a0\u00d9\u00c5\u00dd".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 98;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u00cd<\u00a1\u00a8\u00f4\u00ae:\u001c\u0093\u00bc<\bq\u00d0/U\u00e70\u0014\u0085\u00f2\f\u0080\u00e44\u00f8\u0014oym\u00dd\u007f\u0086\u0015\u00a3A\u0099\u009a.\nl\u00f7LZR\t`q\u00b7[\u00b9\u00d2\u00b4\"%\u00c1_\u00a9\u0019\u00f4\u001e-\u00bbF\u00bb";
                                    var4_3 = "\u00cd<\u00a1\u00a8\u00f4\u00ae:\u001c\u0093\u00bc<\bq\u00d0/U\u00e70\u0014\u0085\u00f2\f\u0080\u00e44\u00f8\u0014oym\u00dd\u007f\u0086\u0015\u00a3A\u0099\u009a.\nl\u00f7LZR\t`q\u00b7[\u00b9\u00d2\u00b4\"%\u00c1_\u00a9\u0019\u00f4\u001e-\u00bbF\u00bb".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 28;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 99;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 126;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 43;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 63;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 68;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 11;
                                            break;
                                        }
                                        default: {
                                            v15 = 47;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.2.a = var5;
                        monitorOneConnection.2.b = new String[5];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x402B) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 33;
                                case 1 -> 249;
                                case 2 -> 237;
                                case 3 -> 210;
                                case 4 -> 231;
                                case 5 -> 15;
                                case 6 -> 174;
                                case 7 -> 225;
                                case 8 -> 36;
                                case 9 -> 214;
                                case 10 -> 25;
                                case 11 -> 234;
                                case 12 -> 159;
                                case 13 -> 97;
                                case 14 -> 70;
                                case 15 -> 220;
                                case 16 -> 177;
                                case 17 -> 192;
                                case 18 -> 140;
                                case 19 -> 211;
                                case 20 -> 201;
                                case 21 -> 20;
                                case 22 -> 28;
                                case 23 -> 9;
                                case 24 -> 182;
                                case 25 -> 40;
                                case 26 -> 67;
                                case 27 -> 43;
                                case 28 -> 96;
                                case 29 -> 142;
                                case 30 -> 218;
                                case 31 -> 172;
                                case 32 -> 191;
                                case 33 -> 83;
                                case 34 -> 87;
                                case 35 -> 189;
                                case 36 -> 41;
                                case 37 -> 132;
                                case 38 -> 62;
                                case 39 -> 246;
                                case 40 -> 86;
                                case 41 -> 169;
                                case 42 -> 149;
                                case 43 -> 82;
                                case 44 -> 212;
                                case 45 -> 188;
                                case 46 -> 11;
                                case 47 -> 135;
                                case 48 -> 88;
                                case 49 -> 57;
                                case 50 -> 241;
                                case 51 -> 193;
                                case 52 -> 73;
                                case 53 -> 84;
                                case 54 -> 122;
                                case 55 -> 223;
                                case 56 -> 255;
                                case 57 -> 148;
                                case 58 -> 187;
                                case 59 -> 44;
                                case 60 -> 195;
                                case 61 -> 61;
                                case 62 -> 26;
                                case 63 -> 233;
                                case 64 -> 108;
                                case 65 -> 141;
                                case 66 -> 45;
                                case 67 -> 78;
                                case 68 -> 109;
                                case 69 -> 208;
                                case 70 -> 206;
                                case 71 -> 6;
                                case 72 -> 102;
                                case 73 -> 90;
                                case 74 -> 243;
                                case 75 -> 16;
                                case 76 -> 58;
                                case 77 -> 121;
                                case 78 -> 47;
                                case 79 -> 164;
                                case 80 -> 12;
                                case 81 -> 205;
                                case 82 -> 179;
                                case 83 -> 117;
                                case 84 -> 219;
                                case 85 -> 113;
                                case 86 -> 98;
                                case 87 -> 254;
                                case 88 -> 24;
                                case 89 -> 170;
                                case 90 -> 14;
                                case 91 -> 247;
                                case 92 -> 126;
                                case 93 -> 186;
                                case 94 -> 196;
                                case 95 -> 32;
                                case 96 -> 72;
                                case 97 -> 144;
                                case 98 -> 1;
                                case 99 -> 137;
                                case 100 -> 131;
                                case 101 -> 31;
                                case 102 -> 146;
                                case 103 -> 71;
                                case 104 -> 133;
                                case 105 -> 127;
                                case 106 -> 153;
                                case 107 -> 134;
                                case 108 -> 49;
                                case 109 -> 8;
                                case 110 -> 165;
                                case 111 -> 129;
                                case 112 -> 89;
                                case 113 -> 240;
                                case 114 -> 101;
                                case 115 -> 69;
                                case 116 -> 99;
                                case 117 -> 105;
                                case 118 -> 74;
                                case 119 -> 150;
                                case 120 -> 183;
                                case 121 -> 51;
                                case 122 -> 4;
                                case 123 -> 95;
                                case 124 -> 17;
                                case 125 -> 248;
                                case 126 -> 173;
                                case 127 -> 116;
                                case 128 -> 91;
                                case 129 -> 181;
                                case 130 -> 48;
                                case 131 -> 238;
                                case 132 -> 168;
                                case 133 -> 180;
                                case 134 -> 227;
                                case 135 -> 194;
                                case 136 -> 252;
                                case 137 -> 79;
                                case 138 -> 215;
                                case 139 -> 106;
                                case 140 -> 156;
                                case 141 -> 138;
                                case 142 -> 143;
                                case 143 -> 239;
                                case 144 -> 112;
                                case 145 -> 37;
                                case 146 -> 2;
                                case 147 -> 171;
                                case 148 -> 115;
                                case 149 -> 217;
                                case 150 -> 23;
                                case 151 -> 81;
                                case 152 -> 151;
                                case 153 -> 94;
                                case 154 -> 21;
                                case 155 -> 213;
                                case 156 -> 107;
                                case 157 -> 55;
                                case 158 -> 75;
                                case 159 -> 190;
                                case 160 -> 229;
                                case 161 -> 232;
                                case 162 -> 152;
                                case 163 -> 123;
                                case 164 -> 29;
                                case 165 -> 245;
                                case 166 -> 52;
                                case 167 -> 114;
                                case 168 -> 147;
                                case 169 -> 242;
                                case 170 -> 124;
                                case 171 -> 163;
                                case 172 -> 10;
                                case 173 -> 236;
                                case 174 -> 178;
                                case 175 -> 155;
                                case 176 -> 158;
                                case 177 -> 184;
                                case 178 -> 139;
                                case 179 -> 46;
                                case 180 -> 226;
                                case 181 -> 7;
                                case 182 -> 235;
                                case 183 -> 167;
                                case 184 -> 224;
                                case 185 -> 175;
                                case 186 -> 120;
                                case 187 -> 209;
                                case 188 -> 66;
                                case 189 -> 204;
                                case 190 -> 110;
                                case 191 -> 119;
                                case 192 -> 160;
                                case 193 -> 56;
                                case 194 -> 65;
                                case 195 -> 221;
                                case 196 -> 161;
                                case 197 -> 38;
                                case 198 -> 136;
                                case 199 -> 77;
                                case 200 -> 162;
                                case 201 -> 244;
                                case 202 -> 228;
                                case 203 -> 22;
                                case 204 -> 197;
                                case 205 -> 145;
                                case 206 -> 63;
                                case 207 -> 125;
                                case 208 -> 111;
                                case 209 -> 93;
                                case 210 -> 130;
                                case 211 -> 30;
                                case 212 -> 185;
                                case 213 -> 118;
                                case 214 -> 50;
                                case 215 -> 157;
                                case 216 -> 60;
                                case 217 -> 199;
                                case 218 -> 35;
                                case 219 -> 203;
                                case 220 -> 92;
                                case 221 -> 3;
                                case 222 -> 166;
                                case 223 -> 39;
                                case 224 -> 251;
                                case 225 -> 59;
                                case 226 -> 0;
                                case 227 -> 18;
                                case 228 -> 34;
                                case 229 -> 250;
                                case 230 -> 176;
                                case 231 -> 13;
                                case 232 -> 54;
                                case 233 -> 64;
                                case 234 -> 128;
                                case 235 -> 253;
                                case 236 -> 76;
                                case 237 -> 207;
                                case 238 -> 42;
                                case 239 -> 19;
                                case 240 -> 198;
                                case 241 -> 85;
                                case 242 -> 53;
                                case 243 -> 202;
                                case 244 -> 222;
                                case 245 -> 216;
                                case 246 -> 80;
                                case 247 -> 104;
                                case 248 -> 200;
                                case 249 -> 27;
                                case 250 -> 103;
                                case 251 -> 68;
                                case 252 -> 100;
                                case 253 -> 230;
                                case 254 -> 154;
                                default -> 5;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.2.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                rdConnection.getDestinationSocketInputShutdown().advise(lifetime, (Function1)new Function1<Unit, Unit>(clientSocket, lifetimeDefinition, n4, string){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull Unit it) {
                        block15: {
                            block13: {
                                var2_2 = 30139352579729L;
                                v0 = ServerSocketPortState.N();
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.3.a(1567072920 - 14701, -1567072920 - -11401, (int)var2_2));
                                var5_3 = ServerSocketWrapper.Companion.getLogger();
                                var7_5 = this.$portNumber;
                                var8_6 = this.$connectionId;
                                var6_7 = null;
                                var4_8 = v0;
                                var9_9 = false;
                                try {
                                    v1 = var5_3.isDebugEnabled();
                                    if (var4_8 != 0) {
                                        if (!v1) break block13;
                                    }
                                    ** GOTO lbl29
                                }
                                catch (Throwable v2) {
                                    throw monitorOneConnection.3.a(v2);
                                }
                                var11_10 = var5_3;
                                var10_11 = false;
                                var11_10.debug(monitorOneConnection.3.a(1567072920 - 14702, 1567072920 - 14931, (int)var2_2) + var7_5 + monitorOneConnection.3.a(1567072920 - 14703, -1567072920 - -29469, (int)var2_2) + var8_6, var6_7);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block17: {
                                            block18: {
                                                this.$clientSocket.shutdownOutput();
                                                v1 = this.$clientSocket.isInputShutdown();
lbl29:
                                                // 3 sources

                                                if (var4_8 == 0) break block14;
                                                if (v1) break block17;
                                                break block18;
                                                catch (Throwable v3) {
                                                    throw monitorOneConnection.3.a(v3);
                                                }
                                            }
                                            try {
                                                block19: {
                                                    v1 = this.$clientSocket.isClosed();
                                                    if (var4_8 == 0) break block14;
                                                    break block19;
                                                    catch (Throwable v4) {
                                                        throw monitorOneConnection.3.a(v4);
                                                    }
                                                }
                                                if (!v1) break block15;
                                            }
                                            catch (Throwable v5) {
                                                throw monitorOneConnection.3.a(v5);
                                            }
                                        }
                                        var5_3 = ServerSocketWrapper.Companion.getLogger();
                                        var7_5 = this.$portNumber;
                                        var8_6 = this.$connectionId;
                                        var6_7 = null;
                                        var9_9 = false;
                                        v1 = var5_3.isDebugEnabled();
                                    }
                                    try {
                                        if (var4_8 == 0) break block15;
                                        if (!v1) break block16;
                                    }
                                    catch (Throwable v6) {
                                        throw monitorOneConnection.3.a(v6);
                                    }
                                    var11_10 = var5_3;
                                    var10_11 = false;
                                    var11_10.debug(monitorOneConnection.3.a(1567072920 - 14704, -1567072920 - -11215, (int)var2_2) + var7_5 + monitorOneConnection.3.a(1567072920 - 14697, -1567072920 - -14772, (int)var2_2) + var8_6, var6_7);
                                }
                                v1 = LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                            catch (Throwable var5_4) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.3.a(1567072920 - 14698, -1567072920 - -14927, (int)var2_2) + this.$portNumber + monitorOneConnection.3.a(1567072920 - 14697, -1567072920 - -14772, (int)var2_2) + this.$connectionId, var5_4);
                            }
                        }
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[6];
                                var3_1 = 0;
                                var2_2 = "X\u00ca\u001b\u00af\u00fc\u00b1\u0085\u00be+-\u00be\u00aa\u00f79\u00ac9\u00e3\u001f\u0091#\u0092\u00b3\u00e3C\u00d1\u00e1\u00d1\u001c\u00be/\u00067GtD6NJ\u00d7\u0015\u00be\u00b8_\u008c\u0011J-i\u00c9\u007f'\u0099\u00dc\u00de[{\u00bc\u00de\u00a2v\u00dd%\u0095(\u0095&\u0001\u00f6\u007fA9\u00f0\u008d\u00a4F\u008a5(=:y\u0086\u00aa\u00d4\u001c\u00cd\u00d6b\u0000_@\u0089S?}U\u00d9\u00d2\u00de\u00d7\u009c\u0085q\u00c3\u001c\u001e\u001aB\u0091\u008b\"?";
                                var4_3 = "X\u00ca\u001b\u00af\u00fc\u00b1\u0085\u00be+-\u00be\u00aa\u00f79\u00ac9\u00e3\u001f\u0091#\u0092\u00b3\u00e3C\u00d1\u00e1\u00d1\u001c\u00be/\u00067GtD6NJ\u00d7\u0015\u00be\u00b8_\u008c\u0011J-i\u00c9\u007f'\u0099\u00dc\u00de[{\u00bc\u00de\u00a2v\u00dd%\u0095(\u0095&\u0001\u00f6\u007fA9\u00f0\u008d\u00a4F\u008a5(=:y\u0086\u00aa\u00d4\u001c\u00cd\u00d6b\u0000_@\u0089S?}U\u00d9\u00d2\u00de\u00d7\u009c\u0085q\u00c3\u001c\u001e\u001aB\u0091\u008b\"?".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 122;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u0099'\u00bfVQ\u00125\u00fa\u00ae\u0005\u00d16\u00bf\"2Ux\u00d8C\u001b\u0000E\u00f3v\u00c0\u0007\u00b7\u00cbE\u00eeG\u00ac\u000b\u00c08\u0015]k\u00b0)MAt\u001f\u00aa\u00002\u0085gpA\u0094\b\u00e1\u009e\u0088\u0004\u00ff\u008e\u00af";
                                    var4_3 = "\u0099'\u00bfVQ\u00125\u00fa\u00ae\u0005\u00d16\u00bf\"2Ux\u00d8C\u001b\u0000E\u00f3v\u00c0\u0007\u00b7\u00cbE\u00eeG\u00ac\u000b\u00c08\u0015]k\u00b0)MAt\u001f\u00aa\u00002\u0085gpA\u0094\b\u00e1\u009e\u0088\u0004\u00ff\u008e\u00af".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 67;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 8;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 30;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 102;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 26;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 63;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 120;
                                            break;
                                        }
                                        default: {
                                            v15 = 114;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.3.a = var5;
                        monitorOneConnection.3.b = new String[6];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x17BA) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 222;
                                case 1 -> 129;
                                case 2 -> 107;
                                case 3 -> 164;
                                case 4 -> 106;
                                case 5 -> 117;
                                case 6 -> 101;
                                case 7 -> 198;
                                case 8 -> 60;
                                case 9 -> 120;
                                case 10 -> 151;
                                case 11 -> 75;
                                case 12 -> 72;
                                case 13 -> 105;
                                case 14 -> 58;
                                case 15 -> 213;
                                case 16 -> 149;
                                case 17 -> 15;
                                case 18 -> 71;
                                case 19 -> 21;
                                case 20 -> 30;
                                case 21 -> 28;
                                case 22 -> 0;
                                case 23 -> 225;
                                case 24 -> 54;
                                case 25 -> 62;
                                case 26 -> 232;
                                case 27 -> 114;
                                case 28 -> 227;
                                case 29 -> 195;
                                case 30 -> 23;
                                case 31 -> 32;
                                case 32 -> 192;
                                case 33 -> 196;
                                case 34 -> 157;
                                case 35 -> 67;
                                case 36 -> 188;
                                case 37 -> 2;
                                case 38 -> 17;
                                case 39 -> 187;
                                case 40 -> 135;
                                case 41 -> 170;
                                case 42 -> 29;
                                case 43 -> 141;
                                case 44 -> 74;
                                case 45 -> 98;
                                case 46 -> 14;
                                case 47 -> 179;
                                case 48 -> 177;
                                case 49 -> 109;
                                case 50 -> 166;
                                case 51 -> 121;
                                case 52 -> 218;
                                case 53 -> 125;
                                case 54 -> 45;
                                case 55 -> 174;
                                case 56 -> 162;
                                case 57 -> 50;
                                case 58 -> 66;
                                case 59 -> 1;
                                case 60 -> 246;
                                case 61 -> 165;
                                case 62 -> 124;
                                case 63 -> 139;
                                case 64 -> 163;
                                case 65 -> 88;
                                case 66 -> 152;
                                case 67 -> 123;
                                case 68 -> 134;
                                case 69 -> 171;
                                case 70 -> 150;
                                case 71 -> 199;
                                case 72 -> 239;
                                case 73 -> 70;
                                case 74 -> 167;
                                case 75 -> 52;
                                case 76 -> 214;
                                case 77 -> 208;
                                case 78 -> 53;
                                case 79 -> 59;
                                case 80 -> 175;
                                case 81 -> 153;
                                case 82 -> 102;
                                case 83 -> 169;
                                case 84 -> 91;
                                case 85 -> 26;
                                case 86 -> 93;
                                case 87 -> 69;
                                case 88 -> 90;
                                case 89 -> 92;
                                case 90 -> 104;
                                case 91 -> 19;
                                case 92 -> 103;
                                case 93 -> 202;
                                case 94 -> 7;
                                case 95 -> 161;
                                case 96 -> 82;
                                case 97 -> 189;
                                case 98 -> 215;
                                case 99 -> 63;
                                case 100 -> 226;
                                case 101 -> 238;
                                case 102 -> 190;
                                case 103 -> 115;
                                case 104 -> 233;
                                case 105 -> 100;
                                case 106 -> 8;
                                case 107 -> 248;
                                case 108 -> 158;
                                case 109 -> 4;
                                case 110 -> 231;
                                case 111 -> 244;
                                case 112 -> 81;
                                case 113 -> 130;
                                case 114 -> 9;
                                case 115 -> 173;
                                case 116 -> 210;
                                case 117 -> 122;
                                case 118 -> 85;
                                case 119 -> 242;
                                case 120 -> 133;
                                case 121 -> 128;
                                case 122 -> 182;
                                case 123 -> 228;
                                case 124 -> 76;
                                case 125 -> 193;
                                case 126 -> 236;
                                case 127 -> 142;
                                case 128 -> 12;
                                case 129 -> 87;
                                case 130 -> 119;
                                case 131 -> 5;
                                case 132 -> 147;
                                case 133 -> 99;
                                case 134 -> 212;
                                case 135 -> 255;
                                case 136 -> 39;
                                case 137 -> 206;
                                case 138 -> 132;
                                case 139 -> 108;
                                case 140 -> 96;
                                case 141 -> 126;
                                case 142 -> 155;
                                case 143 -> 38;
                                case 144 -> 219;
                                case 145 -> 160;
                                case 146 -> 22;
                                case 147 -> 65;
                                case 148 -> 116;
                                case 149 -> 178;
                                case 150 -> 251;
                                case 151 -> 253;
                                case 152 -> 42;
                                case 153 -> 140;
                                case 154 -> 144;
                                case 155 -> 252;
                                case 156 -> 68;
                                case 157 -> 181;
                                case 158 -> 194;
                                case 159 -> 55;
                                case 160 -> 185;
                                case 161 -> 89;
                                case 162 -> 3;
                                case 163 -> 84;
                                case 164 -> 211;
                                case 165 -> 217;
                                case 166 -> 47;
                                case 167 -> 138;
                                case 168 -> 154;
                                case 169 -> 243;
                                case 170 -> 16;
                                case 171 -> 78;
                                case 172 -> 46;
                                case 173 -> 183;
                                case 174 -> 221;
                                case 175 -> 249;
                                case 176 -> 27;
                                case 177 -> 77;
                                case 178 -> 113;
                                case 179 -> 11;
                                case 180 -> 25;
                                case 181 -> 36;
                                case 182 -> 146;
                                case 183 -> 148;
                                case 184 -> 223;
                                case 185 -> 254;
                                case 186 -> 40;
                                case 187 -> 110;
                                case 188 -> 51;
                                case 189 -> 20;
                                case 190 -> 201;
                                case 191 -> 176;
                                case 192 -> 234;
                                case 193 -> 57;
                                case 194 -> 86;
                                case 195 -> 24;
                                case 196 -> 49;
                                case 197 -> 13;
                                case 198 -> 245;
                                case 199 -> 33;
                                case 200 -> 94;
                                case 201 -> 180;
                                case 202 -> 204;
                                case 203 -> 191;
                                case 204 -> 118;
                                case 205 -> 41;
                                case 206 -> 127;
                                case 207 -> 111;
                                case 208 -> 186;
                                case 209 -> 184;
                                case 210 -> 143;
                                case 211 -> 112;
                                case 212 -> 216;
                                case 213 -> 159;
                                case 214 -> 207;
                                case 215 -> 44;
                                case 216 -> 136;
                                case 217 -> 220;
                                case 218 -> 83;
                                case 219 -> 250;
                                case 220 -> 200;
                                case 221 -> 31;
                                case 222 -> 43;
                                case 223 -> 10;
                                case 224 -> 197;
                                case 225 -> 35;
                                case 226 -> 145;
                                case 227 -> 18;
                                case 228 -> 80;
                                case 229 -> 131;
                                case 230 -> 235;
                                case 231 -> 168;
                                case 232 -> 205;
                                case 233 -> 237;
                                case 234 -> 64;
                                case 235 -> 97;
                                case 236 -> 56;
                                case 237 -> 61;
                                case 238 -> 209;
                                case 239 -> 240;
                                case 240 -> 37;
                                case 241 -> 203;
                                case 242 -> 73;
                                case 243 -> 224;
                                case 244 -> 241;
                                case 245 -> 172;
                                case 246 -> 156;
                                case 247 -> 34;
                                case 248 -> 6;
                                case 249 -> 137;
                                case 250 -> 230;
                                case 251 -> 229;
                                case 252 -> 247;
                                case 253 -> 95;
                                case 254 -> 79;
                                default -> 48;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.3.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                rdConnection.getDestinationSocketOutputShutdown().advise(lifetime, (Function1)new Function1<Unit, Unit>(clientSocket, lifetimeDefinition, n4, string){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ LifetimeDefinition $rdConnectionLifetimeDef;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.$rdConnectionLifetimeDef = $rdConnectionLifetimeDef;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull Unit it) {
                        block15: {
                            block13: {
                                var2_2 = 61450913895738L;
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.4.a(-1478207460 - -18502, 1478207460 - 21687, (int)var2_2));
                                var5_3 = ServerSocketWrapper.Companion.getLogger();
                                var7_5 = this.$portNumber;
                                var8_6 = this.$connectionId;
                                var6_7 = null;
                                var9_8 = false;
                                var4_9 = ServerSocketPortState.j();
                                try {
                                    v0 = var5_3.isDebugEnabled();
                                    if (var4_9 == 0) {
                                        if (!v0) break block13;
                                    }
                                    ** GOTO lbl28
                                }
                                catch (Throwable v1) {
                                    throw monitorOneConnection.4.a(v1);
                                }
                                var11_10 = var5_3;
                                var10_11 = false;
                                var11_10.debug(monitorOneConnection.4.a(-1478207460 - -18503, 1478207460 - (char)-32712, (int)var2_2) + var7_5 + monitorOneConnection.4.a(-1478207460 - -18500, -1478207460 - -21539, (int)var2_2) + var8_6, var6_7);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block17: {
                                            block18: {
                                                this.$clientSocket.shutdownInput();
                                                v0 = this.$clientSocket.isOutputShutdown();
lbl28:
                                                // 3 sources

                                                if (var4_9 != 0) break block14;
                                                if (v0) break block17;
                                                break block18;
                                                catch (Throwable v2) {
                                                    throw monitorOneConnection.4.a(v2);
                                                }
                                            }
                                            try {
                                                block19: {
                                                    v0 = this.$clientSocket.isClosed();
                                                    if (var4_9 != 0) break block14;
                                                    break block19;
                                                    catch (Throwable v3) {
                                                        throw monitorOneConnection.4.a(v3);
                                                    }
                                                }
                                                if (!v0) break block15;
                                            }
                                            catch (Throwable v4) {
                                                throw monitorOneConnection.4.a(v4);
                                            }
                                        }
                                        var5_3 = ServerSocketWrapper.Companion.getLogger();
                                        var7_5 = this.$portNumber;
                                        var8_6 = this.$connectionId;
                                        var6_7 = null;
                                        var9_8 = false;
                                        v0 = var5_3.isDebugEnabled();
                                    }
                                    try {
                                        if (var4_9 != 0) break block15;
                                        if (!v0) break block16;
                                    }
                                    catch (Throwable v5) {
                                        throw monitorOneConnection.4.a(v5);
                                    }
                                    var11_10 = var5_3;
                                    var10_11 = false;
                                    var11_10.debug(monitorOneConnection.4.a(-1478207460 - -18501, -1478207460 - -((char)-30479), (int)var2_2) + var7_5 + monitorOneConnection.4.a(-1478207460 - -18506, 1478207460 - 14140, (int)var2_2) + var8_6, var6_7);
                                }
                                v0 = LifetimeDefinition.terminate$default((LifetimeDefinition)this.$rdConnectionLifetimeDef, (boolean)false, (int)1, null);
                            }
                            catch (Throwable var5_4) {
                                ServerSocketWrapper.Companion.getLogger().warn(monitorOneConnection.4.a(-1478207460 - -18507, -1478207460 - -20587, (int)var2_2) + this.$portNumber + monitorOneConnection.4.a(-1478207460 - -18506, 1478207460 - 14140, (int)var2_2) + this.$connectionId, var5_4);
                            }
                        }
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[6];
                                var3_1 = 0;
                                var2_2 = "7\u00e6\u001c\u00ef\u00eb\u000e\u00b9>\u00b9}\u00dc\u00f6\fj\u00bf\u0084\u00bc\u001d\u00ae\u00ceu$\u00a4\u00db\u0003\u00d7iqPwH\u0006k\u00ccH\u00eb\u00c6\u00aeL=zT\u008bu\u00ff\u0014\u0014\u00db\u0015\u00cf\u009c0\u00d8\u008b\"\u001c\u00e4~\u0096\u0090E\u00be\u00a1\\G\u00da!\u00da\u0096\u00e9\u00eb\u00e4\u00b4\u00d7\u001b\u00c3\u000e\u00d8<\u0011\u00d8\u00b5\u00b7\u00bf`\u0091\u00ff]\u00a4m\u0098 \u00e3\u00b38!\u009a\u00e4\u00b6\tY\u00e2\u00aa\u0088\u00fd\u00a4/Q\u00a5\u00bf\u00a6\u00f2@\u00ad\u00b1";
                                var4_3 = "7\u00e6\u001c\u00ef\u00eb\u000e\u00b9>\u00b9}\u00dc\u00f6\fj\u00bf\u0084\u00bc\u001d\u00ae\u00ceu$\u00a4\u00db\u0003\u00d7iqPwH\u0006k\u00ccH\u00eb\u00c6\u00aeL=zT\u008bu\u00ff\u0014\u0014\u00db\u0015\u00cf\u009c0\u00d8\u008b\"\u001c\u00e4~\u0096\u0090E\u00be\u00a1\\G\u00da!\u00da\u0096\u00e9\u00eb\u00e4\u00b4\u00d7\u001b\u00c3\u000e\u00d8<\u0011\u00d8\u00b5\u00b7\u00bf`\u0091\u00ff]\u00a4m\u0098 \u00e3\u00b38!\u009a\u00e4\u00b6\tY\u00e2\u00aa\u0088\u00fd\u00a4/Q\u00a5\u00bf\u00a6\u00f2@\u00ad\u00b1".length();
                                var1_4 = 2;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 64;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "g+\u00e1?\u00db\u001c5\u00b8\u00a0\u00cc\u00f8N\u00b9[\u00f4\u001a!\u00df2\u001a%\u00e6\u00b5\u0099>\u00e6\u00e5\u00ab\u0003\u00f1A\u00872\u00f8\u00cb\u00d2C\u00b6\u00f7\u00a6QW\u00da\u0000\u00dar\u00d3\u00c2'\u00ed\u0013\u00a0\u00b5\u009dSq\u00bb\u00a0\u00f8\u00ac";
                                    var4_3 = "g+\u00e1?\u00db\u001c5\u00b8\u00a0\u00cc\u00f8N\u00b9[\u00f4\u001a!\u00df2\u001a%\u00e6\u00b5\u0099>\u00e6\u00e5\u00ab\u0003\u00f1A\u00872\u00f8\u00cb\u00d2C\u00b6\u00f7\u00a6QW\u00da\u0000\u00dar\u00d3\u00c2'\u00ed\u0013\u00a0\u00b5\u009dSq\u00bb\u00a0\u00f8\u00ac".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 73;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 68;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 27;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 37;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 25;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 93;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 112;
                                            break;
                                        }
                                        default: {
                                            v15 = 3;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.4.a = var5;
                        monitorOneConnection.4.b = new String[6];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x7558) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 193;
                                case 1 -> 72;
                                case 2 -> 12;
                                case 3 -> 137;
                                case 4 -> 204;
                                case 5 -> 70;
                                case 6 -> 7;
                                case 7 -> 88;
                                case 8 -> 135;
                                case 9 -> 59;
                                case 10 -> 77;
                                case 11 -> 114;
                                case 12 -> 32;
                                case 13 -> 124;
                                case 14 -> 91;
                                case 15 -> 80;
                                case 16 -> 131;
                                case 17 -> 13;
                                case 18 -> 190;
                                case 19 -> 197;
                                case 20 -> 144;
                                case 21 -> 181;
                                case 22 -> 223;
                                case 23 -> 205;
                                case 24 -> 138;
                                case 25 -> 71;
                                case 26 -> 98;
                                case 27 -> 155;
                                case 28 -> 79;
                                case 29 -> 152;
                                case 30 -> 95;
                                case 31 -> 23;
                                case 32 -> 62;
                                case 33 -> 120;
                                case 34 -> 184;
                                case 35 -> 67;
                                case 36 -> 3;
                                case 37 -> 203;
                                case 38 -> 61;
                                case 39 -> 231;
                                case 40 -> 54;
                                case 41 -> 9;
                                case 42 -> 160;
                                case 43 -> 145;
                                case 44 -> 196;
                                case 45 -> 175;
                                case 46 -> 129;
                                case 47 -> 253;
                                case 48 -> 139;
                                case 49 -> 227;
                                case 50 -> 140;
                                case 51 -> 189;
                                case 52 -> 166;
                                case 53 -> 35;
                                case 54 -> 222;
                                case 55 -> 78;
                                case 56 -> 217;
                                case 57 -> 230;
                                case 58 -> 84;
                                case 59 -> 52;
                                case 60 -> 28;
                                case 61 -> 101;
                                case 62 -> 41;
                                case 63 -> 236;
                                case 64 -> 250;
                                case 65 -> 48;
                                case 66 -> 64;
                                case 67 -> 130;
                                case 68 -> 229;
                                case 69 -> 142;
                                case 70 -> 170;
                                case 71 -> 237;
                                case 72 -> 252;
                                case 73 -> 220;
                                case 74 -> 209;
                                case 75 -> 192;
                                case 76 -> 107;
                                case 77 -> 55;
                                case 78 -> 183;
                                case 79 -> 25;
                                case 80 -> 11;
                                case 81 -> 143;
                                case 82 -> 207;
                                case 83 -> 187;
                                case 84 -> 198;
                                case 85 -> 208;
                                case 86 -> 161;
                                case 87 -> 73;
                                case 88 -> 109;
                                case 89 -> 46;
                                case 90 -> 22;
                                case 91 -> 104;
                                case 92 -> 112;
                                case 93 -> 146;
                                case 94 -> 74;
                                case 95 -> 37;
                                case 96 -> 117;
                                case 97 -> 128;
                                case 98 -> 235;
                                case 99 -> 89;
                                case 100 -> 113;
                                case 101 -> 173;
                                case 102 -> 165;
                                case 103 -> 126;
                                case 104 -> 167;
                                case 105 -> 247;
                                case 106 -> 76;
                                case 107 -> 150;
                                case 108 -> 108;
                                case 109 -> 90;
                                case 110 -> 182;
                                case 111 -> 194;
                                case 112 -> 6;
                                case 113 -> 210;
                                case 114 -> 191;
                                case 115 -> 1;
                                case 116 -> 103;
                                case 117 -> 110;
                                case 118 -> 201;
                                case 119 -> 179;
                                case 120 -> 178;
                                case 121 -> 254;
                                case 122 -> 83;
                                case 123 -> 243;
                                case 124 -> 232;
                                case 125 -> 136;
                                case 126 -> 133;
                                case 127 -> 245;
                                case 128 -> 249;
                                case 129 -> 97;
                                case 130 -> 153;
                                case 131 -> 111;
                                case 132 -> 122;
                                case 133 -> 58;
                                case 134 -> 92;
                                case 135 -> 125;
                                case 136 -> 51;
                                case 137 -> 199;
                                case 138 -> 239;
                                case 139 -> 116;
                                case 140 -> 94;
                                case 141 -> 34;
                                case 142 -> 159;
                                case 143 -> 26;
                                case 144 -> 106;
                                case 145 -> 195;
                                case 146 -> 40;
                                case 147 -> 241;
                                case 148 -> 242;
                                case 149 -> 244;
                                case 150 -> 31;
                                case 151 -> 63;
                                case 152 -> 56;
                                case 153 -> 177;
                                case 154 -> 215;
                                case 155 -> 85;
                                case 156 -> 127;
                                case 157 -> 39;
                                case 158 -> 228;
                                case 159 -> 162;
                                case 160 -> 93;
                                case 161 -> 50;
                                case 162 -> 86;
                                case 163 -> 180;
                                case 164 -> 168;
                                case 165 -> 5;
                                case 166 -> 185;
                                case 167 -> 87;
                                case 168 -> 200;
                                case 169 -> 2;
                                case 170 -> 156;
                                case 171 -> 171;
                                case 172 -> 176;
                                case 173 -> 4;
                                case 174 -> 42;
                                case 175 -> 121;
                                case 176 -> 157;
                                case 177 -> 33;
                                case 178 -> 29;
                                case 179 -> 238;
                                case 180 -> 172;
                                case 181 -> 224;
                                case 182 -> 36;
                                case 183 -> 174;
                                case 184 -> 96;
                                case 185 -> 148;
                                case 186 -> 60;
                                case 187 -> 115;
                                case 188 -> 221;
                                case 189 -> 141;
                                case 190 -> 234;
                                case 191 -> 186;
                                case 192 -> 75;
                                case 193 -> 68;
                                case 194 -> 188;
                                case 195 -> 240;
                                case 196 -> 147;
                                case 197 -> 216;
                                case 198 -> 0;
                                case 199 -> 123;
                                case 200 -> 164;
                                case 201 -> 8;
                                case 202 -> 69;
                                case 203 -> 219;
                                case 204 -> 57;
                                case 205 -> 226;
                                case 206 -> 154;
                                case 207 -> 65;
                                case 208 -> 38;
                                case 209 -> 81;
                                case 210 -> 82;
                                case 211 -> 44;
                                case 212 -> 47;
                                case 213 -> 246;
                                case 214 -> 20;
                                case 215 -> 14;
                                case 216 -> 43;
                                case 217 -> 206;
                                case 218 -> 49;
                                case 219 -> 214;
                                case 220 -> 15;
                                case 221 -> 105;
                                case 222 -> 100;
                                case 223 -> 53;
                                case 224 -> 149;
                                case 225 -> 16;
                                case 226 -> 218;
                                case 227 -> 151;
                                case 228 -> 118;
                                case 229 -> 163;
                                case 230 -> 169;
                                case 231 -> 248;
                                case 232 -> 21;
                                case 233 -> 211;
                                case 234 -> 158;
                                case 235 -> 19;
                                case 236 -> 27;
                                case 237 -> 251;
                                case 238 -> 134;
                                case 239 -> 30;
                                case 240 -> 233;
                                case 241 -> 17;
                                case 242 -> 202;
                                case 243 -> 18;
                                case 244 -> 24;
                                case 245 -> 102;
                                case 246 -> 212;
                                case 247 -> 10;
                                case 248 -> 255;
                                case 249 -> 45;
                                case 250 -> 99;
                                case 251 -> 132;
                                case 252 -> 225;
                                case 253 -> 66;
                                case 254 -> 119;
                                default -> 213;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.4.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                lifetime.onTermination((Function0)new Function0<Unit>(clientSocket, this, n4, string, rdConnection){
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ int $portNumber;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ RdConnection $rdConnection;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$clientSocket = $clientSocket;
                        this.this$0 = $receiver;
                        this.$portNumber = $portNumber;
                        this.$connectionId = $connectionId;
                        this.$rdConnection = $rdConnection;
                        super(0);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke() {
                        block15: {
                            block11: {
                                var1_1 = 58043033317472L;
                                var4_2 = ServerSocketWrapper.Companion.getLogger();
                                var3_4 = ServerSocketPortState.j();
                                var6_5 = this.$clientSocket;
                                var7_7 = this.this$0;
                                var8_9 = this.$portNumber;
                                var9_10 = this.$connectionId;
                                var5_11 = null;
                                var10_12 = false;
                                try {
                                    v0 = var4_2;
                                    if (var3_4 == 0) {
                                        if (!v0.isDebugEnabled()) break block11;
                                    }
                                    ** GOTO lbl30
                                }
                                catch (Throwable v1) {
                                    throw monitorOneConnection.5.a(v1);
                                }
                                var12_13 = var4_2;
                                var11_14 = false;
                                var13_15 = var9_10;
                                var14_16 = var8_9;
                                var15_17 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)var7_7.getRdPort().getRdPortState())));
                                var16_18 = var6_5.getPort();
                                var12_13.debug(monitorOneConnection.5.a(-845270430 - -13927, 845270430 - 16011, (int)var1_1) + var16_18 + monitorOneConnection.5.a(-845270430 - -13926, -845270430 + -1630, (int)var1_1) + var15_17 + monitorOneConnection.5.a(-845270430 - -13929, -845270430 + -1790, (int)var1_1) + var14_16 + monitorOneConnection.5.a(-845270430 - -13928, 845270430 + 540, (int)var1_1) + var13_15, (Throwable)var5_11);
                            }
                            try {
                                block16: {
                                    block14: {
                                        block12: {
                                            block13: {
                                                v0 = ServerSocketWrapper.Companion.getLogger();
lbl30:
                                                // 2 sources

                                                var4_2 = v0;
                                                var6_5 = this.$connectionId;
                                                var5_11 = null;
                                                var7_8 = false;
                                                try {
                                                    v2 = var4_2.isDebugEnabled();
                                                    if (var3_4 != 0) break block12;
                                                    if (!v2) break block13;
                                                }
                                                catch (Throwable v3) {
                                                    throw monitorOneConnection.5.a(v3);
                                                }
                                                var12_13 = var4_2;
                                                var8_9 = 0;
                                                var12_13.debug(monitorOneConnection.5.a(-845270430 - -13931, -845270430 - -14319, (int)var1_1) + (String)var6_5, (Throwable)var5_11);
                                            }
                                            try {
                                                v4 = this;
                                                if (var3_4 != 0) break block14;
                                                v2 = v4.$clientSocket.isClosed();
                                            }
                                            catch (Throwable v5) {
                                                throw monitorOneConnection.5.a(v5);
                                            }
                                        }
                                        if (v2) break block15;
                                        var4_2 = ServerSocketWrapper.Companion.getLogger();
                                        v4 = this;
                                    }
                                    var5_11 = v4.$connectionId;
                                    var6_6 = false;
                                    try {
                                        if (var3_4 != 0) break block15;
                                        if (!var4_2.isTraceEnabled()) break block16;
                                    }
                                    catch (Throwable v6) {
                                        throw monitorOneConnection.5.a(v6);
                                    }
                                    var12_13 = var4_2;
                                    var7_8 = false;
                                    var12_13.trace(monitorOneConnection.5.a(-845270430 - -13930, -845270430 + -4480, (int)var1_1) + var5_11);
                                }
                                this.$clientSocket.close();
                            }
                            catch (Throwable var4_3) {
                                ServerSocketWrapper.Companion.getLogger().error(var4_3);
                            }
                        }
                        ApplicationKt.getApplication().invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invoke$lambda$3(com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketWrapper com.jetbrains.codeWithMe.model.RdConnection ), ()V)((ServerSocketWrapper)this.this$0, (RdConnection)this.$rdConnection));
                    }

                    private static final void invoke$lambda$3(ServerSocketWrapper this$0, RdConnection $rdConnection) {
                        long l2 = 57635384888095L;
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)monitorOneConnection.5.a(-1218819930 - -((char)-13558), 1218688860 + (char)-12376, (int)l2));
                        Intrinsics.checkNotNullParameter((Object)$rdConnection, (String)monitorOneConnection.5.a(-1218819930 - -((char)-13557), -1218688860 + -((char)-3171), (int)l2));
                        this$0.getRdPort().getConnections().remove((Object)$rdConnection);
                    }

                    private static Throwable a(Throwable throwable) {
                        return throwable;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[8];
                                var3_1 = 0;
                                var2_2 = "j\u001e\u00a6C\u009b\u00c4\u00fcV\u00ec\u00bc\u00f0\u000f\u00b5~\u009b\u0082\u008b\u00e3\u00a2\u0083\u008e\u0004\u00e3!\u00f8\u00aa\u0004\u0010\u0015\u0086,\u0006\u0098\u0006M\u00a6.[\u001b\u00a7\u0011\u00ac\u00e8O\u00d9O\u009d\u00c3\u00cc\u0016\u0000\u0017\u00be2\u009d\u0093\u00ebbPg\u0002\u00c6\u001e\u00beDX\u0014w!4\u0090\u0094&\u00e8\u00aa\u0015\u0080\u00fa\u0000r+FO\u0096\u008fU~";
                                var4_3 = "j\u001e\u00a6C\u009b\u00c4\u00fcV\u00ec\u00bc\u00f0\u000f\u00b5~\u009b\u0082\u008b\u00e3\u00a2\u0083\u008e\u0004\u00e3!\u00f8\u00aa\u0004\u0010\u0015\u0086,\u0006\u0098\u0006M\u00a6.[\u001b\u00a7\u0011\u00ac\u00e8O\u00d9O\u009d\u00c3\u00cc\u0016\u0000\u0017\u00be2\u009d\u0093\u00ebbPg\u0002\u00c6\u001e\u00beDX\u0014w!4\u0090\u0094&\u00e8\u00aa\u0015\u0080\u00fa\u0000r+FO\u0096\u008fU~".length();
                                var1_4 = 21;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 113;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "\u0091\u00abi\u0013\u00e2^\rd;\u0080h8Y\u00e4V\u00fa\u00bfI\u00cd\u0012";
                                    var4_3 = "\u0091\u00abi\u0013\u00e2^\rd;\u0080h8Y\u00e4V\u00fa\u00bfI\u00cd\u0012".length();
                                    var1_4 = 6;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 8;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 117;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 66;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 111;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 49;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 75;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 62;
                                            break;
                                        }
                                        default: {
                                            v15 = 111;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.5.a = var5;
                        monitorOneConnection.5.b = new String[8];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0xFFFF98A9) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 4;
                                case 1 -> 35;
                                case 2 -> 93;
                                case 3 -> 158;
                                case 4 -> 179;
                                case 5 -> 196;
                                case 6 -> 130;
                                case 7 -> 83;
                                case 8 -> 247;
                                case 9 -> 178;
                                case 10 -> 74;
                                case 11 -> 27;
                                case 12 -> 242;
                                case 13 -> 137;
                                case 14 -> 246;
                                case 15 -> 86;
                                case 16 -> 119;
                                case 17 -> 28;
                                case 18 -> 6;
                                case 19 -> 112;
                                case 20 -> 208;
                                case 21 -> 207;
                                case 22 -> 99;
                                case 23 -> 138;
                                case 24 -> 87;
                                case 25 -> 219;
                                case 26 -> 54;
                                case 27 -> 84;
                                case 28 -> 127;
                                case 29 -> 32;
                                case 30 -> 236;
                                case 31 -> 191;
                                case 32 -> 90;
                                case 33 -> 123;
                                case 34 -> 129;
                                case 35 -> 89;
                                case 36 -> 76;
                                case 37 -> 50;
                                case 38 -> 199;
                                case 39 -> 217;
                                case 40 -> 228;
                                case 41 -> 229;
                                case 42 -> 46;
                                case 43 -> 71;
                                case 44 -> 180;
                                case 45 -> 159;
                                case 46 -> 243;
                                case 47 -> 91;
                                case 48 -> 223;
                                case 49 -> 72;
                                case 50 -> 145;
                                case 51 -> 173;
                                case 52 -> 201;
                                case 53 -> 172;
                                case 54 -> 52;
                                case 55 -> 62;
                                case 56 -> 227;
                                case 57 -> 162;
                                case 58 -> 36;
                                case 59 -> 126;
                                case 60 -> 150;
                                case 61 -> 31;
                                case 62 -> 103;
                                case 63 -> 175;
                                case 64 -> 34;
                                case 65 -> 185;
                                case 66 -> 20;
                                case 67 -> 166;
                                case 68 -> 151;
                                case 69 -> 68;
                                case 70 -> 79;
                                case 71 -> 238;
                                case 72 -> 75;
                                case 73 -> 67;
                                case 74 -> 98;
                                case 75 -> 136;
                                case 76 -> 109;
                                case 77 -> 240;
                                case 78 -> 239;
                                case 79 -> 194;
                                case 80 -> 101;
                                case 81 -> 102;
                                case 82 -> 57;
                                case 83 -> 189;
                                case 84 -> 253;
                                case 85 -> 186;
                                case 86 -> 128;
                                case 87 -> 95;
                                case 88 -> 200;
                                case 89 -> 45;
                                case 90 -> 235;
                                case 91 -> 64;
                                case 92 -> 164;
                                case 93 -> 153;
                                case 94 -> 116;
                                case 95 -> 132;
                                case 96 -> 213;
                                case 97 -> 165;
                                case 98 -> 190;
                                case 99 -> 16;
                                case 100 -> 97;
                                case 101 -> 60;
                                case 102 -> 100;
                                case 103 -> 10;
                                case 104 -> 212;
                                case 105 -> 125;
                                case 106 -> 30;
                                case 107 -> 70;
                                case 108 -> 210;
                                case 109 -> 39;
                                case 110 -> 55;
                                case 111 -> 108;
                                case 112 -> 184;
                                case 113 -> 122;
                                case 114 -> 174;
                                case 115 -> 82;
                                case 116 -> 230;
                                case 117 -> 120;
                                case 118 -> 121;
                                case 119 -> 204;
                                case 120 -> 53;
                                case 121 -> 24;
                                case 122 -> 169;
                                case 123 -> 8;
                                case 124 -> 49;
                                case 125 -> 81;
                                case 126 -> 0;
                                case 127 -> 188;
                                case 128 -> 203;
                                case 129 -> 3;
                                case 130 -> 216;
                                case 131 -> 163;
                                case 132 -> 142;
                                case 133 -> 124;
                                case 134 -> 205;
                                case 135 -> 222;
                                case 136 -> 221;
                                case 137 -> 143;
                                case 138 -> 251;
                                case 139 -> 231;
                                case 140 -> 156;
                                case 141 -> 141;
                                case 142 -> 206;
                                case 143 -> 9;
                                case 144 -> 224;
                                case 145 -> 11;
                                case 146 -> 37;
                                case 147 -> 134;
                                case 148 -> 148;
                                case 149 -> 214;
                                case 150 -> 154;
                                case 151 -> 187;
                                case 152 -> 211;
                                case 153 -> 18;
                                case 154 -> 146;
                                case 155 -> 215;
                                case 156 -> 42;
                                case 157 -> 114;
                                case 158 -> 17;
                                case 159 -> 167;
                                case 160 -> 48;
                                case 161 -> 2;
                                case 162 -> 209;
                                case 163 -> 77;
                                case 164 -> 255;
                                case 165 -> 168;
                                case 166 -> 96;
                                case 167 -> 139;
                                case 168 -> 135;
                                case 169 -> 155;
                                case 170 -> 88;
                                case 171 -> 43;
                                case 172 -> 5;
                                case 173 -> 232;
                                case 174 -> 133;
                                case 175 -> 192;
                                case 176 -> 47;
                                case 177 -> 198;
                                case 178 -> 170;
                                case 179 -> 248;
                                case 180 -> 56;
                                case 181 -> 92;
                                case 182 -> 171;
                                case 183 -> 7;
                                case 184 -> 25;
                                case 185 -> 73;
                                case 186 -> 15;
                                case 187 -> 226;
                                case 188 -> 233;
                                case 189 -> 115;
                                case 190 -> 183;
                                case 191 -> 66;
                                case 192 -> 245;
                                case 193 -> 149;
                                case 194 -> 41;
                                case 195 -> 59;
                                case 196 -> 105;
                                case 197 -> 94;
                                case 198 -> 110;
                                case 199 -> 13;
                                case 200 -> 38;
                                case 201 -> 33;
                                case 202 -> 252;
                                case 203 -> 78;
                                case 204 -> 65;
                                case 205 -> 181;
                                case 206 -> 202;
                                case 207 -> 61;
                                case 208 -> 23;
                                case 209 -> 44;
                                case 210 -> 237;
                                case 211 -> 193;
                                case 212 -> 152;
                                case 213 -> 225;
                                case 214 -> 197;
                                case 215 -> 176;
                                case 216 -> 22;
                                case 217 -> 249;
                                case 218 -> 117;
                                case 219 -> 80;
                                case 220 -> 234;
                                case 221 -> 63;
                                case 222 -> 12;
                                case 223 -> 104;
                                case 224 -> 182;
                                case 225 -> 241;
                                case 226 -> 118;
                                case 227 -> 51;
                                case 228 -> 58;
                                case 229 -> 1;
                                case 230 -> 21;
                                case 231 -> 157;
                                case 232 -> 140;
                                case 233 -> 85;
                                case 234 -> 244;
                                case 235 -> 19;
                                case 236 -> 131;
                                case 237 -> 177;
                                case 238 -> 161;
                                case 239 -> 29;
                                case 240 -> 160;
                                case 241 -> 106;
                                case 242 -> 218;
                                case 243 -> 40;
                                case 244 -> 195;
                                case 245 -> 26;
                                case 246 -> 111;
                                case 247 -> 14;
                                case 248 -> 144;
                                case 249 -> 69;
                                case 250 -> 107;
                                case 251 -> 254;
                                case 252 -> 220;
                                case 253 -> 147;
                                case 254 -> 250;
                                default -> 113;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.5.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                object = ServerSocketWrapper.a(-1285010280 + -10820, 1285010280 + 15062, (int)l2) + string;
                object2 = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)object, (int)0, (Function0)((Function0)new Function0<Unit>((String)object, lifetime, clientSocket, string, this, rdConnection){
                    final /* synthetic */ String $threadName;
                    final /* synthetic */ Lifetime $rdConnectionLifetime;
                    final /* synthetic */ Socket $clientSocket;
                    final /* synthetic */ String $connectionId;
                    final /* synthetic */ ServerSocketWrapper this$0;
                    final /* synthetic */ RdConnection $rdConnection;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$threadName = $threadName;
                        this.$rdConnectionLifetime = $rdConnectionLifetime;
                        this.$clientSocket = $clientSocket;
                        this.$connectionId = $connectionId;
                        this.this$0 = $receiver;
                        this.$rdConnection = $rdConnection;
                        super(0);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public final void invoke() {
                        block53: {
                            block51: {
                                block52: {
                                    block41: {
                                        var1_1 = 132517717693431L;
                                        var4_2 = 0;
                                        var3_3 = ServerSocketPortState.j();
                                        ServerSocketWrapper.Companion.getLogger().debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20555, -796774530 - -((char)-13863), (int)var1_1) + this.$threadName + monitorOneConnection.myThread.1.a(796774530 - (char)-20554, 796774530 - (char)-31464, (int)var1_1));
                                        while (RLifetimeKt.isAlive((Lifetime)this.$rdConnectionLifetime)) {
                                            try {
                                                block47: {
                                                    block48: {
                                                        block46: {
                                                            block45: {
                                                                block44: {
                                                                    block56: {
                                                                        block42: {
                                                                            block43: {
                                                                                block40: {
                                                                                    var5_4 /* !! */  = ServerSocketWrapper.Companion.getLogger();
                                                                                    var6_9 = this.$connectionId;
                                                                                    var7_12 = false;
                                                                                    if (var3_3 != 0) break block40;
                                                                                    try {
                                                                                        block55: {
                                                                                            v0 = var5_4 /* !! */ ;
                                                                                            if (var3_3 != 0) break block41;
                                                                                            break block55;
                                                                                            catch (SocketTimeoutException v1) {
                                                                                                throw monitorOneConnection.myThread.1.a(v1);
                                                                                            }
                                                                                        }
                                                                                        if (!v0.isTraceEnabled()) break block40;
                                                                                    }
                                                                                    catch (SocketTimeoutException v2) {
                                                                                        throw monitorOneConnection.myThread.1.a(v2);
                                                                                    }
                                                                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                                                                    var8_17 = false;
                                                                                    var12_26 /* !! */ .trace(monitorOneConnection.myThread.1.a(796774530 - (char)-20557, 796774530 - (char)-30759, (int)var1_1) + var6_9);
                                                                                }
                                                                                var5_4 /* !! */  = null;
                                                                                var5_4 /* !! */  = (Logger)new byte[4096];
                                                                                var6_8 = this.$clientSocket.getInputStream().read((byte[])var5_4 /* !! */ );
                                                                                try {
                                                                                    v3 = var6_8;
                                                                                    if (var3_3 != 0) break block42;
                                                                                    if (v3 != -1) break block43;
                                                                                }
                                                                                catch (SocketTimeoutException v4) {
                                                                                    throw monitorOneConnection.myThread.1.a(v4);
                                                                                }
                                                                                var7_13 = ServerSocketWrapper.Companion.getLogger();
                                                                                var9_21 = this.$connectionId;
                                                                                var8_18 = null;
                                                                                var10_25 = false;
                                                                                try {
                                                                                    if (var3_3 != 0 || !var7_13.isDebugEnabled()) break;
                                                                                }
                                                                                catch (SocketTimeoutException v5) {
                                                                                    throw monitorOneConnection.myThread.1.a(v5);
                                                                                }
                                                                                var12_26 /* !! */  = var7_13;
                                                                                var11_30 = false;
                                                                                var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20556, -796774530 - -25011, (int)var1_1) + var9_21, var8_18);
                                                                                break;
                                                                            }
                                                                            v3 = var6_8;
                                                                        }
                                                                        if (var3_3 != 0) break block44;
                                                                        if (v3 != 0) ** GOTO lbl70
                                                                        break block56;
                                                                        catch (SocketTimeoutException v6) {
                                                                            throw monitorOneConnection.myThread.1.a(v6);
                                                                        }
                                                                    }
                                                                    try {
                                                                        block57: {
                                                                            ServerSocketWrapper.Companion.getLogger().error(monitorOneConnection.myThread.1.a(796774530 - (char)-20551, -796774530 - -28425, (int)var1_1) + this.$connectionId);
                                                                            if (var3_3 == 0) break;
                                                                            break block57;
                                                                            catch (SocketTimeoutException v7) {
                                                                                throw monitorOneConnection.myThread.1.a(v7);
                                                                            }
                                                                        }
                                                                        v3 = var6_8;
                                                                    }
                                                                    catch (SocketTimeoutException v8) {
                                                                        throw monitorOneConnection.myThread.1.a(v8);
                                                                    }
                                                                }
                                                                if (var3_3 != 0) break block45;
                                                                try {
                                                                    block58: {
                                                                        if (v3 >= ((Logger)var5_4 /* !! */ ).length) break block46;
                                                                        break block58;
                                                                        catch (SocketTimeoutException v9) {
                                                                            throw monitorOneConnection.myThread.1.a(v9);
                                                                        }
                                                                    }
                                                                    v3 = var6_8;
                                                                }
                                                                catch (SocketTimeoutException v10) {
                                                                    throw monitorOneConnection.myThread.1.a(v10);
                                                                }
                                                            }
                                                            var7_14 = new byte[v3];
                                                            try {
                                                                v.d(5823143819193950469L, var1_1).invoke(null, v.a((Object)var5_4 /* !! */ , 0, (Object)var7_14, 0, var6_8));
                                                            }
                                                            catch (InvocationTargetException v11) {
                                                                throw v11.getTargetException();
                                                            }
                                                            var5_4 /* !! */  = (Logger)var7_14;
                                                        }
                                                        ServerSocketWrapper.access$getSentBytesCounter$p(this.this$0).add((long)((Logger)var5_4 /* !! */ ).length);
                                                        var7_11 = ServerSocketWrapper.Companion.getLogger();
                                                        var8_16 = this.$connectionId;
                                                        var9_20 = false;
                                                        try {
                                                            v12 = var7_11.isTraceEnabled();
                                                            if (var3_3 != 0) break block47;
                                                            if (v12 == 0) break block48;
                                                        }
                                                        catch (SocketTimeoutException v13) {
                                                            throw monitorOneConnection.myThread.1.a(v13);
                                                        }
                                                        var12_26 /* !! */  = var7_11;
                                                        var10_25 = false;
                                                        var13_27 = var8_16;
                                                        var14_28 = ((Logger)var5_4 /* !! */ ).length;
                                                        var15_29 = var4_2;
                                                        var12_26 /* !! */ .trace(monitorOneConnection.myThread.1.a(796774530 - (char)-20550, -796774530 - -((char)-16840), (int)var1_1) + var15_29 + monitorOneConnection.myThread.1.a(796774530 - (char)-20553, -796774530 - -((char)-21682), (int)var1_1) + var14_28 + monitorOneConnection.myThread.1.a(796774530 - (char)-20552, 796774530 - (char)-20588, (int)var1_1) + (String)var13_27);
                                                    }
                                                    this.$rdConnection.getToDestinationSocket().fire((Object)new DebugTrafficInfo(var4_2, (byte[])var5_4 /* !! */ ));
                                                    v12 = var4_2 + 1;
                                                }
                                                var4_2 = v12;
                                            }
                                            catch (SocketTimeoutException var5_5) {
                                                var6_10 = ServerSocketWrapper.Companion.getLogger();
                                                var8_16 = this.$clientSocket;
                                                var9_22 = this.$connectionId;
                                                var7_11 = null;
                                                var10_25 = false;
                                                try {
                                                    if (var3_3 != 0 || !var6_10.isDebugEnabled()) break;
                                                }
                                                catch (SocketTimeoutException v14) {
                                                    throw monitorOneConnection.myThread.1.a(v14);
                                                }
                                                var12_26 /* !! */  = var6_10;
                                                var11_31 = false;
                                                var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20547, -796774530 - -((char)-12172), (int)var1_1) + var8_16.getSoTimeout() + monitorOneConnection.myThread.1.a(796774530 - (char)-20546, 796774530 - (char)-21694, (int)var1_1) + var9_22, (Throwable)var7_11);
                                                break;
                                            }
                                            catch (IOException var5_6) {
                                                block49: {
                                                    block50: {
                                                        try {
                                                            try {
                                                                v15 = ServerSocketWrapper.Companion.getLogger();
                                                                v16 = var5_6.getClass();
                                                                v17 = var5_6.getMessage();
                                                                v18 = v17;
                                                                v19 = v17;
                                                                if (var3_3 != 0) break block49;
                                                                if (v18 != null) break block50;
                                                            }
                                                            catch (SocketTimeoutException v20) {
                                                                throw monitorOneConnection.myThread.1.a(v20);
                                                            }
                                                            v19 = monitorOneConnection.myThread.1.a(796774530 - (char)-20549, 796774530 - 32709, (int)var1_1);
                                                        }
                                                        catch (SocketTimeoutException v21) {
                                                            throw monitorOneConnection.myThread.1.a(v21);
                                                        }
                                                    }
                                                    v18 = this.$connectionId;
                                                }
                                                var16_32 = v18;
                                                var17_33 = v19;
                                                var18_34 = v16;
                                                v15.warn(monitorOneConnection.myThread.1.a(796774530 - (char)-20548, -796774530 - -((char)-22359), (int)var1_1) + var18_34 + monitorOneConnection.myThread.1.a(796774530 - (char)-20543, 796774530 - 31016, (int)var1_1) + var17_33 + monitorOneConnection.myThread.1.a(796774530 - (char)-20542, 796774530 - (char)-19647, (int)var1_1) + var16_32);
                                                break;
                                            }
                                            catch (Throwable var5_7) {
                                                ServerSocketWrapper.Companion.getLogger().error(monitorOneConnection.myThread.1.a(796774530 - (char)-20545, -796774530 - -((char)-14405), (int)var1_1) + this.$connectionId, var5_7);
                                                break;
                                            }
                                        }
                                        v0 = ServerSocketWrapper.Companion.getLogger();
                                    }
                                    var5_4 /* !! */  = v0;
                                    var7_15 = this.$connectionId;
                                    var6_9 = null;
                                    var8_19 = false;
                                    try {
                                        v22 = var5_4 /* !! */ .isDebugEnabled();
                                        if (var3_3 != 0) break block51;
                                        if (!v22) break block52;
                                    }
                                    catch (SocketTimeoutException v23) {
                                        throw monitorOneConnection.myThread.1.a(v23);
                                    }
                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                    var9_23 = false;
                                    var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20544, 796774530 - (char)-20211, (int)var1_1) + var7_15, (Throwable)var6_9);
                                }
                                try {
                                    this.$rdConnection.getAcceptedConnectionSocketInputShutdown().fire((Object)Unit.INSTANCE);
                                    if (var3_3 != 0) break block53;
                                    v22 = this.$clientSocket.isClosed();
                                }
                                catch (SocketTimeoutException v24) {
                                    throw monitorOneConnection.myThread.1.a(v24);
                                }
                            }
                            if (v22) {
                                block54: {
                                    var5_4 /* !! */  = ServerSocketWrapper.Companion.getLogger();
                                    var7_15 = this.$connectionId;
                                    var6_9 = null;
                                    var8_19 = false;
                                    try {
                                        if (var3_3 != 0 || !var5_4 /* !! */ .isDebugEnabled()) break block54;
                                    }
                                    catch (SocketTimeoutException v25) {
                                        throw monitorOneConnection.myThread.1.a(v25);
                                    }
                                    var12_26 /* !! */  = var5_4 /* !! */ ;
                                    var9_24 = false;
                                    var12_26 /* !! */ .debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20571, -796774530 - -((char)-25876), (int)var1_1) + var7_15, (Throwable)var6_9);
                                }
                                this.$rdConnection.getAcceptedConnectionSocketOutputShutdown().fire((Object)Unit.INSTANCE);
                            }
                            ServerSocketWrapper.Companion.getLogger().debug(monitorOneConnection.myThread.1.a(796774530 - (char)-20570, -796774530 - -((char)-22322), (int)var1_1) + this.$threadName + monitorOneConnection.myThread.1.a(796774530 - (char)-20573, -796774530 - -((char)-18430), (int)var1_1));
                        }
                    }

                    private static SocketTimeoutException a(SocketTimeoutException socketTimeoutException) {
                        return socketTimeoutException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block20: {
                            block19: {
                                var5 = new String[19];
                                var3_1 = 0;
                                var2_2 = "\u00d3\u00ee\u0088r\u00d7_ \u00aa\t\u000b@\u00ab\u00f7\u0092\u00ca\u00dc\u008e=\u001fv\u00a6r\u0097\u00f6\u00cd\u0096|0\u0005\u00e8f\f\u0016\u0081\u00ac\u008fk\u00c8b\u00e5\u00bcm\u0087p\u008eh\u00a6\u00c3\u0092\u00ca\u0013\u00bb\u00c7t\u00fax&\u00ad\u00e2\u00f8{\u00ea\u00c7h\u00aa\u00be\u00ad\u00edd\u00ee>\u00d0\u009b\u00de\u0007\u00f9N\u0095\u00fa\u00e0\u00bbZ~\u00b6?\u00fe\u00ceK\u009b}a\u00cfA\u001bU\u009dy\u00b2W\u0000;4\u0089@ \u00dcB\u001es\u0095Y\u00a2'j\u00c0\u0012\u00e7\u00b6\u00db<\u00d9\u009ck\u00faS\u0004\u0018\u00c9\u00f0\u0083\u00f1\u0095J\u000f\u00catP\u008c[\u00ab\u00ffx.$\"\u00a27;\u0081\u0011\u0015\u0000\u0093u\u0006Y\u00d3B\u00c6\u00d5\u00b6\u00b9'\u00e7K\u00cb\u00fa\u0006b\u00ff\u00f6\u0010;v\u0015D\u00a5\u00b6\u0089\u00a6\u00fe@\u00d2\u00c8k\u00c8\u001f\u00cf&\u009eg\u00ebz){{(\u001c\u00a1\u00b47%\u00d2\u0081\u00f5vb\u00001lYi^\u00baH\u0016\u00be>\u00da\u0019d\u0010;d\u00e9I\u00df\u00a3\u0015\u00b2\u00b3\u00800\u00e8<\u00cc\u00d4\fYc\u0013@\u0016\u00f5\u00c6\u008a\u009cQ\u0014\u0013'_\u009c\u00d5\u00ae\u00ca\u001a\u00cdNy\u00f8\u00fem\thF\u00ae\u00f0CJ\\\u0017^\u0091N?\u00c1\u0010\u00ebk\u0019\u00bd\u009eS\u00d2\u00caAK\u00f0G\u0002\u0001U\u0012}0\u009e\u00b3\u00e0P\u00e3\u00e4\u00d6\r\u0006\u0019\u00f3?0\u009f\u0002\u0094\u001e_o\u001fP\u0007\u000b@z\u001a\u0097)\"AQ\u00f9Y$h\u00d9q1\u00c6\u008b\u0088p\tr\u00d6\u00be*&]\u008b-\u00f3l\u00e1\u00b9ZGW\u00c3[y,4\u00e7\u00159K\u001bJ\u00fd\u00a7\u00cf\u00d3\u00f0\u008a\u00b8`\u00ba\u00e9\u0014\u0013\u00bd\u0015y\u00e4\u009d`%1\"\u00a4\u008d\u000b\u0085\u0007\u00c0\u00fc3.g\u0082\u00f72m\u0083DL\u00ab\u0017\u009b\u0092T[z\u00cd~\u0014*\u00c1k\u0007\u0000%F7\r\u000f\u00fa\u00c5I\u0087\"\u001bM8g}H=)en\u00f2\u008c+3\u00e7\u00afc\u00c1\nH]\"\u001aE\u0004\u00b3\u00e2\u00e5\u0099U\t\u0092}\u00c1Z\u009dX\u009d\u00f0,\u0099j\u0003:e\u007f&\u0017\u00fe3\u008c";
                                var4_3 = "\u00d3\u00ee\u0088r\u00d7_ \u00aa\t\u000b@\u00ab\u00f7\u0092\u00ca\u00dc\u008e=\u001fv\u00a6r\u0097\u00f6\u00cd\u0096|0\u0005\u00e8f\f\u0016\u0081\u00ac\u008fk\u00c8b\u00e5\u00bcm\u0087p\u008eh\u00a6\u00c3\u0092\u00ca\u0013\u00bb\u00c7t\u00fax&\u00ad\u00e2\u00f8{\u00ea\u00c7h\u00aa\u00be\u00ad\u00edd\u00ee>\u00d0\u009b\u00de\u0007\u00f9N\u0095\u00fa\u00e0\u00bbZ~\u00b6?\u00fe\u00ceK\u009b}a\u00cfA\u001bU\u009dy\u00b2W\u0000;4\u0089@ \u00dcB\u001es\u0095Y\u00a2'j\u00c0\u0012\u00e7\u00b6\u00db<\u00d9\u009ck\u00faS\u0004\u0018\u00c9\u00f0\u0083\u00f1\u0095J\u000f\u00catP\u008c[\u00ab\u00ffx.$\"\u00a27;\u0081\u0011\u0015\u0000\u0093u\u0006Y\u00d3B\u00c6\u00d5\u00b6\u00b9'\u00e7K\u00cb\u00fa\u0006b\u00ff\u00f6\u0010;v\u0015D\u00a5\u00b6\u0089\u00a6\u00fe@\u00d2\u00c8k\u00c8\u001f\u00cf&\u009eg\u00ebz){{(\u001c\u00a1\u00b47%\u00d2\u0081\u00f5vb\u00001lYi^\u00baH\u0016\u00be>\u00da\u0019d\u0010;d\u00e9I\u00df\u00a3\u0015\u00b2\u00b3\u00800\u00e8<\u00cc\u00d4\fYc\u0013@\u0016\u00f5\u00c6\u008a\u009cQ\u0014\u0013'_\u009c\u00d5\u00ae\u00ca\u001a\u00cdNy\u00f8\u00fem\thF\u00ae\u00f0CJ\\\u0017^\u0091N?\u00c1\u0010\u00ebk\u0019\u00bd\u009eS\u00d2\u00caAK\u00f0G\u0002\u0001U\u0012}0\u009e\u00b3\u00e0P\u00e3\u00e4\u00d6\r\u0006\u0019\u00f3?0\u009f\u0002\u0094\u001e_o\u001fP\u0007\u000b@z\u001a\u0097)\"AQ\u00f9Y$h\u00d9q1\u00c6\u008b\u0088p\tr\u00d6\u00be*&]\u008b-\u00f3l\u00e1\u00b9ZGW\u00c3[y,4\u00e7\u00159K\u001bJ\u00fd\u00a7\u00cf\u00d3\u00f0\u008a\u00b8`\u00ba\u00e9\u0014\u0013\u00bd\u0015y\u00e4\u009d`%1\"\u00a4\u008d\u000b\u0085\u0007\u00c0\u00fc3.g\u0082\u00f72m\u0083DL\u00ab\u0017\u009b\u0092T[z\u00cd~\u0014*\u00c1k\u0007\u0000%F7\r\u000f\u00fa\u00c5I\u0087\"\u001bM8g}H=)en\u00f2\u008c+3\u00e7\u00afc\u00c1\nH]\"\u001aE\u0004\u00b3\u00e2\u00e5\u0099U\t\u0092}\u00c1Z\u009dX\u009d\u00f0,\u0099j\u0003:e\u007f&\u0017\u00fe3\u008c".length();
                                var1_4 = 8;
                                var0_5 = -1;
lbl7:
                                // 2 sources

                                while (true) {
                                    v0 = 23;
                                    v1 = ++var0_5;
                                    v2 = var2_2.substring(v1, v1 + var1_4);
                                    v3 = -1;
                                    break block19;
                                    break;
                                }
lbl13:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    var2_2 = "qj\u00cd\u00f3n~\u0006\u009f\u0007\u00ae]\u0018_$\u0080\u00ae";
                                    var4_3 = "qj\u00cd\u00f3n~\u0006\u009f\u0007\u00ae]\u0018_$\u0080\u00ae".length();
                                    var1_4 = 8;
                                    var0_5 = -1;
lbl22:
                                    // 2 sources

                                    while (true) {
                                        v0 = 77;
                                        v5 = ++var0_5;
                                        v2 = var2_2.substring(v5, v5 + var1_4);
                                        v3 = 0;
                                        break block19;
                                        break;
                                    }
                                    break;
                                }
lbl28:
                                // 1 sources

                                while (true) {
                                    var5[var3_1++] = v4.intern();
                                    if ((var0_5 += var1_4) < var4_3) {
                                        var1_4 = var2_2.charAt(var0_5);
                                        ** continue;
                                    }
                                    break block20;
                                    break;
                                }
                            }
                            v6 = v2.toCharArray();
                            v7 = v6.length;
                            var6_6 = 0;
                            v8 = v0;
                            v9 = v6;
                            v10 = v7;
                            if (v7 > 1) ** GOTO lbl85
                            do {
                                v11 = v8;
                                v9 = v9;
                                v12 = v9;
                                v13 = v8;
                                v14 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v15 = 63;
                                            break;
                                        }
                                        case 1: {
                                            v15 = 8;
                                            break;
                                        }
                                        case 2: {
                                            v15 = 104;
                                            break;
                                        }
                                        case 3: {
                                            v15 = 91;
                                            break;
                                        }
                                        case 4: {
                                            v15 = 99;
                                            break;
                                        }
                                        case 5: {
                                            v15 = 34;
                                            break;
                                        }
                                        default: {
                                            v15 = 46;
                                        }
                                    }
                                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                                    ++var6_6;
                                    v8 = v11;
                                    if (v11 != 0) break;
                                    v11 = v8;
                                    v9 = v9;
                                    v14 = v8;
                                    v12 = v9;
                                    v13 = v8;
                                }
lbl85:
                                // 2 sources

                                v16 = v9;
                                v10 = v10;
                            } while (v10 > var6_6);
                            v4 = new String(v16);
                            switch (v3) {
                                default: {
                                    ** continue;
                                }
                                ** case 0:
lbl95:
                                // 1 sources

                                ** continue;
                            }
                        }
                        monitorOneConnection.myThread.1.a = var5;
                        monitorOneConnection.myThread.1.b = new String[19];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0x733A) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 103;
                                case 1 -> 198;
                                case 2 -> 235;
                                case 3 -> 68;
                                case 4 -> 206;
                                case 5 -> 208;
                                case 6 -> 98;
                                case 7 -> 147;
                                case 8 -> 119;
                                case 9 -> 42;
                                case 10 -> 73;
                                case 11 -> 213;
                                case 12 -> 36;
                                case 13 -> 82;
                                case 14 -> 13;
                                case 15 -> 205;
                                case 16 -> 83;
                                case 17 -> 141;
                                case 18 -> 130;
                                case 19 -> 29;
                                case 20 -> 222;
                                case 21 -> 47;
                                case 22 -> 10;
                                case 23 -> 240;
                                case 24 -> 218;
                                case 25 -> 174;
                                case 26 -> 129;
                                case 27 -> 238;
                                case 28 -> 9;
                                case 29 -> 160;
                                case 30 -> 210;
                                case 31 -> 180;
                                case 32 -> 55;
                                case 33 -> 187;
                                case 34 -> 138;
                                case 35 -> 153;
                                case 36 -> 1;
                                case 37 -> 28;
                                case 38 -> 18;
                                case 39 -> 151;
                                case 40 -> 126;
                                case 41 -> 154;
                                case 42 -> 26;
                                case 43 -> 161;
                                case 44 -> 249;
                                case 45 -> 165;
                                case 46 -> 203;
                                case 47 -> 100;
                                case 48 -> 33;
                                case 49 -> 88;
                                case 50 -> 215;
                                case 51 -> 12;
                                case 52 -> 163;
                                case 53 -> 184;
                                case 54 -> 58;
                                case 55 -> 108;
                                case 56 -> 246;
                                case 57 -> 121;
                                case 58 -> 194;
                                case 59 -> 173;
                                case 60 -> 190;
                                case 61 -> 30;
                                case 62 -> 192;
                                case 63 -> 225;
                                case 64 -> 217;
                                case 65 -> 40;
                                case 66 -> 84;
                                case 67 -> 182;
                                case 68 -> 197;
                                case 69 -> 224;
                                case 70 -> 209;
                                case 71 -> 24;
                                case 72 -> 99;
                                case 73 -> 237;
                                case 74 -> 179;
                                case 75 -> 92;
                                case 76 -> 186;
                                case 77 -> 77;
                                case 78 -> 11;
                                case 79 -> 31;
                                case 80 -> 137;
                                case 81 -> 148;
                                case 82 -> 20;
                                case 83 -> 231;
                                case 84 -> 145;
                                case 85 -> 63;
                                case 86 -> 46;
                                case 87 -> 81;
                                case 88 -> 22;
                                case 89 -> 211;
                                case 90 -> 101;
                                case 91 -> 239;
                                case 92 -> 228;
                                case 93 -> 131;
                                case 94 -> 69;
                                case 95 -> 181;
                                case 96 -> 59;
                                case 97 -> 80;
                                case 98 -> 230;
                                case 99 -> 168;
                                case 100 -> 255;
                                case 101 -> 50;
                                case 102 -> 164;
                                case 103 -> 118;
                                case 104 -> 149;
                                case 105 -> 120;
                                case 106 -> 157;
                                case 107 -> 248;
                                case 108 -> 214;
                                case 109 -> 193;
                                case 110 -> 252;
                                case 111 -> 175;
                                case 112 -> 250;
                                case 113 -> 241;
                                case 114 -> 76;
                                case 115 -> 177;
                                case 116 -> 104;
                                case 117 -> 79;
                                case 118 -> 78;
                                case 119 -> 156;
                                case 120 -> 102;
                                case 121 -> 75;
                                case 122 -> 115;
                                case 123 -> 178;
                                case 124 -> 107;
                                case 125 -> 146;
                                case 126 -> 133;
                                case 127 -> 123;
                                case 128 -> 166;
                                case 129 -> 25;
                                case 130 -> 204;
                                case 131 -> 144;
                                case 132 -> 91;
                                case 133 -> 93;
                                case 134 -> 105;
                                case 135 -> 34;
                                case 136 -> 57;
                                case 137 -> 19;
                                case 138 -> 150;
                                case 139 -> 35;
                                case 140 -> 0;
                                case 141 -> 232;
                                case 142 -> 8;
                                case 143 -> 233;
                                case 144 -> 152;
                                case 145 -> 65;
                                case 146 -> 202;
                                case 147 -> 5;
                                case 148 -> 62;
                                case 149 -> 61;
                                case 150 -> 244;
                                case 151 -> 44;
                                case 152 -> 220;
                                case 153 -> 109;
                                case 154 -> 162;
                                case 155 -> 254;
                                case 156 -> 142;
                                case 157 -> 247;
                                case 158 -> 201;
                                case 159 -> 52;
                                case 160 -> 167;
                                case 161 -> 37;
                                case 162 -> 136;
                                case 163 -> 3;
                                case 164 -> 134;
                                case 165 -> 70;
                                case 166 -> 172;
                                case 167 -> 16;
                                case 168 -> 38;
                                case 169 -> 219;
                                case 170 -> 229;
                                case 171 -> 155;
                                case 172 -> 66;
                                case 173 -> 96;
                                case 174 -> 51;
                                case 175 -> 221;
                                case 176 -> 113;
                                case 177 -> 110;
                                case 178 -> 60;
                                case 179 -> 245;
                                case 180 -> 71;
                                case 181 -> 106;
                                case 182 -> 114;
                                case 183 -> 127;
                                case 184 -> 253;
                                case 185 -> 74;
                                case 186 -> 56;
                                case 187 -> 188;
                                case 188 -> 159;
                                case 189 -> 116;
                                case 190 -> 64;
                                case 191 -> 14;
                                case 192 -> 122;
                                case 193 -> 89;
                                case 194 -> 32;
                                case 195 -> 171;
                                case 196 -> 2;
                                case 197 -> 189;
                                case 198 -> 72;
                                case 199 -> 196;
                                case 200 -> 21;
                                case 201 -> 236;
                                case 202 -> 112;
                                case 203 -> 27;
                                case 204 -> 87;
                                case 205 -> 48;
                                case 206 -> 143;
                                case 207 -> 23;
                                case 208 -> 53;
                                case 209 -> 195;
                                case 210 -> 183;
                                case 211 -> 132;
                                case 212 -> 86;
                                case 213 -> 191;
                                case 214 -> 199;
                                case 215 -> 243;
                                case 216 -> 4;
                                case 217 -> 97;
                                case 218 -> 212;
                                case 219 -> 185;
                                case 220 -> 124;
                                case 221 -> 43;
                                case 222 -> 216;
                                case 223 -> 158;
                                case 224 -> 90;
                                case 225 -> 45;
                                case 226 -> 176;
                                case 227 -> 111;
                                case 228 -> 234;
                                case 229 -> 49;
                                case 230 -> 251;
                                case 231 -> 226;
                                case 232 -> 169;
                                case 233 -> 170;
                                case 234 -> 54;
                                case 235 -> 135;
                                case 236 -> 7;
                                case 237 -> 94;
                                case 238 -> 6;
                                case 239 -> 223;
                                case 240 -> 125;
                                case 241 -> 200;
                                case 242 -> 39;
                                case 243 -> 15;
                                case 244 -> 41;
                                case 245 -> 95;
                                case 246 -> 117;
                                case 247 -> 207;
                                case 248 -> 227;
                                case 249 -> 128;
                                case 250 -> 85;
                                case 251 -> 17;
                                case 252 -> 67;
                                case 253 -> 242;
                                case 254 -> 139;
                                default -> 140;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.myThread.1.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                }), (int)20, null);
                rdConnection.getReady().advise(lifetime, (Function1)new Function1<Unit, Unit>((Thread)object2, string){
                    final /* synthetic */ Thread $myThread;
                    final /* synthetic */ String $connectionId;
                    private static final String[] a;
                    private static final String[] b;
                    {
                        this.$myThread = $myThread;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    public final void invoke(@NotNull Unit it) {
                        block2: {
                            block3: {
                                long l2 = 91763849783549L;
                                int n2 = ServerSocketPortState.j();
                                Intrinsics.checkNotNullParameter((Object)it, (String)monitorOneConnection.6.a(-1873514580 - -((char)-31601), -1873514580 - -19948, (int)l2));
                                int n3 = n2;
                                Logger logger = ServerSocketWrapper.Companion.getLogger();
                                String string = this.$connectionId;
                                Throwable throwable = null;
                                boolean bl = false;
                                try {
                                    if (n3 != 0) break block2;
                                    if (!logger.isDebugEnabled()) break block3;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw monitorOneConnection.6.a(runtimeException);
                                }
                                Logger logger2 = logger;
                                boolean bl2 = false;
                                logger2.debug(monitorOneConnection.6.a(-1873514580 - -((char)-31602), 1873514580 - 31621, (int)l2) + string, throwable);
                            }
                            this.$myThread.start();
                        }
                    }

                    private static RuntimeException a(RuntimeException runtimeException) {
                        return runtimeException;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    static {
                        block13: {
                            var5 = new String[2];
                            var3_1 = 0;
                            var2_2 = "\u00ebh4\u00a9y\u0095$\u00e0\u00c7\r\u0013j\u00f5\"\u00a4\u00fa\u009c\u00a67\u0003\u009e4\u008dE\u00e9\u00ee=n\u00d5T\u0098\u0088\u0096@\u00bdy\u000f\u0000\u00d0#U\u0005R\u00e8\u00fe\u0087\u0007\u0004\u0010\u00ad\u00e8\u001b1\u0093\u0095";
                            var4_3 = "\u00ebh4\u00a9y\u0095$\u00e0\u00c7\r\u0013j\u00f5\"\u00a4\u00fa\u009c\u00a67\u0003\u009e4\u008dE\u00e9\u00ee=n\u00d5T\u0098\u0088\u0096@\u00bdy\u000f\u0000\u00d0#U\u0005R\u00e8\u00fe\u0087\u0007\u0004\u0010\u00ad\u00e8\u001b1\u0093\u0095".length();
                            var1_4 = 2;
                            var0_5 = -1;
lbl7:
                            // 2 sources

                            while (true) {
                                continue;
                                break;
                            }
lbl9:
                            // 1 sources

                            while (true) {
                                var5[var3_1++] = new String(v0).intern();
                                if ((var0_5 += var1_4) < var4_3) {
                                    var1_4 = var2_2.charAt(var0_5);
                                    ** continue;
                                }
                                break block13;
                                break;
                            }
                            v1 = ++var0_5;
                            v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                            v3 = v2.length;
                            var6_6 = 0;
                            v4 = 31;
                            v5 = v2;
                            v6 = v3;
                            if (v3 > 1) ** GOTO lbl67
                            do {
                                v7 = v4;
                                v5 = v5;
                                v8 = v5;
                                v9 = v4;
                                v10 = var6_6;
                                while (true) {
                                    switch (var6_6 % 7) {
                                        case 0: {
                                            v11 = 54;
                                            break;
                                        }
                                        case 1: {
                                            v11 = 24;
                                            break;
                                        }
                                        case 2: {
                                            v11 = 65;
                                            break;
                                        }
                                        case 3: {
                                            v11 = 86;
                                            break;
                                        }
                                        case 4: {
                                            v11 = 14;
                                            break;
                                        }
                                        case 5: {
                                            v11 = 53;
                                            break;
                                        }
                                        default: {
                                            v11 = 83;
                                        }
                                    }
                                    v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                    ++var6_6;
                                    v4 = v7;
                                    if (v7 != 0) break;
                                    v7 = v4;
                                    v5 = v5;
                                    v10 = v4;
                                    v8 = v5;
                                    v9 = v4;
                                }
lbl67:
                                // 2 sources

                                v0 = v5;
                                v6 = v6;
                            } while (v6 > var6_6);
                            ** while (true)
                        }
                        monitorOneConnection.6.a = var5;
                        monitorOneConnection.6.b = new String[2];
                    }

                    private static String a(int n2, int n3, int n4) {
                        int n5 = (n2 ^ n4 ^ 0xFFFF9CC6) & 0xFFFF;
                        if (b[n5] == null) {
                            int n6;
                            char[] cArray = a[n5].toCharArray();
                            int n7 = switch (cArray[0] & 0xFF) {
                                case 0 -> 169;
                                case 1 -> 246;
                                case 2 -> 220;
                                case 3 -> 74;
                                case 4 -> 142;
                                case 5 -> 137;
                                case 6 -> 79;
                                case 7 -> 147;
                                case 8 -> 157;
                                case 9 -> 133;
                                case 10 -> 29;
                                case 11 -> 41;
                                case 12 -> 20;
                                case 13 -> 22;
                                case 14 -> 85;
                                case 15 -> 38;
                                case 16 -> 106;
                                case 17 -> 24;
                                case 18 -> 88;
                                case 19 -> 28;
                                case 20 -> 33;
                                case 21 -> 210;
                                case 22 -> 224;
                                case 23 -> 92;
                                case 24 -> 140;
                                case 25 -> 175;
                                case 26 -> 199;
                                case 27 -> 201;
                                case 28 -> 128;
                                case 29 -> 141;
                                case 30 -> 165;
                                case 31 -> 209;
                                case 32 -> 184;
                                case 33 -> 181;
                                case 34 -> 73;
                                case 35 -> 8;
                                case 36 -> 126;
                                case 37 -> 96;
                                case 38 -> 55;
                                case 39 -> 68;
                                case 40 -> 155;
                                case 41 -> 82;
                                case 42 -> 120;
                                case 43 -> 195;
                                case 44 -> 89;
                                case 45 -> 227;
                                case 46 -> 239;
                                case 47 -> 164;
                                case 48 -> 60;
                                case 49 -> 123;
                                case 50 -> 134;
                                case 51 -> 109;
                                case 52 -> 32;
                                case 53 -> 197;
                                case 54 -> 125;
                                case 55 -> 18;
                                case 56 -> 174;
                                case 57 -> 46;
                                case 58 -> 76;
                                case 59 -> 150;
                                case 60 -> 156;
                                case 61 -> 250;
                                case 62 -> 225;
                                case 63 -> 219;
                                case 64 -> 172;
                                case 65 -> 104;
                                case 66 -> 208;
                                case 67 -> 12;
                                case 68 -> 91;
                                case 69 -> 30;
                                case 70 -> 129;
                                case 71 -> 63;
                                case 72 -> 127;
                                case 73 -> 249;
                                case 74 -> 217;
                                case 75 -> 98;
                                case 76 -> 240;
                                case 77 -> 42;
                                case 78 -> 3;
                                case 79 -> 51;
                                case 80 -> 136;
                                case 81 -> 189;
                                case 82 -> 182;
                                case 83 -> 185;
                                case 84 -> 25;
                                case 85 -> 211;
                                case 86 -> 84;
                                case 87 -> 86;
                                case 88 -> 226;
                                case 89 -> 187;
                                case 90 -> 183;
                                case 91 -> 53;
                                case 92 -> 27;
                                case 93 -> 0;
                                case 94 -> 203;
                                case 95 -> 151;
                                case 96 -> 161;
                                case 97 -> 152;
                                case 98 -> 179;
                                case 99 -> 102;
                                case 100 -> 177;
                                case 101 -> 81;
                                case 102 -> 162;
                                case 103 -> 146;
                                case 104 -> 16;
                                case 105 -> 112;
                                case 106 -> 132;
                                case 107 -> 130;
                                case 108 -> 118;
                                case 109 -> 192;
                                case 110 -> 93;
                                case 111 -> 14;
                                case 112 -> 149;
                                case 113 -> 47;
                                case 114 -> 193;
                                case 115 -> 188;
                                case 116 -> 69;
                                case 117 -> 52;
                                case 118 -> 105;
                                case 119 -> 45;
                                case 120 -> 143;
                                case 121 -> 171;
                                case 122 -> 170;
                                case 123 -> 119;
                                case 124 -> 221;
                                case 125 -> 234;
                                case 126 -> 13;
                                case 127 -> 94;
                                case 128 -> 107;
                                case 129 -> 99;
                                case 130 -> 216;
                                case 131 -> 100;
                                case 132 -> 40;
                                case 133 -> 95;
                                case 134 -> 9;
                                case 135 -> 19;
                                case 136 -> 124;
                                case 137 -> 138;
                                case 138 -> 153;
                                case 139 -> 48;
                                case 140 -> 26;
                                case 141 -> 5;
                                case 142 -> 198;
                                case 143 -> 248;
                                case 144 -> 191;
                                case 145 -> 2;
                                case 146 -> 108;
                                case 147 -> 230;
                                case 148 -> 233;
                                case 149 -> 159;
                                case 150 -> 166;
                                case 151 -> 113;
                                case 152 -> 72;
                                case 153 -> 110;
                                case 154 -> 34;
                                case 155 -> 62;
                                case 156 -> 65;
                                case 157 -> 101;
                                case 158 -> 36;
                                case 159 -> 254;
                                case 160 -> 15;
                                case 161 -> 242;
                                case 162 -> 173;
                                case 163 -> 252;
                                case 164 -> 236;
                                case 165 -> 11;
                                case 166 -> 205;
                                case 167 -> 49;
                                case 168 -> 167;
                                case 169 -> 103;
                                case 170 -> 17;
                                case 171 -> 206;
                                case 172 -> 218;
                                case 173 -> 154;
                                case 174 -> 64;
                                case 175 -> 116;
                                case 176 -> 223;
                                case 177 -> 117;
                                case 178 -> 231;
                                case 179 -> 23;
                                case 180 -> 131;
                                case 181 -> 158;
                                case 182 -> 44;
                                case 183 -> 168;
                                case 184 -> 75;
                                case 185 -> 145;
                                case 186 -> 1;
                                case 187 -> 111;
                                case 188 -> 50;
                                case 189 -> 176;
                                case 190 -> 139;
                                case 191 -> 190;
                                case 192 -> 122;
                                case 193 -> 6;
                                case 194 -> 186;
                                case 195 -> 35;
                                case 196 -> 196;
                                case 197 -> 251;
                                case 198 -> 241;
                                case 199 -> 247;
                                case 200 -> 21;
                                case 201 -> 4;
                                case 202 -> 253;
                                case 203 -> 61;
                                case 204 -> 39;
                                case 205 -> 77;
                                case 206 -> 243;
                                case 207 -> 200;
                                case 208 -> 121;
                                case 209 -> 204;
                                case 210 -> 163;
                                case 211 -> 148;
                                case 212 -> 228;
                                case 213 -> 245;
                                case 214 -> 238;
                                case 215 -> 54;
                                case 216 -> 232;
                                case 217 -> 180;
                                case 218 -> 213;
                                case 219 -> 90;
                                case 220 -> 178;
                                case 221 -> 160;
                                case 222 -> 71;
                                case 223 -> 56;
                                case 224 -> 202;
                                case 225 -> 80;
                                case 226 -> 214;
                                case 227 -> 115;
                                case 228 -> 194;
                                case 229 -> 135;
                                case 230 -> 57;
                                case 231 -> 255;
                                case 232 -> 10;
                                case 233 -> 97;
                                case 234 -> 70;
                                case 235 -> 43;
                                case 236 -> 207;
                                case 237 -> 78;
                                case 238 -> 237;
                                case 239 -> 87;
                                case 240 -> 222;
                                case 241 -> 67;
                                case 242 -> 235;
                                case 243 -> 59;
                                case 244 -> 66;
                                case 245 -> 83;
                                case 246 -> 244;
                                case 247 -> 229;
                                case 248 -> 31;
                                case 249 -> 37;
                                case 250 -> 215;
                                case 251 -> 58;
                                case 252 -> 7;
                                case 253 -> 144;
                                case 254 -> 212;
                                default -> 114;
                            };
                            int n8 = ((n3 ^= n4) & 0xFF) - n7;
                            if (n8 < 0) {
                                n8 += 256;
                            }
                            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                n6 += 256;
                            }
                            int n9 = 0;
                            while (n9 < cArray.length) {
                                int n10 = n9 % 2;
                                int n11 = n9;
                                char[] cArray2 = cArray;
                                char c2 = cArray[n11];
                                if (n10 == 0) {
                                    cArray2[n11] = (char)(c2 ^ n8);
                                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                } else {
                                    cArray2[n11] = (char)(c2 ^ n6);
                                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                }
                                ++n9;
                            }
                            monitorOneConnection.6.b[n5] = new String(cArray).intern();
                        }
                        return b[n5];
                    }
                });
                Logger logger3 = ServerSocketWrapper.logger;
                Throwable throwable = null;
                boolean bl3 = false;
                try {
                    if (n3 != 0) break block9;
                    if (!logger3.isDebugEnabled()) break block10;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ServerSocketWrapper.a(illegalStateException);
                }
                logger = logger3;
                boolean bl4 = false;
                String string5 = string;
                int n8 = n4;
                String string6 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState())));
                int n9 = clientSocket.getPort();
                logger.debug(ServerSocketWrapper.a(-1285010280 + -10819, 1285010280 - 7251, (int)l2) + n9 + ServerSocketWrapper.a(-1285010280 + -10823, 1285010280 + 14238, (int)l2) + string6 + ServerSocketWrapper.a(-1285010280 + -10823, 1285010280 + 14238, (int)l2) + n8 + ServerSocketWrapper.a(-1285010280 + -10814, 1285010280 + 5065, (int)l2) + string5, throwable);
            }
            ApplicationKt.getApplication().invokeLater(() -> ServerSocketWrapper.monitorOneConnection$lambda$4(this, rdConnection), ModalityState.any());
        }
    }

    private final Thread createListeningThread(ServerSocket socket2) {
        long l2 = 99047953156837L;
        int n2 = this.rdPort.getPortNumber();
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)(ServerSocketWrapper.a(1712298480 + (char)-21651, 1712298480 + 27413, (int)l2) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.rdPort.getRdPortState()))) + ServerSocketWrapper.a(1712298480 + (char)-21657, -1712298480 + -((char)-9712), (int)l2) + n2), (int)0, (Function0)((Function0)new Function0<Unit>(this, n2, socket2){
            final /* synthetic */ ServerSocketWrapper this$0;
            final /* synthetic */ int $hostPortNumber;
            final /* synthetic */ ServerSocket $socket;
            private static final String[] a;
            private static final String[] b;
            {
                this.this$0 = $receiver;
                this.$hostPortNumber = $hostPortNumber;
                this.$socket = $socket;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block21: {
                    var1_1 = 24739864690809L;
                    v0 = ServerSocketPortState.j();
                    ServerSocketWrapper.Companion.getLogger().info(createListeningThread.1.a(-853003560 + -((char)-7694), -853003560 + -((char)-15041), (int)var1_1) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$0.getRdPort().getRdPortState()))) + createListeningThread.1.a(-853003560 + -((char)-7695), -853134630 - -((char)-647), (int)var1_1) + this.$hostPortNumber);
                    var3_2 = v0;
                    while (RLifetimeKt.isAlive((Lifetime)ServerSocketWrapper.access$getLifetime$p(this.this$0))) {
                        try {
                            block20: {
                                block17: {
                                    block18: {
                                        block19: {
                                            var4_3 = this.$socket.accept();
                                            try {
                                                v1 = RLifetimeKt.isAlive((Lifetime)ServerSocketWrapper.access$getLifetime$p(this.this$0));
                                                if (var3_2 == 0) {
                                                    if (!v1) break block17;
                                                }
                                                ** GOTO lbl72
                                            }
                                            catch (SocketTimeoutException v2) {
                                                throw createListeningThread.1.a(v2);
                                            }
                                            var5_8 = ServerSocketWrapper.Companion.getLogger();
                                            var6_9 = this.this$0;
                                            var7_11 = this.$hostPortNumber;
                                            var8_12 = false;
                                            try {
                                                if (var3_2 != 0) break block18;
                                                if (!var5_8.isTraceEnabled()) break block19;
                                            }
                                            catch (SocketTimeoutException v3) {
                                                throw createListeningThread.1.a(v3);
                                            }
                                            var10_14 = var5_8;
                                            var9_13 = false;
                                            var11_15 = var7_11;
                                            var12_16 = PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)var6_9.getRdPort().getRdPortState())));
                                            var13_17 = var4_3.getPort();
                                            var10_14.trace(createListeningThread.1.a(-853003560 + -((char)-7692), -853134630 - -((char)-8133), (int)var1_1) + var13_17 + createListeningThread.1.a(-853003560 + -((char)-7693), -853134630 - -((char)-5759), (int)var1_1) + var12_16 + createListeningThread.1.a(-853003560 + -((char)-7693), -853134630 - -((char)-5759), (int)var1_1) + var11_15);
                                        }
                                        Intrinsics.checkNotNull((Object)var4_3);
                                        ServerSocketWrapper.access$monitorOneConnection(this.this$0, var4_3);
                                    }
                                    if (var3_2 == 0) continue;
                                }
                                var5_8 = ServerSocketWrapper.Companion.getLogger();
                                var6_10 = false;
                                try {
                                    if (var3_2 != 0) continue;
                                    if (!var5_8.isTraceEnabled()) break block20;
                                }
                                catch (SocketTimeoutException v4) {
                                    throw createListeningThread.1.a(v4);
                                }
                                var10_14 = var5_8;
                                var7_11 = 0;
                                var10_14.trace(createListeningThread.1.a(-853003560 + -((char)-7690), -853003560 + -((char)-9560), (int)var1_1));
                            }
                            var4_3.close();
                        }
                        catch (SocketTimeoutException var4_4) {
                        }
                        catch (SocketException var4_5) {
                            ServerSocketWrapper.Companion.getLogger().warn(createListeningThread.1.a(-853003560 + -((char)-7691), 853003560 + (char)-6562, (int)var1_1), (Throwable)var4_5);
                            break;
                        }
                        catch (Throwable var4_6) {
                            ServerSocketWrapper.Companion.getLogger().error(var4_6);
                            break;
                        }
                    }
                    try {
                        try {
                            if (var3_2 != 0) break block21;
                            v1 = this.$socket.isClosed();
                        }
                        catch (SocketTimeoutException v5) {
                            throw createListeningThread.1.a(v5);
                        }
lbl72:
                        // 2 sources

                        if (!v1) {
                            this.$socket.close();
                        }
                    }
                    catch (Throwable var4_7) {
                        ServerSocketWrapper.Companion.getLogger().warn(var4_7);
                    }
                    ServerSocketWrapper.Companion.getLogger().info(createListeningThread.1.a(-853003560 + -((char)-7688), 853134630 - (char)-6926, (int)var1_1) + PortForwardingUtilsKt.readable((RdPortState)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.this$0.getRdPort().getRdPortState()))) + createListeningThread.1.a(-853003560 + -((char)-7693), -853134630 - -((char)-5759), (int)var1_1) + this.$hostPortNumber);
                }
            }

            private static SocketTimeoutException a(SocketTimeoutException socketTimeoutException) {
                return socketTimeoutException;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block20: {
                    block19: {
                        var5 = new String[7];
                        var3_1 = 0;
                        var2_2 = "\u0018?\u00d7K\u00b7a\u00fb\u00a6\u00c3\u00a3\u0017\fI\u0004\u001c\u00f4\u00d7O\u00d3_\u00ca\u0017\u00e0M\u00a1v\u0004\u00b3\u00d7\u00e0v\u0015W\u0085l\u00fe\u0086?R\u00d0\u009c\u001d\u00fc\u00b6.\u0089\u00ac\u00b3\u007f\u00c7\u00b1\u001d,\u0004\u0093\u0003\u00e4\u00ec:\\\u0098\r]\u00aaK\u00d7^,\u00cc\u00ea\u008c\u00ec\u00ce\u00f4[t\u00da\u00d0\u00a4Bl-\u00fa\u001f}9z|k\u0019\u00a0\u00d6\u0019)P\u00bd\u00cb0,\u0085\u00bc\u008e\u0089\u00bd\u00b5\u0094\u008fb\u0019\u00fb\u000b\u000e\u00bb\u00b99\u00b6\u0086";
                        var4_3 = "\u0018?\u00d7K\u00b7a\u00fb\u00a6\u00c3\u00a3\u0017\fI\u0004\u001c\u00f4\u00d7O\u00d3_\u00ca\u0017\u00e0M\u00a1v\u0004\u00b3\u00d7\u00e0v\u0015W\u0085l\u00fe\u0086?R\u00d0\u009c\u001d\u00fc\u00b6.\u0089\u00ac\u00b3\u007f\u00c7\u00b1\u001d,\u0004\u0093\u0003\u00e4\u00ec:\\\u0098\r]\u00aaK\u00d7^,\u00cc\u00ea\u008c\u00ec\u00ce\u00f4[t\u00da\u00d0\u00a4Bl-\u00fa\u001f}9z|k\u0019\u00a0\u00d6\u0019)P\u00bd\u00cb0,\u0085\u00bc\u008e\u0089\u00bd\u00b5\u0094\u008fb\u0019\u00fb\u000b\u000e\u00bb\u00b99\u00b6\u0086".length();
                        var1_4 = 26;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            v0 = 79;
                            v1 = ++var0_5;
                            v2 = var2_2.substring(v1, v1 + var1_4);
                            v3 = -1;
                            break block19;
                            break;
                        }
lbl13:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = v4.intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            var2_2 = "Y\u00be\u008am8\u00f5\u0000\u00ff\u0014\u00ae\u00c3\u00a9\u00ef\u00cc\u00b6\u00fb\u0017\u00f8\u00a9m\u00a0\"\u00d72o\u0002\u00e0\u000f\u0083\u0080F;\u00ddw\u00c1\u00b8\u0094\u00da\u00d5\u00b8";
                            var4_3 = "Y\u00be\u008am8\u00f5\u0000\u00ff\u0014\u00ae\u00c3\u00a9\u00ef\u00cc\u00b6\u00fb\u0017\u00f8\u00a9m\u00a0\"\u00d72o\u0002\u00e0\u000f\u0083\u0080F;\u00ddw\u00c1\u00b8\u0094\u00da\u00d5\u00b8".length();
                            var1_4 = 16;
                            var0_5 = -1;
lbl22:
                            // 2 sources

                            while (true) {
                                v0 = 55;
                                v5 = ++var0_5;
                                v2 = var2_2.substring(v5, v5 + var1_4);
                                v3 = 0;
                                break block19;
                                break;
                            }
                            break;
                        }
lbl28:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = v4.intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block20;
                            break;
                        }
                    }
                    v6 = v2.toCharArray();
                    v7 = v6.length;
                    var6_6 = 0;
                    v8 = v0;
                    v9 = v6;
                    v10 = v7;
                    if (v7 > 1) ** GOTO lbl85
                    do {
                        v11 = v8;
                        v9 = v9;
                        v12 = v9;
                        v13 = v8;
                        v14 = var6_6;
                        while (true) {
                            switch (var6_6 % 7) {
                                case 0: {
                                    v15 = 97;
                                    break;
                                }
                                case 1: {
                                    v15 = 54;
                                    break;
                                }
                                case 2: {
                                    v15 = 6;
                                    break;
                                }
                                case 3: {
                                    v15 = 68;
                                    break;
                                }
                                case 4: {
                                    v15 = 18;
                                    break;
                                }
                                case 5: {
                                    v15 = 115;
                                    break;
                                }
                                default: {
                                    v15 = 125;
                                }
                            }
                            v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                            ++var6_6;
                            v8 = v11;
                            if (v11 != 0) break;
                            v11 = v8;
                            v9 = v9;
                            v14 = v8;
                            v12 = v9;
                            v13 = v8;
                        }
lbl85:
                        // 2 sources

                        v16 = v9;
                        v10 = v10;
                    } while (v10 > var6_6);
                    v4 = new String(v16);
                    switch (v3) {
                        default: {
                            ** continue;
                        }
                        ** case 0:
lbl95:
                        // 1 sources

                        ** continue;
                    }
                }
                createListeningThread.1.a = var5;
                createListeningThread.1.b = new String[7];
            }

            private static String a(int n2, int n3, int n4) {
                int n5 = (n2 ^ n4 ^ 0xFFFF909F) & 0xFFFF;
                if (b[n5] == null) {
                    int n6;
                    char[] cArray = a[n5].toCharArray();
                    int n7 = switch (cArray[0] & 0xFF) {
                        case 0 -> 66;
                        case 1 -> 132;
                        case 2 -> 88;
                        case 3 -> 254;
                        case 4 -> 118;
                        case 5 -> 250;
                        case 6 -> 186;
                        case 7 -> 2;
                        case 8 -> 170;
                        case 9 -> 41;
                        case 10 -> 0;
                        case 11 -> 70;
                        case 12 -> 248;
                        case 13 -> 152;
                        case 14 -> 208;
                        case 15 -> 163;
                        case 16 -> 101;
                        case 17 -> 140;
                        case 18 -> 194;
                        case 19 -> 215;
                        case 20 -> 181;
                        case 21 -> 180;
                        case 22 -> 209;
                        case 23 -> 245;
                        case 24 -> 87;
                        case 25 -> 135;
                        case 26 -> 193;
                        case 27 -> 185;
                        case 28 -> 80;
                        case 29 -> 224;
                        case 30 -> 71;
                        case 31 -> 102;
                        case 32 -> 116;
                        case 33 -> 234;
                        case 34 -> 238;
                        case 35 -> 82;
                        case 36 -> 57;
                        case 37 -> 231;
                        case 38 -> 228;
                        case 39 -> 139;
                        case 40 -> 227;
                        case 41 -> 202;
                        case 42 -> 92;
                        case 43 -> 99;
                        case 44 -> 166;
                        case 45 -> 205;
                        case 46 -> 157;
                        case 47 -> 168;
                        case 48 -> 149;
                        case 49 -> 230;
                        case 50 -> 85;
                        case 51 -> 171;
                        case 52 -> 182;
                        case 53 -> 19;
                        case 54 -> 123;
                        case 55 -> 53;
                        case 56 -> 26;
                        case 57 -> 141;
                        case 58 -> 10;
                        case 59 -> 243;
                        case 60 -> 212;
                        case 61 -> 161;
                        case 62 -> 251;
                        case 63 -> 74;
                        case 64 -> 198;
                        case 65 -> 24;
                        case 66 -> 129;
                        case 67 -> 77;
                        case 68 -> 12;
                        case 69 -> 199;
                        case 70 -> 58;
                        case 71 -> 8;
                        case 72 -> 75;
                        case 73 -> 191;
                        case 74 -> 115;
                        case 75 -> 4;
                        case 76 -> 223;
                        case 77 -> 18;
                        case 78 -> 33;
                        case 79 -> 216;
                        case 80 -> 207;
                        case 81 -> 255;
                        case 82 -> 42;
                        case 83 -> 103;
                        case 84 -> 221;
                        case 85 -> 65;
                        case 86 -> 146;
                        case 87 -> 137;
                        case 88 -> 203;
                        case 89 -> 27;
                        case 90 -> 55;
                        case 91 -> 16;
                        case 92 -> 14;
                        case 93 -> 126;
                        case 94 -> 147;
                        case 95 -> 143;
                        case 96 -> 114;
                        case 97 -> 169;
                        case 98 -> 235;
                        case 99 -> 50;
                        case 100 -> 252;
                        case 101 -> 218;
                        case 102 -> 100;
                        case 103 -> 79;
                        case 104 -> 83;
                        case 105 -> 196;
                        case 106 -> 73;
                        case 107 -> 162;
                        case 108 -> 176;
                        case 109 -> 213;
                        case 110 -> 154;
                        case 111 -> 247;
                        case 112 -> 69;
                        case 113 -> 177;
                        case 114 -> 22;
                        case 115 -> 111;
                        case 116 -> 107;
                        case 117 -> 105;
                        case 118 -> 20;
                        case 119 -> 35;
                        case 120 -> 110;
                        case 121 -> 52;
                        case 122 -> 28;
                        case 123 -> 172;
                        case 124 -> 31;
                        case 125 -> 246;
                        case 126 -> 201;
                        case 127 -> 9;
                        case 128 -> 195;
                        case 129 -> 178;
                        case 130 -> 240;
                        case 131 -> 237;
                        case 132 -> 151;
                        case 133 -> 117;
                        case 134 -> 128;
                        case 135 -> 62;
                        case 136 -> 127;
                        case 137 -> 15;
                        case 138 -> 64;
                        case 139 -> 125;
                        case 140 -> 144;
                        case 141 -> 200;
                        case 142 -> 104;
                        case 143 -> 120;
                        case 144 -> 63;
                        case 145 -> 56;
                        case 146 -> 3;
                        case 147 -> 184;
                        case 148 -> 37;
                        case 149 -> 25;
                        case 150 -> 156;
                        case 151 -> 44;
                        case 152 -> 167;
                        case 153 -> 49;
                        case 154 -> 72;
                        case 155 -> 30;
                        case 156 -> 222;
                        case 157 -> 109;
                        case 158 -> 84;
                        case 159 -> 81;
                        case 160 -> 21;
                        case 161 -> 164;
                        case 162 -> 39;
                        case 163 -> 48;
                        case 164 -> 91;
                        case 165 -> 46;
                        case 166 -> 225;
                        case 167 -> 40;
                        case 168 -> 220;
                        case 169 -> 236;
                        case 170 -> 17;
                        case 171 -> 189;
                        case 172 -> 253;
                        case 173 -> 6;
                        case 174 -> 98;
                        case 175 -> 67;
                        case 176 -> 130;
                        case 177 -> 29;
                        case 178 -> 13;
                        case 179 -> 36;
                        case 180 -> 34;
                        case 181 -> 38;
                        case 182 -> 94;
                        case 183 -> 78;
                        case 184 -> 148;
                        case 185 -> 54;
                        case 186 -> 211;
                        case 187 -> 138;
                        case 188 -> 175;
                        case 189 -> 133;
                        case 190 -> 226;
                        case 191 -> 119;
                        case 192 -> 113;
                        case 193 -> 249;
                        case 194 -> 112;
                        case 195 -> 7;
                        case 196 -> 150;
                        case 197 -> 158;
                        case 198 -> 60;
                        case 199 -> 204;
                        case 200 -> 210;
                        case 201 -> 11;
                        case 202 -> 97;
                        case 203 -> 241;
                        case 204 -> 145;
                        case 205 -> 61;
                        case 206 -> 1;
                        case 207 -> 155;
                        case 208 -> 229;
                        case 209 -> 131;
                        case 210 -> 108;
                        case 211 -> 96;
                        case 212 -> 23;
                        case 213 -> 217;
                        case 214 -> 5;
                        case 215 -> 124;
                        case 216 -> 76;
                        case 217 -> 59;
                        case 218 -> 45;
                        case 219 -> 106;
                        case 220 -> 142;
                        case 221 -> 165;
                        case 222 -> 214;
                        case 223 -> 233;
                        case 224 -> 121;
                        case 225 -> 188;
                        case 226 -> 173;
                        case 227 -> 136;
                        case 228 -> 242;
                        case 229 -> 153;
                        case 230 -> 197;
                        case 231 -> 68;
                        case 232 -> 192;
                        case 233 -> 90;
                        case 234 -> 93;
                        case 235 -> 89;
                        case 236 -> 183;
                        case 237 -> 232;
                        case 238 -> 134;
                        case 239 -> 206;
                        case 240 -> 160;
                        case 241 -> 32;
                        case 242 -> 187;
                        case 243 -> 190;
                        case 244 -> 47;
                        case 245 -> 174;
                        case 246 -> 86;
                        case 247 -> 244;
                        case 248 -> 179;
                        case 249 -> 51;
                        case 250 -> 95;
                        case 251 -> 239;
                        case 252 -> 122;
                        case 253 -> 43;
                        case 254 -> 159;
                        default -> 219;
                    };
                    int n8 = ((n3 ^= n4) & 0xFF) - n7;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                        n6 += 256;
                    }
                    int n9 = 0;
                    while (n9 < cArray.length) {
                        int n10 = n9 % 2;
                        int n11 = n9;
                        char[] cArray2 = cArray;
                        char c2 = cArray[n11];
                        if (n10 == 0) {
                            cArray2[n11] = (char)(c2 ^ n8);
                            n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                        } else {
                            cArray2[n11] = (char)(c2 ^ n6);
                            n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                        }
                        ++n9;
                    }
                    createListeningThread.1.b[n5] = new String(cArray).intern();
                }
                return b[n5];
            }
        }), (int)20, null);
    }

    private static final void changeListeningSocket$lambda$0(ServerSocketWrapper this$0) {
        long l2 = 21640445877241L;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)ServerSocketWrapper.a(-1894354710 - -25432, 1894354710 - 16805, (int)l2));
        IOptProperty iOptProperty = this$0.rdPort.getRdPortState();
        SocketAddress socketAddress = this$0.getServerSocket().getLocalSocketAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)ServerSocketWrapper.a(-1894354710 - -25433, 1894354710 - 6918, (int)l2));
        iOptProperty.set((Object)new RdPortState(SocketState.LISTENING, PortForwardingUtilsKt.toRdSocketAddress((InetSocketAddress)socketAddress), null));
    }

    private static final void monitorOneConnection$lambda$4(ServerSocketWrapper this$0, RdConnection $rdConnection) {
        long l2 = 72598318630509L;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)ServerSocketWrapper.a(486400770 + 26318, -486400770 + -((char)-28016), (int)l2));
        Intrinsics.checkNotNullParameter((Object)$rdConnection, (String)ServerSocketWrapper.a(486400770 + 26319, 486400770 + 12091, (int)l2));
        this$0.rdPort.getConnections().add((Object)$rdConnection);
    }

    public static final /* synthetic */ LongCounter access$getReceivedBytesCounter$p(ServerSocketWrapper $this) {
        return $this.receivedBytesCounter;
    }

    public static final /* synthetic */ LongCounter access$getSentBytesCounter$p(ServerSocketWrapper $this) {
        return $this.sentBytesCounter;
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(ServerSocketWrapper $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ void access$monitorOneConnection(ServerSocketWrapper $this, Socket clientSocket) {
        $this.monitorOneConnection(clientSocket);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var7 = 31247311885560L;
                var5_1 = new String[31];
                var3_2 = 0;
                var2_3 = "M\u00abn\u0091\u00be\t\u00c4\u00d5\u0006\u0003'L\u00a6\f\u00b9\b\u000bO\u0093\u00fe\u00ee~\u00cb\u00b7#\u00ba\u00ddH\u00e2\u0085n\u00baSZsDY@\u00f54f\u00b4\u0097\u00b3\u00b5\u00be^~\u0087\u00ed\u0012\u00a8\u00b5}\u00e5l\u0007\u0013\u00f2\u0001\u0005@\u00d2\u0012\u00acf'e\u0010\u00b3[\u00faYU\u00b5\u00a7\u00af\u00fb\u00c2\u00b7\u0086\u00ca\bkZH\f\u00c1i\u0091a\u0010\u00cf\u0017\"\u009b\u0090\u008c\u00f6\u00e0\u00ce\tr\u00a0\u00876\u0005\u0092\u0099H\u00c5--G\u00a5\u00c3\u0096j\u00e9\u0000\u00c4\u0005\u00d8\u00af\u000f\u00eai~\u00e5\u001a\u0085\u001bv\f2f\u0080*0&\u0006o\u009b\u00c7\u00c4\u00dd\u009a5\u00eck`\u00822x\u00e3ur\u00181\u009f\u00c0\u00d8:\t|lv\u0088\u008e\u001e\u00c5\u00dc0\u00b8\u00ce\u00c2\u00e0\u0000\u00dao\u00a7\n2\u00a7f\u0087\u00cfC\u00cf\u0002\u0081\r>`\u00fex_w \u00e0\u00aa\u001f-\u0010A\u0000\u000frF\u009fF\u00f8\u00b2\u00eb\u0007\u0010z\u00fbqS\u00e9\u0083P6\u00ef\u00e2K\u00ba%q\u00ef\u00dd3\u00de\u000fa\u00a2\u001e.8H\u0095\u0012\u008c\u00bf\u001e\u0013Cd\u00db.\u0014&\u00ad\u00bf\u0004\u00dcOm\u00f9_\u00b0kZ\u008d\u0017B\u00cd2M\u0017\u00c4xa1\u0000\u00e1\u00e9_G\u00c3\u0088\u0087\u008ev\u0089\u0083\u0080\u00b9\u001cz.\u0089\u00ec\u0089\u00ae&t\u001a^\u0010\u00bc.\u0096\u008e\u00df\u008e^\u00c3\u009e\u00f0\u00ad\u00fb\u0011{M\u00f5\u00d4\u00dfr\u00cb\u00e2\u008aT@ \u001b\u0083W\u00ee{?\u0018\u0000\u00b5S\u0007Q\u00e1\u0080.\u00d2\u008bf\u008c\u00c7*\u00bc\u00b4a\u00a4!T\u0003\u0092-\u00c6g\u00c2\u00d0r\u0011\u0087yw7p\u008c\u00bb\t1\u0093\u00f7!o\u00e7\u00d0\u0010\u00ef<\\G\u00e1\u0095\u0012\u0004\u00d5*\u00e0(\t\u00a3\b\u0014\u009e\u00ce\u008d[\u00a1\u00de\t=4\u00c7\u0019\u00b4}\u0014\u00bf7\u0013\u00d9\u00cb\u0084=\u00a8\u000egH\u00c0DG\u00a8<+g\u00e4\u00af\u009c\u009a?\u001f6l\u00b4\u00e1\u008f\u00fdE.$\u00d7\u008b\u00f9\u00b4\u00e4\u008e\u0099h\u00a7\u00ab\u00fe\u00eb\u00b7\u00d1xZ;\u0002O=\u001e\u00a3\u00fb\u00b2q\u00b0\u00c2\u00f5\u00d8B\u00acZcw\u00fb\u00cca\u0087\u00ad\u00f2\u009d\u008b,5tP\u00d3&7\u009b\u00c6\u00a7\u00e6\r\u001c\u0016j\u00f1\u00ab6\u00a30M\u00e3o\u0014\u00b4\u0015\u00f5\u00ec\u00b0\u0005\u0006\u001f\u00d0\u0015+\n\u00eb\u008d\n\u00f3Tq\u00ac~\u0012\u00ecE\u0004\u00fd\u00f2\u00e53\u0006\u00e1\u00be\u00bcRD\u0019\u001e\u00c6\u00f2\u00c9\u00f1\u0095\u0019\u00b2Hw\u00a0q\u00f2mx4\u00f6\u00ca\u00ed\u00e8\u00ba\u00d2Z\u001dV\u008dN\u007f\u00cb\u0019H'\u00e4\f\u00f4\u00b2/q*\u0007\u0002\u00fdn;\u0003e\u0096\u009dz=\u0083\u00d02\u000fI\u00c7y\u007f\u0016\u00bc[\u00ad+-e_\u00e0\u00fe\u00ee\u00e1\u00d0\u00132~\u000b\u008bJ\u00c9N\u00040\u00a1/_\u00be\u00d2d}\u00e6\u00d2\u00f2\u0006&\u007fDj[\u001e\u000f\u00ec\u008d\u00f5\u0082i^U\u00ebE\u00d6D.\u0089\u00b2\u00f8\u0006p3\u00dd\u00b5v\u0000?P\u00a8\u0085g\u00dc\u00f5Z\n\u00da\u00cdI\u00b6*\u0013\u009ez\u00d6\u00f6Nx\u00c3\u0091\u0010\u009e\u008c\u00b3\u00a5?\u009c\u009adW\u00b4,\u0098c\u00ff\u008f\u007f\rX\u00b3\u00fdJ(k\u001bs\u00e2ltX\u0011O\u00d3\u001f'\u00cf\u00a9\u00a6\u0015\u0000\u009c\u0006P\u0098\u00d9\u00c0\u00f6\u00ae";
                var4_4 = "M\u00abn\u0091\u00be\t\u00c4\u00d5\u0006\u0003'L\u00a6\f\u00b9\b\u000bO\u0093\u00fe\u00ee~\u00cb\u00b7#\u00ba\u00ddH\u00e2\u0085n\u00baSZsDY@\u00f54f\u00b4\u0097\u00b3\u00b5\u00be^~\u0087\u00ed\u0012\u00a8\u00b5}\u00e5l\u0007\u0013\u00f2\u0001\u0005@\u00d2\u0012\u00acf'e\u0010\u00b3[\u00faYU\u00b5\u00a7\u00af\u00fb\u00c2\u00b7\u0086\u00ca\bkZH\f\u00c1i\u0091a\u0010\u00cf\u0017\"\u009b\u0090\u008c\u00f6\u00e0\u00ce\tr\u00a0\u00876\u0005\u0092\u0099H\u00c5--G\u00a5\u00c3\u0096j\u00e9\u0000\u00c4\u0005\u00d8\u00af\u000f\u00eai~\u00e5\u001a\u0085\u001bv\f2f\u0080*0&\u0006o\u009b\u00c7\u00c4\u00dd\u009a5\u00eck`\u00822x\u00e3ur\u00181\u009f\u00c0\u00d8:\t|lv\u0088\u008e\u001e\u00c5\u00dc0\u00b8\u00ce\u00c2\u00e0\u0000\u00dao\u00a7\n2\u00a7f\u0087\u00cfC\u00cf\u0002\u0081\r>`\u00fex_w \u00e0\u00aa\u001f-\u0010A\u0000\u000frF\u009fF\u00f8\u00b2\u00eb\u0007\u0010z\u00fbqS\u00e9\u0083P6\u00ef\u00e2K\u00ba%q\u00ef\u00dd3\u00de\u000fa\u00a2\u001e.8H\u0095\u0012\u008c\u00bf\u001e\u0013Cd\u00db.\u0014&\u00ad\u00bf\u0004\u00dcOm\u00f9_\u00b0kZ\u008d\u0017B\u00cd2M\u0017\u00c4xa1\u0000\u00e1\u00e9_G\u00c3\u0088\u0087\u008ev\u0089\u0083\u0080\u00b9\u001cz.\u0089\u00ec\u0089\u00ae&t\u001a^\u0010\u00bc.\u0096\u008e\u00df\u008e^\u00c3\u009e\u00f0\u00ad\u00fb\u0011{M\u00f5\u00d4\u00dfr\u00cb\u00e2\u008aT@ \u001b\u0083W\u00ee{?\u0018\u0000\u00b5S\u0007Q\u00e1\u0080.\u00d2\u008bf\u008c\u00c7*\u00bc\u00b4a\u00a4!T\u0003\u0092-\u00c6g\u00c2\u00d0r\u0011\u0087yw7p\u008c\u00bb\t1\u0093\u00f7!o\u00e7\u00d0\u0010\u00ef<\\G\u00e1\u0095\u0012\u0004\u00d5*\u00e0(\t\u00a3\b\u0014\u009e\u00ce\u008d[\u00a1\u00de\t=4\u00c7\u0019\u00b4}\u0014\u00bf7\u0013\u00d9\u00cb\u0084=\u00a8\u000egH\u00c0DG\u00a8<+g\u00e4\u00af\u009c\u009a?\u001f6l\u00b4\u00e1\u008f\u00fdE.$\u00d7\u008b\u00f9\u00b4\u00e4\u008e\u0099h\u00a7\u00ab\u00fe\u00eb\u00b7\u00d1xZ;\u0002O=\u001e\u00a3\u00fb\u00b2q\u00b0\u00c2\u00f5\u00d8B\u00acZcw\u00fb\u00cca\u0087\u00ad\u00f2\u009d\u008b,5tP\u00d3&7\u009b\u00c6\u00a7\u00e6\r\u001c\u0016j\u00f1\u00ab6\u00a30M\u00e3o\u0014\u00b4\u0015\u00f5\u00ec\u00b0\u0005\u0006\u001f\u00d0\u0015+\n\u00eb\u008d\n\u00f3Tq\u00ac~\u0012\u00ecE\u0004\u00fd\u00f2\u00e53\u0006\u00e1\u00be\u00bcRD\u0019\u001e\u00c6\u00f2\u00c9\u00f1\u0095\u0019\u00b2Hw\u00a0q\u00f2mx4\u00f6\u00ca\u00ed\u00e8\u00ba\u00d2Z\u001dV\u008dN\u007f\u00cb\u0019H'\u00e4\f\u00f4\u00b2/q*\u0007\u0002\u00fdn;\u0003e\u0096\u009dz=\u0083\u00d02\u000fI\u00c7y\u007f\u0016\u00bc[\u00ad+-e_\u00e0\u00fe\u00ee\u00e1\u00d0\u00132~\u000b\u008bJ\u00c9N\u00040\u00a1/_\u00be\u00d2d}\u00e6\u00d2\u00f2\u0006&\u007fDj[\u001e\u000f\u00ec\u008d\u00f5\u0082i^U\u00ebE\u00d6D.\u0089\u00b2\u00f8\u0006p3\u00dd\u00b5v\u0000?P\u00a8\u0085g\u00dc\u00f5Z\n\u00da\u00cdI\u00b6*\u0013\u009ez\u00d6\u00f6Nx\u00c3\u0091\u0010\u009e\u008c\u00b3\u00a5?\u009c\u009adW\u00b4,\u0098c\u00ff\u008f\u007f\rX\u00b3\u00fdJ(k\u001bs\u00e2ltX\u0011O\u00d3\u001f'\u00cf\u00a9\u00a6\u0015\u0000\u009c\u0006P\u0098\u00d9\u00c0\u00f6\u00ae".length();
                var1_5 = 8;
                var0_6 = -1;
lbl8:
                // 2 sources

                while (true) {
                    v0 = 123;
                    v1 = ++var0_6;
                    v2 = var2_3.substring(v1, v1 + var1_5);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl14:
                // 1 sources

                while (true) {
                    var5_1[var3_2++] = v4.intern();
                    if ((var0_6 += var1_5) < var4_4) {
                        var1_5 = var2_3.charAt(var0_6);
                        ** continue;
                    }
                    var2_3 = "\u00df\u00a8\u00fe.t\u009ag\u00c1\u001fD\u00c11\b\u0010t\u0013\u00b0\u00a6\u00ae\u00dd\u0007\u0093G\u009dj\u00b8\u00b0\u0011\u0087\u00d3";
                    var4_4 = "\u00df\u00a8\u00fe.t\u009ag\u00c1\u001fD\u00c11\b\u0010t\u0013\u00b0\u00a6\u00ae\u00dd\u0007\u0093G\u009dj\u00b8\u00b0\u0011\u0087\u00d3".length();
                    var1_5 = 13;
                    var0_6 = -1;
lbl23:
                    // 2 sources

                    while (true) {
                        v0 = 94;
                        v5 = ++var0_6;
                        v2 = var2_3.substring(v5, v5 + var1_5);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl29:
                // 1 sources

                while (true) {
                    var5_1[var3_2++] = v4.intern();
                    if ((var0_6 += var1_5) < var4_4) {
                        var1_5 = var2_3.charAt(var0_6);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_7 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl86
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_7;
                while (true) {
                    switch (var6_7 % 7) {
                        case 0: {
                            v15 = 65;
                            break;
                        }
                        case 1: {
                            v15 = 108;
                            break;
                        }
                        case 2: {
                            v15 = 124;
                            break;
                        }
                        case 3: {
                            v15 = 92;
                            break;
                        }
                        case 4: {
                            v15 = 54;
                            break;
                        }
                        case 5: {
                            v15 = 4;
                            break;
                        }
                        default: {
                            v15 = 86;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_7;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl86:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_7);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl96:
                // 1 sources

                ** continue;
            }
        }
        ServerSocketWrapper.a = var5_1;
        ServerSocketWrapper.b = new String[31];
        ServerSocketWrapper.Companion = new Companion(null);
        var9_8 = false;
        var10_9 = false;
        v17 = Logger.getInstance(ServerSocketWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)v17, (String)ServerSocketWrapper.a(1424861970 - (char)-12341, -1424861970 - -((char)-825), (int)var7));
        ServerSocketWrapper.logger = v17;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    private static String a(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFA1) & 0xFFFF;
        if (b[n5] == null) {
            int n6;
            char[] cArray = a[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 166;
                case 1 -> 46;
                case 2 -> 47;
                case 3 -> 246;
                case 4 -> 242;
                case 5 -> 243;
                case 6 -> 204;
                case 7 -> 110;
                case 8 -> 173;
                case 9 -> 82;
                case 10 -> 145;
                case 11 -> 218;
                case 12 -> 80;
                case 13 -> 126;
                case 14 -> 132;
                case 15 -> 192;
                case 16 -> 156;
                case 17 -> 255;
                case 18 -> 232;
                case 19 -> 227;
                case 20 -> 157;
                case 21 -> 150;
                case 22 -> 207;
                case 23 -> 186;
                case 24 -> 184;
                case 25 -> 106;
                case 26 -> 62;
                case 27 -> 94;
                case 28 -> 162;
                case 29 -> 141;
                case 30 -> 215;
                case 31 -> 112;
                case 32 -> 177;
                case 33 -> 75;
                case 34 -> 210;
                case 35 -> 73;
                case 36 -> 146;
                case 37 -> 56;
                case 38 -> 113;
                case 39 -> 167;
                case 40 -> 179;
                case 41 -> 120;
                case 42 -> 63;
                case 43 -> 236;
                case 44 -> 9;
                case 45 -> 153;
                case 46 -> 181;
                case 47 -> 102;
                case 48 -> 23;
                case 49 -> 20;
                case 50 -> 230;
                case 51 -> 182;
                case 52 -> 24;
                case 53 -> 19;
                case 54 -> 195;
                case 55 -> 171;
                case 56 -> 217;
                case 57 -> 140;
                case 58 -> 98;
                case 59 -> 220;
                case 60 -> 123;
                case 61 -> 241;
                case 62 -> 211;
                case 63 -> 185;
                case 64 -> 97;
                case 65 -> 103;
                case 66 -> 28;
                case 67 -> 40;
                case 68 -> 27;
                case 69 -> 223;
                case 70 -> 25;
                case 71 -> 1;
                case 72 -> 234;
                case 73 -> 225;
                case 74 -> 74;
                case 75 -> 144;
                case 76 -> 178;
                case 77 -> 8;
                case 78 -> 70;
                case 79 -> 213;
                case 80 -> 121;
                case 81 -> 253;
                case 82 -> 36;
                case 83 -> 214;
                case 84 -> 0;
                case 85 -> 143;
                case 86 -> 188;
                case 87 -> 244;
                case 88 -> 92;
                case 89 -> 104;
                case 90 -> 231;
                case 91 -> 85;
                case 92 -> 118;
                case 93 -> 49;
                case 94 -> 21;
                case 95 -> 142;
                case 96 -> 41;
                case 97 -> 252;
                case 98 -> 88;
                case 99 -> 187;
                case 100 -> 251;
                case 101 -> 38;
                case 102 -> 151;
                case 103 -> 197;
                case 104 -> 248;
                case 105 -> 199;
                case 106 -> 229;
                case 107 -> 65;
                case 108 -> 69;
                case 109 -> 160;
                case 110 -> 139;
                case 111 -> 4;
                case 112 -> 163;
                case 113 -> 55;
                case 114 -> 183;
                case 115 -> 58;
                case 116 -> 66;
                case 117 -> 196;
                case 118 -> 53;
                case 119 -> 165;
                case 120 -> 61;
                case 121 -> 5;
                case 122 -> 105;
                case 123 -> 115;
                case 124 -> 26;
                case 125 -> 138;
                case 126 -> 221;
                case 127 -> 161;
                case 128 -> 39;
                case 129 -> 109;
                case 130 -> 91;
                case 131 -> 51;
                case 132 -> 205;
                case 133 -> 34;
                case 134 -> 12;
                case 135 -> 169;
                case 136 -> 60;
                case 137 -> 83;
                case 138 -> 68;
                case 139 -> 240;
                case 140 -> 136;
                case 141 -> 131;
                case 142 -> 84;
                case 143 -> 72;
                case 144 -> 190;
                case 145 -> 52;
                case 146 -> 59;
                case 147 -> 30;
                case 148 -> 16;
                case 149 -> 226;
                case 150 -> 208;
                case 151 -> 42;
                case 152 -> 135;
                case 153 -> 96;
                case 154 -> 147;
                case 155 -> 247;
                case 156 -> 203;
                case 157 -> 22;
                case 158 -> 44;
                case 159 -> 193;
                case 160 -> 137;
                case 161 -> 170;
                case 162 -> 149;
                case 163 -> 158;
                case 164 -> 50;
                case 165 -> 233;
                case 166 -> 155;
                case 167 -> 239;
                case 168 -> 180;
                case 169 -> 189;
                case 170 -> 11;
                case 171 -> 14;
                case 172 -> 81;
                case 173 -> 35;
                case 174 -> 235;
                case 175 -> 206;
                case 176 -> 15;
                case 177 -> 71;
                case 178 -> 32;
                case 179 -> 200;
                case 180 -> 175;
                case 181 -> 3;
                case 182 -> 37;
                case 183 -> 67;
                case 184 -> 29;
                case 185 -> 209;
                case 186 -> 45;
                case 187 -> 95;
                case 188 -> 224;
                case 189 -> 212;
                case 190 -> 89;
                case 191 -> 168;
                case 192 -> 108;
                case 193 -> 176;
                case 194 -> 116;
                case 195 -> 194;
                case 196 -> 43;
                case 197 -> 148;
                case 198 -> 111;
                case 199 -> 254;
                case 200 -> 101;
                case 201 -> 2;
                case 202 -> 48;
                case 203 -> 99;
                case 204 -> 86;
                case 205 -> 191;
                case 206 -> 119;
                case 207 -> 228;
                case 208 -> 130;
                case 209 -> 77;
                case 210 -> 117;
                case 211 -> 164;
                case 212 -> 33;
                case 213 -> 154;
                case 214 -> 90;
                case 215 -> 13;
                case 216 -> 216;
                case 217 -> 127;
                case 218 -> 250;
                case 219 -> 122;
                case 220 -> 174;
                case 221 -> 245;
                case 222 -> 79;
                case 223 -> 76;
                case 224 -> 237;
                case 225 -> 124;
                case 226 -> 125;
                case 227 -> 87;
                case 228 -> 107;
                case 229 -> 201;
                case 230 -> 129;
                case 231 -> 57;
                case 232 -> 159;
                case 233 -> 238;
                case 234 -> 7;
                case 235 -> 133;
                case 236 -> 202;
                case 237 -> 198;
                case 238 -> 6;
                case 239 -> 18;
                case 240 -> 93;
                case 241 -> 152;
                case 242 -> 17;
                case 243 -> 31;
                case 244 -> 219;
                case 245 -> 114;
                case 246 -> 222;
                case 247 -> 249;
                case 248 -> 10;
                case 249 -> 100;
                case 250 -> 128;
                case 251 -> 78;
                case 252 -> 64;
                case 253 -> 172;
                case 254 -> 134;
                default -> 54;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            ServerSocketWrapper.b[n5] = new String(cArray).intern();
        }
        return b[n5];
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketWrapper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PortStrategy.values().length];
            try {
                nArray[PortStrategy.REASSIGN_WHEN_BUSY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PortStrategy.ERROR_WHEN_BUSY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

