/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.swing.states;

import com.jetbrains.wormhole.interop.MainThreadScheduler;
import com.jetbrains.wormhole.interop.NativeWindowProxy;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.ReadOnlyNativeWindowProxy;
import com.jetbrains.wormhole.interop.SystemFocusManager;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.WindowProxyChain;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.AttachOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.EmbedOperationVerifier;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016J\u0018\u0010$\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020&H\u0016J\u0018\u0010)\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010*\u001a\u00020\u0001H\u0016J\b\u0010+\u001a\u00020 H\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020\u0001H\u0016J\b\u0010.\u001a\u00020\u0001H\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006/"}, d2={"Lcom/jetbrains/wormhole/swing/states/FinalState;", "Lcom/jetbrains/wormhole/states/WormholeState;", "targetWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "hostWindowId", "mainThreadScheduler", "Lcom/jetbrains/wormhole/interop/MainThreadScheduler;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/MainThreadScheduler;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "proxyChain", "Lcom/jetbrains/wormhole/interop/WindowProxyChain;", "(Lcom/jetbrains/wormhole/interop/WindowProxyChain;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "attachOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getAttachOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "embedOperationVerifier", "getEmbedOperationVerifier", "focusManager", "Lcom/jetbrains/wormhole/interop/SystemFocusManager;", "j", "()Lcom/jetbrains/wormhole/interop/SystemFocusManager;", "getPlatform", "()Lcom/jetbrains/wormhole/interop/Platform;", "getProxyChain", "()Lcom/jetbrains/wormhole/interop/WindowProxyChain;", "getStateFactory", "()Lcom/jetbrains/wormhole/states/StateFactory;", "arrange", "", "componentRect", "Ljava/awt/Rectangle;", "visibleRect", "attachToRoot", "isShowing", "", "detachFromRoot", "restorePreviousWindowState", "embedWindow", "hide", "onActivated", "onDeactivated", "onTargetDead", "unembedWindow", "component"})
public class FinalState
extends WormholeState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    @NotNull
    private final WindowOperationVerifier attachOperationVerifier;
    @NotNull
    private final WindowProxyChain proxyChain;
    @NotNull
    private final StateFactory stateFactory;
    @NotNull
    private final Platform platform;

    @Override
    @NotNull
    public final WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public final WindowOperationVerifier getAttachOperationVerifier() {
        return this.attachOperationVerifier;
    }

    @NotNull
    protected final WindowProxyChain getProxyChain() {
        return this.proxyChain;
    }

    @NotNull
    protected final StateFactory getStateFactory() {
        return this.stateFactory;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    private final SystemFocusManager j() {
        return this.platform.getSystemFocusManager();
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        this.proxyChain.detach();
        return this.stateFactory.finalState(targetWindowId, this.proxyChain.getHostWindow().getId());
    }

    @Override
    @NotNull
    public WormholeState unembedWindow() {
        this.proxyChain.detach();
        return this.stateFactory.intermediateRootState(this.proxyChain.getHostWindow().getId());
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        throw (Throwable)new IllegalStateException("Failed to attach new root with '" + hostWindowId + "' id. " + "Attaching new root in " + Reflection.getOrCreateKotlinClass(FinalState.class).getSimpleName() + " state is not allowed. " + "Needs to detach current root ('" + this.proxyChain.getHostWindow().getId() + "') first.");
    }

    @Override
    @NotNull
    public WormholeState detachFromRoot(boolean restorePreviousWindowState) {
        WormholeState wormholeState;
        if (restorePreviousWindowState) {
            wormholeState = this.stateFactory.intermediateHiddenTargetState(this.proxyChain);
        } else {
            this.proxyChain.detach();
            wormholeState = this.stateFactory.intermediateTargetState(this.proxyChain.getTargetWindow().getId());
        }
        return wormholeState;
    }

    @Override
    @NotNull
    public WormholeState hide() {
        return this.stateFactory.hiddenState(this.proxyChain);
    }

    @Override
    @NotNull
    public WormholeState onTargetDead() {
        this.proxyChain.detach();
        return this.stateFactory.deadTargetState(this.proxyChain.getHostWindow().getId());
    }

    @Override
    public void arrange(@NotNull Rectangle componentRect, @NotNull Rectangle visibleRect) {
        Intrinsics.checkNotNullParameter((Object)componentRect, (String)"componentRect");
        Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
        this.proxyChain.getChromakeyWindow().arrange(componentRect.x + visibleRect.x, componentRect.y + visibleRect.y, visibleRect.width, visibleRect.height);
        this.proxyChain.getTargetWindow().arrange(-visibleRect.x, -visibleRect.y, componentRect.width, componentRect.height);
    }

    @Override
    public void onActivated() {
        this.j().setFocusedWindow(this.proxyChain.getTargetWindow().getId());
    }

    @Override
    public void onDeactivated() {
    }

    public FinalState(@NotNull WindowId targetWindowId, @NotNull WindowId hostWindowId, @NotNull MainThreadScheduler mainThreadScheduler, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        Intrinsics.checkNotNullParameter((Object)mainThreadScheduler, (String)"mainThreadScheduler");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.stateFactory = stateFactory;
        this.platform = platform;
        ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy = platform.getProxyFactory().find(hostWindowId);
        NativeWindowProxy nativeWindowProxy = platform.getProxyFactory().create("ChromaKey", readOnlyNativeWindowProxy, mainThreadScheduler);
        NativeWindowProxy nativeWindowProxy2 = platform.getProxyFactory().getProxyForExistingWindow(targetWindowId);
        boolean bl = false;
        boolean bl2 = false;
        NativeWindowProxy nativeWindowProxy3 = nativeWindowProxy2;
        boolean bl3 = false;
        nativeWindowProxy3.bind(nativeWindowProxy);
        NativeWindowProxy nativeWindowProxy4 = nativeWindowProxy2;
        this.proxyChain = new WindowProxyChain(readOnlyNativeWindowProxy, nativeWindowProxy, nativeWindowProxy4);
        this.embedOperationVerifier = new EmbedOperationVerifier(hostWindowId, platform);
        this.attachOperationVerifier = new AttachOperationVerifier(targetWindowId, platform);
    }

    public FinalState(@NotNull WindowProxyChain proxyChain, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)proxyChain, (String)"proxyChain");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.stateFactory = stateFactory;
        this.proxyChain = proxyChain;
        this.platform = platform;
        this.embedOperationVerifier = new EmbedOperationVerifier(proxyChain.getHostWindow().getId(), platform);
        this.attachOperationVerifier = new AttachOperationVerifier(proxyChain.getTargetWindow().getId(), platform);
    }
}

