/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states.verifiers.wormhole;

import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.verifiers.wormhole.UnknownRootEmbedOperationVerifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/wormhole/states/verifiers/wormhole/EmbedOperationVerifier;", "Lcom/jetbrains/wormhole/states/verifiers/wormhole/UnknownRootEmbedOperationVerifier;", "rootWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/Platform;)V", "canPerformOperation", "Lkotlin/Pair;", "", "", "Lcom/jetbrains/wormhole/states/verifiers/VerificationResult;", "windowId", "component"})
public final class EmbedOperationVerifier
extends UnknownRootEmbedOperationVerifier {
    private final WindowId rootWindowId;
    private final Platform platform;

    @Override
    @NotNull
    protected Pair<Boolean, String> canPerformOperation(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowId windowId2 = windowId;
        if (Intrinsics.areEqual((Object)windowId2, (Object)this.rootWindowId)) {
            return this.fail("The target window is the window of the component. Can't embed myself");
        }
        if (this.platform.getWindowIdProvider().getAncestors(this.rootWindowId).contains(windowId2)) {
            return this.fail("The target window is an ancestor of the component. Can't embed a parent");
        }
        return super.canPerformOperation(windowId2);
    }

    public EmbedOperationVerifier(@NotNull WindowId rootWindowId, @NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)rootWindowId, (String)"rootWindowId");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        super(platform);
        this.rootWindowId = rootWindowId;
        this.platform = platform;
    }
}

