/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.states.common;

import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.EmbedOperationVerifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/wormhole/states/common/IntermediateRootState;", "Lcom/jetbrains/wormhole/states/WormholeState;", "hostWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/WindowId;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "embedOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getEmbedOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getHostWindowId", "()Lcom/jetbrains/wormhole/interop/WindowId;", "getPlatform", "()Lcom/jetbrains/wormhole/interop/Platform;", "attachToRoot", "isShowing", "", "detachFromRoot", "restorePreviousWindowState", "embedWindow", "targetWindowId", "component"})
public class IntermediateRootState
extends WormholeState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    @NotNull
    private final WindowId hostWindowId;
    @NotNull
    private final Platform platform;
    private final StateFactory stateFactory;

    @Override
    @NotNull
    public WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        return isShowing ? this.stateFactory.finalState(targetWindowId, this.hostWindowId) : this.stateFactory.hiddenState(targetWindowId, this.hostWindowId);
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        throw (Throwable)new IllegalStateException("Failed to attach new root with '" + hostWindowId + "' id. " + "Attaching new root in " + "<init>" + " is not allowed. " + "Needs to detach current root ('" + this.hostWindowId + "') first.");
    }

    @Override
    @NotNull
    public WormholeState detachFromRoot(boolean restorePreviousWindowState) {
        return this.stateFactory.initialState();
    }

    @NotNull
    public final WindowId getHostWindowId() {
        return this.hostWindowId;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    public IntermediateRootState(@NotNull WindowId hostWindowId, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        this.hostWindowId = hostWindowId;
        this.platform = platform;
        this.stateFactory = stateFactory;
        this.embedOperationVerifier = new EmbedOperationVerifier(this.hostWindowId, this.platform);
    }
}

