/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows;

import com.jetbrains.wormhole.SystemEnvironmentProvider;
import com.jetbrains.wormhole.events.EventBus;
import com.jetbrains.wormhole.interop.MainThreadScheduler;
import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.PlatformProvider;
import com.jetbrains.wormhole.interop.windows.WindowsFocusManager;
import com.jetbrains.wormhole.interop.windows.WindowsNativeWindowIdProvider;
import com.jetbrains.wormhole.interop.windows.WindowsNativeWindowProxyFactory;
import com.jetbrains.wormhole.interop.windows.keyboard.WindowsKeyboardHookInstaller;
import com.jetbrains.wormhole.interop.windows.keyboard.WindowsKeyboardInputRouter;
import com.jetbrains.wormhole.interop.windows.keyboard.WindowsVirtualKeyCodeProcessor;
import com.jetbrains.wormhole.logging.Logger;
import com.jetbrains.wormhole.logging.NoOperationLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/wormhole/interop/windows/WindowsPlatformProvider;", "Lcom/jetbrains/wormhole/interop/PlatformProvider;", "systemEnvironmentProvider", "Lcom/jetbrains/wormhole/SystemEnvironmentProvider;", "logger", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/jetbrains/wormhole/SystemEnvironmentProvider;Lcom/jetbrains/wormhole/logging/Logger;)V", "getPlatform", "Lcom/jetbrains/wormhole/interop/Platform;", "eventBus", "Lcom/jetbrains/wormhole/events/EventBus;", "mainThreadScheduler", "Lcom/jetbrains/wormhole/interop/MainThreadScheduler;", "interop"})
public final class WindowsPlatformProvider
implements PlatformProvider {
    private final SystemEnvironmentProvider systemEnvironmentProvider;
    private final Logger logger;

    @Override
    @NotNull
    public Platform getPlatform(@NotNull EventBus eventBus, @NotNull MainThreadScheduler mainThreadScheduler) {
        Intrinsics.checkNotNullParameter((Object)eventBus, (String)"eventBus");
        Intrinsics.checkNotNullParameter((Object)mainThreadScheduler, (String)"mainThreadScheduler");
        WindowsFocusManager windowsFocusManager = new WindowsFocusManager(mainThreadScheduler);
        return new Platform(new WindowsNativeWindowProxyFactory(eventBus, this.systemEnvironmentProvider, this.logger), new WindowsNativeWindowIdProvider(), windowsFocusManager, new WindowsKeyboardInputRouter(windowsFocusManager, WindowsVirtualKeyCodeProcessor.INSTANCE, new WindowsKeyboardHookInstaller(this.logger), mainThreadScheduler, this.logger));
    }

    public WindowsPlatformProvider(@NotNull SystemEnvironmentProvider systemEnvironmentProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)systemEnvironmentProvider, (String)"systemEnvironmentProvider");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.systemEnvironmentProvider = systemEnvironmentProvider;
        this.logger = logger2;
    }

    public /* synthetic */ WindowsPlatformProvider(SystemEnvironmentProvider systemEnvironmentProvider, Logger logger2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            logger2 = NoOperationLogger.INSTANCE;
        }
        this(systemEnvironmentProvider, logger2);
    }
}

