/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows;

import com.jetbrains.wormhole.SystemEnvironmentProvider;
import com.jetbrains.wormhole.interop.NativeWindowProxy;
import com.jetbrains.wormhole.interop.ReadOnlyNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.ReadOnlyWindowsNativeWindowProxy;
import com.jetbrains.wormhole.interop.windows.ShellScalingApiProvider;
import com.jetbrains.wormhole.interop.windows.WindowsNativeWindowIdProvider;
import com.jetbrains.wormhole.interop.windows.libraries.ShellScalingApi;
import com.jetbrains.wormhole.interop.windows.libraries.User32Kt;
import com.jetbrains.wormhole.logging.LogLevel;
import com.jetbrains.wormhole.logging.Logger;
import com.jetbrains.wormhole.logging.LoggerKt;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u0017H\u0002J\u0006\u0010!\u001a\u00020\u0017J(\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u0019H\u0004J\b\u0010%\u001a\u00020\u0017H\u0014J\b\u0010&\u001a\u00020\u0017H\u0014J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u0000H\u0014J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0004H\u0014J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0004J\b\u0010-\u001a\u00020\u0017H\u0002J\b\u0010.\u001a\u00020\u0017H\u0002J\u000e\u0010/\u001a\u00020\u0004*\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/wormhole/interop/windows/WindowsNativeWindowProxy;", "Lcom/jetbrains/wormhole/interop/windows/ReadOnlyWindowsNativeWindowProxy;", "Lcom/jetbrains/wormhole/interop/NativeWindowProxy;", "hWnd", "Lcom/sun/jna/platform/win32/WinDef$HWND;", "systemEnvironmentProvider", "Lcom/jetbrains/wormhole/SystemEnvironmentProvider;", "logger", "Lcom/jetbrains/wormhole/logging/Logger;", "(Lcom/sun/jna/platform/win32/WinDef$HWND;Lcom/jetbrains/wormhole/SystemEnvironmentProvider;Lcom/jetbrains/wormhole/logging/Logger;)V", "doesNativeWindowExist", "", "j", "()Z", "initialParent", "isDetachedOnce", "value", "isVisible", "setVisible", "(Z)V", "shellScalingApiProvider", "Lcom/jetbrains/wormhole/interop/windows/ShellScalingApiProvider;", "arrange", "", "x", "", "y", "width", "height", "bind", "parentWindow", "Lcom/jetbrains/wormhole/interop/ReadOnlyNativeWindowProxy;", "j", "detach", "move", "w", "h", "onArrange", "onBind", "onChildWindowBound", "childWindowProxy", "onDetach", "initialParentHWND", "replaceParent", "newParentHWND", "w", "N", "j", "interop"})
public abstract class WindowsNativeWindowProxy
extends ReadOnlyWindowsNativeWindowProxy
implements NativeWindowProxy {
    private boolean isDetachedOnce;
    private final WinDef.HWND initialParent;
    private final ShellScalingApiProvider shellScalingApiProvider;
    private boolean isVisible;
    private final SystemEnvironmentProvider systemEnvironmentProvider;
    private final Logger logger;

    private final boolean j() {
        return User32Kt.getUser32().IsWindow(this.getHWnd());
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean value) {
        if (value != this.isVisible) {
            this.j();
            this.isVisible = value;
        }
    }

    @Override
    public final void arrange(int x2, int y, int width, int height) {
        LoggerKt.lazyLog(this.logger, LogLevel.TRACE, (Function0<String>)((Function0)new Function0<String>(x2, y, width, height){
            final /* synthetic */ int $x;
            final /* synthetic */ int $y;
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;

            @NotNull
            public final String invoke() {
                return "WindowsNativeWindowProxy :: Arrange(" + this.$x + ", " + this.$y + ", " + this.$width + ", " + this.$height + ").";
            }
            {
                this.$x = n2;
                this.$y = n3;
                this.$width = n4;
                this.$height = n5;
                super(0);
            }
        }));
        if (this.isDetachedOnce) {
            return;
        }
        this.move(x2, y, width, height);
        this.onArrange();
    }

    @Override
    public final void bind(@NotNull ReadOnlyNativeWindowProxy parentWindow) {
        Intrinsics.checkNotNullParameter((Object)parentWindow, (String)"parentWindow");
        ReadOnlyWindowsNativeWindowProxy cfr_ignored_0 = (ReadOnlyWindowsNativeWindowProxy)parentWindow;
        boolean bl = Intrinsics.areEqual((Object)this.getId(), (Object)((ReadOnlyWindowsNativeWindowProxy)parentWindow).getId()) ^ true;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "This window can't be the desired parent window";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !new WindowsNativeWindowIdProvider().getAncestors(((ReadOnlyWindowsNativeWindowProxy)parentWindow).getId()).contains(this.getId());
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "This window can't be an ancestor of the desired parent window";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        WinDef.HWND hWND = ((ReadOnlyWindowsNativeWindowProxy)parentWindow).getId().getHWnd();
        this.w();
        this.replaceParent(hWND);
        if (parentWindow instanceof WindowsNativeWindowProxy) {
            ((WindowsNativeWindowProxy)parentWindow).onChildWindowBound(this);
        }
        this.onBind();
    }

    @Override
    public final void detach() {
        boolean bl = !this.isDetachedOnce;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "In current realization the already detached window can't be detached again";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.isDetachedOnce = true;
        if (this.j()) {
            this.onDetach(this.initialParent);
        }
    }

    protected final void move(int x2, int y, int w, int h) {
        IntByReference intByReference = new IntByReference();
        boolean bl = false;
        boolean bl2 = false;
        IntByReference intByReference2 = intByReference;
        int n2 = 0;
        ShellScalingApi.DefaultImpls.GetProcessDpiAwareness$default(this.shellScalingApiProvider.getShellScalingApi(), null, intByReference2, 1, null);
        int n3 = intByReference.getValue();
        if (n3 == 2) {
            int n4;
            float f;
            intByReference = User32Kt.getUser32().MonitorFromWindow(this.getHWnd(), 2);
            if (intByReference == null) {
                User32Kt.getUser32().MoveWindow(this.getHWnd(), x2, y, w, h, true);
                return;
            }
            float f2 = this.systemEnvironmentProvider.getSystemScalingFactor();
            if (f2 > 0.0f) {
                f = f2;
            } else {
                intByReference2 = new IntByReference();
                n2 = 0;
                n4 = 0;
                IntByReference intByReference3 = intByReference2;
                boolean bl3 = false;
                this.shellScalingApiProvider.getShellScalingApi().GetScaleFactorForMonitor((WinUser.HMONITOR)intByReference, intByReference3);
                f = (float)intByReference2.getValue() / 100.0f;
            }
            float f3 = f;
            int n5 = (int)((float)x2 * f3);
            n2 = (int)((float)y * f3);
            n4 = (int)((float)w * f3);
            int n6 = (int)((float)h * f3);
            User32Kt.getUser32().MoveWindow(this.getHWnd(), n5, n2, n4, n6, true);
        } else {
            User32Kt.getUser32().MoveWindow(this.getHWnd(), x2, y, w, h, true);
        }
    }

    @NotNull
    protected final WinDef.HWND replaceParent(@NotNull WinDef.HWND newParentHWND) {
        Intrinsics.checkNotNullParameter((Object)newParentHWND, (String)"newParentHWND");
        this.N();
        return this.j(User32Kt.getUser32().SetParent(this.getHWnd(), newParentHWND));
    }

    protected void onArrange() {
    }

    protected void onDetach(@NotNull WinDef.HWND initialParentHWND) {
        Intrinsics.checkNotNullParameter((Object)initialParentHWND, (String)"initialParentHWND");
    }

    protected void onBind() {
    }

    protected void onChildWindowBound(@NotNull WindowsNativeWindowProxy childWindowProxy) {
        Intrinsics.checkNotNullParameter((Object)childWindowProxy, (String)"childWindowProxy");
    }

    private final void N() {
        int n2 = User32Kt.getUser32().GetWindowLong(this.getHWnd(), -16);
        User32Kt.getUser32().SetWindowLong(this.getHWnd(), -16, n2 |= 0x40000000);
        int n3 = User32Kt.getUser32().GetWindowLong(this.getHWnd(), -20);
        int n4 = 65536;
        User32Kt.getUser32().SetWindowLong(this.getHWnd(), -20, n3 |= n4);
    }

    private final void w() {
        int n2 = User32Kt.getUser32().GetWindowLong(this.getHWnd(), -16);
        User32Kt.getUser32().SetWindowLong(this.getHWnd(), -16, n2 &= ~0xCF0000);
        int n3 = User32Kt.getUser32().GetWindowLong(this.getHWnd(), -20);
        User32Kt.getUser32().SetWindowLong(this.getHWnd(), -20, n3 &= ~131585);
    }

    private final void j() {
        if (this.isVisible()) {
            User32Kt.getUser32().ShowWindow(this.getHWnd(), 0);
        } else {
            User32Kt.getUser32().ShowWindow(this.getHWnd(), 5);
        }
    }

    private final WinDef.HWND j(WinDef.HWND hWND) {
        WinDef.HWND hWND2 = hWND;
        if (hWND2 == null) {
            WinDef.HWND hWND3 = User32Kt.getUser32().GetDesktopWindow();
            hWND2 = hWND3;
            Intrinsics.checkNotNullExpressionValue((Object)hWND3, (String)"user32.GetDesktopWindow()");
        }
        return hWND2;
    }

    public WindowsNativeWindowProxy(@NotNull WinDef.HWND hWnd, @NotNull SystemEnvironmentProvider systemEnvironmentProvider, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)hWnd, (String)"hWnd");
        Intrinsics.checkNotNullParameter((Object)systemEnvironmentProvider, (String)"systemEnvironmentProvider");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        super(hWnd);
        this.systemEnvironmentProvider = systemEnvironmentProvider;
        this.logger = logger2;
        this.initialParent = this.j(User32Kt.getUser32().GetAncestor(hWnd, 1));
        this.shellScalingApiProvider = new ShellScalingApiProvider(this.systemEnvironmentProvider);
        this.isVisible = true;
    }
}

