/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.interop.windows;

import com.jetbrains.wormhole.interop.NativeWindowIdProvider;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.WindowIdNotFoundException;
import com.jetbrains.wormhole.interop.windows.WindowsWindowId;
import com.jetbrains.wormhole.interop.windows.libraries.User32Kt;
import com.sun.jna.platform.win32.WinDef;
import java.awt.peer.ComponentPeer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KCallable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/wormhole/interop/windows/WindowsNativeWindowIdProvider;", "Lcom/jetbrains/wormhole/interop/NativeWindowIdProvider;", "()V", "doesWindowExist", "", "windowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "getAncestors", "", "getWindowId", "heavyweightPeer", "Ljava/awt/peer/ComponentPeer;", "isTopLevelWindow", "interop"})
public final class WindowsNativeWindowIdProvider
implements NativeWindowIdProvider {
    @Override
    @NotNull
    public WindowId getWindowId(@NotNull ComponentPeer heavyweightPeer) {
        Object v0;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)heavyweightPeer, (String)"heavyweightPeer");
            object = Reflection.getOrCreateKotlinClass(heavyweightPeer.getClass()).getMembers();
            boolean bl = false;
            Object var5_4 = null;
            boolean bl2 = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                KCallable kCallable = (KCallable)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)kCallable.getName(), (Object)"getHWnd")) continue;
                if (bl2) {
                    v0 = null;
                    break block4;
                }
                var5_4 = t;
                bl2 = true;
            }
            v0 = !bl2 ? null : var5_4;
        }
        KCallable kCallable = v0;
        if (kCallable == null) {
            throw (Throwable)new WindowIdNotFoundException("Failed to obtain WindowId. Provided component peer should contain 'getHWnd' method accessible by reflection.");
        }
        Object object2 = kCallable.call(new Object[]{heavyweightPeer});
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
        }
        object = (Number)object2;
        return new WindowsWindowId((Number)object);
    }

    @Override
    public boolean doesWindowExist(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowsWindowId windowsWindowId = (WindowsWindowId)windowId;
        return User32Kt.getUser32().IsWindow(windowsWindowId.getHWnd());
    }

    @Override
    @NotNull
    public Set<WindowId> getAncestors(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        WindowsWindowId windowsWindowId = (WindowsWindowId)windowId;
        boolean bl = false;
        Set set = new LinkedHashSet();
        WinDef.HWND hWND = User32Kt.getUser32().GetAncestor(windowsWindowId.getHWnd(), 1);
        while (hWND != null) {
            set.add(new WindowsWindowId(hWND));
            hWND = User32Kt.getUser32().GetAncestor(hWND, 1);
        }
        return set;
    }

    @Override
    public boolean isTopLevelWindow(@NotNull WindowId windowId) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        return this.getAncestors(windowId).size() == 1;
    }
}

