/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.wormhole.awt.states;

import com.jetbrains.wormhole.interop.Platform;
import com.jetbrains.wormhole.interop.ReadOnlyNativeWindowProxy;
import com.jetbrains.wormhole.interop.WindowChain;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.states.StateFactory;
import com.jetbrains.wormhole.states.WormholeState;
import com.jetbrains.wormhole.states.common.IntermediateTargetState;
import com.jetbrains.wormhole.states.verifiers.WindowOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.EmbedOperationVerifier;
import com.jetbrains.wormhole.states.verifiers.wormhole.EmbeddedTargetAttachOperationVerifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/wormhole/awt/states/IntermediateInitializedTargetState;", "Lcom/jetbrains/wormhole/states/common/IntermediateTargetState;", "chain", "Lcom/jetbrains/wormhole/interop/WindowChain;", "platform", "Lcom/jetbrains/wormhole/interop/Platform;", "stateFactory", "Lcom/jetbrains/wormhole/states/StateFactory;", "(Lcom/jetbrains/wormhole/interop/WindowChain;Lcom/jetbrains/wormhole/interop/Platform;Lcom/jetbrains/wormhole/states/StateFactory;)V", "attachOperationVerifier", "Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "getAttachOperationVerifier", "()Lcom/jetbrains/wormhole/states/verifiers/WindowOperationVerifier;", "embedOperationVerifier", "getEmbedOperationVerifier", "attachToRoot", "Lcom/jetbrains/wormhole/states/WormholeState;", "hostWindowId", "Lcom/jetbrains/wormhole/interop/WindowId;", "isShowing", "", "embedWindow", "targetWindowId", "unembedWindow", "component"})
public final class IntermediateInitializedTargetState
extends IntermediateTargetState {
    @NotNull
    private final WindowOperationVerifier embedOperationVerifier;
    @NotNull
    private final WindowOperationVerifier attachOperationVerifier;
    private final WindowChain chain;
    private final Platform platform;

    @Override
    @NotNull
    public WindowOperationVerifier getEmbedOperationVerifier() {
        return this.embedOperationVerifier;
    }

    @Override
    @NotNull
    public WindowOperationVerifier getAttachOperationVerifier() {
        return this.attachOperationVerifier;
    }

    @Override
    @NotNull
    public WormholeState embedWindow(@NotNull WindowId targetWindowId, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)targetWindowId, (String)"targetWindowId");
        this.chain.detach();
        return this.getStateFactory().intermediateTargetState(targetWindowId);
    }

    @Override
    @NotNull
    public WormholeState unembedWindow() {
        this.chain.detach();
        return this.getStateFactory().initialState();
    }

    @Override
    @NotNull
    public WormholeState attachToRoot(@NotNull WindowId hostWindowId, boolean isShowing) {
        WindowChain windowChain;
        Intrinsics.checkNotNullParameter((Object)hostWindowId, (String)"hostWindowId");
        if (Intrinsics.areEqual((Object)hostWindowId, (Object)this.chain.getHostWindow().getId()) ^ true) {
            this.chain.getHostWindow().detach();
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy = this.platform.getProxyFactory().find(hostWindowId);
            boolean bl = false;
            boolean bl2 = false;
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy2 = readOnlyNativeWindowProxy;
            boolean bl3 = false;
            this.chain.getTargetWindow().bind(readOnlyNativeWindowProxy2);
            ReadOnlyNativeWindowProxy readOnlyNativeWindowProxy3 = readOnlyNativeWindowProxy;
            windowChain = new WindowChain(readOnlyNativeWindowProxy3, this.chain.getTargetWindow());
        } else {
            windowChain = this.chain;
        }
        WindowChain windowChain2 = windowChain;
        return isShowing ? this.getStateFactory().finalState(windowChain2) : this.getStateFactory().hiddenState(windowChain2);
    }

    public IntermediateInitializedTargetState(@NotNull WindowChain chain, @NotNull Platform platform, @NotNull StateFactory stateFactory) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)stateFactory, (String)"stateFactory");
        super(chain.getHostWindow().getId(), platform, stateFactory);
        this.chain = chain;
        this.platform = platform;
        this.embedOperationVerifier = new EmbedOperationVerifier(this.chain.getHostWindow().getId(), this.platform);
        this.attachOperationVerifier = new EmbeddedTargetAttachOperationVerifier(this.chain.getTargetWindow().getId(), this.platform);
    }
}

