/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.states;

import com.jetbrains.states.State;
import com.jetbrains.states.StateTransitionException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0005J/\u0010\u000e\u001a\u00020\f2!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00028\u00000\u0010H\u0086\b\u00f8\u0001\u0000J\u0013\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R \u0010\u0007\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/states/StateMachine;", "TState", "Lcom/jetbrains/states/State;", "", "initialState", "(Lcom/jetbrains/states/State;)V", "<set-?>", "currentState", "getCurrentState", "()Lcom/jetbrains/states/State;", "Lcom/jetbrains/states/State;", "onStateChanged", "", "to", "switchTo", "obtainState", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "current", "state", "component"})
public abstract class StateMachine<TState extends State> {
    @NotNull
    private TState currentState;

    @NotNull
    public final TState getCurrentState() {
        return this.currentState;
    }

    public final void switchTo(@NotNull TState state) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        try {
            ((State)this.currentState).deactivate();
        }
        catch (Exception exception) {
            throw (Throwable)new StateTransitionException("Failed to deactivate current state: '" + this.currentState.getClass().getName() + '\'', exception);
        }
        this.currentState = state;
        try {
            ((State)this.currentState).activate();
        }
        catch (Exception exception) {
            throw (Throwable)new StateTransitionException("Failed to activate new state: '" + this.currentState.getClass().getName() + '\'', exception);
        }
        this.onStateChanged(state);
    }

    public final void switchTo(@NotNull Function1<? super TState, ? extends TState> obtainState) {
        int n2 = 0;
        Intrinsics.checkNotNullParameter(obtainState, (String)"obtainState");
        try {
            State state = (State)obtainState.invoke(this.getCurrentState());
            this.switchTo(state);
        }
        catch (Exception exception) {
            throw (Throwable)new StateTransitionException("Failed to obtain new state", exception);
        }
    }

    protected void onStateChanged(@NotNull TState to) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
    }

    public StateMachine(@NotNull TState initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.currentState = initialState;
    }

    public static final /* synthetic */ State access$getCurrentState$p(StateMachine $this) {
        return $this.currentState;
    }

    public static final /* synthetic */ void access$setCurrentState$p(StateMachine $this, State state) {
        $this.currentState = state;
    }
}

