/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.workspaceModel;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelCache;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RdCustomLocation;
import com.jetbrains.rider.model.RdNullLocation;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemLocation;
import com.jetbrains.rider.model.RdProjectState;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionFolderDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.fus.SolutionLifecycleCollector;
import com.jetbrains.rider.projectView.solutionStructure.ProjectMark;
import com.jetbrains.rider.projectView.solutionStructure.SolutionMark;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.projectView.workspace.impl.ProjectModelEntityBuilderKt;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceGlobalListener;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelInitializer;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceModelUpdater;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import com.jetbrains.rider.workspaceModel.ProjectModelEntityPrototypeMerger;
import com.jetbrains.rider.workspaceModel.RiderModuleTypeKt;
import com.jetbrains.rider.workspaceModel.RiderWorkspaceModelInitializer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\u00020\u0001:\u0002ABB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eJ\u0010\u0010)\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0012H\u0016J\u0018\u0010.\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u001c\u0010/\u001a\u00020%2\b\u00100\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u00010\u0012H\u0016J\u001c\u00102\u001a\u00020%2\b\u00100\u001a\u0004\u0018\u00010\u00122\b\u00101\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u00103\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J0\u00107\u001a\u00020%*\u00020'2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0017092\u0006\u0010:\u001a\u00020\u00122\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u001e\u0010<\u001a\u00020\u0012*\u00020'2\u0006\u0010=\u001a\u00020>2\b\u0010:\u001a\u0004\u0018\u00010\u0012H\u0002J*\u0010?\u001a\u00020%*\u00020'2\u0006\u0010@\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer;", "Lcom/jetbrains/rider/projectView/workspace/impl/WorkspaceModelInitializer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executableProjectUUID", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "<set-?>", "", "isApplicable", "()Z", "isColdStart", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "webSiteProjectUUID", "j", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "solutionEntity", "j", "Lcom/jetbrains/rider/model/RdUnloadProjectDescriptor;", "projectMark", "Lcom/jetbrains/rider/projectView/solutionStructure/ProjectMark;", "j", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "j", "Lcom/jetbrains/rider/model/RdSolutionDescriptor;", "solutionMark", "Lcom/jetbrains/rider/projectView/solutionStructure/SolutionMark;", "j", "Lcom/jetbrains/rider/model/RdSolutionFolderDescriptor;", "j", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "solutionItem", "Ljava/nio/file/Path;", "initialize", "", "storage", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "vfuManager", "j", "merge", "builder", "existingBuilder", "existingSolutionEntity", "updateWorkspaceModel", "validateFrontendWorkspaceModel", "frontendEntity", "backendEntity", "j", "j", "errorMessage", "Ljava/util/function/Supplier;", "", "j", "projectMarks", "", "parentEntity", "entitiesToRemove", "j", "descriptor", "Lcom/jetbrains/rider/model/RdProjectModelItemDescriptor;", "j", "solutionFolderEntity", "Companion", "MergeKey", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderWorkspaceModelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer\n+ 2 StructuredLogging.kt\ncom/jetbrains/rd/platform/diagnostics/StructuredLoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,375:1\n140#2,9:376\n161#2,2:385\n150#2,9:387\n1194#3,2:396\n1222#3,4:398\n1194#3,2:402\n1222#3,4:404\n1194#3,2:409\n1222#3,4:411\n1194#3,2:415\n1222#3,4:417\n1#4:408\n13#5:421\n*S KotlinDebug\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer\n*L\n59#1:376,9\n59#1:385,2\n59#1:387,9\n140#1:396,2\n140#1:398,4\n167#1:402,2\n167#1:404,4\n325#1:409,2\n325#1:411,4\n328#1:415,2\n328#1:417,4\n32#1:421\n*E\n"})
public final class RiderWorkspaceModelInitializer
extends WorkspaceModelInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private VirtualFileUrlManager virtualFileUrlManager;
    private boolean isColdStart;
    private boolean isApplicable;
    private final UUID webSiteProjectUUID;
    private final UUID executableProjectUUID;
    @NotNull
    private static final Logger logger;
    private static boolean noChangeAssertsMode;

    public RiderWorkspaceModelInitializer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isColdStart = true;
        this.isApplicable = true;
        this.webSiteProjectUUID = UUID.fromString("E24C65DC-7377-472B-9ABA-BC803B73C61A");
        this.executableProjectUUID = UUID.fromString("911E67C6-3D85-4FCE-B560-20A9C3E3FF48");
    }

    public boolean isColdStart() {
        return this.isColdStart;
    }

    public boolean isApplicable() {
        return this.isApplicable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(@NotNull MutableEntityStorage storage, @NotNull VirtualFileUrlManager vfuManager) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)vfuManager, (String)"vfuManager");
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        this.virtualFileUrlManager = vfuManager;
        this.isColdStart = WorkspaceModelExtensionsKt.getSolutionEntity((EntityStorage)((EntityStorage)storage)) == null;
        this.isApplicable = SolutionMark.Companion.canCreateFrom(SolutionHostExtensionsKt.getSolution((Project)this.project));
        logger.info("Workspace model initialization started [IsColdStart=" + this.isColdStart() + "]...");
        Logger logger2 = logger;
        String string = "WorkspaceModel.Init";
        Object var5_5 = null;
        boolean bl = false;
        Logger logger3 = logger2;
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.nanoTime();
        try {
            boolean bl4 = false;
            SolutionLifecycleCollector.INSTANCE.trackActivity(this.project, SolutionLifecycleCollector.INSTANCE.getWorkspaceModelInitActivity(), (Function0)new Function0<Unit>(storage, this){
                final /* synthetic */ MutableEntityStorage $storage;
                final /* synthetic */ RiderWorkspaceModelInitializer this$0;
                {
                    this.$storage = $storage;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    try {
                        RiderModuleTypeKt.getOrCreateRiderModuleEntity(this.$storage);
                        if (this.this$0.isApplicable()) {
                            RiderWorkspaceModelInitializer.access$getLogger$cp().info("SolutionMark parsing started...");
                            SolutionMark solutionMark = SolutionMark.Companion.createFromSolution(SolutionHostExtensionsKt.getSolution((Project)RiderWorkspaceModelInitializer.access$getProject$p(this.this$0)));
                            RiderWorkspaceModelInitializer.access$getLogger$cp().info("SolutionMark parsing finished");
                            RiderWorkspaceModelInitializer.access$getLogger$cp().info("Initialize Workspace Model started...");
                            this.this$0.updateWorkspaceModel(this.$storage, solutionMark);
                            RiderWorkspaceModelInitializer.access$getLogger$cp().info("Initialize Workspace Model finished");
                        }
                    }
                    catch (Throwable throwable) {
                        RiderWorkspaceModelInitializer.access$getLogger$cp().error(throwable);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            try {
                String string2 = throwable instanceof ProcessCanceledException || throwable instanceof CancellationException ? "Cancelled" : "Exception";
                bl3 = true;
                StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<" + string2 + "> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
                throw throwable;
            }
            catch (Throwable throwable2) {
                if (!bl3) {
                    StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
                }
                throw throwable2;
            }
        }
        StructuredLoggingKt.sendStructuredLog((Logger)logger3, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)string) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - l) / 1000000.0) + "ms\u200b\u200c\u200b"));
        ApplicationKt.getApplication().invokeLater(() -> RiderWorkspaceModelInitializer.j(this));
        logger.info("Workspace model initialization finished");
    }

    @TestOnly
    public final void updateWorkspaceModel(@NotNull MutableEntityStorage storage, @NotNull SolutionMark solutionMark) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)solutionMark, (String)"solutionMark");
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((EntityStorage)((EntityStorage)storage));
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        if (projectModelEntity2 == null) {
            object = this.j(solutionMark);
            ProjectModelEntity projectModelEntity3 = this.j(storage, (RdProjectModelItemDescriptor)object, null);
            ProjectModelEntityBuilderKt.addOrUpdateSolutionPointerEntity((MutableEntityStorage)storage, (ProjectModelEntity)projectModelEntity3);
            projectModelEntity2 = projectModelEntity3;
        }
        ProjectModelEntity projectModelEntity4 = projectModelEntity2;
        object = this.j(projectModelEntity4);
        this.j(storage, solutionMark.getProjectMarks(), projectModelEntity4, (Set<ProjectModelEntity>)object);
        for (ProjectModelEntity projectModelEntity5 : ProjectModelEntityExtensionsKt.getRootEntities((Collection)((Collection)object))) {
            this.j(() -> RiderWorkspaceModelInitializer.j(projectModelEntity5));
            storage.removeEntity((WorkspaceEntity)projectModelEntity5);
        }
    }

    private final Set<ProjectModelEntity> j(ProjectModelEntity projectModelEntity) {
        var var2_2 = new ProjectModelEntityVisitor(){
            @NotNull
            private final Set<ProjectModelEntity> entities;
            {
                this.entities = new LinkedHashSet<E>();
            }

            @NotNull
            public final Set<ProjectModelEntity> getEntities() {
                return this.entities;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitProject(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Stop;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitUnloadedProject(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Stop;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitSolutionFolder(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                this.entities.add(entity);
                return ProjectModelEntityVisitor.Result.Continue;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitProjectFile(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                ProjectModelEntity projectModelEntity = entity.getParentEntity();
                if ((projectModelEntity != null ? projectModelEntity.getDescriptor() : null) instanceof RdSolutionFolderDescriptor) {
                    this.entities.add(entity);
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }
        };
        var2_2.visit(projectModelEntity);
        return var2_2.getEntities();
    }

    private final void j(MutableEntityStorage mutableEntityStorage, List<ProjectMark> list2, ProjectModelEntity projectModelEntity, Set<ProjectModelEntity> set) {
        Iterable iterable = projectModelEntity.getChildrenEntities();
        boolean bl = false;
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Object object = new LinkedHashMap(n2);
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)t;
            Map map2 = object;
            boolean bl3 = false;
            map2.put(MergeKey.Companion.create(projectModelEntity2), t);
        }
        Map map3 = object;
        for (ProjectMark projectMark : list2) {
            MergeKey mergeKey = new MergeKey(projectMark.getName(), projectMark.getProjectGuid());
            iterable2 = (ProjectModelEntity)map3.get(mergeKey);
            if (iterable2 != null) {
                set.remove(iterable2);
                v0 = iterable2;
            } else {
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectMark.isSolutionFolder() ? (RdProjectModelItemDescriptor)this.j(projectMark) : (projectMark.isHiddenInFilter() ? (RdProjectModelItemDescriptor)this.j(projectMark) : (RdProjectModelItemDescriptor)this.j(projectMark));
                v0 = object = this.j(mutableEntityStorage, rdProjectModelItemDescriptor, projectModelEntity);
            }
            if (projectMark.isSolutionFolder()) {
                this.j(mutableEntityStorage, (ProjectModelEntity)object, projectMark, set);
            }
            this.j(mutableEntityStorage, CollectionsKt.toList((Iterable)projectMark.getChildren()), (ProjectModelEntity)object, set);
        }
    }

    private final void j(MutableEntityStorage mutableEntityStorage, ProjectModelEntity projectModelEntity, ProjectMark projectMark, Set<ProjectModelEntity> set) {
        boolean bl = ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)projectModelEntity);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable iterable = projectModelEntity.getChildrenEntities();
        boolean bl2 = false;
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10)), (int)16);
        Iterable iterable2 = iterable;
        Map map2 = new LinkedHashMap(n2);
        boolean bl3 = false;
        for (Object t : iterable2) {
            ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)t;
            Map map3 = map2;
            boolean bl4 = false;
            map3.put(MergeKey.Companion.create(projectModelEntity2), t);
        }
        Map map4 = map2;
        for (Path path : projectMark.getSolutionItems()) {
            Intrinsics.checkNotNull((Object)path);
            MergeKey mergeKey = new MergeKey(PathsKt.getName((Path)path), null);
            iterable2 = (ProjectModelEntity)map4.get(mergeKey);
            if (iterable2 != null) {
                set.remove(iterable2);
                continue;
            }
            map2 = this.j(path);
            this.j(mutableEntityStorage, (RdProjectModelItemDescriptor)map2, projectModelEntity);
        }
    }

    private final ProjectModelEntity j(MutableEntityStorage mutableEntityStorage, RdProjectModelItemDescriptor rdProjectModelItemDescriptor, ProjectModelEntity projectModelEntity) {
        this.j(() -> RiderWorkspaceModelInitializer.j(rdProjectModelItemDescriptor, projectModelEntity));
        VirtualFileUrlManager virtualFileUrlManager = this.virtualFileUrlManager;
        if (virtualFileUrlManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager = null;
        }
        VirtualFileUrl virtualFileUrl = ProjectModelEntityBuilderKt.calculateVirtualFileUrl((VirtualFileUrlManager)virtualFileUrlManager, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (ProjectModelEntity)projectModelEntity);
        VirtualFileUrlManager virtualFileUrlManager2 = this.virtualFileUrlManager;
        if (virtualFileUrlManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"virtualFileUrlManager");
            virtualFileUrlManager2 = null;
        }
        List list2 = ProjectModelEntityBuilderKt.calculateAlternativeVirtualFileUrls((VirtualFileUrlManager)virtualFileUrlManager2, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (VirtualFileUrl)virtualFileUrl);
        return ProjectModelEntityBuilderKt.addOrUpdateProjectModelEntity((MutableEntityStorage)mutableEntityStorage, null, (RdProjectModelItemDescriptor)rdProjectModelItemDescriptor, (VirtualFileUrl)virtualFileUrl, (List)list2, (ProjectModelEntity)projectModelEntity);
    }

    private final RdProjectFileDescriptor j(Path path) {
        RdCustomLocation rdCustomLocation = new RdCustomLocation(((Object)path).toString());
        String string = PathsKt.getName((Path)path);
        return new RdProjectFileDescriptor(false, false, "", null, null, string, (RdProjectModelItemLocation)rdCustomLocation);
    }

    private final RdSolutionDescriptor j(SolutionMark solutionMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = solutionMark.getSolutionPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        Path path3 = solutionMark.getSolutionFilterPath();
        return new RdSolutionDescriptor(RdSolutionState.Default, !SolutionHostExtensionsKt.isExistingSolution((Project)this.project), path3 != null ? ((Object)path3).toString() : null, solutionMark.getSolutionName(), rdProjectModelItemLocation2);
    }

    private final RdSolutionFolderDescriptor j(ProjectMark projectMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = projectMark.getPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        String string = projectMark.getName();
        return new RdSolutionFolderDescriptor(null, uUID, string, rdProjectModelItemLocation2);
    }

    private final RdProjectDescriptor j(ProjectMark projectMark) {
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Path path = projectMark.getPath();
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(((Object)path2).toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        String string = projectMark.getName();
        RdProjectState rdProjectState = RdProjectState.Default;
        boolean bl = this.j(projectMark);
        RdProjectType rdProjectType = RdProjectType.Default;
        List list2 = CollectionsKt.emptyList();
        String string2 = projectMark.getName();
        return new RdProjectDescriptor(rdProjectState, null, bl, false, true, rdProjectType, false, null, list2, null, uUID, string, string2, rdProjectModelItemLocation2);
    }

    private final RdUnloadProjectDescriptor j(ProjectMark projectMark) {
        boolean bl;
        RdProjectModelItemLocation rdProjectModelItemLocation;
        Object object;
        Path path = projectMark.getPath();
        if (path != null) {
            object = path;
            boolean bl2 = false;
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdCustomLocation(object.toString());
        } else {
            rdProjectModelItemLocation = (RdProjectModelItemLocation)new RdNullLocation();
        }
        RdProjectModelItemLocation rdProjectModelItemLocation2 = rdProjectModelItemLocation;
        UUID uUID = projectMark.getProjectGuid();
        RdUnloadProjectState rdUnloadProjectState = RdUnloadProjectState.Filtered;
        Path path2 = projectMark.getPath();
        if (path2 != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        object = projectMark.getName();
        String string = RdClientDotnetBundle.INSTANCE.message("WorkspaceModelInitializer.project.descriptor.filtered", new Object[0]);
        return new RdUnloadProjectDescriptor(rdUnloadProjectState, string, bl3, uUID, (String)object, rdProjectModelItemLocation2);
    }

    private final boolean j(ProjectMark projectMark) {
        boolean bl;
        Path path = projectMark.getPath();
        if (path != null) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        } else {
            bl = false;
        }
        return bl || Intrinsics.areEqual((Object)projectMark.getProjectTypeGuid(), (Object)this.webSiteProjectUUID) || Intrinsics.areEqual((Object)projectMark.getProjectTypeGuid(), (Object)this.executableProjectUUID);
    }

    public void validateFrontendWorkspaceModel(@Nullable ProjectModelEntity frontendEntity, @Nullable ProjectModelEntity backendEntity) {
        if (!this.isApplicable() || !this.isColdStart()) {
            return;
        }
        logger.info("Workspace model validation started...");
        this.j(frontendEntity, backendEntity);
        logger.info("Workspace model validation finished");
    }

    private final void j(ProjectModelEntity projectModelEntity, ProjectModelEntity projectModelEntity2) {
        Map map2;
        Object object;
        Object object22;
        ProjectModelEntity projectModelEntity3 = projectModelEntity;
        if (projectModelEntity3 == null || (projectModelEntity3 = projectModelEntity3.getDescriptor()) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity4 = projectModelEntity3;
        ProjectModelEntity projectModelEntity5 = projectModelEntity2;
        if (projectModelEntity5 == null || (projectModelEntity5 = projectModelEntity5.getDescriptor()) == null) {
            return;
        }
        ProjectModelEntity projectModelEntity6 = projectModelEntity5;
        if (!Intrinsics.areEqual((Object)projectModelEntity4.getName(), (Object)projectModelEntity6.getName())) {
            logger.error("Mismatching entity name: " + projectModelEntity4.getName() + " != " + projectModelEntity6.getName());
            return;
        }
        if (!Intrinsics.areEqual((Object)projectModelEntity4.getLocation(), (Object)projectModelEntity6.getLocation())) {
            logger.error("Mismatching entity location: " + projectModelEntity4.getLocation() + " != " + projectModelEntity6.getLocation() + " in " + projectModelEntity.getName());
            return;
        }
        if (projectModelEntity4 instanceof RdSolutionDescriptor && projectModelEntity6 instanceof RdSolutionDescriptor) {
            if (((RdSolutionDescriptor)projectModelEntity4).isVirtual() != ((RdSolutionDescriptor)projectModelEntity6).isVirtual()) {
                logger.error("Frontend.isVirtual " + ((RdSolutionDescriptor)projectModelEntity4).isVirtual() + " != Backend.isVirtual " + ((RdSolutionDescriptor)projectModelEntity6).isVirtual() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdSolutionDescriptor)projectModelEntity4).getFilterFilePath(), (Object)((RdSolutionDescriptor)projectModelEntity6).getFilterFilePath())) {
                logger.error("Frontend.filterFilePath " + ((RdSolutionDescriptor)projectModelEntity4).getFilterFilePath() + " != Backend.filterFilePath " + ((RdSolutionDescriptor)projectModelEntity6).getFilterFilePath() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdUnloadProjectDescriptor && projectModelEntity6 instanceof RdUnloadProjectDescriptor) {
            if (((RdUnloadProjectDescriptor)projectModelEntity4).getState() != ((RdUnloadProjectDescriptor)projectModelEntity6).getState()) {
                logger.error("Frontend.state " + ((RdUnloadProjectDescriptor)projectModelEntity4).getState() + " != Backend.state " + ((RdUnloadProjectDescriptor)projectModelEntity6).getState() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdUnloadProjectDescriptor)projectModelEntity4).getTooltip(), (Object)((RdUnloadProjectDescriptor)projectModelEntity6).getTooltip())) {
                logger.error("Frontend.tooltip " + ((RdUnloadProjectDescriptor)projectModelEntity4).getTooltip() + " != Backend.tooltip " + ((RdUnloadProjectDescriptor)projectModelEntity6).getTooltip() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdProjectFileDescriptor && projectModelEntity6 instanceof RdProjectFileDescriptor) {
            if (((RdProjectFileDescriptor)projectModelEntity4).isInternal() != ((RdProjectFileDescriptor)projectModelEntity6).isInternal()) {
                logger.error("Frontend.isInternal " + ((RdProjectFileDescriptor)projectModelEntity4).isInternal() + " != Backend.isInternal " + ((RdProjectFileDescriptor)projectModelEntity6).isInternal() + " in " + projectModelEntity.getName());
            }
            if (((RdProjectFileDescriptor)projectModelEntity4).isLinked() != ((RdProjectFileDescriptor)projectModelEntity6).isLinked()) {
                logger.error("Frontend.isLinked " + ((RdProjectFileDescriptor)projectModelEntity4).isLinked() + " != Backend.isLinked " + ((RdProjectFileDescriptor)projectModelEntity6).isLinked() + " in " + projectModelEntity.getName());
            }
            if (!Intrinsics.areEqual((Object)((RdProjectFileDescriptor)projectModelEntity4).getBuildAction(), (Object)((RdProjectFileDescriptor)projectModelEntity6).getBuildAction())) {
                logger.error("Frontend.buildAction " + ((RdProjectFileDescriptor)projectModelEntity4).getBuildAction() + " != Backend.buildAction " + ((RdProjectFileDescriptor)projectModelEntity6).getBuildAction() + " in " + projectModelEntity.getName());
            }
        }
        if (projectModelEntity4 instanceof RdProjectDescriptor && projectModelEntity6 instanceof RdProjectDescriptor && ((RdProjectDescriptor)projectModelEntity4).getDirectoryBased() != ((RdProjectDescriptor)projectModelEntity6).getDirectoryBased()) {
            logger.error("Frontend.directoryBased " + ((RdProjectDescriptor)projectModelEntity4).getDirectoryBased() + " != Backend.directoryBased " + ((RdProjectDescriptor)projectModelEntity6).getDirectoryBased() + " in " + projectModelEntity.getName());
        }
        if (!ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)projectModelEntity) && !ProjectModelEntityExtensionsKt.isSolutionFolder((ProjectModelEntity)projectModelEntity)) {
            return;
        }
        Object object3 = projectModelEntity.getChildrenEntities();
        boolean bl = false;
        int n2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10)), (int)16);
        Iterable iterable = object3;
        Object object4 = new LinkedHashMap(n2);
        boolean bl2 = false;
        for (Object object22 : iterable) {
            object = (ProjectModelEntity)object22;
            map2 = object4;
            boolean bl3 = false;
            map2.put(MergeKey.Companion.create((ProjectModelEntity)object), object22);
        }
        Map map3 = object4;
        Iterator iterator2 = projectModelEntity2.getChildrenEntities();
        n2 = 0;
        int n3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), (int)10)), (int)16);
        object4 = iterator2;
        Map map4 = new LinkedHashMap(n3);
        boolean bl4 = false;
        object22 = object4.iterator();
        while (object22.hasNext()) {
            Object object5 = object = object22.next();
            map2 = map4;
            boolean bl5 = false;
            map2.put(MergeKey.Companion.create((ProjectModelEntity)object5), object);
        }
        object3 = map4;
        if (map3.size() != object3.size()) {
            logger.error("Frontend children " + map3.size() + " != Backend children " + object3.size() + " in " + projectModelEntity.getName());
            return;
        }
        for (MergeKey mergeKey : CollectionsKt.subtract((Iterable)map3.keySet(), (Iterable)object3.keySet())) {
            logger.error("Missing backend entity " + mergeKey);
        }
        for (MergeKey mergeKey : CollectionsKt.subtract((Iterable)object3.keySet(), (Iterable)map3.keySet())) {
            logger.error("Missing frontend entity " + mergeKey);
        }
        for (MergeKey mergeKey : CollectionsKt.intersect((Iterable)map3.keySet(), (Iterable)object3.keySet())) {
            this.j((ProjectModelEntity)map3.get(mergeKey), (ProjectModelEntity)object3.get(mergeKey));
        }
    }

    private final void j(Supplier<String> supplier) {
        if (!noChangeAssertsMode) {
            return;
        }
        if (WorkspaceModelCache.Companion.getInstance(this.project) == null) {
            return;
        }
        logger.error(supplier.get());
    }

    public void merge(@NotNull MutableEntityStorage builder2, @NotNull ProjectModelEntity solutionEntity, @NotNull MutableEntityStorage existingBuilder, @NotNull ProjectModelEntity existingSolutionEntity) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)solutionEntity, (String)"solutionEntity");
        Intrinsics.checkNotNullParameter((Object)existingBuilder, (String)"existingBuilder");
        Intrinsics.checkNotNullParameter((Object)existingSolutionEntity, (String)"existingSolutionEntity");
        new ProjectModelEntityPrototypeMerger(builder2, existingBuilder).merge(solutionEntity, existingSolutionEntity);
    }

    private static final void j(RiderWorkspaceModelInitializer riderWorkspaceModelInitializer) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderWorkspaceModelInitializer), (String)"this$0");
        WorkspaceGlobalListener.INSTANCE.fireEvents((Function1)new Function1<WorkspaceGlobalListener.Listener, Unit>(riderWorkspaceModelInitializer){
            final /* synthetic */ RiderWorkspaceModelInitializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull WorkspaceGlobalListener.Listener it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.cachedModelReady(RiderWorkspaceModelInitializer.access$getProject$p(this.this$0));
            }
        });
    }

    private static final String j(ProjectModelEntity projectModelEntity) {
        Intrinsics.checkNotNullParameter((Object)projectModelEntity, (String)"$entity");
        return "Entity " + projectModelEntity.getName() + " should not be deleted during startup";
    }

    private static final String j(RdProjectModelItemDescriptor rdProjectModelItemDescriptor, ProjectModelEntity projectModelEntity) {
        Intrinsics.checkNotNullParameter((Object)rdProjectModelItemDescriptor, (String)"$descriptor");
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        return "Entity " + rdProjectModelItemDescriptor.getName() + " -> " + (projectModelEntity2 != null ? projectModelEntity2.getName() : null) + " should not be created during startup";
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(RiderWorkspaceModelInitializer $this) {
        return $this.project;
    }

    static {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(WorkspaceModelUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "noChangeAssertsMode", "", "enableNoChangeAsserts", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getInstance", "Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderWorkspaceModelInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,375:1\n17#2,2:376\n*S KotlinDebug\n*F\n+ 1 RiderWorkspaceModelInitializer.kt\ncom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$Companion\n*L\n35#1:376,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderWorkspaceModelInitializer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(WorkspaceModelInitializer.class);
            if (object == null) {
                throw new IllegalStateException("Service " + WorkspaceModelInitializer.class + " not found in container " + componentManager);
            }
            return (RiderWorkspaceModelInitializer)((Object)object);
        }

        public final void enableNoChangeAsserts(@NotNull Lifetime lifetime2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            noChangeAssertsMode = true;
            lifetime2.onTermination((Function0)enableNoChangeAsserts.1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey;", "", "name", "", "guid", "Ljava/util/UUID;", "(Ljava/lang/String;Ljava/util/UUID;)V", "getGuid", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rider"})
    public static final class MergeKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @Nullable
        private final UUID guid;

        public MergeKey(@NotNull String name, @Nullable UUID guid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.guid = guid;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final UUID getGuid() {
            return this.guid;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final UUID component2() {
            return this.guid;
        }

        @NotNull
        public final MergeKey copy(@NotNull String name, @Nullable UUID guid) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new MergeKey(name, guid);
        }

        public static /* synthetic */ MergeKey copy$default(MergeKey mergeKey, String string, UUID uUID, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = mergeKey.name;
            }
            if ((n2 & 2) != 0) {
                uUID = mergeKey.guid;
            }
            return mergeKey.copy(string, uUID);
        }

        @NotNull
        public String toString() {
            return "MergeKey(name=" + this.name + ", guid=" + this.guid + ")";
        }

        public int hashCode() {
            int n2 = this.name.hashCode();
            n2 = n2 * 31 + (this.guid == null ? 0 : this.guid.hashCode());
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MergeKey)) {
                return false;
            }
            MergeKey mergeKey = (MergeKey)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)mergeKey.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.guid, (Object)mergeKey.guid);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey$Companion;", "", "()V", "create", "Lcom/jetbrains/rider/workspaceModel/RiderWorkspaceModelInitializer$MergeKey;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final MergeKey create(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                return rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? new MergeKey(((RdProjectDescriptor)rdProjectModelItemDescriptor).getOriginalName(), ((RdProjectDescriptor)rdProjectModelItemDescriptor).getOriginalGuid()) : (rdProjectModelItemDescriptor instanceof RdUnloadProjectDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getGuid()) : (rdProjectModelItemDescriptor instanceof RdSolutionFolderDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), ((RdSolutionFolderDescriptor)rdProjectModelItemDescriptor).getGuid()) : (rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? new MergeKey(rdProjectModelItemDescriptor.getName(), null) : null)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

